/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.util.EncodingFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.BaseUtils;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.PromptField;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.bc;
import com.inet.report.bf;
import com.inet.report.cache.Cache;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.RelativePathDataFactory;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.csv.c;
import com.inet.report.util.EngineUtils;
import com.inet.shared.utils.MemoryStream;
import java.io.File;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class DatabaseReportData
extends RelativePathDataFactory {
    public static final String FORMAT = "database_report_data";

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return super.getTableSourceInfos(ds, catalog, string -> string.endsWith(".rpt") ? string.substring(0, string.length() - 4) : null);
    }

    @Override
    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull Datasource ds, String catalog, String schema, String name, int type) throws ReportException {
        b b2 = this.b(ds, name);
        Engine engine = b2.getEngine();
        Properties properties = new Properties();
        properties.setProperty("promptonrefresh", "1");
        Prompt[] promptArray = null;
        try {
            bf.a(b2, properties, true);
        }
        catch (PromptRequestWarning promptRequestWarning) {
            promptArray = promptRequestWarning.getPrompts();
        }
        engine.setSF("false");
        this.a(ds, engine);
        try {
            engine.execute();
            engine.getPageData(1);
        }
        catch (PromptRequestWarning promptRequestWarning) {
            if (promptArray == null) {
                promptArray = promptRequestWarning.getPrompts();
            }
            int n2 = promptArray.length;
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            return this.a(name, promptArray, 0, stringArray, nArray);
        }
        ArrayList<c> arrayList = b2.bH();
        int n3 = arrayList.size();
        int n4 = n3 + (promptArray == null ? 0 : promptArray.length);
        String[] stringArray = new String[n4];
        int[] nArray = new int[n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            c c2 = arrayList.get(i2);
            stringArray[i2] = c2.ze();
            nArray[i2] = c2.getValueType();
        }
        return this.a(name, promptArray, n3, stringArray, nArray);
    }

    private List<ColumnInfo> a(String string, Prompt[] promptArray, int n2, String[] stringArray, int[] nArray) {
        int n3;
        int n4 = stringArray.length;
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>(n4);
        for (n3 = 0; n3 < n2; ++n3) {
            arrayList.add(new ColumnInfo(stringArray[n3], nArray[n3]));
        }
        n3 = n4 - n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            Prompt prompt = promptArray[i2];
            if (prompt.isNotUsed()) continue;
            int n5 = prompt.getValueType();
            int n6 = this.E(n5);
            if (prompt.isRange()) {
                n5 ^= 0x80;
            }
            if (prompt.isMulti()) {
                n5 ^= 0x100;
            }
            arrayList.add(new ColumnInfo(prompt.getName(), n5, 1, n6, 0));
        }
        return arrayList;
    }

    private int E(int n2) {
        switch (n2) {
            case 6: 
            case 7: {
                return 2;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 14: {
                return -2;
            }
            case 15: {
                return 93;
            }
        }
        return 12;
    }

    private void a(Datasource datasource, Engine engine) {
        PromptField[] promptFieldArray = engine.bB.iZ();
        PromptField[] promptFieldArray2 = datasource.getEngine().bB.iZ();
        for (int i2 = 0; promptFieldArray != null && i2 < promptFieldArray.length; ++i2) {
            PromptField promptField = promptFieldArray[i2];
            for (int i3 = 0; promptFieldArray2 != null && i3 < promptFieldArray2.length; ++i3) {
                PromptField promptField2 = promptFieldArray2[i3];
                if (promptField2.yZ == null || !promptField2.yZ.equalsIgnoreCase(promptField.getName())) continue;
                promptField.value = promptField2.value;
                promptField.valueSet = true;
            }
        }
    }

    @Override
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        Datasource datasource = ts.getDatasource();
        b b2 = this.b(datasource, ts.getDatabaseIdentifier());
        Engine engine = b2.getEngine();
        this.a(datasource, engine);
        engine.execute();
        engine.getPageData(1);
        return new TableData(b2.bI());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="name of file is not user input")
    private b b(Datasource datasource, String string) throws ReportException {
        Serializable serializable;
        Object object = null;
        List<String> list = this.getPathNames(datasource);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            serializable = new File(list.get(i2), string + ".rpt");
            if (!serializable.exists()) continue;
            object = serializable.getPath();
            break;
        }
        if (object == null) {
            String string2 = list.get(0);
            object = string2.indexOf(58) > 1 ? string2 + "/" + EncodingFunctions.encodeFileUrlPath((String)string) + ".rpt" : new File(string2, string + ".rpt").getPath();
        }
        Properties properties = new Properties();
        properties.setProperty("export_fmt", FORMAT);
        properties.setProperty("report", (String)object);
        properties.setProperty("encoding", "UTF8");
        serializable = EngineUtils.createEngine(properties, (PropertiesChecker)com.inet.report.servlets.b.btV.get(), Cache.getEngineFactory(), null);
        return (b)((Engine)serializable).bB;
    }

    public static class b
    extends bc {
        private final ArrayList<c> le = new ArrayList();
        private a lf;

        public b(Engine engine) {
            super(engine);
        }

        ArrayList<c> bH() {
            return this.le;
        }

        a bI() {
            if (this.lf == null) {
                String[] stringArray = new String[this.le.size()];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = this.le.get(i2).ze();
                }
                this.lf = new a(stringArray);
            }
            return this.lf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void F(int n2) throws AccessDeniedException {
            super.F(n2);
            this.bI();
            Object[] objectArray = new Object[this.le.size()];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = this.le.get(i2).zf();
            }
            a a2 = this.lf;
            synchronized (a2) {
                this.lf.addRow(objectArray);
                this.lf.notifyAll();
            }
        }

        @Override
        protected void b(MemoryStream memoryStream) {
        }

        @Override
        protected void a(c c2, boolean bl2, int n2) {
            if (bl2) {
                this.le.add(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void bJ() throws ReportException {
            super.bJ();
            a a2 = this.bI();
            synchronized (a2) {
                this.lf.bG();
                this.lf.notifyAll();
            }
        }
    }

    private static class a
    extends SimpleResultSet {
        private boolean ld;

        a(String[] stringArray) {
            super(stringArray);
        }

        void bG() {
            this.ld = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean next() throws SQLException {
            a a2 = this;
            synchronized (a2) {
                while (this.getAllRows().size() == 0 && !this.ld) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        BaseUtils.printStackTrace(interruptedException);
                        return false;
                    }
                }
            }
            return super.next();
        }
    }
}

