/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axC;
    private static Hashtable<String, Object> buc;
    private static long bud;
    private static long bue;
    private static int buf;
    private static int bug;
    private static int buh;
    private static volatile int bui;
    private static volatile int buj;
    private static Set<Integer> buk;
    private static Set<String> bul;
    private static Set<String> bum;
    private static double bun;
    private static int buo;
    private static int bup;
    private static double buq;
    private static double bur;
    private static int bus;
    private static int but;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.NE();
        ++buf;
    }

    public static void incReportRequest() {
        ++bug;
    }

    public static void incRenderedReports() {
        ++buh;
        buj = Math.max(buj, ++bui);
    }

    public static void decRenderedReports() {
        --bui;
    }

    public static int getCurrentRenderingReports() {
        return bui;
    }

    public static int getMaxRenderingReports() {
        return buj;
    }

    public static void countReportTemplates(URL reportUrl) {
        buk.add(reportUrl.hashCode());
    }

    public static void countClientLanguages(Locale locale) {
        bul.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        bum.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        bun += (double)pages;
        ++buo;
        bup = Math.max(bup, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        buq += (double)fetchedRecord;
        bur += (double)discardedRecords;
        bus = Math.max(bus, fetchedRecord);
        but = Math.max(but, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = buc.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void NE() {
        long l2 = System.currentTimeMillis();
        if (l2 > bud) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= bud) return;
                Accumulator.a(buc, "");
                Accumulator.save();
                buf = 0;
                bug = 0;
                buh = 0;
                bun = 0.0;
                bup = 0;
                buo = 0;
                buq = 0.0;
                bus = 0;
                bur = 0.0;
                but = 0;
                buk.clear();
                bul.clear();
                bum.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= bue) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= bue) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axC == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        buc.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(buf, hashtable, "Total Requests" + string);
        Accumulator.a(bug, hashtable, "Report Requests" + string);
        Accumulator.a(buh, hashtable, "Rendered Reports" + string);
        Accumulator.a(bun, hashtable, "Total Page Count" + string);
        Accumulator.a(bup, hashtable, "Maximal Page Count" + string);
        Accumulator.a(buq, hashtable, "Total fetched Records" + string);
        Accumulator.a(bus, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(bur, hashtable, "Total discarded Records" + string);
        Accumulator.a(but, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(buk.size(), hashtable, "Report Templates");
            Accumulator.a(bul.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", bul);
            Accumulator.a(bum.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", bum);
            Accumulator.a(bun / (double)buo, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, buk);
            hashtable.put("Client Languages" + string, bul);
            hashtable.put("Report Formats" + string, bum);
            hashtable.put("Average Page Count" + string, buo);
        }
        hashtable.put("Next Day", bud);
    }

    private static Hashtable<String, Object> NF() {
        Hashtable<String, Object> hashtable = buc = new Hashtable<String, Object>();
        try {
            axC = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axC));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    buc = hashtable;
                } else {
                    hashtable = buc;
                }
                buf = (int)Accumulator.dJ("Total Requests");
                bug = (int)Accumulator.dJ("Report Requests");
                buh = (int)Accumulator.dJ("Rendered Reports");
                bun = Accumulator.dJ("Total Page Count");
                bup = (int)Accumulator.dJ("Maximal Page Count");
                buo = (int)Accumulator.dJ("Average Page Count");
                buq = Accumulator.dJ("Total fetched Records");
                bus = (int)Accumulator.dJ("Maximal fetched Records");
                bur = Accumulator.dJ("Total discarded Records");
                but = (int)Accumulator.dJ("Maximal discarded Records");
                buk = Accumulator.dK("Report Templates");
                bul = Accumulator.dK("Client Languages");
                bum = Accumulator.dK("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.NG();
                    bud = l2;
                    Accumulator.NE();
                }
            }
            catch (Throwable throwable) {
                buc = hashtable;
                buk = Collections.synchronizedSet(new HashSet());
                bul = Collections.synchronizedSet(new HashSet());
                bum = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.NG();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            buk = Collections.synchronizedSet(new HashSet());
            bul = Collections.synchronizedSet(new HashSet());
            bum = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void NG() {
        Date date = new Date();
        bue = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        bud = date.getTime();
    }

    private static synchronized void save() {
        if (axC == null) {
            return;
        }
        Accumulator.NG();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axC));
            objectOutputStream.writeObject(buc);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dJ(String string) {
        Number number = (Number)buc.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dK(String string) {
        Set set = (Set)buc.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, d2);
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, d4);
        }
    }

    static {
        buc = Accumulator.NF();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

