/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.error.HasErrorCode;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.ReportException;
import com.inet.report.i18n.ReportErrorCode;
import java.sql.SQLException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

@InternalApi
public class ReportExceptionFactory {
    private static Pattern JN = Pattern.compile("(?s)\\[(\\d{1,7})\\].*");

    @Nonnull
    public static ReportException createReportException(ErrorCode messageID, Object ... parameters) {
        String string = messageID.getMsg(parameters);
        int n2 = messageID.getErrorCodeNumber();
        ReportException reportException = new ReportException(string, n2);
        return reportException;
    }

    @Nonnull
    public static ReportException createReportExceptionWithCauseOutOfMemoryError(String loc, Throwable th) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        Object[] objectArray = new Object[]{String.valueOf(runtime.totalMemory()), String.valueOf(runtime.freeMemory()), loc};
        return (ReportException)ReportExceptionFactory.createReportException(ReportErrorCode.outOfMemory, objectArray).initCause(th);
    }

    @Nonnull
    public static ReportException createReportExceptionWithCause(Throwable th, ErrorCode messageID, Object ... msgParameters) {
        ErrorCode errorCode;
        String string;
        if (th instanceof AccessDeniedException) {
            ReportException reportException = new ReportException(th.getMessage(), ((AccessDeniedException)th).getErrorCode());
            reportException.initCause(th);
            return reportException;
        }
        if (th instanceof ReportException) {
            StackTraceElement[] stackTraceElementArray;
            int n2 = ((ReportException)th).getErrorCode();
            if (n2 == -601) {
                return (ReportException)th;
            }
            ReportException reportException = new ReportException(th.getMessage(), n2);
            StackTraceElement[] stackTraceElementArray2 = th.getStackTrace();
            if (stackTraceElementArray2 != null && stackTraceElementArray2.length > 0 && (stackTraceElementArray = reportException.getStackTrace()) != null && stackTraceElementArray.length > 0) {
                int n3;
                int n4 = stackTraceElementArray2.length - 1;
                for (n3 = stackTraceElementArray.length - 1; n4 >= 0 && n3 >= 0 && stackTraceElementArray2[n4].equals(stackTraceElementArray[n3]); --n4, --n3) {
                }
                if (n3 <= 2 || stackTraceElementArray.length - n3 > 10) {
                    return (ReportException)th;
                }
            }
            reportException.initCause(th);
            return reportException;
        }
        if (th instanceof OutOfMemoryError) {
            return ReportExceptionFactory.createReportExceptionWithCauseOutOfMemoryError("unknown", th);
        }
        if (th instanceof InterruptedException) {
            return (ReportException)ReportExceptionFactory.createReportException(ReportErrorCode.Interrupted, new Object[0]).initCause(th);
        }
        if (th instanceof SQLException && messageID == ReportErrorCode.wrapException) {
            SQLException sQLException = (SQLException)th;
            String string2 = sQLException.getSQLState();
            String string3 = String.valueOf(sQLException.getErrorCode());
            Object object = sQLException.getMessage();
            while ((sQLException = sQLException.getNextException()) != null) {
                String string4 = sQLException.getMessage();
                if (string4 == null || Objects.equals(object, string4)) continue;
                object = (String)object + "\n" + string4;
            }
            return (ReportException)ReportExceptionFactory.createReportException(ReportErrorCode.SqlError, object, string2, string3).initCause(th);
        }
        if (th instanceof HasErrorCode) {
            return (ReportException)new ReportException(th.getMessage(), ((HasErrorCode)th).getErrorCode()).initCause(th);
        }
        String string5 = string = th != null ? th.getMessage() : null;
        if (string != null && messageID == ReportErrorCode.wrapException && (errorCode = ReportExceptionFactory.af(string)) != null) {
            string = string.substring(string.indexOf(93) + 1).trim();
            return (ReportException)new ReportException(string, errorCode.getErrorCodeNumber()).initCause(th);
        }
        return (ReportException)ReportExceptionFactory.createReportException(messageID, msgParameters).initCause(th);
    }

    @Nonnull
    public static ReportException createReportExceptionWithCause(Throwable th) {
        ReportErrorCode reportErrorCode = ReportErrorCode.wrapException;
        String string = th.getMessage();
        return ReportExceptionFactory.createReportExceptionWithCause(th, reportErrorCode, th.getClass().getName(), string);
    }

    private static ErrorCode af(String string) {
        Matcher matcher = JN.matcher(string);
        if (matcher.find()) {
            int n2 = Integer.parseInt(matcher.group(1));
            return ErrorCode.valueOf((int)n2);
        }
        return null;
    }
}

