/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.ac;
import com.inet.viewer.ak;
import com.inet.viewer.ap;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.zip.Adler32;
import java.util.zip.GZIPInputStream;
import javax.annotation.SuppressFBWarnings;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@PublicApi
public class URLRenderData
implements RenderData {
    private static final String bKV = com.inet.viewer.i18n.a.getMsg("error.renderdata.ignoring_timeout");
    private final Properties bKW = new Properties();
    private Properties hm;
    private boolean hq;
    private String hn;
    private String tu;
    private long bKX = System.currentTimeMillis() / 1000L;
    private String bKY = TimeZone.getDefault().getID();
    private boolean isRefresh;
    private boolean bKZ;
    private a bLa;
    private boolean bLb;
    private String bLc;
    private SSLSocketFactory bLd;
    private HostnameVerifier bLe;
    private WeakHashMap<HttpURLConnection, ?> bLf = new WeakHashMap();
    private final Object bLg = new Object();
    private static final Hashtable<String, String> bLh = new Hashtable();

    public URLRenderData(String requestURL) {
        this.setReportLocation(requestURL);
    }

    public URLRenderData(URL url) {
        this.setReportLocation(url.toString());
    }

    @Override
    public void setReportLocation(String url) {
        if (url == null) {
            return;
        }
        int n2 = ((String)url).indexOf(63);
        if (n2 >= 0) {
            String string = ((String)url).substring(n2 + 1);
            url = ((String)url).substring(0, n2 + 1);
            this.ei(string);
        } else {
            url = (String)url + "?";
        }
        this.tu = url;
        this.reset();
    }

    private void ei(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&=", true);
        boolean bl2 = true;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (string4.equals("&")) {
                this.W(string2, string3);
                string2 = "";
                string3 = "";
                bl2 = true;
                continue;
            }
            if (string4.equals("=")) {
                bl2 = false;
                continue;
            }
            if (bl2) {
                string2 = string4;
                continue;
            }
            string3 = string4;
        }
        this.W(string2, string3);
    }

    private void W(String string, String string2) {
        try {
            String string3;
            String string4;
            if ("promptonrefresh".equalsIgnoreCase(string)) {
                if ("true".equalsIgnoreCase(string2)) {
                    this.setPromptOnRefresh(true);
                } else if ("false".equalsIgnoreCase(string2)) {
                    this.setPromptOnRefresh(false);
                }
                return;
            }
            try {
                string4 = URLDecoder.decode(string, "UTF-8").toLowerCase();
                string4 = URLRenderData.ej(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.debug("Error: " + string + " could not be decoded. Reason: ");
                illegalArgumentException.printStackTrace(ViewerUtils.getLogStream());
                string4 = string;
            }
            try {
                string3 = URLDecoder.decode(string2, "UTF-8");
                string3 = URLRenderData.ej(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.debug("Error: " + string2 + " could not be decoded. Reason: ");
                illegalArgumentException.printStackTrace(ViewerUtils.getLogStream());
                string3 = string2;
            }
            this.bKW.put(string4, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ViewerUtils.error(unsupportedEncodingException.toString());
            this.bKW.put(string, string2);
        }
    }

    private static String ej(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string);
        int n3 = 0;
        while ((n3 = stringBuilder.indexOf("&#", n3)) >= 0 && (n2 = stringBuilder.indexOf(";", n3)) >= 0) {
            try {
                char c2 = (char)Integer.parseInt(stringBuilder.substring(n3 + 2, n2));
                stringBuilder.delete(n3, n2 + 1);
                stringBuilder.insert(n3, c2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public String getReportLocation() {
        return this.tu;
    }

    private static String p(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static void a(Properties properties, URLConnection uRLConnection) throws IOException {
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string, "");
            printWriter.print(string + "=" + string2 + "&");
        }
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(HttpURLConnection httpURLConnection, Properties properties, boolean bl2, boolean bl3) throws IOException {
        Object object;
        if (httpURLConnection instanceof HttpsURLConnection) {
            object = (HttpsURLConnection)httpURLConnection;
            if (this.bLd != null) {
                ((HttpsURLConnection)object).setSSLSocketFactory(this.bLd);
            }
            if (this.bLe != null) {
                ((HttpsURLConnection)object).setHostnameVerifier(this.bLe);
            }
        }
        if (this.bLc != null) {
            httpURLConnection.setRequestProperty("Cookie", this.bLc);
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, identity");
        httpURLConnection.setRequestProperty("timezone", this.bKY);
        object = this.bLg;
        synchronized (object) {
            this.bLf.put(httpURLConnection, null);
        }
        if (!bl2 || bl3) {
            URLRenderData.a(properties, httpURLConnection);
        }
        httpURLConnection.connect();
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only used on client side")
    void a(a a2, Properties properties, String string, boolean bl2) throws IOException, ViewerException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl3 = false;
        Object object5 = this.tu;
        boolean bl4 = bl2 = bl2 || this.bLb;
        if (bl2) {
            object4 = this.q(properties);
            if (object4 != null) {
                object5 = object4;
            } else {
                bl3 = true;
            }
        }
        object4 = new URL((String)object5);
        HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object4).openConnection();
        this.a(httpURLConnection, properties, bl2, bl3);
        a2.bLj = httpURLConnection;
        try {
            a2.aeg = httpURLConnection.getInputStream();
        }
        catch (ProtocolException protocolException) {
            httpURLConnection = URLRenderData.a(httpURLConnection);
            if (httpURLConnection == null) {
                throw protocolException;
            }
            this.a(httpURLConnection, properties, bl2, bl3);
            a2.bLj = httpURLConnection;
            a2.aeg = httpURLConnection.getInputStream();
        }
        this.RP();
        String string2 = httpURLConnection.getHeaderField("Set-Cookie");
        if (string2 != null) {
            try {
                Map<String, List<String>> map;
                object3 = CookieHandler.getDefault();
                if (object3 == null) {
                    object3 = new CookieManager();
                    CookieHandler.setDefault((CookieHandler)object3);
                    ((CookieHandler)object3).put(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields());
                }
                if (this.getCookie() != null && (map = ((CookieHandler)object3).get(httpURLConnection.getURL().toURI(), httpURLConnection.getHeaderFields())).containsKey("Cookie") && (object2 = map.get("Cookie")) != null && object2.size() > 0 && (object = (String)object2.get(0)) != null && ((String)object).length() > 0) {
                    this.setCookie(null);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ViewerUtils.printStackTrace(uRISyntaxException);
            }
        }
        a2.bLi = httpURLConnection.getContentLength();
        object3 = httpURLConnection.getContentType();
        if (object3 == null) {
            throw new ViewerException(com.inet.viewer.i18n.a.getMsg("error.renderdata.contentType_returns_null") + " " + httpURLConnection.getContentLength());
        }
        if ("gzip".equals(httpURLConnection.getContentEncoding())) {
            a2.aeg = new GZIPInputStream(a2.aeg, 8192);
            a2.bLi = -1;
        }
        if ((n2 = ((String)object3).indexOf(59)) != -1) {
            object3 = ((String)object3).substring(0, n2);
        }
        if ((object2 = bLh.get(object3)) == null || !this.X(string, (String)object2)) {
            if ("bin".equals(object2)) {
                object = new ac();
                ((ac)object).data = this.a(a2);
                ((ac)object).readTokens();
            }
            this.RP();
            object = null;
            try {
                byte[] byArray = new byte[1024];
                int n3 = a2.aeg.read(byArray);
                a2.aeg.close();
                object = n3 > 0 ? ac.f(byArray, 0, n3) : "no data";
            }
            catch (Throwable throwable) {
                ViewerUtils.printStackTrace(throwable);
            }
            throw new ViewerException(0, com.inet.viewer.i18n.a.getMsg("error.renderdata.wrong_mime_type") + " " + (String)object3, string, null, null, null, 0, (String)object);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only used on client side")
    private static HttpURLConnection a(HttpURLConnection httpURLConnection) {
        try {
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            List<String> list = map.get("WWW-Authenticate");
            for (String string : list) {
                URL uRL;
                PasswordAuthentication passwordAuthentication;
                if (!string.toUpperCase().startsWith("BASIC") || (passwordAuthentication = Authenticator.requestPasswordAuthentication((uRL = httpURLConnection.getURL()).getHost(), null, uRL.getPort(), uRL.getProtocol(), "", "BASIC", uRL, Authenticator.RequestorType.SERVER)) == null) continue;
                byte[] byArray = (passwordAuthentication.getUserName() + ":" + new String(passwordAuthentication.getPassword())).getBytes("UTF-8");
                string = Base64.getEncoder().encodeToString(byArray);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("Authorization", "Basic " + string);
                return httpURLConnection;
            }
        }
        catch (IOException iOException) {
            ViewerUtils.printStackTrace(iOException);
        }
        return null;
    }

    String q(Properties properties) {
        Object object = this.tu;
        String string = URLRenderData.p(properties);
        if (!((String)object).endsWith("?")) {
            object = (String)object + "&";
        }
        if (((String)(object = (String)object + string)).length() > 1023 && !this.bLb) {
            return null;
        }
        return object;
    }

    private boolean X(String string, String string2) {
        if (string.equalsIgnoreCase("data")) {
            string = "csv";
        } else if ("zip".equals(string2) && ("jpg".equals(string) || "png".equals(string) || "gif".equals(string) || "bmp".equals(string))) {
            return true;
        }
        return string.toLowerCase().startsWith(string2);
    }

    private byte[] c(Properties properties, String string) throws ViewerException {
        return this.a(properties, string, true, null);
    }

    private byte[] a(Properties properties, String string, boolean bl2, a a2) throws ViewerException {
        if (EventQueue.isDispatchThread()) {
            ViewerUtils.debug("contacting server on EDT...");
            ViewerUtils.printStackTrace(new ViewerException("debug info"));
        }
        while (bl2) {
            Object object;
            a a3 = a2 == null ? new a() : a2;
            try {
                Object object2;
                boolean bl3 = true;
                try {
                    this.a(a3, properties, string, false);
                    bl3 = false;
                }
                catch (ViewerException viewerException) {
                    try {
                        bl3 = this.a(a3, properties, string);
                    }
                    catch (ViewerException viewerException2) {
                        object = viewerException2;
                    }
                    if (bl3) {
                        if (this.bLb || ((ViewerException)object).srvVersion != null && ((ViewerException)object).srvVersion.length() > 0 || this.bKZ) {
                            throw object;
                        }
                        ViewerUtils.debug("Encountered: " + ((Throwable)object).getMessage() + " while trying POST request.");
                    }
                }
                catch (IOException iOException) {
                    if (a3.bLj instanceof HttpURLConnection) {
                        InputStream inputStream;
                        object2 = (HttpURLConnection)a3.bLj;
                        int n2 = ((HttpURLConnection)object2).getResponseCode();
                        if (n2 == 401) {
                            throw iOException;
                        }
                        if (n2 >= 300 && n2 <= 399) {
                            ViewerUtils.debug("encountered HTTP " + n2 + " --> " + ((URLConnection)object2).getHeaderField("Location"));
                        }
                        if ((inputStream = ((HttpURLConnection)object2).getErrorStream()) != null) {
                            String string2 = ((URLConnection)object2).getContentType();
                            if ("gzip".equals(((URLConnection)object2).getContentEncoding())) {
                                inputStream = new GZIPInputStream(inputStream, 8192);
                            }
                            ViewerUtils.debug(this.a(this.g(inputStream), string2));
                        }
                    }
                    if (this.bLb || this.bKZ) {
                        throw iOException;
                    }
                    ViewerUtils.debug("Encountered: " + iOException.getMessage() + " while trying POST request.");
                }
                if (!bl3) {
                    if (a2 != null) {
                        return null;
                    }
                    object = this.a(a3);
                    object2 = properties.get("cmd").toString();
                    if (object2 != null && (((String)object2).equals("get_pg_count") || ((String)object2).equals("ping")) || this.bh((byte[])object) || this.bLb) {
                        return object;
                    }
                    ViewerUtils.debug("Encountered Checksum Problem!");
                }
                ViewerUtils.debug(" => Fallback to HTTP GET Request instead of POST");
                this.a(a3, properties, string, true);
                return a2 == null ? this.a(a3) : null;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.RP();
                ViewerUtils.debug(bKV);
            }
            catch (IOException iOException) {
                ViewerUtils.error("Problem when attemping to connect via GET with URL '" + this.tu + "'");
                this.RP();
                try {
                    if (a3.bLj instanceof HttpURLConnection) {
                        Object object3;
                        object = (HttpURLConnection)a3.bLj;
                        if (((HttpURLConnection)object).getResponseCode() == 504) {
                            ViewerUtils.debug(bKV);
                            continue;
                        }
                        InputStream inputStream = ((HttpURLConnection)object).getErrorStream();
                        String string3 = ((URLConnection)object).getContentType();
                        if ("gzip".equals(((URLConnection)object).getContentEncoding())) {
                            inputStream = new GZIPInputStream(inputStream, 8192);
                        }
                        ByteArrayOutputStream byteArrayOutputStream = this.g(inputStream);
                        String string4 = bLh.get(string3);
                        if ("bin".equals(string4)) {
                            try {
                                object3 = new ac();
                                ((ac)object3).data = byteArrayOutputStream.toByteArray();
                                ((ac)object3).readTokens();
                            }
                            catch (ViewerException viewerException) {
                                throw viewerException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        object3 = this.a(byteArrayOutputStream, string3);
                        ViewerUtils.debug((String)object3);
                        if (((String)object3).startsWith("<html>")) {
                            throw ViewerException.createViewerExceptionWithMessage((String)object3, iOException);
                        }
                        ViewerException viewerException = ViewerException.createViewerException(iOException);
                        if (((String)object3).length() > 5) {
                            viewerException.stacktrace = object3;
                        }
                        throw viewerException;
                    }
                    if (a3.aeg != null) {
                        a3.aeg.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw ViewerException.createViewerException(iOException);
            }
            catch (Exception exception) {
                try {
                    a3.aeg.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.RP();
                throw ViewerException.createViewerException(exception);
            }
        }
        return null;
    }

    private boolean a(a a2, Properties properties, String string) throws ViewerException, IOException {
        String string2;
        HttpURLConnection httpURLConnection;
        int n2;
        if (a2.bLj instanceof HttpURLConnection && (n2 = (httpURLConnection = (HttpURLConnection)a2.bLj).getResponseCode()) >= 300 && n2 <= 399 && (string2 = httpURLConnection.getHeaderField("Location")) != null && !string2.equals(this.tu)) {
            ViewerUtils.debug("Redirect from: " + this.tu + " to: " + string2);
            this.tu = string2;
            this.a(a2, properties, string, false);
            return false;
        }
        return true;
    }

    private ByteArrayOutputStream g(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (inputStream == null) {
            return byteArrayOutputStream;
        }
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream;
    }

    private String a(ByteArrayOutputStream byteArrayOutputStream, String string) {
        String string2;
        if (string != null) {
            int n2 = string.indexOf("charset=");
            if (n2 > 0) {
                char c2;
                char c3;
                string2 = string.substring(n2 + "charset=".length());
                int n3 = string2.length();
                if (n3 > 2 && (c3 = string2.charAt(0)) == (c2 = string2.charAt(n3 - 1)) && (c3 == '\'' || c3 == '\"')) {
                    string2 = string2.substring(1, n3 - 1);
                }
            } else {
                string2 = "utf8";
            }
        } else {
            string2 = "utf8";
        }
        try {
            return byteArrayOutputStream.toString(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byteArrayOutputStream.toString();
        }
    }

    private boolean bh(byte[] byArray) {
        int n2 = byArray.length - 4;
        if (n2 < 0) {
            return false;
        }
        int n3 = (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF);
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, 0, byArray.length - 4);
        int n4 = (int)adler32.getValue();
        return n4 == n3;
    }

    void reset() {
        this.bLa = null;
    }

    private byte[] a(a a2) throws IOException {
        return this.a(a2, a2.bLi, true);
    }

    private byte[] a(a a2, int n2, boolean bl2) throws IOException {
        this.RP();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n2 > 0) {
                int n4 = a2.aeg.read(byArray, n3, n2);
                if (n4 < 0) {
                    if (bl2) {
                        throw new ViewerException(com.inet.viewer.i18n.a.getMsg("error.renderdata.wrong_packet_size_received") + " " + n3 + " " + com.inet.viewer.i18n.a.getMsg("error.renderdata.bytes_expected") + " " + (n2 + n3));
                    }
                    if (n3 > 0) {
                        byte[] byArray2 = new byte[n3];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        return byArray2;
                    }
                    return null;
                }
                n2 -= n4;
                n3 += n4;
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n5;
        while ((n5 = a2.aeg.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n5);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        if (page < 1) {
            throw new ViewerException("Page out of allowed range: " + page);
        }
        byte[] byArray = this.c(this.A("get_pg", page), "bin");
        ac ac2 = new ac();
        ac2.data = byArray;
        ac2.readTokens();
        return byArray;
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        this.isRefresh = true;
        this.bKZ = false;
        return this.c(this.A("rfsh", page), "bin");
    }

    @Override
    public int getPageCount() throws ViewerException {
        byte[] byArray = this.c(this.RT(), "bin");
        if (byArray.length == 4) {
            return (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        }
        ac ac2 = new ac();
        ac2.data = byArray;
        ac2.readTokens();
        throw new ViewerException(new String("unknown data from the server: " + String.valueOf(byArray)));
    }

    @Override
    public boolean isPageLimitExceeded() throws ViewerException {
        Properties properties = this.RR();
        properties.put("cmd", "get_pg_limit");
        byte[] byArray = this.c(properties, "bin");
        ak ak2 = new ak();
        ak2.data = byArray;
        ak2.readTokens();
        return ak2.isPageLimitExceeded();
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        if (this.hm == null) {
            throw new ViewerException(com.inet.viewer.i18n.a.getMsg("error.renderdata.getChunkCount_needed"));
        }
        while (true) {
            try {
                if (this.bLa == null) {
                    return null;
                }
                if (this.bLa.bLi < 0) {
                    byte[] byArray = this.a(this.bLa, 4096, false);
                    if (byArray == null) {
                        this.bLa = null;
                    }
                    return byArray;
                }
                if (this.bLa.bLi < 4096) {
                    byte[] byArray = this.a(this.bLa);
                    this.bLa = null;
                    return byArray;
                }
                this.bLa.bLi -= 4096;
                return this.a(this.bLa, 4096, true);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.RP();
                ViewerUtils.debug(bKV);
                continue;
            }
            catch (Exception exception) {
                try {
                    this.bLa.aeg.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.RP();
                throw ViewerException.createViewerException(exception);
            }
            break;
        }
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        this.hm = this.RR();
        this.hm.put("cmd", "export");
        if (expProps != null) {
            Enumeration<?> enumeration = expProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.hm.put(string, ViewerUtils.encode(expProps.getProperty(string)));
            }
        } else {
            throw new IllegalArgumentException("Null is not supported as argument for getExportChunkCount.");
        }
        this.bLa = new a();
        this.a(this.hm, this.hm.getProperty("export_fmt"), true, this.bLa);
        return (int)Math.ceil((double)this.bLa.bLi / 4096.0);
    }

    private void RP() throws ViewerException {
        if (this.bKZ) {
            this.bKZ = false;
            throw new ViewerException(com.inet.viewer.i18n.a.getMsg("error.renderdata.page_rendering_canceled"));
        }
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        return this.c(this.RS(), "bin");
    }

    @Override
    public void setReportTitle(String title) {
        this.hn = title;
    }

    @Override
    public String getReportTitle() {
        return this.hn;
    }

    private Properties RQ() {
        Properties properties = new Properties();
        properties.put("viewer", "java2");
        properties.put("vgen", String.valueOf(this.bKX));
        properties.put("timezone", String.valueOf(this.bKY));
        return properties;
    }

    private Properties RR() {
        Properties properties = this.RQ();
        if (this.bKW != null) {
            Enumeration<?> enumeration = this.bKW.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                properties.put(ViewerUtils.encode(string), ViewerUtils.encode(this.bKW.getProperty(string)));
            }
        }
        return properties;
    }

    private Properties A(String string, int n2) {
        Properties properties = this.RR();
        if (this.isRefresh && this.isPromptOnRefresh()) {
            properties.put("promptOnRefresh", "1");
        } else if (this.isRefresh && !this.isPromptOnRefresh()) {
            properties.put("promptOnRefresh", "0");
        }
        this.isRefresh = false;
        properties.put("cmd", string);
        properties.put("page", String.valueOf(n2));
        return properties;
    }

    private Properties RS() {
        Properties properties = this.RR();
        properties.put("cmd", "get_grouptree");
        return properties;
    }

    private Properties RT() {
        Properties properties = this.RR();
        properties.put("cmd", "get_pg_count");
        return properties;
    }

    @Override
    public final void setReportProperty(String key, String value) {
        if (value == null) {
            this.bKW.remove(key.toLowerCase());
        } else {
            this.bKW.put(key.toLowerCase(), value);
        }
        this.reset();
    }

    @Override
    public final Properties getProperties() {
        this.reset();
        return this.bKW;
    }

    @Override
    public final String getReportProperty(String key) {
        return this.bKW.getProperty(key);
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.reset();
        this.hq = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hq;
    }

    @Override
    public RenderData getCopy() {
        URLRenderData uRLRenderData = new URLRenderData(this.getReportLocation());
        uRLRenderData.isRefresh = this.isRefresh;
        uRLRenderData.bLb = this.bLb;
        uRLRenderData.bKW.putAll((Map<?, ?>)this.bKW);
        uRLRenderData.bLc = this.bLc;
        uRLRenderData.bLd = this.bLd;
        uRLRenderData.bLe = this.bLe;
        return uRLRenderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        WeakHashMap<HttpURLConnection, ?> weakHashMap;
        this.bKZ = true;
        this.a(this.A("stop", 1), "bin", false, null);
        Iterator<HttpURLConnection> iterator = this.bLg;
        synchronized (iterator) {
            weakHashMap = this.bLf;
            this.bLf = new WeakHashMap();
        }
        for (URLConnection uRLConnection : weakHashMap.keySet()) {
            if (uRLConnection == null || !(uRLConnection instanceof HttpURLConnection)) continue;
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        Properties properties = this.RR();
        properties.put("cmd", "search");
        properties.put("phrase", ViewerUtils.encode(phrase));
        properties.put("page", Integer.toString(startPage));
        properties.put("flags", Integer.toString(flags));
        return this.c(properties, "bin");
    }

    @Override
    public byte[] getFontData(int fontID) {
        Properties properties = this.RR();
        properties.put("export_fmt", "font");
        properties.put("cmd", "get_pg");
        properties.put("page", Integer.toString(fontID));
        return this.c(properties, "bin");
    }

    @Override
    public void resetServerCacheTimeout() {
        Properties properties = this.RR();
        properties.put("cmd", "ping");
        byte[] byArray = this.c(properties, "bin");
        ap ap2 = new ap();
        ap2.data = byArray;
        ap2.readTokens();
    }

    public void setForceUseGET(boolean force) {
        this.bLb = force;
    }

    public boolean isForceUseGET() {
        return this.bLb;
    }

    public void setCookie(String cookie) {
        this.bLc = cookie;
    }

    public String getCookie() {
        return this.bLc;
    }

    void RU() {
        this.bKZ = false;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.bLd = sslSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.bLe = hostnameVerifier;
    }

    static {
        bLh.put("application/crystalclear", "bin");
        bLh.put("application/clearreports", "bin");
        bLh.put("application/pdf", "pdf");
        bLh.put("application/ps", "ps");
        bLh.put("application/msword", "rtf");
        bLh.put("application/rtf", "rtf");
        bLh.put("application/jra", "jra");
        bLh.put("application/jar", "jar");
        bLh.put("application/json", "json");
        bLh.put("text/rtf", "rtf");
        bLh.put("application/vnd.ms-excel", "xls");
        bLh.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        bLh.put("text/x-comma-separated-values", "csv");
        bLh.put("text/comma-separated-values", "csv");
        bLh.put("text/xml", "xml");
        bLh.put("text/plain", "txt");
        bLh.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        bLh.put("text/html", "htm");
        bLh.put("image/svg+xml", "svg");
        bLh.put("image/bmp", "bmp");
        bLh.put("image/gif", "gif");
        bLh.put("image/png", "png");
        bLh.put("image/jpeg", "jpg");
        bLh.put("application/zip", "zip");
        bLh.put("application/vnd.oasis.opendocument.spreadsheet", "ods");
    }

    private static class a {
        private InputStream aeg;
        private int bLi;
        private URLConnection bLj;

        private a() {
        }
    }
}

