/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ActionPool;
import com.inet.viewer.CustomPromptEditor;
import com.inet.viewer.ProgressPool;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ReportViewChangeListener;
import com.inet.viewer.ReportViewer;
import com.inet.viewer.SwingReportView;
import com.inet.viewer.SwingToolBar;
import com.inet.viewer.SwingViewerContext;
import com.inet.viewer.ToolBar;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.l;
import com.inet.viewer.n;
import com.inet.viewer.props.DefaultSetting;
import com.inet.viewer.y;
import java.applet.Applet;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PublicApi
public class SwingReportViewer
extends JPanel
implements ReportViewer {
    private ChangeListener bJc = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane jTabbedPane = (JTabbedPane)evt.getSource();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 == -1) {
                return;
            }
            SwingReportViewer.this.setCurrentReportView((SwingReportView)jTabbedPane.getComponentAt(n2));
            SwingReportViewer.this.repaint();
        }
    };
    private int bJd;
    public static final int VERSION_MAJOR = 25;
    public static final int VERSION_MINOR = 10;
    private com.inet.viewer.props.a bJe = new com.inet.viewer.props.b();
    static final Dimension bFr = new Dimension(640, 480);
    private ArrayList bJf = new ArrayList();
    private boolean bsJ = true;
    private boolean bJg = true;
    private boolean bJh;
    private SwingReportView bJi;
    private y bJj;
    private ActionPool bJk;
    private ArrayList bJl = new ArrayList();
    private SwingToolBar bJm;
    private Map bJn = new HashMap();
    private ProgressPool bJo = new ProgressPool();
    private PropertyChangeSupport bCn = new PropertyChangeSupport(this);
    private String bJp;
    private ViewerContext byG;
    public static final int PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR = 0;
    public static final int PRINTER_USE_REPORT_FORMAT = 1;
    private Throwable bJq;
    private final HashMap bGH = new HashMap();
    private Boolean bJr = null;

    public SwingReportViewer() {
        this((ViewerContext)null);
    }

    public SwingReportViewer(ViewerContext context) {
        this.bJk = new ActionPool(this);
        this.bJm = new SwingToolBar(this);
        if (context == null) {
            context = new SwingViewerContext(this);
        }
        this.setViewerContext(context);
        SwingUtilities.invokeLater(new Runnable(){
            private final String[] bJt = new String[]{"notfound.gif", "rootnode.gif", "groupnode_magnifier.gif", "groupnodeexp.gif", "groupnode.gif"};
            private int MZ;

            @Override
            public void run() {
                ViewerUtils.getImageIcon(this.bJt[this.MZ++]);
                if (this.MZ < this.bJt.length) {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        ViewerUtils.logClientData(SwingReportViewer.getVersion());
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        if (this.getLayout() instanceof FlowLayout) {
            this.setLayout(new BorderLayout());
        }
        this.add((Component)this.bJm, "North");
        this.setPreferredSize(bFr);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.Rz();
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.RY()));
        this.a(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.RA();
            }
        };
        abstractAction2.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.RY() | 0x40));
        this.a(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.bJh = !SwingReportViewer.this.bJh;
                for (int i2 = 0; i2 < SwingReportViewer.this.bJf.size(); ++i2) {
                    ((b)SwingReportViewer.this.bJf.get((int)i2)).bJu.Ru().db(SwingReportViewer.this.bJh);
                }
            }
        };
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, ViewerUtils.RY() | 0x40));
        this.a(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingReportViewer.this.bJj != null && SwingReportViewer.this.bJj.indexOfComponent(SwingReportViewer.this.bJi) > 0) {
                    SwingReportViewer.this.closeReportView(SwingReportViewer.this.bJi);
                }
            }
        };
        abstractAction4.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, ViewerUtils.RY()));
        this.a(abstractAction4);
        ActionPool actionPool = this.getActionPool();
        this.a(actionPool.getViewerAction(17));
        this.a(actionPool.getViewerAction(16));
        this.a(actionPool.getViewerAction(15));
        this.a(actionPool.getViewerAction(13));
        this.a(actionPool.getViewerAction(14));
        this.a(actionPool.getViewerAction(18));
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AWTPermission("accessClipboard"));
            }
        }
        catch (SecurityException securityException) {
            actionPool.getViewerAction(1).setEnabled(false);
            actionPool.getViewerAction(2).setEnabled(false);
        }
    }

    @Override
    public void setViewerContext(ViewerContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (context instanceof SwingViewerContext) {
            ((SwingViewerContext)context).setViewer(this);
        }
        this.byG = context;
    }

    @Override
    public ViewerContext getViewerContext() {
        return this.byG;
    }

    private void a(Action action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        this.getInputMap(2).put(keyStroke, action);
        this.getActionMap().put(action, action);
    }

    @Override
    public void closeAllReportViews() {
        ViewerUtils.debug("closing and disposing of all ReportViews...");
        for (b b2 : this.bJf) {
            b2.bJu.unregister();
        }
        this.bJf.clear();
        this.setCurrentReportView(null);
        this.removeAll();
        this.add((Component)this.bJm, "North");
        this.bJj = new y(this);
        this.add((Component)this.bJj, "Center");
        this.repaint();
    }

    @Override
    public void closeReportView(int index) {
        Component component = ((b)this.bJf.get((int)index)).bJu.getComponent();
        this.closeReportView((SwingReportView)component);
    }

    @Override
    public void closeReportView(ReportView view) {
        if (view == null) {
            throw new IllegalArgumentException();
        }
        if (this.bJj == null) {
            return;
        }
        int n2 = this.bJj.indexOfComponent((SwingReportView)view);
        this.bJj.removeTabAt(n2);
        this.bJf.remove(n2);
        this.setCurrentReportView((SwingReportView)this.bJj.getSelectedComponent());
        ((SwingReportView)view).unregister();
    }

    @Override
    public ToolBar getToolBar() {
        return this.bJm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView addNewReportView(RenderData data, boolean isClosable) {
        if (data == null) {
            throw new IllegalArgumentException("RenderData is null");
        }
        ReportView reportView = this.c(data);
        if (reportView != null) {
            return reportView;
        }
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            ReportView reportView2 = this.createReportView(data);
            this.addReportView(reportView2, isClosable);
            return reportView2;
        }
    }

    @Override
    public void addReportView(ReportView repView, boolean isClosable) {
        if (repView == null) {
            throw new IllegalArgumentException();
        }
        RenderData renderData = repView.getReportData();
        this.a(repView, renderData, isClosable);
    }

    @Override
    public ReportView addNewReportView(RenderData data) {
        boolean bl2 = this.bJf.size() > 0;
        return this.addNewReportView(data, bl2);
    }

    public ReportView createReportView(RenderData data) {
        SwingReportView swingReportView = new SwingReportView(this, this.bJe, this.getViewerContext());
        swingReportView.init(data);
        return swingReportView;
    }

    @Override
    public void addReportView(ReportView repView) {
        boolean bl2 = this.bJf.size() > 0;
        this.addReportView(repView, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ReportView reportView, RenderData renderData, boolean bl2) {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            boolean bl3;
            this.setPreferredSize(null);
            this.requestFocusInWindow();
            if (this.c(renderData) != null) {
                return;
            }
            this.bJf.add(new b((SwingReportView)reportView, renderData.getReportLocation(), renderData.getProperties()));
            this.setCurrentReportView(reportView);
            boolean bl4 = bl3 = this.bJj == null;
            if (bl3) {
                this.bJj = new y(this);
                this.add((Component)this.bJj, "Center");
                this.bJj.addChangeListener(this.bJc);
            }
            String string = SwingReportViewer.eg(renderData.getReportTitle());
            this.bJj.a(string, reportView.getComponent(), bl2);
            this.bJj.setSelectedComponent(reportView.getComponent());
            PropertyChangeListener[] propertyChangeListenerArray = this.bCn.getPropertyChangeListeners();
            for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
                reportView.getStatusBar().addStateChangeListener(propertyChangeListenerArray[i2]);
            }
        }
    }

    private ReportView c(RenderData renderData) {
        Iterator iterator = this.bJf.iterator();
        if (this.bJj != null) {
            while (iterator.hasNext()) {
                b b2 = (b)iterator.next();
                if (!b2.My.equals(renderData.getReportLocation()) || !"adhoc".equals(b2.My) && !b2.JO.equals(renderData.getProperties())) continue;
                this.bJj.setSelectedComponent(b2.bJu.getComponent());
                return b2.bJu;
            }
        }
        return null;
    }

    private static String eg(String string) {
        if (string != null && string.length() > 20) {
            String string2 = string.substring(0, 17) + "...";
            return string2;
        }
        return string;
    }

    @Override
    public void removeNotify() {
        if (this.bJj != null) {
            this.bJj.removeChangeListener(this.bJc);
        }
        for (b b2 : this.bJf) {
            b2.bJu.unregister();
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object2;
        if (this.bJj != null) {
            this.bJj.addChangeListener(this.bJc);
        }
        if (this.getRootPane() == null) {
            throw new ViewerException("The top window must be a Swing component - you cannot add the Viewer to a Frame or Dialog, use a JFrame or JDialog instead.");
        }
        for (Object object2 : this.bJf) {
            ((b)object2).bJu.OD();
        }
        object2 = SwingReportViewer.a(this);
        if (object2 instanceof Applet && ((Applet)object2).getAppletContext() != null) {
            this.setViewerContext(new com.inet.viewer.b(this.getViewerContext(), (Applet)object2));
        } else if (this.getViewerContext() == null) {
            this.setViewerContext(new SwingViewerContext(this));
        }
        super.addNotify();
    }

    private static Component a(Component component) {
        Container container = component.getParent();
        if (!(container == null || container instanceof Applet && ((Applet)container).getAppletContext() != null)) {
            return SwingReportViewer.a(container);
        }
        return container;
    }

    void b(n n2, RenderData renderData) {
        RenderData renderData2;
        if (n2 != null && (renderData2 = l.a(n2, renderData)) != null) {
            this.addNewReportView(renderData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView getCurrentReportView() {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            return this.bJi;
        }
    }

    @Override
    public void setCurrentReportView(ReportView rv) {
        int n2;
        if (rv != null && this.bJj != null && (n2 = this.bJj.indexOfComponent(rv.getComponent())) != -1 && n2 != this.bJj.getSelectedIndex()) {
            this.bJj.removeChangeListener(this.bJc);
            this.bJj.setSelectedComponent(rv.getComponent());
            this.bJj.addChangeListener(this.bJc);
            this.repaint();
        }
        this.bJi = (SwingReportView)rv;
        this.Ry();
    }

    @Override
    public void setHasGroupTree(boolean hasGroupTree) {
        this.a(hasGroupTree ? Boolean.TRUE : Boolean.FALSE);
        this.cZ(hasGroupTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cZ(boolean bl2) {
        this.bsJ = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bJf.size(); ++i2) {
                ((b)this.bJf.get((int)i2)).bJu.setHasGroupTree(bl2);
            }
        }
    }

    @Override
    public boolean hasGroupTree() {
        return this.bsJ;
    }

    @Override
    public void setHasStatusBar(boolean hasStatusBar) {
        this.da(hasStatusBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void da(boolean bl2) {
        this.bJg = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bJf.size(); ++i2) {
                ((b)this.bJf.get((int)i2)).bJu.cW(bl2);
            }
        }
    }

    @Override
    public boolean hasStatusBar() {
        return this.bJg;
    }

    boolean Rx() {
        return this.bJh;
    }

    public static int getMajorVersion() {
        return 25;
    }

    public static int getMinorVersion() {
        return 10;
    }

    public static String getVersionSuffix() {
        String string = "";
        return string;
    }

    public static String getVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(25);
        stringBuffer.append(".");
        stringBuffer.append(10);
        stringBuffer.append(".");
        stringBuffer.append("198");
        stringBuffer.append(SwingReportViewer.getVersionSuffix());
        return stringBuffer.toString();
    }

    public ActionPool getActionPool() {
        return this.bJk;
    }

    void d(Throwable throwable) {
        this.bJq = throwable;
    }

    public Throwable getLastError() {
        return this.bJq;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void Ry() {
        for (int i2 = 0; i2 < this.bJl.size(); ++i2) {
            ((ReportViewChangeListener)this.bJl.get(i2)).reportViewChanged(this.bJi);
        }
    }

    @Override
    public void addReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bJl.add(rvcl);
    }

    @Override
    public void removeReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bJl.remove(rvcl);
    }

    public static PrintStream getLoggingStream() {
        return ViewerUtils.getLogStream();
    }

    public static void setLoggingStream(PrintStream stream) {
        ViewerUtils.setLogStream(stream);
    }

    void a(SwingReportView swingReportView, String string) {
        int n2;
        if (this.bJj != null && (n2 = this.bJj.indexOfComponent(swingReportView)) != -1) {
            String string2 = SwingReportViewer.eg(string);
            this.bJj.setTitleAt(n2, string2);
            if (!string.equals(string2)) {
                this.bJj.setToolTipTextAt(n2, string);
            }
            this.bJj.revalidate();
        }
    }

    @Override
    public ReportView getReportView(int i2) {
        return ((b)this.bJf.get((int)i2)).bJu;
    }

    @Override
    public int getReportViewCount() {
        return this.bJf.size();
    }

    @Override
    public void addStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bCn.addPropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().addStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public void removeStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bCn.removePropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().removeStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public ProgressPool getProgressPool() {
        return this.bJo;
    }

    public String getDefaultExportDirectory() {
        return this.RB();
    }

    public void setDefaultExportDirectory(String directory) {
        this.eh(directory);
    }

    private void Rz() {
        if (this.bJj != null) {
            int n2 = this.bJj.indexOfComponent(this.bJi);
            SwingReportView swingReportView = (SwingReportView)this.bJj.getComponentAt((n2 + 1) % this.bJj.getTabCount());
            this.bJj.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    private void RA() {
        if (this.bJj != null) {
            int n2 = this.bJj.indexOfComponent(this.bJi);
            if (n2 == 0) {
                n2 = this.bJj.getTabCount();
            }
            SwingReportView swingReportView = (SwingReportView)this.bJj.getComponentAt((n2 - 1) % this.bJj.getTabCount());
            this.bJj.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    void showError(Throwable th, Object source) {
        this.d(th);
        this.getViewerContext().showError(th, source);
    }

    @Override
    public void setCustomPromptEditor(String promptName, int valueType, CustomPromptEditor editor) {
        promptName = promptName.toLowerCase();
        if (editor == null) {
            this.bJn.remove(new a(promptName, valueType));
        } else {
            this.bJn.put(new a(promptName, valueType), editor);
        }
    }

    CustomPromptEditor z(String string, int n2) {
        CustomPromptEditor customPromptEditor = (CustomPromptEditor)this.bJn.get(new a(string.toLowerCase(), n2));
        if (customPromptEditor != null) {
            return customPromptEditor;
        }
        return (CustomPromptEditor)this.bJn.get(new a(string.toLowerCase(), -1));
    }

    void eh(String string) {
        this.bJp = string;
    }

    String RB() {
        return this.bJp;
    }

    HashMap RC() {
        return this.bGH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void c(PromptData[] promptDataArray) {
        HashMap hashMap = this.bGH;
        synchronized (hashMap) {
            for (int i2 = 0; i2 < promptDataArray.length; ++i2) {
                String string = promptDataArray[i2].getName();
                if (string == null) continue;
                this.bGH.put(string.toLowerCase(), promptDataArray[i2].getPromptValueObject());
            }
        }
    }

    public void setPrinterDefaultFormatHandling(int printerDefaultFormatHandling) {
        if (printerDefaultFormatHandling != 0 && printerDefaultFormatHandling != 1) {
            throw new IllegalArgumentException("parameter must be either PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR or PRINTER_USE_REPORT_FORMAT!");
        }
        this.bJd = printerDefaultFormatHandling;
    }

    public int getPrinterDefaultFormatHandling() {
        return this.bJd;
    }

    void a(Boolean bl2) {
        this.bJr = bl2;
    }

    Boolean RD() {
        return this.bJr;
    }

    public DefaultSetting getDefaultSetting(DefaultSetting.a key) {
        return this.bJe.a(key);
    }

    public void setDefaultSetting(DefaultSetting.a key, DefaultSetting value) {
        this.bJe.a(key, value);
    }

    private static class b {
        private SwingReportView bJu;
        private String My;
        private Properties JO;

        private b(SwingReportView swingReportView, String string, Properties properties) {
            this.bJu = swingReportView;
            this.My = string;
            this.JO = properties;
        }

        public boolean equals(Object obj) {
            return this.bJu.equals(obj) || super.equals(obj);
        }
    }

    private static class a {
        private final String aXa;
        private final int btv;

        private a(String string, int n2) {
            this.aXa = string;
            this.btv = n2;
        }

        public boolean equals(Object obj) {
            return obj instanceof a && ((a)obj).btv == this.btv && (((a)obj).aXa == null && this.aXa == null || ((a)obj).aXa.equals(this.aXa));
        }

        public int hashCode() {
            return this.aXa.hashCode() + this.btv * 17;
        }
    }
}

