/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bCG;
    private int bCA;
    private boolean bCH;
    private Timer bCI;
    private Popup bCJ;
    private JLabel bCK;
    private JPanel bCL;
    private boolean bCM;
    private Point bCN;
    private JComboBox bCO;
    private boolean bCP;
    private boolean bCQ;
    private Class bCR;
    private Constructor bCS;
    private Class[] bCT = new Class[]{String.class};
    private Color bCU;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bCV;

    private RealtimeValidationPopup(int promptType) {
        this.bCA = promptType;
        this.bCK = new JLabel();
        this.bCL = new JPanel();
        this.bCL.setOpaque(true);
        this.bCL.add(this.bCK);
        this.bCL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bCL.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bCI = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bCV == null) {
            return;
        }
        this.bCP = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bCO = surroundingBox;
        }
        this.bCG = textcomponent;
        this.bCG.addFocusListener(this);
        this.bCU = this.bCG.getBackground();
    }

    private void initFormats() {
        this.bCV = null;
        switch (this.bCA % 128) {
            case 6: 
            case 7: {
                this.bCV = this.bCP ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bCV = this.bCP ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bCV = this.bCP ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bCV = this.bCP ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void Pq() {
        if (this.bCG instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bCG.isEnabled() || !this.bCG.isShowing() || object.toString().length() == 0 || this.bCG instanceof JComboBox && ((JComboBox)this.bCG).isPopupVisible() || (this.bCA % 128 == 6 || this.bCA % 128 == 7) && string.equals("-")) {
            if (!this.bCG.isEnabled()) {
                this.bCG.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bCG.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bCV.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bCQ && this.bCR != null) {
                if (this.bCR == Object.class) {
                    this.bCR = String.class;
                }
                this.bCS = this.bCR.getConstructor(this.bCT);
                this.bCS.newInstance(string);
            }
            this.bCH = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bCG.getLocationOnScreen();
                point.y += this.bCG.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bCG.invalidate();
            this.bCG.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bCV, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bCV.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).On();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bCG.getLocationOnScreen();
        point.y += this.bCG.getHeight();
        this.bCH = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.Pr();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bCG.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bCG.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bCG.getLocationOnScreen();
        point.y += this.bCG.getHeight();
        this.bCH = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.Pr();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bCG.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bCG.invalidate();
    }

    private String Pr() {
        Format format = switch (this.bCA) {
            case 9 -> PromptValue.DATEFORMAT;
            case 15 -> PromptValue.DATETIMEFORMAT;
            case 10 -> PromptValue.TIMEFORMAT;
            default -> null;
        };
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bCA == 6 || this.bCA == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ee(string);
        this.bCK.setText(string);
        this.bCL.setBackground(color);
        if (!this.bCM) {
            this.bCN = point;
        } else {
            point = this.bCN;
        }
        if (this.bCJ != null) {
            this.hidePopup();
        }
        this.bCJ = PopupFactory.getSharedInstance().getPopup(this.bCG, this.bCL, point.x, point.y);
        this.bCJ.show();
        this.bCM = true;
        if (this.bCI.isRunning()) {
            this.bCI.restart();
        } else {
            this.bCI.start();
        }
    }

    private String ee(String object) {
        object = this.bCH ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bCG instanceof JPasswordField) {
            return new String(((JPasswordField)this.bCG).getPassword());
        }
        if (this.bCG instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bCG).getText();
            if (this.bCO == null) {
                return string2;
            }
            Object object = this.bCO.getSelectedItem();
            if (this.bCG != null && this.bCO.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bCG instanceof JComboBox) {
            return ((JComboBox)this.bCG).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bCJ != null) {
            this.bCJ.hide();
        }
        this.bCM = false;
        if (this.bCI.isRunning()) {
            this.bCI.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bCQ = checkClassType;
        this.bCR = classtype;
    }

    public void setPromptType(int promptType) {
        this.bCA = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bCG == null) {
            return;
        }
        if (this.bCG instanceof JTextField) {
            ((JTextField)this.bCG).getDocument().removeDocumentListener(this);
        } else if (this.bCG instanceof JComboBox) {
            ((JComboBox)this.bCG).removeActionListener(this);
            ((JComboBox)this.bCG).removePopupMenuListener(this);
        }
        this.bCG.removeFocusListener(this);
        if (this.bCO != null) {
            this.bCO.removeActionListener(this);
            this.bCO.removePopupMenuListener(this);
        }
        this.bCG.setBackground(this.bCU);
    }

    public boolean isPopupError() {
        return this.bCH;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.Pq();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.Pq();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bCV = format;
    }
}

