/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int bxg = -1;
    protected final PropertyChangeSupport bCn = new PropertyChangeSupport(this);
    private int type;
    private int bCo;
    private int progress;
    private boolean bCp = false;
    private String afO;
    private ReportView bCq;
    private ViewerContext byG;
    private Component bAH;
    Thread bCr;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bCq = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bAH = reportView.getComponent();
            this.byG = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.byG = viewerContext;
        this.bAH = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bCr != null && this.bCr.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bCr = new Thread((Runnable)this, this.getName());
        this.bCr.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bCp) {
            this.bCr.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bCr.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bCp;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bCp;
        this.bCp = indeterminate;
        this.bCn.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.bxg;
        this.bxg = status;
        this.bCn.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.bxg);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.bxg == 3 || this.bxg == 2 || this.bxg == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.bxg == 3;
    }

    public boolean isErrored() {
        return this.bxg == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bCo;
        this.bCo = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bCn.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bCo;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bCn.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bCq;
    }

    public int getStatus() {
        return this.bxg;
    }

    public String getErrorMessage() {
        return this.afO;
    }

    public void setErrorMessage(String msg) {
        this.afO = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.byG == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.byG.showError(th, this.bAH);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bCn.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bCn.removePropertyChangeListener(l2);
    }

    protected void Pj() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bCn.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bCn.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

