/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.servlets;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigValue;
import com.inet.config.LicenseInfo;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.http.PluginServlet;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.NetworkFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportKeyFactory;
import com.inet.report.by;
import com.inet.report.config.LicenseKeyInfo;
import com.inet.report.servlets.b;
import com.inet.report.servlets.c;
import com.inet.report.statistic.Accumulator;
import com.inet.report.util.ServletUtils;
import com.inet.report.util.WebUtils;
import com.inet.report.util.i;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ReportPluginServlet
extends HttpServlet
implements PluginServlet {
    public static final String SERVLET_PATH = "/report";
    private static CopyOnWriteArraySet<String> btU;
    private static int btV;
    private static ConfigValue<String> btW;

    @Nonnull
    public String getPathSpec() {
        return SERVLET_PATH;
    }

    public void init(@Nullable ServletConfig config) throws ServletException {
        super.init(config);
        Objects.requireNonNull(config);
        com.inet.shared.servlet.ServletUtils.setServletContext((ServletContext)config.getServletContext());
        LogManager.getLogger((String)"Reporting");
        if (btW == null) {
            Thread thread = new Thread("ReportPluginServlet.init"){

                @Override
                public void run() {
                    by.kE();
                    btW = new ConfigValue<String>(ConfigKey.LICENSEKEY){

                        protected void setValue(@Nullable String value) throws IllegalArgumentException {
                            LicenseInfo licenseInfo = ConfigKeyParser.getCurrent();
                            if (licenseInfo.isValid()) {
                                String string = (String)licenseInfo.getAttributes().get("clientcount");
                                if (string != null) {
                                    btU = new CopyOnWriteArraySet();
                                    btV = Integer.parseInt(string);
                                } else {
                                    string = (String)licenseInfo.getAttributes().get("standalone");
                                    if (Boolean.parseBoolean(string)) {
                                        btU = new CopyOnWriteArraySet();
                                        try {
                                            btU.add("localhost");
                                            btU.add("127.0.0.1");
                                            btU.add("127.0.1.1");
                                            btU.add(IOFunctions.normalizeIPv6((String)"::1"));
                                            InetAddress inetAddress = NetworkFunctions.getLocalHost();
                                            btU.add(NetworkFunctions.getLocalHostName().toLowerCase());
                                            btU.add(inetAddress.getHostAddress().toLowerCase());
                                            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                                            while (enumeration.hasMoreElements()) {
                                                NetworkInterface networkInterface = enumeration.nextElement();
                                                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                                                while (enumeration2.hasMoreElements()) {
                                                    InetAddress inetAddress2 = enumeration2.nextElement();
                                                    btU.add(inetAddress2.getHostAddress().toLowerCase());
                                                }
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        btV = btU.size();
                                    } else {
                                        btU = null;
                                        btV = 0;
                                    }
                                }
                                return;
                            }
                        }
                    };
                }
            };
            thread.start();
        }
    }

    public void destroy() {
        BaseUtils.info("Servlet destroy called");
        Engine.shutdown();
        super.destroy();
    }

    public void doExecRequest(@Nonnull Properties props, @Nonnull HttpServletRequest req, HttpServletResponse res) throws Exception {
        ServletOutputStream servletOutputStream = res.getOutputStream();
        WebUtils.execRequestCache(req, res, (OutputStream)servletOutputStream, props, (PropertiesChecker)b.btT.get());
    }

    private static final void dG(String string) throws ReportException {
        if (btU != null) {
            if (string.indexOf(58) >= 0) {
                string = IOFunctions.normalizeIPv6((String)string);
            }
            if (!btU.contains(string)) {
                btU.add(string);
                if (btU.size() > btV) {
                    btU.remove(string);
                    String string2 = btU.toString();
                    String string3 = ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getDefaultSupportAddress();
                    throw ReportExceptionFactory.createReportException((ErrorCode)BaseErrorCode.MaxClients, LicenseKeyInfo.getCurrent().getLicenseText(), string2, string, string3);
                }
            }
        }
    }

    public void afterPropertiesStoredHook(HttpServletRequest req, HttpServletResponse res, Properties props) throws ServletException, IOException {
    }

    public void service(@Nullable HttpServletRequest req, @Nullable HttpServletResponse res) throws ServletException, IOException {
        Objects.requireNonNull(req);
        Objects.requireNonNull(res);
        String string = req.getMethod();
        Objects.requireNonNull(string);
        String string2 = req.getRequestURI();
        if (string.equals("HEAD") && string2 != null && string2.endsWith("/reportserver")) {
            res.setStatus(204);
            return;
        }
        Accumulator.incTotalRequest();
        Properties properties = com.inet.shared.servlet.ServletUtils.getAllParameters((HttpServletRequest)req);
        i.n(properties);
        try {
            ReportKeyFactory.decodeProps(properties);
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        String string3 = req.getHeader("Cookie");
        if (string3 != null && string3.length() > 0) {
            properties.put("cookie", string3);
        }
        ServletUtils.setContextProperties(req, properties);
        properties.put("locale", ClientLocale.getThreadLocale().toString());
        if (!properties.containsKey("timezone")) {
            properties.put("timezone", ClientTimezone.getTimeZone().getID());
        }
        try {
            this.afterPropertiesStoredHook(req, res, properties);
            c.a(properties, "after properties stored");
            c.m(properties);
            ReportPluginServlet.dG(SessionStore.getRemoteAddr());
            Accumulator.incReportRequest();
            by.f(properties);
            this.doExecRequest(properties, req, res);
        }
        catch (Exception exception) {
            ServletErrorHandler.sendErrorPage((HttpServletRequest)req, (HttpServletResponse)res, (Throwable)exception);
        }
    }
}

