/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.html;

import com.inet.graphics.encode.PNGEncoder;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.layout.richhtml.b;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.html.d;
import com.inet.report.renderer.html.f;
import com.inet.report.renderer.html.tree.a;
import com.inet.report.renderer.html.tree.e;
import com.inet.shared.utils.MemoryStream;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class HtmlDocumentWriter
extends AbstractDocumentWriter {
    private static final int aLm = ",\"url\":\"".length();
    private final f aLn;
    private final boolean aLo;
    private boolean aLp;
    private boolean aLq;
    private boolean aLr;
    @Nonnull
    private final MemoryStream aLs;
    private final MemoryStream aLt = new MemoryStream();
    private int bi;
    private int Ki;
    private WriterCapabilities aKf;
    private int aLu;
    private int aLv;
    private HashMap<String, String> aLw;
    private e aLx;
    private String aLy;
    private int aHN;
    private int aHO;
    private int aHP;
    private int aHQ;

    public HtmlDocumentWriter() {
        this(false);
    }

    public HtmlDocumentWriter(boolean isZip) {
        this.aLo = isZip;
        this.aLs = new MemoryStream();
        this.aLn = new f(this);
        this.aKf = new d(this.aLp);
        this.aLw = new HashMap();
    }

    @Override
    public void startDocument() throws ReportException {
        b.vt();
        super.startDocument();
    }

    @Override
    @Nonnull
    public Layout getLayout() {
        return this.aLn;
    }

    @Override
    public void startPage() throws ReportException {
        super.startPage();
        if (!this.aLr) {
            this.aLt.setLength(0);
            ++this.aLu;
            this.aLv = 0;
            this.aLn.refresh();
            this.aLn.startPage();
            if (this.aLq || this.aLp) {
                this.aLr = true;
            }
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
        HtmlDocumentWriter.K(null, ".........endPage..........");
        if (this.aLr) {
            this.aLn.Dp();
            this.aLn.De();
            this.aLn.Di();
        } else {
            this.CT();
        }
        this.aLn.bP(false);
    }

    void CT() {
        Object object;
        this.aLn.De();
        this.aLn.Di();
        this.aLs.writeASCII("<!DOCTYPE html>");
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("<html>");
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("<head>");
        HtmlDocumentWriter.M(this.aLs);
        this.CY();
        this.aLs.writeASCII("<style type=\"text/css\">");
        HtmlDocumentWriter.M(this.aLs);
        this.aLn.R(this.aLs);
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("</style>");
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("<script type=\"text/javascript\">");
        if (this.aLu == 1) {
            object = this.getMetaData();
            HtmlDocumentWriter.M(this.aLs);
            this.aLs.writeASCII("var permissions={allowprint:");
            this.aLs.writeASCII(Boolean.toString(object.isPrintingEnabled()));
            this.aLs.writeASCII(",enabledFormats:");
            try {
                String[] stringArray = object.getEnabledFormats();
                if (stringArray == null) {
                    this.aLs.writeASCII("null");
                } else {
                    new Json().toJson((Object)stringArray, (OutputStream)this.aLs);
                }
            }
            catch (IOException iOException) {
                BaseUtils.error(iOException.getMessage());
            }
            this.aLs.writeASCII("};");
            HtmlDocumentWriter.M(this.aLs);
        }
        try {
            HtmlDocumentWriter.b("viewer/helper/events.js", this.aLs);
            HtmlDocumentWriter.b("viewer/page.js", this.aLs);
        }
        catch (IOException iOException) {
            BaseUtils.error(iOException.getMessage());
        }
        this.aLs.writeASCII("</script>");
        this.aLs.writeASCII("</head>");
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("<body");
        this.aLs.writeASCII(" class=\"page" + this.aLu + "\">");
        HtmlDocumentWriter.M(this.aLs);
        this.aLn.an().writeTo(this.aLs);
        this.aLn.a(this.aLs, false, true);
        this.aLn.an().reset();
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("</body>");
        HtmlDocumentWriter.M(this.aLs);
        this.aLs.writeASCII("</html>");
        object = this.aLu + ".html";
        HtmlDocumentWriter.a((String)object, this.aLs.toByteArray(), this.aLt);
        this.i(this.aLt, -1);
        this.aLs.reset();
        this.aLn.Dj();
        this.aLn.Dq();
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        if (this.aLr) {
            this.CT();
        }
        super.endDocument();
        String string = this.aLx != null ? this.aLx.Ee() : "[]";
        string = this.ct(string);
        String string2 = this.p(string, this.aLu);
        this.aLt.setLength(0);
        HtmlDocumentWriter.a("0.json", BaseUtils.getBytesUTF8(string2), this.aLt);
        try {
            object = new MemoryStream();
            try {
                object.writeASCII("var groupTreeJson=");
                Json json = new Json();
                StringBuilder stringBuilder = new StringBuilder();
                json.toJson((Object)string2, stringBuilder);
                object.write(BaseUtils.getBytesUTF8(stringBuilder.toString()));
                object.writeASCII(";");
                HtmlDocumentWriter.a("0.js", object.toByteArray(), this.aLt);
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            throw new ReportException("Memory Stream unexpectedly aborted.", -1);
        }
        if (this.aLo && (object = (Object)this.getMetaData().getThumbnailData()) != null) {
            HtmlDocumentWriter.a("thumbnail.png", (byte[])object, this.aLt);
        }
        this.getPages().setGroupTree(this.aLt.toByteArray());
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.bi = width;
        this.Ki = height;
        this.aHN = topMargin;
        this.aHO = leftMargin;
        this.aHP = bottomMargin;
        this.aHQ = rightMargin;
    }

    String CU() {
        return String.valueOf(this.aLu);
    }

    public static void M(MemoryStream memoryStream) {
        memoryStream.write(10);
    }

    public int CV() {
        return this.Ki;
    }

    public int CW() {
        if (this.aLp || this.aLq) {
            return Math.max(this.aLn.Dn() + this.aHN + this.aHP, this.Ki);
        }
        return this.Ki;
    }

    public int CX() {
        return this.bi;
    }

    @Override
    @Nonnull
    public WriterCapabilities getCapabilities() {
        return this.aKf;
    }

    private void CY() {
        DocumentMetaData documentMetaData = this.getMetaData();
        this.aLs.writeASCII("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        if (documentMetaData != null) {
            this.J("title", documentMetaData.getTitle());
            this.J("keywords", documentMetaData.getKeyWords());
            this.J("subject", documentMetaData.getSubject());
            this.J("template", documentMetaData.getTemplate());
            this.J("comments", documentMetaData.getComments());
            this.b("createTime", documentMetaData.getPrintTime());
            this.J("generator", "i-net Clear Reports");
        }
    }

    private void J(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        this.aLs.writeASCII("<meta name=\"" + string + "\" content=\"" + string2 + "\" />");
        HtmlDocumentWriter.M(this.aLs);
    }

    private void b(String string, Date date) {
        if (date == null) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String string2 = simpleDateFormat.format(date);
        this.J(string, string2);
    }

    String a(String string, Image image, byte[] byArray) {
        Object object;
        Object object2 = object = string != null ? this.aLw.get(string) : null;
        if (object == null) {
            if (image == null) {
                return "";
            }
            if (byArray == null) {
                byArray = PNGEncoder.getPNGImageData((Image)image);
            }
            if (byArray != null) {
                String string2 = MimeTypes.getMimeTypeFromData((byte[])byArray);
                String string3 = string2 == "image/svg+xml" || string2 == "text/xml; charset=utf-8" ? ".svg" : ".png";
                object = String.valueOf(this.aLu) + "-" + ++this.aLv + string3;
                HtmlDocumentWriter.a((String)object, byArray, this.aLt);
                if (this.aLy != null) {
                    object = (String)object + this.aLy + (String)object;
                }
                if (string != null) {
                    this.aLw.put(string, (String)object);
                }
            } else {
                return "";
            }
        }
        return object;
    }

    String a(String string, String string2, byte[] byArray) {
        Object object;
        Object object2 = object = string != null ? this.aLw.get(string) : null;
        if (object != null) {
            return object;
        }
        if (byArray == null) {
            return "";
        }
        object = String.valueOf(this.aLu) + "-" + ++this.aLv + "." + (string2 != null ? string2 : ".png");
        HtmlDocumentWriter.a((String)object, byArray, this.aLt);
        if (this.aLy != null) {
            object = (String)object + this.aLy + (String)object;
        }
        if (string != null) {
            this.aLw.put(string, (String)object);
        }
        return object;
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data, @Nullable String additionalWriterOptions) {
        HtmlDocumentWriter.a(fileName, data, this.aLt);
    }

    private void i(MemoryStream memoryStream, int n2) {
        if (n2 == -1) {
            this.getPages().addPage(memoryStream.toByteArray());
        } else {
            this.getPages().setPageData(memoryStream.toByteArray(), n2);
        }
    }

    private static void a(String string, byte[] byArray, MemoryStream memoryStream) {
        byte[] byArray2 = BaseUtils.getBytesUTF8(string);
        memoryStream.writeInverseInt(byArray2.length);
        memoryStream.write(byArray2);
        memoryStream.writeInverseInt(byArray.length);
        memoryStream.write(byArray);
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        super.setUserProperties(props);
        if (props == null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("html export: user properties not defined");
            }
        } else {
            String string = props.getProperty("layout");
            if (string != null) {
                if (string.equals("single")) {
                    this.aLp = true;
                    ((d)this.aKf).bM(this.aLp);
                    this.aLn.Do();
                } else if (string.equals("concat")) {
                    this.aLq = true;
                    this.aLn.Do();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Report name is provided by user and checked before rendering. Also we're just reading the file name")
    private String p(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"grouptreeData\":");
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(',');
        stringBuilder.append(" \"pageCount\":");
        stringBuilder.append('\"');
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append('\"');
        int n3 = Math.round((float)this.bi / 15.0f);
        int n4 = Math.round((float)this.Ki / 15.0f);
        int n5 = Math.round((float)this.bi / 566.92914f * 10.0f);
        int n6 = Math.round((float)this.Ki / 566.92914f * 10.0f);
        if (this.aLp || this.aLq) {
            n4 = Math.max(Math.round((float)(this.aLn.Dn() + this.aHN + this.aHP) / 15.0f * 10.0f), n4);
            n6 = Math.max(Math.round((float)(this.aLn.Dn() + this.aHN + this.aHP) / 566.92914f * 10.0f), n6);
        }
        stringBuilder.append(',');
        stringBuilder.append(" \"page\":{\"width\":\"");
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append('\"');
        stringBuilder.append(',');
        stringBuilder.append(" \"height\":\"");
        stringBuilder.append(String.valueOf(n4));
        stringBuilder.append('\"');
        stringBuilder.append(',');
        stringBuilder.append(" \"print\":{\"width\":\"");
        stringBuilder.append(String.valueOf(n5));
        stringBuilder.append("mm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"height\":\"");
        stringBuilder.append(String.valueOf(n6));
        stringBuilder.append("mm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"margin\":{\"left\":\"");
        stringBuilder.append(String.valueOf((float)this.aHO / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"right\":\"");
        stringBuilder.append(String.valueOf((float)this.aHQ / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"bottom\":\"");
        stringBuilder.append(String.valueOf((float)this.aHP / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"top\":\"");
        stringBuilder.append(String.valueOf((float)this.aHN / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append('}');
        stringBuilder.append('}');
        stringBuilder.append('}');
        DocumentMetaData documentMetaData = this.getMetaData();
        this.c(stringBuilder, "title", documentMetaData.getTitle());
        this.c(stringBuilder, "author", documentMetaData.getAuthor());
        this.c(stringBuilder, "subject", documentMetaData.getSubject());
        this.c(stringBuilder, "keywords", documentMetaData.getKeyWords());
        this.c(stringBuilder, "comments", documentMetaData.getComments());
        String string2 = HtmlDocumentWriter.j(this.getProperties());
        if (string2 != null) {
            this.c(stringBuilder, "report", string2 + ".rpt");
        } else if (documentMetaData.getReportURL() != null) {
            this.c(stringBuilder, "report", new File(documentMetaData.getReportURL().getFile()).getName());
        }
        if (documentMetaData.getPrintTime() != null) {
            this.c(stringBuilder, "created", "" + documentMetaData.getPrintTime().getTime());
        }
        String string3 = this.getPages() != null && this.getPages().isPageLimitExceeded() ? "true" : "false";
        stringBuilder.append(',');
        stringBuilder.append("\"isPageLimitExceeded\":\"");
        stringBuilder.append(string3);
        stringBuilder.append('\"');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void c(StringBuilder stringBuilder, String string, String string2) {
        if (StringFunctions.isEmpty((String)string2)) {
            return;
        }
        stringBuilder.append(',');
        stringBuilder.append("\"" + string + "\":");
        new Json().toJson((Object)string2, stringBuilder);
    }

    e CZ() {
        if (this.aLx == null) {
            this.aLx = new a();
        }
        return this.aLx;
    }

    int AZ() {
        return this.aHO;
    }

    int AY() {
        return this.aHN;
    }

    int Bb() {
        return this.aHQ;
    }

    int Ba() {
        return this.aHP;
    }

    static void b(@Nonnull String string, MemoryStream memoryStream) throws IOException {
        URL uRL = HtmlDocumentWriter.class.getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException("resource: " + string + " not found");
        }
        byte[] byArray = IOFunctions.getFileBuffer((URL)uRL);
        memoryStream.write(byArray);
    }

    private String ct(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -6;
        int n3 = 0;
        while ((n2 = string.indexOf(",\"url\":\"", n2 + 6)) != -1) {
            int n4 = n2 + aLm;
            if (n4 >= string.length() || string.charAt(n4) != '\"') continue;
            stringBuilder.append(string.substring(n3, n2));
            n3 = n4 + 1;
        }
        if (n3 != 0) {
            stringBuilder.append(string.substring(n3, string.length()));
            string = stringBuilder.toString();
        }
        return string;
    }

    public static void K(String string, String string2) {
    }

    @Nullable
    public static String j(@Nullable Properties properties) {
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("report");
        if (string != null) {
            int n2 = Math.max(string.lastIndexOf("/"), string.lastIndexOf(92));
            if (n2 != -1 && n2 != string.length() - 1) {
                if ((string = string.substring(n2 + 1)).endsWith(".rpt")) {
                    string = string.substring(0, string.length() - ".rpt".length());
                }
            } else {
                string = null;
            }
        }
        return string;
    }
}

