/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.docx;

import com.inet.annotations.InternalApi;
import com.inet.font.layout.FontContext;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.certificate.CertificateInfo;
import com.inet.report.encode.c;
import com.inet.report.layout.BulletChunk;
import com.inet.report.layout.Chunk;
import com.inet.report.layout.HyperlinkChunk;
import com.inet.report.layout.ImageChunk;
import com.inet.report.layout.IndentChunk;
import com.inet.report.layout.LineBreakChunk;
import com.inet.report.layout.ListChunk;
import com.inet.report.layout.TextChunk;
import com.inet.report.renderer.doc.Adornment;
import com.inet.report.renderer.doc.CellAdornment;
import com.inet.report.renderer.doc.StyledLayout;
import com.inet.report.renderer.docx.b;
import com.inet.report.renderer.docx.e;
import com.inet.report.renderer.docx.models.a;
import com.inet.report.renderer.docx.models.d;
import com.inet.report.renderer.docx.models.f;
import com.inet.report.renderer.docx.models.g;
import com.inet.report.renderer.docx.models.l;
import com.inet.report.renderer.docx.models.m;
import com.inet.report.renderer.docx.models.n;
import com.inet.report.renderer.docx.models.o;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Supplier;
import javax.imageio.ImageIO;

@InternalApi
public class DocxStyledLayout
extends b
implements StyledLayout {
    private com.inet.report.renderer.docx.models.b aHC;
    private o aHm;
    private n aHn;
    private m aHD;
    private boolean aHp = false;
    private int aHq = -1;

    public DocxStyledLayout(com.inet.report.util.zip.a zipOutputStream) {
        super(zipOutputStream);
    }

    @Override
    public void startReport(e pageLayout) throws IOException {
        super.startReport(pageLayout);
        this.aHt.Bo().cn("<w:p>");
    }

    @Override
    public void finishReport(l properties, String applicationName) throws IOException {
        this.aHt.Bo().cn("</w:p>");
        super.finishReport(properties, applicationName);
    }

    @Override
    public void startBand(int y2, int[] heights) throws ReportException {
    }

    @Override
    public void startContainer(int x2, int y2, int width, int height, int backgroundColor, boolean underlayFollow) throws ReportException {
        if (this.aHD != null) {
            x2 += this.aHD.getX();
            y2 += this.aHD.getY();
        }
        this.aHC = new com.inet.report.renderer.docx.models.b(x2, y2, width, height);
        try {
            this.aHt.a(this.aHC, new Adornment(backgroundColor), false);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void endContainer() throws ReportException {
        this.aHC = null;
    }

    @Override
    public void endBand() throws ReportException {
    }

    @Override
    public void startSubreport(int x2, int y2, int width, int height, Adornment adornment, String tooltip) throws ReportException {
        x2 = this.fl(x2);
        y2 = this.fm(y2);
        this.aHD = new m(x2, y2, this.aHC);
        this.aHt.Bh();
        try {
            com.inet.report.renderer.docx.models.b b2 = new com.inet.report.renderer.docx.models.b(x2, y2, width, height);
            this.aHt.a(b2, adornment, true);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void endSubreport() throws ReportException {
        this.aHC = this.aHD.BL();
        this.aHD = null;
        this.aHt.Bi();
    }

    @Override
    public void startGroup(int groupLevel, String groupLabel, String requestUrl) throws ReportException {
    }

    @Override
    public void endGroup() {
    }

    @Override
    public void startTextBox(int x2, int y2, int width, int height, boolean canGrow, Adornment adornment, int vAlign, int rotation, int glyphOrientation, String url, String toolTip, boolean isRichHtml) throws ReportException {
        Object object;
        o.a a2 = this.toRotationType(rotation);
        if (this.aHn == null) {
            x2 = this.fl(x2);
            y2 = this.fm(y2);
        } else {
            object = this.aHn.yQ();
            x2 -= ((Insets)object).left;
            y2 -= ((Insets)object).top;
        }
        object = this.createHyperlink(url, toolTip, this.aHn);
        this.aHm = o.a(x2, y2, width, height, adornment, a2, (d)object, this.aHu, this.aHv, this.createWriterForMemoryStream());
    }

    @Override
    public void drawChunk(Chunk chunk, int x2, int y2, int align) throws ReportException {
        align = this.convertDefaultAlignIfNeeded(align);
        try {
            switch (chunk.getChunkType()) {
                case 1: {
                    TextChunk textChunk = (TextChunk)chunk;
                    this.aHm.a(textChunk.getText(), textChunk.getFontContext(), align, Optional.empty());
                    break;
                }
                case 2: {
                    LineBreakChunk lineBreakChunk = (LineBreakChunk)chunk;
                    this.aHm.a(lineBreakChunk.getFirstLineIndent(), lineBreakChunk.getLeftIndent(), lineBreakChunk.getRightIndent(), lineBreakChunk.getLineSpacingAbsolute(), lineBreakChunk.getLineSpacingRelative());
                    int n2 = lineBreakChunk.getHeight();
                    if (n2 > 0) {
                        int n3 = n2 / 25;
                        this.aHm.fx(n3);
                    }
                    if (lineBreakChunk.isWordWrapLineBreak()) {
                        this.aHm.cp(lineBreakChunk.getWordWrapDiff());
                        break;
                    }
                    if (lineBreakChunk.isOnlyLineBreak()) {
                        this.aHm.vc();
                        break;
                    }
                    this.aHm.vc();
                    this.aHm.vc();
                    break;
                }
                case 3: {
                    BulletChunk bulletChunk = (BulletChunk)chunk;
                    g g2 = g.a(bulletChunk.getBulletType(), g.aIt);
                    this.aHm.a(bulletChunk.getValue(), g2, align);
                    break;
                }
                case 4: {
                    ListChunk listChunk = (ListChunk)chunk;
                    if (listChunk.isBeginningTag()) {
                        g g3 = g.a(listChunk.getListType(), g.aIt);
                        this.aHm.c(g3);
                        break;
                    }
                    if (this.aHq == 3) {
                        this.aHm.vc();
                    }
                    this.aHm.BU();
                    break;
                }
                case 5: {
                    IndentChunk indentChunk = (IndentChunk)chunk;
                    if (!indentChunk.isTab()) break;
                    this.aHm.fy(1);
                    break;
                }
                case 6: {
                    ImageChunk imageChunk = (ImageChunk)chunk;
                    int n4 = imageChunk.getWidth() * 15;
                    int n5 = imageChunk.getHeight() * 15;
                    this.aHm.a((BufferedImage)imageChunk.getImage(), n4, n5, align, this.aHy);
                    break;
                }
                case 7: {
                    HyperlinkChunk hyperlinkChunk = (HyperlinkChunk)chunk;
                    if (hyperlinkChunk.isBeginningTag()) {
                        this.aHm.a(hyperlinkChunk.getURL(), hyperlinkChunk.getColor(), this.aHw);
                        break;
                    }
                    this.aHm.BV();
                }
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        this.aHq = chunk.getChunkType();
    }

    @Override
    public void endTextBox() throws ReportException {
        try {
            this.aHm.Bg();
            if (this.aHn != null) {
                this.aHt.a(this.aHm, true);
            } else {
                this.aHt.a(this.aHm);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        this.aHm = null;
    }

    @Override
    public void drawBox(int x2, int y2, int width, int height, Adornment adornment, String url, String toolTip, boolean mso) throws ReportException {
        Object object;
        if (this.aHn == null) {
            x2 = this.fl(x2);
            y2 = this.fm(y2);
        } else {
            object = this.aHn.yQ();
            x2 -= ((Insets)object).left;
            y2 -= ((Insets)object).top;
        }
        if (adornment.getTopStyle() != 0) {
            int n2;
            if (adornment.getTopStyle() == 2) {
                int n3 = adornment.getLineWidth() * 3;
                adornment = adornment.clone();
                adornment.setLinewidth(n3);
            }
            if (width > (n2 = adornment.getLineWidth())) {
                width -= n2;
                x2 += n2 / 2;
            }
            if (height > n2) {
                height -= n2;
                y2 += n2 / 2;
            }
        }
        object = this.createHyperlink(url, toolTip, this.aHn);
        a a2 = new a(x2, y2, width, height, adornment, (d)object);
        try {
            if (this.aHn != null) {
                this.aHt.a(a2);
            } else {
                this.aHt.a(a2, mso);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void drawLine(int x2, int y2, int width, int height, Adornment adornment) throws ReportException {
        Object object;
        int n2 = adornment.getTopStyle();
        int n3 = adornment.getBorderColor();
        int n4 = adornment.getLineWidth();
        if (this.aHn == null) {
            x2 = this.fl(x2);
            y2 = this.fm(y2);
        } else {
            object = this.aHn.yQ();
            x2 -= ((Insets)object).left;
            y2 -= ((Insets)object).top;
        }
        object = new f(x2, y2, width, height, n2, n3, n4);
        try {
            if (this.aHn != null) {
                this.aHt.b((f)object);
            } else {
                this.aHt.a((f)object);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void startSignature(int x2, int y2, int width, int height, Adornment adornment, CertificateInfo certificateInfo) throws ReportException {
    }

    @Override
    public void endSignature() throws ReportException {
    }

    @Override
    public void drawFormField(int x2, int y2, int width, int height, Adornment adornment, int formFieldType, String[] values, FontContext fontContext, String formName) throws ReportException {
    }

    @Override
    public void drawSorting(int x2, int y2, int width, int height, Adornment adornment, String url, String toolTip, boolean down, boolean alphaNumeric) throws ReportException {
    }

    @Override
    public byte[] drawImage(Image img, byte[] imgData, String imageKey, Rectangle borderRect, Rectangle imageRect, Adornment adornment, String url, String toolTip) throws ReportException {
        Object object;
        if (borderRect == imageRect) {
            imageRect = new Rectangle(imageRect);
        }
        if (imgData == null && img != null) {
            try {
                object = new FastByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)((BufferedImage)img), "png", (OutputStream)object);
                    imgData = object.toByteArray();
                }
                finally {
                    object.close();
                }
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        if (this.aHn == null) {
            borderRect.x = this.fl(borderRect.x);
            borderRect.y = this.fm(borderRect.y);
            imageRect.x = this.fl(imageRect.x);
            imageRect.y = this.fm(imageRect.y);
        } else {
            object = this.aHn.yQ();
            borderRect.x -= object.left;
            imageRect.x -= object.left;
        }
        object = this.createHyperlink(url, toolTip, this.aHn);
        com.inet.report.renderer.docx.models.e e2 = new com.inet.report.renderer.docx.models.e((BufferedImage)img, imgData, borderRect, imageRect, adornment, (d)object, imageKey);
        try {
            if (this.aHn != null) {
                this.aHt.c(e2);
            } else {
                this.aHt.a(e2);
            }
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        return imgData;
    }

    @Override
    public Graphics2D createGraphics(int x2, int y2, int width, int height, Adornment adornment, String url, String toolTip) throws ReportException {
        Supplier<com.inet.report.encode.b> supplier = () -> this.aJ(width, height);
        Runnable runnable = () -> {
            Cloneable cloneable;
            byte[] byArray = this.AQ();
            this.AR();
            if (byArray == null) {
                return;
            }
            Rectangle rectangle = new Rectangle(x2, y2, width, height);
            if (this.aHn == null) {
                rectangle.x = this.fl(rectangle.x);
                rectangle.y = this.fm(rectangle.y);
            } else {
                cloneable = this.aHn.yQ();
                rectangle.x -= cloneable.left;
            }
            cloneable = new Rectangle(rectangle);
            d d2 = this.createHyperlink(url, toolTip, this.aHn);
            com.inet.report.renderer.docx.models.e e2 = new com.inet.report.renderer.docx.models.e(null, byArray, rectangle, (Rectangle)cloneable, adornment, d2, null);
            try {
                if (this.aHn != null) {
                    this.aHt.c(e2);
                } else {
                    this.aHt.d(e2);
                }
            }
            catch (IOException iOException) {
                BaseUtils.error("An error occurred while adding EMF file to the report in docx format:");
                BaseUtils.error(iOException);
            }
        };
        e e2 = this.getPageLayout();
        return new c(x2, y2, width, height, supplier, runnable, e2.getWidth(), e2.getHeight());
    }

    @Override
    public void removeGraphics(Graphics2D g2, Exception ex) {
        this.AR();
    }

    @Override
    public void startTable(int x2, int y2, int[] colWidths, int[] rowHeights, Adornment adornment, String url, String toolTip, Insets cellMargins) throws ReportException {
        x2 = this.fl(x2);
        y2 = this.fm(y2);
        d d2 = d.I(url, toolTip);
        this.aHn = new n(x2, y2, colWidths, rowHeights, adornment, d2, cellMargins);
        this.aHp = true;
    }

    @Override
    public void startRow() throws ReportException {
        if (this.aHp) {
            return;
        }
        try {
            int n2 = this.aHn.BM();
            this.aHt.fq(n2);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void startCell(int col, int row, int colSpan, int rowSpan, CellAdornment cellAdornment, Adornment textboxAdornment, Insets insets, int vAlign, int rotation, int glyphOrientation, String url, String toolTip) throws ReportException {
        int n2;
        int n3;
        if (textboxAdornment != null) {
            n3 = this.aHn.aK(col, colSpan);
            n2 = this.aHn.aL(row, rowSpan);
            if (insets != null) {
                n3 = n3 - insets.left - insets.right;
                n2 = n2 - insets.top - insets.bottom;
            }
            o.a a2 = this.toRotationType(rotation);
            d d2 = this.createHyperlink(url, toolTip, this.aHn);
            this.aHm = o.a(0, 0, n3, n2, textboxAdornment, a2, d2, this.aHu, this.aHv, this.createWriterForMemoryStream());
        }
        if (insets == null && col == 0 && row == 0) {
            insets = new Insets(0, this.aHn.yQ().left, 0, 0);
        }
        try {
            if (this.aHp) {
                n3 = this.aHn.getX() + insets.left;
                this.aHt.b(n3, this.aHn.getY(), this.aHn.Aa(), this.aHn.ye());
                n2 = this.aHn.BM();
                this.aHt.fq(n2);
                this.aHp = false;
            }
            for (n.b b2 : this.aHn.fw(col)) {
                this.aHt.a(b2.BP(), b2.BQ());
            }
            this.aHt.b(colSpan, rowSpan, cellAdornment, insets);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        this.aHn.a(col, row, colSpan, rowSpan, cellAdornment);
    }

    @Override
    public void endCell() throws ReportException {
        try {
            if (this.aHm != null) {
                this.aHm.Bg();
                this.aHt.a(this.aHm, false);
            }
            this.aHt.Bk();
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        this.aHm = null;
    }

    @Override
    public void endRow() throws ReportException {
        try {
            for (n.b b2 : this.aHn.fw(this.aHn.getColumnCount())) {
                this.aHt.a(b2.BP(), b2.BQ());
            }
            this.aHt.Bl();
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void endTable() throws ReportException {
        this.aHn = null;
        try {
            this.aHt.Bn();
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void startMulticolumnRegion(int[] columnPositions, boolean isAcrossThenDown) {
    }

    @Override
    public void endMulticolumnRegion() {
    }

    @Override
    public void repeatGroupHeaders() {
    }

    private int fl(int n2) {
        return this.aHC == null ? n2 : this.aHC.getX() + n2;
    }

    private int fm(int n2) {
        return this.aHC == null ? n2 : this.aHC.getY() + n2;
    }
}

