/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.api.implementation;

import com.inet.report.Engine;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ba;
import com.inet.report.be;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFormatCategory;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.renderer.api.commands.c;
import com.inet.report.renderer.doc.DocumentWriter;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.report.util.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class q
extends c
implements RendererFactory {
    @Nonnull
    public String getExtensionName() {
        return "svg";
    }

    @Override
    @Nonnull
    public RendererFormatCategory getCategoryName() {
        return new RendererFormatCategory("renderer.category.img");
    }

    @Override
    @Nonnull
    public ba<?> getRendererDocument(@Nonnull Engine parentEngine, @Nonnull String exportFormat) {
        return new be(parentEngine);
    }

    @Override
    @Nullable
    public DocumentWriter getDocumentWriter(@Nonnull String exportFormat) {
        return null;
    }

    @Override
    @Nonnull
    public String getMimeType() {
        return "image/svg+xml";
    }

    @Override
    @Nullable
    public ToClientCmd getToClientCmd(@Nonnull String exportFormat) {
        return this;
    }

    @Override
    public void exportPageToClient(@Nonnull Cache cache, int size, int count, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull ReportCacheKey key, @Nonnull String httpContentType, @Nullable String page, @Nonnull Properties props) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = props.getProperty("file");
        if (string == null || string.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoExportFile, new Object[0]);
        }
        string = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf("."));
        int n2 = SVGUtils.getAutoRefresh(props);
        byteArrayOutputStream.write(SVGUtils.getSvgViewerPackage(count, true, string, n2));
        for (int i2 = 1; i2 <= count; ++i2) {
            byte[] byArray = cache.getPageAndWait(key, i2, 600000);
            RenderDataUtils.writeFileData(byteArrayOutputStream, i2 + ".svg", byArray);
        }
        byteArrayOutputStream.write(RenderDataUtils.intToByteArray(-1));
        WebUtils.sendHeader(request, response, props, 200, byteArrayOutputStream.toByteArray().length, httpContentType);
        out.write(byteArrayOutputStream.toByteArray());
    }
}

