/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.drive;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.report.plugins.drive.e;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DriveReportPermissionChecker
implements PluginPermissionChecker {
    private static final ConfigValue<Boolean> awy = new ConfigValue(ConfigKey.REPOLOCATION_ENABLED);
    private static final ConfigValue<Boolean> awz = new ConfigValue(ConfigKey.SYSTEMPERMISSION_ENABLED);
    public static final DrivePermissionType EXECUTE = new DrivePermissionType("reporting", "execute", () -> ReportingServerPlugin.MSG.getMsg("permission.execute", new Object[0]));

    public boolean checkExecutePermission(URL url) throws AccessDeniedException {
        if (((Boolean)awz.get()).booleanValue() && SystemPermissionChecker.checkAccess((Permission)PermissionChecker.PERMISSION_EXECUTE_ALL_REPORTS)) {
            return true;
        }
        try {
            return DriveReportPermissionChecker.getDriveEntry(url) != null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static byte[] getReportData(URL url) throws AccessDeniedException, IOException {
        DriveEntry driveEntry = DriveReportPermissionChecker.getDriveEntry(url);
        if (driveEntry == null || !driveEntry.hasFeature(Content.class)) {
            return null;
        }
        if (DriveReportPermissionChecker.bY(driveEntry.getID())) {
            return null;
        }
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            byte[] byArray;
            block14: {
                InputStream inputStream = ((Content)driveEntry.getFeature(Content.class)).getInputStream();
                try {
                    byArray = IOFunctions.readBytes((InputStream)inputStream);
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static DriveEntry getDriveEntry(@Nullable URL url) throws AccessDeniedException, FileNotFoundException {
        if (url == null) return null;
        if (!DriveReportPermissionChecker.isDriveProtocol(url)) {
            return null;
        }
        Object object = url.getPath();
        object = EncodingFunctions.decodeUrlPath((String)object);
        if ("repo".equals(url.getProtocol().toLowerCase()) && ((String)object).startsWith("~/")) {
            object = "/Home/" + ((String)object).substring(2);
        }
        try {
            BaseErrorCode baseErrorCode;
            UserAccountScope userAccountScope;
            Drive drive = Drive.getInstance();
            DriveEntry driveEntry = null;
            GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
            if (gUID != null) {
                driveEntry = drive.resolve((String)object);
            }
            if (driveEntry == null) {
                userAccountScope = UserAccountScope.createPrivileged();
                try {
                    driveEntry = drive.resolve((String)object);
                    if (driveEntry == null) {
                        DriveEntry driveEntry2 = null;
                        return driveEntry2;
                    }
                }
                finally {
                    if (userAccountScope != null) {
                        userAccountScope.close();
                    }
                }
            }
            if ((userAccountScope = (GUID)driveEntry.getMetaData(MetaData.HOMEFOLDER)) != null && !userAccountScope.equals((Object)gUID)) {
                throw new AccessDeniedException("Access denied for '" + (String)object + "'. File is located in foreign home folder.", (ErrorCode)BaseErrorCode.forbidden);
            }
            String string = driveEntry.getID();
            String string2 = DriveIDUtils.getMountRootID((String)string);
            if (string2 != null) {
                @Nullable MountDescription mountDescription = MountManager.getInstance().getMountDescription(GUID.valueOf((String)string2));
                if (mountDescription == null) throw new FileNotFoundException(url.toString());
                if (gUID == null) throw new FileNotFoundException(url.toString());
                if (!gUID.equals((Object)mountDescription.getUserID())) {
                    throw new FileNotFoundException(url.toString());
                }
            }
            if (!DriveReportPermissionChecker.bY(string)) return driveEntry;
            String string3 = e.MSG.getMsg("noExecutePermission", new Object[]{object});
            if (gUID == null) {
                baseErrorCode = BaseErrorCode.UserNotLoggedIn;
                throw new AccessDeniedException(string3, (ErrorCode)baseErrorCode);
            }
            baseErrorCode = BaseErrorCode.forbidden;
            throw new AccessDeniedException(string3, (ErrorCode)baseErrorCode);
        }
        catch (AccessDeniedException accessDeniedException) {
            accessDeniedException.setUrl(url);
            throw accessDeniedException;
        }
    }

    private static boolean bY(@Nonnull String string) {
        return (Boolean)awz.get() != false && !SystemPermissionChecker.checkAccess((Permission)PermissionChecker.PERMISSION_EXECUTE_ALL_REPORTS) && !Drive.getInstance().getPermissionChecker().hasPermission(string, false, new String[]{EXECUTE.getPermissionTypeName()});
    }

    public static boolean isDriveProtocol(@Nonnull URL url) {
        String string = url.getProtocol();
        return "drive".equals(string) || "repo".equals(string);
    }

    public boolean checkReportLocation(URL url) throws AccessDeniedException {
        return DriveReportPermissionChecker.isDriveProtocol(url) && (Boolean)awy.get() != false;
    }
}

