/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.layout;

import com.inet.annotations.InternalApi;
import com.inet.report.layout.Chunk;

@InternalApi
public class ListChunk
extends Chunk {
    public static final int INDENT_PER_LEVEL = 300;
    public static final int DISK = 0;
    public static final int SQUARE = 1;
    public static final int CIRCLE = 2;
    public static final int GRAPHICAL_MAX = 2;
    public static final int TEXTUAL_MIN = 5;
    public static final int NUMERIC = 5;
    public static final int U_ROMAN = 6;
    public static final int L_ROMAN = 7;
    public static final int U_ALPHA = 8;
    public static final int L_ALPHA = 9;
    public static final int DISC_RADIUS = 45;
    private boolean arK;
    private int asK;

    public int getListType() {
        return this.asK;
    }

    public boolean isBeginningTag() {
        return this.arK;
    }

    public ListChunk(int listType, boolean beginn, int level) {
        this.chunkType = 4;
        this.arK = beginn;
        this.asK = listType;
    }

    public String toString() {
        return "ListChunk, type: " + this.asK + " beginning: " + this.arK;
    }

    public static final String convertNumber(int number, int listType) {
        if (listType == 5) {
            return "" + number;
        }
        String string = "";
        switch (listType) {
            case 9: {
                return ListChunk.getLatinListValue(number, true);
            }
            case 8: {
                return ListChunk.getLatinListValue(number, false);
            }
            case 6: {
                return ListChunk.calculateRomanNumerals(number);
            }
            case 7: {
                return ListChunk.calculateRomanNumerals(number).toLowerCase();
            }
        }
        return string;
    }

    public static String getLatinListValue(int number, boolean lowerCase) {
        if (number <= 0) {
            return "";
        }
        int n2 = lowerCase ? 97 : 65;
        StringBuilder stringBuilder = new StringBuilder();
        while (number > 0) {
            stringBuilder.insert(0, (char)(--number % 26 + n2));
            number /= 26;
        }
        return stringBuilder.toString();
    }

    public static final String calculateRomanNumerals(int number) {
        String string = "IVXLCDM";
        Object object = "";
        int n2 = 1000;
        if (number < 1 || number > 4999) {
            return "0";
        }
        if (number > 3999) {
            object = (String)object + string.charAt(6);
            number -= 1000;
        }
        for (int i2 = 3; i2 >= 0; --i2) {
            int n3 = number / n2;
            number %= n2;
            switch (n3) {
                case 0: {
                    break;
                }
                case 5: {
                    object = (String)object + string.charAt(2 * i2 + 1);
                    break;
                }
                case 9: {
                    object = (String)object + string.charAt(2 * i2);
                    object = (String)object + string.charAt(2 * i2 + 2);
                    break;
                }
                case 4: {
                    object = (String)object + string.charAt(2 * i2);
                    object = (String)object + string.charAt(2 * i2 + 1);
                    break;
                }
                default: {
                    if (n3 > 5) {
                        object = (String)object + string.charAt(2 * i2 + 1);
                        n3 -= 5;
                    }
                    for (int i3 = 0; i3 < n3; ++i3) {
                        object = (String)object + string.charAt(2 * i2);
                    }
                }
            }
            n2 /= 10;
        }
        return object;
    }
}

