/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.exportwebui.api;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.utils.MimeTypes;
import com.inet.permissions.url.URLPermissionChecker;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportProperties;
import com.inet.report.exportwebui.api.data.ExportReportRequest;
import com.inet.report.exportwebui.api.data.ExportReportResponse;
import com.inet.report.exportwebui.data.ExportFormatDescription;
import com.inet.report.exportwebui.data.ExportResponseData;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.report.renderer.api.RendererFormatCategory;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class ExportReportHandlerBase<T extends ExportReportRequest<?>>
extends ServiceMethod<T, ExportReportResponse> {
    public short getMethodType() {
        return 1;
    }

    @Nullable
    public static ExportResponseData collectExportFormats(@Nullable String reportFile) {
        if (reportFile == null) {
            return null;
        }
        List<ExportFormatDescription> list = ExportReportHandlerBase.collectExportFormats();
        try {
            URL uRL = URLPermissionChecker.checkReportLocation((String)reportFile);
            PermissionChecker.checkReportLocation(uRL);
            Properties properties = new Properties();
            properties.put("report", uRL.toExternalForm());
            Engine engine = RDC.loadEngine(properties);
            ReportProperties reportProperties = engine.getReportProperties();
            boolean bl2 = reportProperties.isPrintingEnabled();
            String[] stringArray = reportProperties.getEnabledFormats();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null && stringArray.length > 0) {
                arrayList.addAll(Arrays.asList(stringArray));
                list.removeIf(exportFormatDescription -> !arrayList.contains(exportFormatDescription.getKey()));
            }
            return new ExportResponseData(bl2, list);
        }
        catch (ReportException reportException) {
            return null;
        }
    }

    @Nonnull
    public static List<ExportFormatDescription> collectExportFormats() {
        Object object;
        Object object2;
        Object object3;
        HashMap<RendererFormatCategory, List> hashMap = new HashMap<RendererFormatCategory, List>();
        for (Map.Entry<String, RendererFactory> object52 : RendererFactoryManager.getInstance().getDocumentRenderer()) {
            object3 = object52.getValue();
            for (String string : object3.getSupportedFormats()) {
                Set set;
                ExportFormatDescription exportFormatDescription;
                RendererFormatCategory rendererFormatCategory2;
                List list;
                object2 = object3.getInitFormat(string);
                object = object3.getDisplayName(string);
                if (object2 == null || object == null || object3.isViewer(string) || (list = hashMap.computeIfAbsent(rendererFormatCategory2 = object3.getCategoryName(), rendererFormatCategory -> new ArrayList())).contains((Object)(exportFormatDescription = new ExportFormatDescription((String)object2, (String)object, true, set = MimeTypes.getFileFilters((String)object3.getMimeType(string)))))) continue;
                list.add(exportFormatDescription);
            }
        }
        final Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        Comparator<LocalizedKey> comparator = new Comparator<LocalizedKey>(){

            public int a(LocalizedKey localizedKey, LocalizedKey localizedKey2) {
                return collator.compare(localizedKey.getDisplayName(), localizedKey2.getDisplayName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((LocalizedKey)object, (LocalizedKey)object2);
            }
        };
        object3 = new ArrayList();
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        arrayList.sort(Comparator.naturalOrder());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (RendererFormatCategory)iterator.next();
            object = (List)hashMap.get(object2);
            Objects.requireNonNull(object);
            object.sort(comparator);
            object3.add(new ExportFormatDescription("", object2.getDisplayName(), true, Collections.emptySet()));
            object3.addAll(object);
        }
        return object3;
    }
}

