/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.annotations.InternalApi;
import com.inet.report.PictureProperties;
import com.inet.report.ax;
import com.inet.report.encode.AbstractDecoder;
import com.inet.report.encode.a;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

@InternalApi
public abstract class Decoder2
extends AbstractDecoder {
    protected Decoder2() {
    }

    public Decoder2(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public abstract Point draw(Graphics2D var1, PictureProperties var2, int var3, int var4);

    public abstract boolean isFinished();

    public abstract void reset();

    @Override
    protected BufferedImage decodeImage(int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        a a2 = new a();
        a2.setWidth(width * 15);
        a2.setHeight(height * 15);
        a2.setScalingOption(6);
        this.draw(bufferedImage.createGraphics(), a2, width, height);
        return bufferedImage;
    }

    public Point2D.Double getScaling(PictureProperties blob, int docWidth, int docHeight) {
        int n2 = blob.getWidth();
        int n3 = blob.getHeight();
        double d2 = 1.0;
        double d3 = 1.0;
        switch (blob.getScalingOption()) {
            case 5: {
                d2 = d3 = (double)n3 / (double)docHeight;
                break;
            }
            case 0: {
                d2 = (double)n2 / (double)docWidth;
                d3 = (double)n3 / (double)docHeight;
                break;
            }
            case 2: {
                d2 = (double)n2 / (double)docWidth;
                d3 = blob.getHeightRenderingFactor();
                break;
            }
            case 3: {
                d2 = blob.getWidthRenderingFactor();
                d3 = (double)n3 / (double)docHeight;
                break;
            }
            case 1: {
                d2 = blob.getWidthRenderingFactor();
                d3 = blob.getHeightRenderingFactor();
                break;
            }
            case 6: {
                d2 = (double)n2 / (double)docWidth;
                d3 = (double)n3 / (double)docHeight;
                if (d2 < d3) {
                    d3 = d2;
                    break;
                }
                d2 = d3;
                break;
            }
            case 4: {
                d3 = d2 = (double)n2 / (double)docWidth;
                break;
            }
        }
        return new Point2D.Double(d2, d3);
    }

    public int getUsedHeight(PictureProperties blob, int drawableHeight, int maxHeight) {
        int n2 = blob.getHeight();
        if (blob.isCanGrow() || ax.evalBooleanProperty(blob.getCanGrowFormula(), false, null)) {
            n2 = maxHeight;
        }
        n2 = Math.min(drawableHeight, n2);
        if (!blob.isCanShrink() && !ax.evalBooleanProperty(blob.getCanShrinkFormula(), false, null)) {
            return Math.max(n2, Math.min(blob.getHeight(), maxHeight));
        }
        return n2;
    }

    public int getUsedWidth(PictureProperties blob, int drawableWidth, int maxWidth) {
        int n2 = blob.getWidth();
        if (blob.isCanGrow() || ax.evalBooleanProperty(blob.getCanGrowFormula(), false, null)) {
            n2 = maxWidth;
        }
        n2 = Math.min(drawableWidth, n2);
        if (!blob.isCanShrink() && !ax.evalBooleanProperty(blob.getCanShrinkFormula(), false, null)) {
            return Math.max(n2, Math.min(blob.getWidth(), maxWidth));
        }
        return n2;
    }

    public Point getDrawPosition(PictureProperties blob, int docWidth, int docHeight, int maxWidth, int maxHeight) {
        Point point = new Point();
        int n2 = blob.getWidth();
        if ((blob.isCanGrow() || ax.evalBooleanProperty(blob.getCanGrowFormula(), false, null)) && docWidth > n2) {
            n2 = docWidth <= maxWidth ? docWidth : maxWidth;
        }
        if (!blob.isCanShrink() && !ax.evalBooleanProperty(blob.getCanShrinkFormula(), false, null) || docWidth > n2) {
            if (blob.getHorAlign() == 2) {
                point.x = (n2 - docWidth) / 2;
            } else if (blob.getHorAlign() == 3) {
                point.x = n2 - docWidth;
            }
        }
        int n3 = blob.getHeight();
        if ((blob.isCanGrow() || ax.evalBooleanProperty(blob.getCanGrowFormula(), false, null)) && docHeight > n3) {
            n3 = docHeight <= maxHeight ? docHeight : maxHeight;
        } else if ((blob.isCanShrink() || ax.evalBooleanProperty(blob.getCanShrinkFormula(), false, null)) && docHeight < n3) {
            return point;
        }
        if (blob.getVerAlign() == 2) {
            point.y = (n3 - docHeight) / 2;
        } else if (blob.getVerAlign() == 3) {
            point.y = n3 - docHeight;
        }
        return point;
    }

    @Override
    public Image createThumbnail(int maxWidth, int maxHeight) {
        return this.decodeImage(maxWidth, maxHeight);
    }

    @Override
    public boolean isAutoScaledAndAligned() {
        return true;
    }
}

