/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.ParameterList;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.SimpleResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseSqlServer
extends Database {
    @Override
    protected boolean scanSourceType(TableSource ts, ParameterList dataTypeScale, boolean useMetaDataCache) throws SQLException, ReportException {
        return super.scanSourceType(ts, dataTypeScale, useMetaDataCache) || ts.getDatabaseIdentifier().endsWith(";1");
    }

    @Override
    protected String getSqlIdentifier(Datasource ds, String identifier, boolean escapeEverything) {
        if (identifier.endsWith(";1")) {
            return super.getSqlIdentifier(ds, identifier.substring(0, identifier.length() - 2), escapeEverything) + ";1";
        }
        return super.getSqlIdentifier(ds, identifier, escapeEverything);
    }

    @Override
    protected boolean needQuote(String identifier) {
        if (identifier.startsWith("[")) {
            return false;
        }
        return super.needQuote(identifier);
    }

    @Override
    public int getMaxAliasNameLength() {
        return 128;
    }

    @Override
    public String convertToString(String parameter) throws ReportException {
        return "convert(varchar," + parameter + ")";
    }

    @Override
    public String convertToInt(String parameter) throws ReportException {
        return "convert(int," + parameter + ")";
    }

    @Override
    public String convertToTime(String time) throws ReportException {
        return this.convertToTime("{fn HOUR(" + time + ")}", "{fn MINUTE(" + time + ")}", "{fn SECOND(" + time + ")}");
    }

    @Override
    public String convertToDate(String date) throws ReportException {
        return this.convertToDate("{fn YEAR(" + date + ")}", "{fn MONTH(" + date + ")}", "{fn DAYOFMONTH(" + date + ")}");
    }

    @Override
    public String convertToDate(String year, String month, String day) throws ReportException {
        return "convert(datetime, right( '0000' + convert(varchar," + year + "),4) + right( '00' + convert(varchar," + month + "), 2) + right( '00' + convert(varchar," + day + "), 2))";
    }

    @Override
    public String convertToTime(String hour, String minute, String sec) throws ReportException {
        return "convert(datetime, right( '00' + convert(varchar," + hour + "),2)+ ':'+ right( '00' + convert(varchar," + minute + "), 2) +':'+ right( '00' + convert(varchar," + sec + "),2),8)";
    }

    @Override
    public String convertToTimeStamp(String year, String month, String day, String hour, String minute, String sec) throws ReportException {
        return "convert(datetime, right( '0000' + convert(varchar," + year + "),4) + '-' + right( '00' + convert(varchar," + month + "), 2) + '-' +right( '00' + convert(varchar," + day + "),2)+' '+right( '00' + convert(varchar," + hour + "),2)+ ':'+ right( '00' + convert(varchar," + minute + "), 2) +':'+ right( '00' + convert(varchar," + sec + "),2),20)";
    }

    @Override
    protected void findColumnLabels(TableSource ts) {
        block14: {
            try (Connection connection = ts.getDatasource().getConnection();){
                if (ts.getType() != 1) {
                    return;
                }
                String string = ts.getDatabaseIdentifier();
                if (string.indexOf(46) != -1) {
                    string = string.substring(string.lastIndexOf(46) + 1, string.length());
                }
                ResultSet resultSet = DatabaseUtils.executeQuery(connection.createStatement(), "select syscolumns.name ,sysobjects.name , sysproperties.value from syscolumns, sysobjects,sysproperties where syscolumns.id = sysobjects.id and sysobjects.id=sysproperties.id and syscolumns.colorder=sysproperties.smallid and sysproperties.name = 'MS_Description' and sysobjects.name = '" + string + "'", null);
                SimpleResultSet simpleResultSet = new SimpleResultSet(resultSet);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("search column labels COLUMN_NAME\t\tTABLE_NAME\t\tCOMMENTS");
                }
                while (simpleResultSet.next()) {
                    DatabaseField databaseField;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(simpleResultSet.getString(1) + "\t\t" + simpleResultSet.getString(2) + "\t\t" + simpleResultSet.getString(3));
                    }
                    if ((databaseField = ts.getDatabaseField(simpleResultSet.getString(1))) == null) continue;
                    databaseField.setColumnLabel(simpleResultSet.getString(3));
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block14;
                BaseUtils.debug("unable to fetch column labels: " + String.valueOf(exception));
            }
        }
    }

    @Override
    public String convertStringToSQLSyntax(String s2, boolean isFunctionParam) {
        if (!isFunctionParam) {
            return "N" + super.convertStringToSQLSyntax(s2, isFunctionParam);
        }
        return super.convertStringToSQLSyntax(s2, isFunctionParam);
    }
}

