/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.rules;

import com.inet.problemfinder.ProblemFinderWarning;
import com.inet.problemfinder.ProblemFinderWarningImpl;
import com.inet.problemfinder.i18n.Msg;
import com.inet.problemfinder.rules.AbstractRuleField;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaDefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.SQLValueProvider;
import com.inet.report.Validity;
import javax.swing.AbstractAction;

public class RulePromptFormulaValid
extends AbstractRuleField {
    @Override
    protected ProblemFinderWarning check(Engine engine, Field field) {
        if (field instanceof PromptField) {
            DynamicValueProvider dynamicValueProvider = ((PromptField)field).getDefaultValueProvider();
            if (dynamicValueProvider instanceof SQLValueProvider) {
                return null;
            }
            DefaultValue[] defaultValueArray = ((PromptField)field).getDefaultValues();
            if (defaultValueArray != null) {
                for (DefaultValue defaultValue : defaultValueArray) {
                    if (!(defaultValue instanceof FormulaDefaultValue)) continue;
                    FormulaField formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField();
                    String string = Msg.getFieldDisplayName(field);
                    String string2 = Msg.getMsg("ProblemFinder.Rule.PromptFormula.warn", string);
                    Validity validity = formulaField.validate();
                    if (validity != null) {
                        Validity.States states = validity.getState();
                        if (states == Validity.States.WARNING) {
                            return new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.WARNING, this, string2, string, new AbstractAction[0]);
                        }
                        if (states == Validity.States.ERROR || states == Validity.States.DEPENDING_ERROR) {
                            return new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.ERROR, this, string2, string, new AbstractAction[0]);
                        }
                    }
                    try {
                        if (formulaField.getEvaluateTime() != 0) {
                            return new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.WARNING, this, string2, string, new AbstractAction[0]);
                        }
                    }
                    catch (ReportException reportException) {
                        // empty catch block
                    }
                    int n2 = defaultValue.getType();
                    if (((PromptField)field).getDiscreteOrRangeType() == 1) {
                        n2 |= 0x80;
                    }
                    if (n2 == formulaField.getValueType()) continue;
                    return new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.WARNING, this, string2, string, new AbstractAction[0]);
                }
            }
        }
        return null;
    }

    @Override
    public String getRuleLabel() {
        return Msg.getMsg("ProblemFinder.Rule.PromptFormula.label", Msg.getMsg("prompt.field"));
    }
}

