/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.api.implementation;

import com.inet.report.Engine;
import com.inet.report.RendererBase;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.renderer.api.commands.b;
import com.inet.report.renderer.doc.DocumentWriter;
import com.inet.report.renderer.html.HtmlDocumentWriter;
import com.inet.report.renderer.java.a;
import com.inet.report.util.WebUtils;
import com.inet.shared.servlet.ServletUtils;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class i
implements RendererFactory {
    @Nonnull
    public String getExtensionName() {
        return "image";
    }

    @Override
    @Nullable
    public String getDisplayName(String exportformat) {
        return exportformat.toUpperCase();
    }

    @Override
    @Nullable
    public String getInitFormat(@Nonnull String exportFormat) {
        return null;
    }

    @Override
    public List<String> getSupportedFormats() {
        return List.of("png", "jpeg", "jpg", "bmp", "gif");
    }

    @Override
    @Nonnull
    public RendererBase<?> getRendererDocument(@Nonnull Engine parentEngine, @Nonnull String exportFormat) {
        if (exportFormat.equals("jpeg")) {
            exportFormat = "jpg";
        }
        return RendererFactory.super.getRendererDocument(parentEngine, exportFormat);
    }

    @Override
    @Nonnull
    public DocumentWriter getDocumentWriter(@Nonnull String exportFormat) {
        return new a(exportFormat);
    }

    @Override
    @Nonnull
    public String getMimeType(@Nonnull String exportFormat) {
        if (exportFormat.equals("png")) {
            return "image/png";
        }
        if (exportFormat.equals("jpeg")) {
            return "image/jpeg";
        }
        if (exportFormat.equals("jpg")) {
            return "image/jpeg";
        }
        if (exportFormat.equals("bmp")) {
            return "image/bmp";
        }
        if (exportFormat.equals("gif")) {
            return "image/gif";
        }
        throw new IllegalArgumentException("Unknown image export format: " + exportFormat);
    }

    @Override
    @Nonnull
    public ToClientCmd getToClientCmd(@Nonnull String exportFormat) {
        final String string = this.getMimeType(exportFormat);
        return new b(){

            @Override
            @Nonnull
            public String getMimeType() {
                return string;
            }
        };
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file to get the name")
    public void exportPageToClient(@Nonnull Cache cache, int size, int count, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull OutputStream out, @Nonnull ReportCacheKey key, @Nonnull String httpContentType, @Nullable String page, @Nonnull Properties props) throws Exception {
        String string = props.getProperty("export_fmt");
        Objects.requireNonNull(string);
        if (count == 1) {
            byte[] byArray = cache.getPageAndWait(key, 1, 600000);
            WebUtils.sendHeader(request, response, props, 200, byArray.length, httpContentType);
            out.write(byArray);
        } else {
            WebUtils.sendHeader(request, response, props, 200, -1, "application/zip");
            String string2 = HtmlDocumentWriter.j(props);
            if (string2 != null) {
                ServletUtils.setContentDisposition((HttpServletResponse)response, (String)(string2 + ".zip"), (boolean)false);
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(out);
            for (int i2 = 1; i2 <= count; ++i2) {
                ZipEntry zipEntry = new ZipEntry(i2 + "." + string);
                zipOutputStream.putNextEntry(zipEntry);
                byte[] byArray = cache.getPageAndWait(key, i2, 600000);
                zipOutputStream.write(byArray);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
    }
}

