/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.pool;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.pool.ConnectionPool;
import com.inet.report.pool.PoolConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

@InternalApi
public class InternalConnectionPool
implements ConnectionPool {
    private static Vector<Thread> axi = new Vector();
    private ConcurrentHashMap<DataSource, CopyOnWriteArrayList<PoolEntry>> axj = new ConcurrentHashMap();
    private Hashtable<String, Driver> axk = new Hashtable();
    private long axl = 600000L;
    private int axm = 0;
    private long axn = 10000L;
    private final Object axo = new Object();
    private a axp = new a();

    public InternalConnectionPool() {
        ConfigValue<Integer> configValue = new ConfigValue<Integer>(ConfigKey.MAX_CONNECTIONS){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                int n2 = (Integer)this.get();
                if (n2 < 0) {
                    LogManager.getConfigLogger().error((Throwable)new IllegalArgumentException("[Pool Manager] Negative maximum connection count value"));
                }
                InternalConnectionPool.this.axm = n2;
            }
        };
        ConfigValue<Double> configValue2 = new ConfigValue<Double>(ConfigKey.CONNECTION_POOL_TIMEOUT){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                long l2 = (long)((Double)this.get() * 60000.0);
                if (l2 < 0L) {
                    LogManager.getConfigLogger().error((Throwable)new IllegalArgumentException("[Pool Manager] Negative timeout value"));
                    return;
                }
                long l3 = InternalConnectionPool.this.axl;
                InternalConnectionPool.this.axl = l2;
                if (l3 == 0L && InternalConnectionPool.this.axl != 0L) {
                    InternalConnectionPool.this.axp = new a();
                }
            }
        };
        ConfigValue<Integer> configValue3 = new ConfigValue<Integer>(ConfigKey.LOGIN_TIMEOUT){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                long l2 = (Integer)this.get() * 1000;
                if (l2 < 0L) {
                    LogManager.getConfigLogger().error((Throwable)new IllegalArgumentException("[Pool Manager] Negative login timeout value"));
                    return;
                }
                InternalConnectionPool.this.axn = l2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolConnection getConnection(String driverClassName, String connectionUrl, Properties properties) throws SQLException, ReportException {
        Object object;
        Driver driver;
        CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList;
        block31: {
            copyOnWriteArrayList = null;
            try {
                if (StringFunctions.isEmpty((String)driverClassName)) {
                    driver = DriverManager.getDriver(connectionUrl);
                    driverClassName = driver.getClass().getName();
                    break block31;
                }
                object = this;
                synchronized (object) {
                    driver = this.axk.get(driverClassName);
                    if (driver == null) {
                        try {
                            driver = (Driver)LoaderUtils.classForName((String)driverClassName, (Object)this).newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (driverClassName.equals("sun.jdbc.odbc.JdbcOdbcDriver")) {
                                if (BaseUtils.isDebug()) {
                                    BaseUtils.debug(classNotFoundException);
                                }
                                driver = (Driver)LoaderUtils.classForName((String)"com.inet.odbc.OdbcDriver", (Object)this).newInstance();
                            }
                            throw classNotFoundException;
                        }
                        this.axk.put(driverClassName, driver);
                    }
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{driverClassName};
                throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.PM_CannotLoadDriver, objectArray);
            }
        }
        DataSource dataSource = new DataSource(driverClassName, connectionUrl, properties);
        object = this;
        synchronized (object) {
            copyOnWriteArrayList = this.axj.get(dataSource);
            if (copyOnWriteArrayList == null) {
                copyOnWriteArrayList = new CopyOnWriteArrayList();
                this.axj.put(dataSource, copyOnWriteArrayList);
            }
        }
        PoolConnection poolConnection = this.a(copyOnWriteArrayList);
        if (poolConnection != null) {
            return poolConnection;
        }
        object = new PoolEntry();
        if (this.axm != 0) {
            int n2;
            CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList2 = copyOnWriteArrayList;
            synchronized (copyOnWriteArrayList2) {
                n2 = copyOnWriteArrayList.size();
            }
            if (this.axm <= n2) {
                long l2 = System.currentTimeMillis();
                long l3 = 0L;
                Object object2 = this.axo;
                synchronized (object2) {
                    while ((l3 < this.axn || this.axn == 0L) && this.axm != 0 && this.axm <= copyOnWriteArrayList.size()) {
                        try {
                            this.axo.wait(this.axn == 0L ? 0L : this.axn - l3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        poolConnection = this.a(copyOnWriteArrayList);
                        if (poolConnection != null) {
                            return poolConnection;
                        }
                        l3 = System.currentTimeMillis() - l2;
                    }
                }
            }
            if (this.axm != 0 && this.axm <= copyOnWriteArrayList.size()) {
                Object[] objectArray = new Object[]{this.axn / 1000L + " s.", new Integer(this.axm)};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_LoginTimeout, objectArray);
            }
        }
        try {
            copyOnWriteArrayList.add((PoolEntry)object);
            return ((PoolEntry)object).a(dataSource, driver);
        }
        catch (SQLException sQLException) {
            ((PoolEntry)object).a(sQLException);
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolConnection a(CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList) throws SQLException {
        Connection connection = null;
        for (int i2 = 0; i2 < copyOnWriteArrayList.size(); ++i2) {
            PoolEntry poolEntry = copyOnWriteArrayList.get(i2);
            if (poolEntry.axs) continue;
            InternalConnectionPool internalConnectionPool = this;
            synchronized (internalConnectionPool) {
                if (poolEntry.axs) {
                    continue;
                }
                if (poolEntry.axu != null && poolEntry.axt + 30000L > System.currentTimeMillis()) {
                    throw poolEntry.axu;
                }
                poolEntry.axs = true;
                poolEntry.axt = System.currentTimeMillis();
            }
            if (poolEntry.axr == null) {
                copyOnWriteArrayList.remove(poolEntry);
                continue;
            }
            connection = poolEntry.axr;
            boolean bl2 = true;
            try {
                try {
                    bl2 = !connection.isValid(5);
                }
                catch (Throwable throwable) {
                    bl2 = connection.isClosed();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl2) {
                try {
                    poolEntry.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                copyOnWriteArrayList.remove(poolEntry);
                connection = null;
                continue;
            }
            return new PoolConnection(connection, poolEntry);
        }
        return null;
    }

    public synchronized HashMap<DataSource, List<PoolEntry>> getPoolDS() {
        return new HashMap<DataSource, List<PoolEntry>>(this.axj);
    }

    @Override
    public synchronized void shutdown() {
        for (Thread thread : axi) {
            if (thread == null) continue;
            thread.interrupt();
        }
    }

    private class a
    implements Runnable {
        private a() {
            Thread thread = new Thread((Runnable)this, "PoolManager");
            try {
                thread.setPriority(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                thread.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            thread.start();
            axi.add(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PoolEntry poolEntry;
            int n2;
            while (InternalConnectionPool.this.axl > 0L) {
                Iterator<CopyOnWriteArrayList<PoolEntry>> iterator = InternalConnectionPool.this.axj.values().iterator();
                while (iterator.hasNext()) {
                    CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList = iterator.next();
                    for (n2 = 0; n2 < copyOnWriteArrayList.size(); ++n2) {
                        poolEntry = copyOnWriteArrayList.get(n2);
                        if (poolEntry.axs || InternalConnectionPool.this.axl <= 0L || poolEntry.axt + InternalConnectionPool.this.axl >= System.currentTimeMillis()) continue;
                        boolean bl2 = false;
                        InternalConnectionPool internalConnectionPool = InternalConnectionPool.this;
                        synchronized (internalConnectionPool) {
                            if (!poolEntry.axs && InternalConnectionPool.this.axl > 0L && poolEntry.axt + InternalConnectionPool.this.axl < System.currentTimeMillis()) {
                                bl2 = copyOnWriteArrayList.remove(poolEntry);
                            }
                            if (copyOnWriteArrayList.size() == 0) {
                                iterator.remove();
                            }
                        }
                        if (!bl2) continue;
                        poolEntry.close();
                    }
                }
                try {
                    long l2 = InternalConnectionPool.this.axl / 10L;
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (InternalConnectionPool.this.axl > 0L) {
                for (CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList : InternalConnectionPool.this.axj.values()) {
                    for (n2 = 0; n2 < copyOnWriteArrayList.size(); ++n2) {
                        poolEntry = copyOnWriteArrayList.get(n2);
                        poolEntry.close();
                    }
                }
            }
        }
    }

    @InternalApi
    public class DataSource {
        private String aas;
        private String url;
        private Properties Vd;

        DataSource(String driver, String url, Properties props) throws ReportException {
            if (driver == null) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_PropertyError, "\"driver\"");
            }
            if (url == null) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_PropertyError, "\"url\"");
            }
            this.aas = driver;
            this.url = url;
            this.Vd = props;
        }

        public boolean equals(Object ds) {
            return ((DataSource)ds).aas.equals(this.aas) && ((DataSource)ds).url.equals(this.url) && ((DataSource)ds).Vd.equals(this.Vd);
        }

        public int hashCode() {
            return this.aas.hashCode() ^ this.url.hashCode();
        }

        public String getDriver() {
            return this.aas;
        }

        public String getUrl() {
            return this.url;
        }

        public Properties getProperties() {
            return this.Vd;
        }
    }

    public class PoolEntry {
        private Connection axr;
        private boolean axs = true;
        private long axt = System.currentTimeMillis();
        private SQLException axu;

        PoolConnection a(DataSource dataSource, Driver driver) throws SQLException, ReportException {
            this.axr = driver.connect(dataSource.url, (Properties)dataSource.Vd.clone());
            if (this.axr == null) {
                this.axs = false;
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_InvalidDrvUrl, dataSource.url, driver.toString());
            }
            return new PoolConnection(this.axr, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            try {
                this.axr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.axr = null;
            this.axs = false;
            Object object = InternalConnectionPool.this.axo;
            synchronized (object) {
                InternalConnectionPool.this.axo.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed() {
            this.axs = false;
            this.axt = System.currentTimeMillis();
            Object object = InternalConnectionPool.this.axo;
            synchronized (object) {
                InternalConnectionPool.this.axo.notify();
            }
        }

        public boolean isUsing() {
            return this.axs;
        }

        void a(SQLException sQLException) {
            this.axu = sQLException;
            this.axs = false;
            this.axt = System.currentTimeMillis();
        }
    }
}

