/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.PreferencesUtils;
import com.inet.report.BaseUtils;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ae;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.util.EngineUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public abstract class RelativePathDataFactory
extends BaseDataFactory {
    public static final String PATH = "path";
    private URL IO;

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="the file is a directory to search for specific files")
    protected Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog, @Nonnull Function<String, String> fileNameFilter) {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        List<String> list = this.getPathNames(ds);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = list.get(i2);
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                String string3 = fileNameFilter.apply(string2);
                if (string3 == null) continue;
                hashMap.put(string3, new TableSourceInfo(catalog, null, string3, 20));
            }
        }
        return hashMap;
    }

    protected List<String> getPathNames(Datasource ds) {
        ArrayList arrayList = new ArrayList();
        DataSourceConfiguration dataSourceConfiguration = ds.getDataSourceConfiguration();
        String string = dataSourceConfiguration == null ? "." : dataSourceConfiguration.getProperty(PATH);
        return this.getPathNames(ds, string);
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file used for checks")
    public List<String> getPathNames(@Nonnull Datasource ds, @Nonnull String pathOrFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(pathOrFile);
        if (file.isAbsolute() && file.exists()) {
            arrayList.add(pathOrFile);
        } else {
            Object object;
            block16: {
                if (this.IO == null) {
                    try {
                        object = ae.getEngine(ds).getReportFile();
                        if (!((URL)object).getPath().isEmpty()) {
                            this.IO = object;
                        }
                    }
                    catch (ReportException reportException) {
                        BaseUtils.printStackTrace(reportException);
                    }
                }
                if (this.IO != null) {
                    try {
                        object = new URL(this.IO, pathOrFile);
                        if ("file".equals(((URL)object).getProtocol())) {
                            arrayList.add(IOFunctions.getFileName((URL)object));
                            break block16;
                        }
                        arrayList.add(((URL)object).toString());
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    try {
                        object = new URL(pathOrFile);
                        arrayList.add(((URL)object).toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (arrayList.size() == 0) {
                arrayList.add(pathOrFile);
                if (EngineUtils.isDesigner()) {
                    object = PreferencesUtils.userRoot().node("/com/inet/designer");
                    Preferences preferences = ((Preferences)object).node("lastOpened");
                    int n2 = ((Preferences)object).node("prefs").getInt("mruSize", 10);
                    for (int i2 = n2 - 1; i2 >= 0; --i2) {
                        File file2;
                        String string;
                        String string2 = preferences.get(String.valueOf(i2), null);
                        if (string2 == null || arrayList.contains(string = new File(file2 = new File(string2).getParentFile(), pathOrFile).getAbsolutePath())) continue;
                        arrayList.add(string);
                    }
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public String getVersion() {
        return "24.10.655";
    }
}

