/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.format;

import com.inet.annotations.PublicApi;
import com.inet.report.chart.f;
import com.inet.report.chart.format.Abbreviation;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.i;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class FixedNumberFormat
extends NumberFormat
implements ChartFormat {
    public static final int DEFAULT_NUMBER_OF_DECIMAL_PLACES = 2;
    public static final boolean DEFAULT_USE_THOUSANDS_SEPARATOR = true;
    public static final Abbreviation DEFAULT_ABBREVIATION = Abbreviation.ABBREVIATION_NONE;
    public static final int MINUS_SIGN_BEFORE = 0;
    public static final int MINUS_SIGN_AFTER = 1;
    public static final int MINUS_SIGN_BRACKETS = 2;
    public static final int MINUS_SIGN_SYSTEM_DEFAULT = 4;
    public static final int FORMAT_NUMBER = 0;
    public static final int FORMAT_PERCENT = 1;
    public static final int FORMAT_CURRENCY = 2;
    private FormatingProperties Ya = new FormatingProperties();
    private int Ye = 2;
    private boolean Yf = true;
    private int Yg = 4;
    private Abbreviation Yh = Abbreviation.ABBREVIATION_NONE;
    private DecimalFormat Yi;
    private int type;

    public FixedNumberFormat() {
        this(0);
    }

    public FixedNumberFormat(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("The parameter 'type' is illegal.");
        }
        this.type = type;
    }

    public Abbreviation getAbbreviation() {
        return this.Yh;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        if (abbreviation == null) {
            throw i.d("abbreviation");
        }
        this.Yh = abbreviation;
    }

    public int getNumberOfDecimalPlaces() {
        return this.Ye;
    }

    public void setNumberOfDecimalPlaces(int numberOfDecimalPlaces) {
        if (numberOfDecimalPlaces < 0) {
            throw new IllegalArgumentException("The parameter 'numberOfDecimalPlaces' is less than zero.");
        }
        this.Ye = numberOfDecimalPlaces;
        this.Yi = null;
    }

    public boolean isUseThousandSeparator() {
        return this.Yf;
    }

    public void setUseThousandSeparator(boolean useThousandSeparator) {
        this.Yf = useThousandSeparator;
        this.Yi = null;
    }

    public int getMinusSymbol() {
        return this.Yg;
    }

    public void setMinusSymbol(int minusSymbol) {
        this.Yg = minusSymbol;
    }

    @Override
    public void setFormatingProperties(FormatingProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Parameter 'properties' is null.");
        }
        this.Ya = properties;
        this.Yi = null;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.a(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.a(number, toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        throw new RuntimeException("Method not implemented.");
    }

    private StringBuffer a(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.Yi == null) {
            Object object = FixedNumberFormat.a(this);
            switch (this.type) {
                case 2: {
                    this.Yi = (DecimalFormat)NumberFormat.getCurrencyInstance(this.Ya.getLocale());
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(this.Ya.getLocale());
                    if (this.getMinusSymbol() == 4) {
                        this.Yi.applyPattern((String)object);
                        this.Yi.setPositivePrefix(decimalFormat.getPositivePrefix());
                        this.Yi.setPositiveSuffix(decimalFormat.getPositiveSuffix());
                        this.Yi.setNegativePrefix(decimalFormat.getNegativePrefix());
                        this.Yi.setNegativeSuffix(decimalFormat.getNegativeSuffix());
                        break;
                    }
                    String string = decimalFormat.getDecimalFormatSymbols().getCurrencySymbol();
                    object = decimalFormat.getPositivePrefix().indexOf(string) != -1 ? string + (String)object : (String)object + string;
                    object = FixedNumberFormat.a((String)object, this);
                    this.Yi.applyPattern((String)object);
                    break;
                }
                case 0: {
                    object = FixedNumberFormat.a((String)object, this);
                    this.Yi = (DecimalFormat)NumberFormat.getInstance(this.Ya.getLocale());
                    this.Yi.applyPattern((String)object);
                    break;
                }
                case 1: {
                    this.Yi = (DecimalFormat)NumberFormat.getPercentInstance(this.Ya.getLocale());
                    object = (String)object + "%";
                    object = FixedNumberFormat.a((String)object, this);
                    this.Yi.applyPattern((String)object);
                }
            }
        }
        if (this.type == 0 && !this.Yh.equals(Abbreviation.ABBREVIATION_NONE)) {
            stringBuffer.append(this.Yh.a(d2, this.Yi));
            return stringBuffer;
        }
        return this.Yi.format(d2, stringBuffer, fieldPosition);
    }

    private static String a(FixedNumberFormat fixedNumberFormat) {
        StringBuilder stringBuilder = null;
        stringBuilder = fixedNumberFormat.isUseThousandSeparator() ? new StringBuilder("#,##0") : new StringBuilder("###0");
        int n2 = fixedNumberFormat.getNumberOfDecimalPlaces();
        if (n2 > 0) {
            stringBuilder.append('.');
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append('0');
            }
        }
        return stringBuilder.toString();
    }

    private static String a(String string, FixedNumberFormat fixedNumberFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (fixedNumberFormat.getMinusSymbol()) {
            case 1: {
                stringBuilder.append(';');
                stringBuilder.append(string);
                stringBuilder.append('-');
                break;
            }
            case 0: {
                stringBuilder.append(';');
                stringBuilder.append('-');
                stringBuilder.append(string);
                break;
            }
            case 2: {
                stringBuilder.append(';');
                stringBuilder.append('(');
                stringBuilder.append(string);
                stringBuilder.append(')');
                break;
            }
        }
        return string + String.valueOf(stringBuilder);
    }

    @Override
    public void saveProperties(StringBuilder buffer, int depth) {
        f.a(buffer, depth, "Format", "type", this.getName());
        f.b(buffer, depth + 1, "Type", String.valueOf(this.type));
        if (this.getNumberOfDecimalPlaces() != 2) {
            f.b(buffer, depth + 1, "NumberOfDecimalPlaces", String.valueOf(this.getNumberOfDecimalPlaces()));
        }
        if (!this.isUseThousandSeparator()) {
            f.b(buffer, depth + 1, "UseThousandsSeparator", String.valueOf(this.isUseThousandSeparator()));
        }
        if (this.getMinusSymbol() != 4) {
            f.b(buffer, depth + 1, "NegativeType", String.valueOf(this.getMinusSymbol()));
        }
        if (this.getAbbreviation() != null) {
            this.getAbbreviation().g(buffer, depth + 1);
        }
        f.a(buffer, depth, "Format", null, true);
    }

    @Override
    public void readProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Abbreviation abbreviation;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("type") || element2.getNodeName().equals("Type")) {
                int n2;
                if (element2.getAttribute("value").length() <= 0) continue;
                this.type = n2 = Integer.parseInt(element2.getAttribute("value"));
                continue;
            }
            if (element2.getNodeName().equals("NumberOfDecimalPlaces")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n3 = Integer.parseInt(element2.getAttribute("value"));
                this.setNumberOfDecimalPlaces(n3);
                continue;
            }
            if (element2.getNodeName().equals("UseThousandSeperators") || element2.getNodeName().equals("UseThousandsSeparator")) {
                String string = element2.getAttribute("value");
                if (string.length() <= 0) continue;
                this.setUseThousandSeparator(Boolean.valueOf(string));
                continue;
            }
            if (element2.getNodeName().equals("NegativeType")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n4 = Integer.parseInt(element2.getAttribute("value"));
                this.setMinusSymbol(n4);
                continue;
            }
            if (!element2.getNodeName().equals("Abbreviation") || (abbreviation = Abbreviation.getAbbreviation(element2)) == null) continue;
            this.setAbbreviation(abbreviation);
        }
    }

    @Override
    public FixedNumberFormat clone() {
        FixedNumberFormat fixedNumberFormat = new FixedNumberFormat(this.type);
        fixedNumberFormat.Yh = this.Yh;
        fixedNumberFormat.Yg = this.Yg;
        fixedNumberFormat.Ye = this.Ye;
        fixedNumberFormat.Yf = this.Yf;
        fixedNumberFormat.Ya = (FormatingProperties)this.Ya.clone();
        return fixedNumberFormat;
    }

    protected String getName() {
        return "FixedNumberFormat";
    }

    public int getType() {
        return this.type;
    }
}

