/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.annotations.PublicApi;
import com.inet.error.WrappedRuntimeException;
import com.inet.lib.io.ChunkedInputStream;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;

@PublicApi
public class ReportCacheInputStream
extends ChunkedInputStream {
    private ReportCacheKey ht;
    private int page;
    private int VE;

    public ReportCacheInputStream(ReportCacheKey key, int timeout) {
        super(ReportCacheInputStream.a(key, 1, timeout));
        this.ht = key;
        this.page = 1;
        this.VE = timeout;
    }

    private static byte[] a(ReportCacheKey reportCacheKey, int n2, int n3) {
        try {
            return Cache.getCache().getPageAndWait(reportCacheKey, n2, n3);
        }
        catch (ReportException reportException) {
            throw new WrappedRuntimeException((Throwable)reportException);
        }
    }

    protected byte[] nextChunk() {
        try {
            if (Cache.getCache().getPageCountAndWait(this.ht, this.VE) > this.page) {
                return ReportCacheInputStream.a(this.ht, ++this.page, this.VE);
            }
            return null;
        }
        catch (ReportException reportException) {
            throw new WrappedRuntimeException((Throwable)reportException);
        }
    }
}

