/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.list.StringIntMap;
import com.inet.lib.util.LocaleUtils;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.Group;
import com.inet.report.RendererBase;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.as;
import com.inet.report.bg;
import com.inet.report.bk;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.y;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public class ReportProperties
implements NodeParser,
Serializable {
    public static final int DEFAULT_PAPER_ORIENTATION = 0;
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 2;
    public static final int DEFAULT_PAPERSIZE = 0;
    public static final int PAPER_LETTER = 1;
    public static final int PAPER_LETTER_SMALL = 2;
    public static final int PAPER_TABLOID = 3;
    public static final int PAPER_LEDGER = 4;
    public static final int PAPER_LEGAL = 5;
    public static final int PAPER_STATEMENT = 6;
    public static final int PAPER_EXECUTIVE = 7;
    public static final int PAPER_A3 = 8;
    public static final int PAPER_A4 = 9;
    public static final int PAPER_A4_SMALL = 10;
    public static final int PAPER_A5 = 11;
    public static final int PAPER_B4 = 12;
    public static final int PAPER_B5 = 13;
    public static final int PAPER_FOLIO = 14;
    public static final int PAPER_QUATRO = 15;
    public static final int PAPER_10_X_14 = 16;
    public static final int PAPER_11_X_17 = 17;
    public static final int PAPER_NOTE = 18;
    public static final int PAPER_ENVELOPE_9 = 19;
    public static final int PAPER_ENVELOPE_10 = 20;
    public static final int PAPER_ENVELOPE_11 = 21;
    public static final int PAPER_ENVELOPE_12 = 22;
    public static final int PAPER_ENVELOPE_14 = 23;
    public static final int PAPER_C_SHEET = 24;
    public static final int PAPER_D_SHEET = 25;
    public static final int PAPER_E_SHEET = 26;
    public static final int PAPER_ENVELOPE_DL = 27;
    public static final int PAPER_ENVELOPE_C5 = 28;
    public static final int PAPER_ENVELOPE_C3 = 29;
    public static final int PAPER_ENVELOPE_C4 = 30;
    public static final int PAPER_ENVELOPE_C6 = 31;
    public static final int PAPER_ENVELOPE_C65 = 32;
    public static final int PAPER_ENVELOPE_B4 = 33;
    public static final int PAPER_ENVELOPE_B5 = 34;
    public static final int PAPER_ENVELOPE_B6 = 35;
    public static final int PAPER_ENVELOPE_ITALY = 36;
    public static final int PAPER_ENVELOPE_MONARCH = 37;
    public static final int PAPER_ENVELOPE_PERSONAL = 38;
    public static final int PAPER_FANFOLD_US = 39;
    public static final int PAPER_FANFOLD_STD_GERMAN = 40;
    public static final int PAPER_FANFOLD_LEGAL_GERMAN = 41;
    public static final int PAPER_B4_ISO = 42;
    public static final int PAPER_JAPANESE_POSTCARD = 43;
    public static final int PAPER_9_X_11 = 44;
    public static final int PAPER_10_X_11 = 45;
    public static final int PAPER_15_X_11 = 46;
    public static final int PAPER_MAX = 132;
    public static final int[] pageSizes = new int[]{12240, 15840, 12240, 15840, 15840, 24480, 24480, 15840, 12240, 20160, 7920, 12240, 10440, 15120, 16839, 23814, 11907, 16839, 11907, 16839, 8419, 11907, 14571, 20638, 10319, 14571, 12240, 18720, 12190, 15592, 14400, 20160, 15840, 24480, 12240, 15840, 5580, 12780, 5940, 13680, 6480, 14940, 6840, 15840, 7200, 16560, 24480, 31680, 31680, 48960, 48960, 63360, 6237, 12474, 9185, 12984, 18370, 25968, 12984, 18370, 6463, 9185, 6463, 12984, 14175, 20015, 9979, 14175, 9979, 7087, 6237, 13041, 5580, 10800, 5220, 9360, 21420, 15840, 12240, 17280, 12240, 18720, 23814, 33679, 5670, 8391, 12960, 15840, 14400, 15840, 21600, 15840, 12474, 12474, 12240, 15840, 12240, 15840, 13680, 17280, 13680, 21600, 16833, 25920, 13348, 16833, 12240, 15840, 11907, 16839, 13680, 17280, 12870, 20185, 17293, 27612, 12240, 18273, 11907, 18711, 8391, 11907, 10319, 14571, 18257, 25231, 9865, 13324, 11396, 15649, 23814, 33679, 16839, 23814, 18257, 25231, 11340, 8391, 5953, 8391, 12240, 15840, 12240, 15840, 12240, 15840, 12240, 15840, 15840, 12240, 23814, 16839, 16839, 11907, 11907, 8419, 1927, 14571, 14571, 10319, 8391, 567, 8391, 11340, 8391, 5953, 12240, 15840, 12240, 15840, 12240, 15840, 12240, 15840, 7257, 10319, 10319, 7257, 17280, 15840, 12240, 15840, 12240, 15840, 8278, 12190, 5499, 8561, 5499, 8561, 5783, 9355, 5783, 9979, 7087, 9979, 6237, 11793, 6237, 12474, 6804, 13041, 9072, 13041, 6804, 17520, 12984, 18370, 18370, 25968, 12240, 15840, 12240, 15840, 12240, 15840, 9355, 5783, 9979, 5783, 9979, 7087, 11793, 6237, 12474, 6237, 13041, 6804, 13041, 9072, 17520, 6804, 18370, 12984, 25968, 18370, 3600, 4800, 3600, 6000, 3600, 6480, 4800, 7200, 7200, 12000, 7200, 12810, 9600, 14400, 15360, 11520, 19200, 10800, 28800, 16200, 5669, 8504, 5760, 8640, 5953, 8391, 7937, 8504};
    public static final int PAPER_A2 = 66;
    public static final int USERDEFINED_PAPER = 256;
    static final ConfigValue<Integer> JJ = new ConfigValue(ConfigKey.DEFAULT_PAPERSIZE);
    static final ConfigValue<Integer> JK = new ConfigValue(ConfigKey.DEFAULT_ORIENTATION);
    private final DatabaseTables wt;
    Engine bm;
    private boolean JL;
    private boolean JM;
    private boolean JN;
    private int JO;
    private boolean JP = true;
    private boolean JQ;
    private boolean JR;
    boolean JS;
    String JT = "";
    String JU = "";
    int AN;
    int JV;
    int JW;
    int JX;
    boolean JY;
    boolean JZ;
    boolean Ka;
    private int bi = 11907;
    private int Kb = 16839;
    private int Kc = 256;
    private int Kd = 0;
    private int Ke = 720;
    private int Kf = 720;
    private int Kg = 720;
    private int Kh = 720;
    private boolean Ki;
    private boolean Kj = true;
    private String[] Kk;
    private boolean Kl = true;
    private boolean Km = true;
    private boolean Kn = true;
    private Locale Ko;
    private boolean Kp = true;
    private int Kq;
    private int Kr;
    private int Ks = Engine.getMajorVersion();
    private int Kt;
    private boolean Ku = true;

    ReportProperties(DatabaseTables dbTables, Engine engine) {
        this.wt = dbTables;
        this.bm = engine;
    }

    public boolean isSuppressIfNoRows() {
        return this.JL;
    }

    public void setSuppressIfNoRows(boolean suppressIfNoRows) {
        this.JL = suppressIfNoRows;
    }

    public void setDistinct(boolean distinct) {
        this.JM = distinct;
    }

    public boolean isDistinct() {
        return this.JM;
    }

    public boolean isConvertNullValuesToDefault() {
        return this.JN;
    }

    public void setConvertNullValuesToDefault(boolean convertNullValuesToDefault) {
        this.JN = convertNullValuesToDefault;
    }

    public boolean isShowSuppressedGroupTreeNodes() {
        return this.JP;
    }

    public void setShowSuppressedGroupTreeNodes(boolean showSuppressedGroupTreeNodes) {
        this.JP = showSuppressedGroupTreeNodes;
    }

    public void setRowBufferSize(int rowCount) {
        this.JO = rowCount;
    }

    public int getRowBufferSize() {
        return this.JO;
    }

    public boolean isValidForRowBuffer() {
        return bk.c(this.wt);
    }

    public void setPaperOrient(int paperOrientation, int paperSize) throws ReportException {
        if (paperSize != 256 && (paperSize < 0 || paperSize > 132)) {
            throw y.b("paperSize", paperSize, null);
        }
        this.Kc = paperSize;
        this.setPaperSize(paperOrientation, paperSize);
    }

    public int getPaperOrient() {
        if (this.Kd == 0) {
            return this.bi > this.Kb ? 2 : 1;
        }
        return this.Kd;
    }

    public int getPaperHeight() {
        return this.Kb;
    }

    public void setPaperHeight(int height) {
        if (height < 0) {
            throw y.a("height", height, null);
        }
        if (height < this.bm.bB.getReportProperties().getMarginTop() + this.bm.bB.getReportProperties().getMarginBottom()) {
            throw y.a("page height is lesser than margin top and margin bottom", height - this.bm.bB.getReportProperties().getMarginTop() - this.bm.bB.getReportProperties().getMarginBottom(), null);
        }
        this.Kb = height;
        this.Kc = 256;
    }

    public int getPaperWidth() {
        return this.bi;
    }

    public void setPaperWidth(int width) throws ReportException {
        if (width < 0) {
            throw y.a("width", width, null);
        }
        this.bm(width - this.bm.bB.getReportProperties().getMarginLeft() - this.bm.bB.getReportProperties().getMarginRight());
        this.bi = width;
        this.Kc = 256;
    }

    void bm(int n2) throws ReportException {
        if (n2 < 0) {
            throw y.a("page width lesser than margins", n2, null);
        }
        Group[] groupArray = this.bm.bB.getAreaPairs();
        if (groupArray != null) {
            for (Group group : groupArray) {
                if (group == null) continue;
                this.a(group.sn, n2);
                this.a(group.so, n2);
            }
        }
    }

    private void a(Area area, int n2) throws ReportException {
        if (area != null) {
            for (Section section : area.gh) {
                section.width = n2;
            }
        }
    }

    public int getPaperFormat() {
        int n2;
        int n3;
        int n4;
        if (this.Kc != 256) {
            return this.Kc;
        }
        int n5 = 1;
        for (n4 = 0; n4 < pageSizes.length; n4 += 2) {
            n3 = pageSizes[n4];
            n2 = pageSizes[n4 + 1];
            if (n3 == this.bi && n2 == this.Kb) {
                return n5;
            }
            if (n3 == this.Kb && n2 == this.bi) {
                return n5;
            }
            ++n5;
        }
        n5 = 1;
        for (n4 = 0; n4 < pageSizes.length; n4 += 2) {
            n3 = pageSizes[n4];
            n2 = pageSizes[n4 + 1];
            double d2 = (double)n3 * 0.99;
            double d3 = (double)n3 * 1.01;
            double d4 = (double)n2 * 0.99;
            double d5 = (double)n2 * 1.01;
            if (d2 < (double)this.bi && d3 > (double)this.bi && d4 < (double)this.Kb && d5 > (double)this.Kb) {
                this.Kc = n5;
                return n5;
            }
            if (d2 < (double)this.Kb && d3 > (double)this.Kb && d4 < (double)this.bi && d5 > (double)this.bi) {
                this.Kc = n5;
                return n5;
            }
            ++n5;
        }
        return 256;
    }

    public static int findPaperFormat(int x2, int y2, boolean isLandscape) {
        int n2 = 9;
        if (x2 <= 0 || y2 <= 0) {
            throw new IllegalArgumentException("args must be positive values");
        }
        if (isLandscape) {
            int n3 = x2;
            x2 = y2;
            y2 = n3;
        }
        double d2 = x2 * x2 + y2 * y2;
        float f2 = x2;
        float f3 = y2;
        for (int i2 = 0; i2 < pageSizes.length; i2 += 2) {
            if (x2 == pageSizes[i2 + 0] && y2 == pageSizes[i2 + 1]) {
                n2 = i2 / 2 + 1;
                break;
            }
            f2 = x2 - pageSizes[i2 + 0];
            f3 = y2 - pageSizes[i2 + 1];
            double d3 = f2 * f2 + f3 * f3;
            if (!(d3 < d2)) continue;
            d2 = d3;
            n2 = i2 / 2 + 1;
        }
        return n2;
    }

    public int getLabelWidth() {
        return this.AN;
    }

    public void setLabelWidth(int labelWidth) {
        if (labelWidth < 0) {
            throw y.a("labelWidth", labelWidth, null);
        }
        this.AN = labelWidth;
    }

    public int getLabelHeight() {
        return this.JV;
    }

    public void setLabelHeight(int labelHeight) {
        if (labelHeight < 0) {
            throw y.a("labelHeight", labelHeight, null);
        }
        this.JV = labelHeight;
    }

    public int getHorizontal() {
        return this.JW;
    }

    public void setHorizontal(int horizontal) {
        if (horizontal < 0) {
            throw y.a("horizontal", horizontal, null);
        }
        this.JW = horizontal;
    }

    public int getVertical() {
        return this.JX;
    }

    public void setVertical(int vertical) {
        if (vertical < 0) {
            throw y.a("vertical", vertical, null);
        }
        this.JX = vertical;
    }

    public void setLabelName(String s2) {
        this.JT = s2;
    }

    public String getLabelName() {
        return this.JT;
    }

    public boolean isAcrossThenDown() {
        return this.JY;
    }

    public void setAcrossThenDown(boolean acrossThenDown) {
        this.JY = acrossThenDown;
    }

    public boolean isFormatGroupsWithMultipleColumn() {
        return this.JZ;
    }

    public void setFormatGroupsWithMultipleColumn(boolean formatGroupsWithMultipleColumn) {
        this.JZ = formatGroupsWithMultipleColumn;
    }

    public void setMarginTop(int margin) {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        if (this.Kb < margin + this.bm.bB.getReportProperties().getMarginBottom()) {
            throw y.a("page height is lesser than margin top and margin bottom", this.Kb - margin - this.bm.bB.getReportProperties().getMarginBottom(), null);
        }
        this.Kg = margin;
    }

    public int getMarginTop() {
        return this.Kg;
    }

    public void setMarginBottom(int margin) {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        if (this.Kb < margin + this.bm.bB.getReportProperties().getMarginTop()) {
            throw y.a("page height lesser than margin top and margin bottom", this.Kb - margin - this.bm.bB.getReportProperties().getMarginTop(), null);
        }
        this.Kh = margin;
    }

    public int getMarginBottom() {
        return this.Kh;
    }

    public void setMarginLeft(int margin) throws ReportException {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        this.bm(this.bi - margin - this.bm.bB.getReportProperties().getMarginRight());
        this.Ke = margin;
    }

    public int getMarginLeft() {
        return this.Ke;
    }

    public void setMarginRight(int margin) throws ReportException {
        if (margin < 0) {
            throw y.a("margin", margin, null);
        }
        this.bm(this.bi - margin - this.bm.bB.getReportProperties().getMarginLeft());
        this.Kf = margin;
    }

    public int getMarginRight() {
        return this.Kf;
    }

    public boolean isFormatWithMultipleColumns() {
        return this.JS;
    }

    public void setFormatWithMultipleColumns(boolean val) {
        this.JS = val;
    }

    void w(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, ++n2, a.Kx.name(), k.z(this.bi));
        k.a(stringBuilder, n2, a.Ky.name(), k.z(this.Kb));
        k.a(stringBuilder, n2, a.Kz.name(), k.z(this.Kd));
        k.a(stringBuilder, n2, a.KA.name(), k.z(this.bm.bB.getReportProperties().getMarginLeft()));
        k.a(stringBuilder, n2, a.KB.name(), k.z(this.bm.bB.getReportProperties().getMarginRight()));
        k.a(stringBuilder, n2, a.KC.name(), k.z(this.bm.bB.getReportProperties().getMarginTop()));
        k.a(stringBuilder, n2, a.KD.name(), k.z(this.bm.bB.getReportProperties().getMarginBottom()));
        if (this.JT != null) {
            k.a(stringBuilder, n2, a.KE.name(), this.JT);
        }
        if (this.JU != null) {
            k.a(stringBuilder, n2, a.KF.name(), this.JU);
        }
        k.a(stringBuilder, n2, a.KS.name(), k.g(this.JS));
        k.a(stringBuilder, n2, a.KG.name(), k.z(this.AN));
        k.a(stringBuilder, n2, a.KH.name(), k.z(this.JV));
        k.a(stringBuilder, n2, a.KJ.name(), k.z(this.JX));
        k.a(stringBuilder, n2, a.KI.name(), k.z(this.JW));
        k.a(stringBuilder, n2, a.KK.name(), k.g(this.JY));
        k.a(stringBuilder, n2, a.KL.name(), k.g(this.JZ));
        k.a(stringBuilder, n2, a.KM.name(), k.g(this.JM));
        k.a(stringBuilder, n2, a.Lc.name(), k.g(this.JP));
        k.a(stringBuilder, n2, a.KN.name(), k.g(this.isIgnoreFiltering()));
        k.a(stringBuilder, n2, a.KO.name(), k.g(this.isIgnoreSorting()));
        if (this.JO != 0 && this.isValidForRowBuffer()) {
            k.a(stringBuilder, n2, a.KP.name(), k.z(this.JO));
        }
        k.a(stringBuilder, n2, a.KT.name(), k.g(this.JL));
        k.a(stringBuilder, n2, a.KU.name(), k.g(this.JN));
        k.a(stringBuilder, n2, a.KV.name(), k.g(this.Ka));
        k.a(stringBuilder, n2, a.KW.name(), k.g(this.Ki));
        if (this.Kk != null && this.Kk.length > 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i2 = 0; i2 < this.Kk.length; ++i2) {
                if (i2 != 0) {
                    stringBuilder2.append(' ');
                }
                stringBuilder2.append(this.Kk[i2]);
            }
            k.a(stringBuilder, n2, a.KX.name(), stringBuilder2.toString());
        }
        k.a(stringBuilder, n2, a.KY.name(), k.g(this.Kj));
        k.a(stringBuilder, n2, a.KZ.name(), k.g(this.Kl));
        k.a(stringBuilder, n2, a.La.name(), k.g(this.Km));
        k.a(stringBuilder, n2, a.Lb.name(), k.g(this.Kn));
        if (this.Ko != null) {
            k.a(stringBuilder, n2, a.Ld.name(), this.Ko.toString());
        }
        k.a(stringBuilder, n2, a.Le.name(), k.g(this.Ku));
        if (stringBuilder.length() > 0) {
            printWriter.print(string + "<ReportProperties>\n");
            printWriter.print(stringBuilder);
            printWriter.print(string + "</ReportProperties>\n");
        }
    }

    void b(int n2, String string, as as2) throws ReportException {
        switch (n2) {
            case 231: {
                this.bi = Integer.parseInt(string);
                break;
            }
            case 232: {
                this.Kb = Integer.parseInt(string);
                break;
            }
            case 102223: {
                this.Kd = Integer.parseInt(string);
                break;
            }
            case 233: {
                this.Ke = Integer.parseInt(string);
                break;
            }
            case 234: {
                this.Kf = Integer.parseInt(string);
                break;
            }
            case 235: {
                this.Kg = Integer.parseInt(string);
                break;
            }
            case 236: {
                this.Kh = Integer.parseInt(string);
                break;
            }
            case 238: {
                this.JT = string;
                break;
            }
            case 239: {
                this.JU = string;
                break;
            }
            case 240: {
                this.AN = Integer.parseInt(string);
                break;
            }
            case 241: {
                this.JV = Integer.parseInt(string);
                break;
            }
            case 243: {
                if (as2.xt >= 6) {
                    this.JW = Integer.parseInt(string);
                    break;
                }
                this.JX = Integer.parseInt(string);
                break;
            }
            case 242: {
                if (as2.xt >= 6) {
                    this.JX = Integer.parseInt(string);
                    break;
                }
                this.JW = Integer.parseInt(string);
                break;
            }
            case 244: {
                this.JY = Boolean.valueOf(string);
                break;
            }
            case 2600: {
                this.JZ = Boolean.valueOf(string);
                break;
            }
            case 245: {
                this.bm.bB.getSummaryInfo().setReportTitle(string);
                break;
            }
            case 246: {
                this.bm.bB.getSummaryInfo().setAuthor(string);
                break;
            }
            case 247: {
                this.bm.bB.getSummaryInfo().setKeywords(string);
                break;
            }
            case 248: {
                this.bm.bB.getSummaryInfo().setSubject(string);
                break;
            }
            case 249: {
                this.bm.bB.getSummaryInfo().setTemplate(string);
                break;
            }
            case 250: {
                this.bm.bB.getSummaryInfo().setComments(string);
                break;
            }
            case 251: {
                this.bm.bB.getSummaryInfo().setLastSaved(as2.T(string));
                break;
            }
            case 252: {
                this.bm.bB.getSummaryInfo().setCreated(as2.T(string));
                break;
            }
            case 254: {
                this.JM = Boolean.valueOf(string);
                break;
            }
            case 2543: {
                this.JP = Boolean.valueOf(string);
                break;
            }
            case 2542: {
                this.setIgnoreFiltering(Boolean.valueOf(string));
                break;
            }
            case 2541: {
                this.setIgnoreSorting(Boolean.valueOf(string));
                break;
            }
            case 255: {
                this.JO = Integer.parseInt(string);
                break;
            }
            case 237: {
                this.JS = Boolean.valueOf(string);
                break;
            }
            case 2601: {
                this.JL = Boolean.valueOf(string);
                break;
            }
            case 2602: {
                this.JN = Boolean.valueOf(string);
                break;
            }
            case 2603: {
                this.Ka = Boolean.valueOf(string);
                break;
            }
            case 2604: {
                this.Ki = Boolean.valueOf(string);
                break;
            }
            case 2605: {
                this.Kk = string.split(" ");
                break;
            }
            case 2606: {
                this.Kj = Boolean.valueOf(string);
                break;
            }
            case 2607: {
                this.Kl = Boolean.valueOf(string);
                break;
            }
            case 2608: {
                this.Km = Boolean.valueOf(string);
                break;
            }
            case 2609: {
                this.Kn = Boolean.valueOf(string);
                break;
            }
            case 2610: {
                this.setReportLocale(this.ai(string));
                break;
            }
            case 2611: {
                this.Ku = Boolean.parseBoolean(string);
            }
        }
    }

    static void a(StringIntMap stringIntMap) {
        stringIntMap.put("major_version", 227);
        stringIntMap.put("minor_version", 228);
        stringIntMap.put("major_xml_version", 229);
        stringIntMap.put("minor_xml_version", 230);
        stringIntMap.put("page width", 231);
        stringIntMap.put("page height", 232);
        stringIntMap.put("page orientation", 102223);
        stringIntMap.put("page margin left", 233);
        stringIntMap.put("page margin right", 234);
        stringIntMap.put("page margin top", 235);
        stringIntMap.put("page margin bottom", 236);
        stringIntMap.put("format with multiple columns", 237);
        stringIntMap.put("format groups with multiple columns", 2600);
        stringIntMap.put("mailing label type 1", 238);
        stringIntMap.put("mailing label type 2", 239);
        stringIntMap.put("mailing label width", 240);
        stringIntMap.put("mailing label height", 241);
        stringIntMap.put("mailing label distance vertical", 242);
        stringIntMap.put("mailing label distance horizontal", 243);
        stringIntMap.put("across then down", 244);
        stringIntMap.put("report title", 245);
        stringIntMap.put("report author", 246);
        stringIntMap.put("report keywords", 247);
        stringIntMap.put("report subject", 248);
        stringIntMap.put("report template", 249);
        stringIntMap.put("report comments", 250);
        stringIntMap.put("report last saved", 251);
        stringIntMap.put("report created", 252);
        stringIntMap.put("distinct", 254);
        stringIntMap.put("show suppressed nodes", 2543);
        stringIntMap.put("ignore sorting", 2541);
        stringIntMap.put("ignore filtering", 2542);
        stringIntMap.put("rowbuffer", 255);
        stringIntMap.put("data source", 258);
        stringIntMap.put("data source desc", 259);
        stringIntMap.put("suppress if no rows", 2601);
        stringIntMap.put("convert null values to default", 2602);
        stringIntMap.put("hide PageFooter inside ReportHeader", 2603);
        stringIntMap.put("form print", 2604);
        stringIntMap.put("enabled formats", 2605);
        stringIntMap.put("printing enabled", 2606);
        stringIntMap.put("clipboard enabled", 2607);
        stringIntMap.put("export enabled", 2608);
        stringIntMap.put("group tree visible", 2609);
        stringIntMap.put("report locale", 2610);
        stringIntMap.put("save datasource", 2611);
    }

    public void setPaperSize(int paperOrient, int paperFormat) throws ReportException {
        int n2;
        if (paperFormat > 0 && paperFormat < pageSizes.length / 2 + 1) {
            this.bi = pageSizes[2 * (paperFormat - 1)];
            this.bm(this.bi - this.bm.bB.getReportProperties().getMarginLeft() - this.bm.bB.getReportProperties().getMarginRight());
            this.Kb = pageSizes[2 * (paperFormat - 1) + 1];
            this.Kc = paperFormat;
        } else if (paperFormat != 256) {
            if (paperFormat == 0) {
                n2 = (Integer)JJ.get();
                if (n2 <= 0 || n2 >= pageSizes.length / 2 + 1) {
                    if (BaseUtils.isWarning()) {
                        BaseUtils.warning("The value for \"default_PaperSize\" in the i-net Clear Reports configuration is invalid: " + n2);
                    }
                    n2 = 1;
                }
                this.bi = pageSizes[2 * (n2 - 1)];
                this.bm(this.bi - this.bm.bB.getReportProperties().getMarginLeft() - this.bm.bB.getReportProperties().getMarginRight());
                this.Kb = pageSizes[2 * (n2 - 1) + 1];
                this.Kc = n2;
            } else {
                BaseUtils.warning("Unsupported paper size: " + paperFormat + "! Use Letter instead.\n");
                this.bi = 12240;
                this.Kb = 15840;
                this.Kc = 1;
            }
        }
        this.Kd = paperOrient;
        if (paperOrient == 2) {
            n2 = this.bi;
            this.bi = this.Kb;
            this.Kb = n2;
        }
    }

    public boolean isHidePageFooterInsideReportHeader() {
        return this.Ka;
    }

    public void setHidePageFooterInsideReportHeader(boolean hidePageFooterInsideReportHeader) {
        this.Ka = hidePageFooterInsideReportHeader;
    }

    public void setFormPrint(boolean value) {
        this.Ki = value;
    }

    public boolean isFormPrint() {
        return this.Ki;
    }

    public void setPrintingEnabled(boolean value) {
        this.Kj = value;
    }

    public boolean isPrintingEnabled() {
        return this.Kj;
    }

    public void setEnabledFormats(String[] formats) {
        this.Kk = formats;
    }

    public String[] getEnabledFormats() {
        return this.Kk;
    }

    public void setClipboardEnabled(boolean value) {
        this.Kl = value;
    }

    public boolean isClipboardEnabled() {
        return this.Kl;
    }

    public void setExportEnabled(boolean value) {
        this.Km = value;
    }

    public boolean isExportEnabled() {
        return this.Km;
    }

    public void setGroupTreeVisible(boolean value) {
        this.Kn = value;
    }

    public boolean isGroupTreeVisible() {
        return this.Kn;
    }

    @Deprecated
    public boolean isIgnoreSorting() {
        return this.JQ;
    }

    @Deprecated
    public void setIgnoreSorting(boolean ignoreSorting) {
        this.JQ = ignoreSorting;
    }

    @Deprecated
    public boolean isIgnoreFiltering() {
        return this.JR;
    }

    @Deprecated
    public void setIgnoreFiltering(boolean ignoreFiltering) {
        this.JR = ignoreFiltering;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        String string = atts.getValue("value");
        if (string == null) {
            return null;
        }
        a a2 = a.aj(tag);
        if (a2 == a.Lf) {
            return null;
        }
        switch (a2) {
            case Kx: {
                this.bi = Integer.parseInt(string);
                break;
            }
            case Ky: {
                this.Kb = Integer.parseInt(string);
                break;
            }
            case Kz: {
                this.Kd = Integer.parseInt(string);
                break;
            }
            case KA: {
                this.Ke = Integer.parseInt(string);
                break;
            }
            case KB: {
                this.Kf = Integer.parseInt(string);
                break;
            }
            case KC: {
                this.Kg = Integer.parseInt(string);
                break;
            }
            case KD: {
                this.Kh = Integer.parseInt(string);
                break;
            }
            case KE: {
                this.JT = string;
                break;
            }
            case KF: {
                this.JU = string;
                break;
            }
            case KG: {
                this.AN = Integer.parseInt(string);
                break;
            }
            case KH: {
                this.JV = Integer.parseInt(string);
                break;
            }
            case KI: {
                this.JW = Integer.parseInt(string);
                break;
            }
            case KJ: {
                this.JX = Integer.parseInt(string);
                break;
            }
            case KK: {
                this.JY = Boolean.valueOf(string);
                break;
            }
            case KL: {
                this.JZ = Boolean.valueOf(string);
                break;
            }
            case KM: {
                this.JM = Boolean.valueOf(string);
                break;
            }
            case KN: {
                this.setIgnoreFiltering(Boolean.valueOf(string));
                break;
            }
            case KO: {
                this.setIgnoreSorting(Boolean.valueOf(string));
                break;
            }
            case KP: {
                this.JO = Integer.parseInt(string);
                break;
            }
            case KS: {
                this.JS = Boolean.valueOf(string);
                break;
            }
            case KT: {
                this.JL = Boolean.valueOf(string);
                break;
            }
            case KU: {
                this.JN = Boolean.valueOf(string);
                break;
            }
            case KV: {
                this.Ka = Boolean.valueOf(string);
                break;
            }
            case KW: {
                this.Ki = Boolean.valueOf(string);
                break;
            }
            case KX: {
                this.Kk = string.split(" ");
                break;
            }
            case KY: {
                this.Kj = Boolean.valueOf(string);
                break;
            }
            case KZ: {
                this.Kl = Boolean.valueOf(string);
                break;
            }
            case La: {
                this.Km = Boolean.valueOf(string);
                break;
            }
            case Lb: {
                this.Kn = Boolean.valueOf(string);
                break;
            }
            case Lc: {
                this.JP = Boolean.valueOf(string);
                break;
            }
            case Ld: {
                this.setReportLocale(this.ai(string));
                break;
            }
            case Le: {
                this.Ku = Boolean.parseBoolean(string);
            }
        }
        return null;
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    public void setReportLocale(Locale reportLocale) {
        Object object;
        if (BaseUtils.isInfo() && reportLocale != Locale.getDefault()) {
            BaseUtils.info("Set server locale for the current report: " + String.valueOf(reportLocale != null ? reportLocale : String.valueOf(Locale.getDefault()) + " (VM default)"));
        }
        if (reportLocale != null && reportLocale != Locale.getDefault() && BaseUtils.isWarning() && (object = LocaleUtils.checkLocale((Locale)reportLocale)) != null) {
            BaseUtils.warning("setReportLocale: " + (String)object);
        }
        this.Ko = reportLocale;
        if (this.bm != null && this.bm.bB != null) {
            object = this.bm.bB;
            if (reportLocale != null) {
                if (((bg)object).serverLocale == ((bg)object).ressourceLocale) {
                    ((bg)object).setLocale(reportLocale, false);
                }
                ((bg)object).serverLocale = reportLocale;
                if (((bg)object).IJ != null) {
                    for (int i2 = 0; i2 < ((bg)object).IJ.size(); ++i2) {
                        RendererBase<?> rendererBase = ((bg)object).IJ.get(i2);
                        rendererBase.serverLocale = reportLocale;
                    }
                }
            } else {
                this.setReportLocale(Locale.getDefault());
                this.Ko = null;
            }
        }
    }

    public Locale getReportLocale() {
        return this.Ko;
    }

    private Locale ai(String string) {
        if (string != null && string.length() > 0) {
            String string2;
            if (BaseUtils.isWarning() && (string2 = LocaleUtils.checkLocaleString((String)string)) != null) {
                BaseUtils.warning("parseLocaleFromString: " + string2);
            }
            return LocaleUtils.valueOf((String)string);
        }
        return null;
    }

    public boolean isCCFormat() {
        return this.Kp;
    }

    void R(boolean bl2) {
        this.Kp = bl2;
    }

    int il() {
        return this.Kq;
    }

    void bn(int n2) {
        this.Kq = n2;
    }

    int im() {
        return this.Kr;
    }

    void bo(int n2) {
        this.Kr = n2;
    }

    public int getXMLMajorVersion() {
        return this.Ks;
    }

    void bp(int n2) {
        this.Ks = n2;
    }

    public int getXMLMinorVersion() {
        return this.Kt;
    }

    void bq(int n2) {
        this.Kt = n2;
    }

    public void setSaveDatasource(boolean save) {
        this.Ku = save;
    }

    public boolean isSaveDatasource() {
        return this.Ku;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a Kw = new a();
        public static final /* enum */ a Kx = new a();
        public static final /* enum */ a Ky = new a();
        public static final /* enum */ a Kz = new a();
        public static final /* enum */ a KA = new a();
        public static final /* enum */ a KB = new a();
        public static final /* enum */ a KC = new a();
        public static final /* enum */ a KD = new a();
        public static final /* enum */ a KE = new a();
        public static final /* enum */ a KF = new a();
        public static final /* enum */ a KG = new a();
        public static final /* enum */ a KH = new a();
        public static final /* enum */ a KI = new a();
        public static final /* enum */ a KJ = new a();
        public static final /* enum */ a KK = new a();
        public static final /* enum */ a KL = new a();
        public static final /* enum */ a KM = new a();
        public static final /* enum */ a KN = new a();
        public static final /* enum */ a KO = new a();
        public static final /* enum */ a KP = new a();
        public static final /* enum */ a KQ = new a();
        public static final /* enum */ a KR = new a();
        public static final /* enum */ a KS = new a();
        public static final /* enum */ a KT = new a();
        public static final /* enum */ a KU = new a();
        public static final /* enum */ a KV = new a();
        public static final /* enum */ a KW = new a();
        public static final /* enum */ a KX = new a();
        public static final /* enum */ a KY = new a();
        public static final /* enum */ a KZ = new a();
        public static final /* enum */ a La = new a();
        public static final /* enum */ a Lb = new a();
        public static final /* enum */ a Lc = new a();
        public static final /* enum */ a Ld = new a();
        public static final /* enum */ a Le = new a();
        public static final /* enum */ a Lf = new a();
        private static HashMap<String, a> gC;
        private static final /* synthetic */ a[] Lg;

        public static a[] values() {
            return (a[])Lg.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static a aj(String string) {
            a a2 = gC.get(string);
            if (a2 == null) {
                a2 = Lf;
            }
            return a2;
        }

        private static /* synthetic */ a[] in() {
            return new a[]{Kw, Kx, Ky, Kz, KA, KB, KC, KD, KE, KF, KG, KH, KI, KJ, KK, KL, KM, KN, KO, KP, KQ, KR, KS, KT, KU, KV, KW, KX, KY, KZ, La, Lb, Lc, Ld, Le, Lf};
        }

        static {
            Lg = a.in();
            gC = new HashMap();
            gC.put("DefaultAttribute", Kw);
            gC.put("PageWidth", Kx);
            gC.put("PageHeight", Ky);
            gC.put("PageOrientation", Kz);
            gC.put("PageMarginLeft", KA);
            gC.put("PageMarginRight", KB);
            gC.put("PageMarginTop", KC);
            gC.put("PageMarginBottom", KD);
            gC.put("MailingLabelType1", KE);
            gC.put("MailingLabelType2", KF);
            gC.put("MailingLabelWidth", KG);
            gC.put("MailingLabelHeight", KH);
            gC.put("MailingLabelDistanceHorizontal", KI);
            gC.put("MailingLabelDistanceVertical", KJ);
            gC.put("AcrossThenDown", KK);
            gC.put("FormatGroupsWithMultipleColumns", KL);
            gC.put("Distinct", KM);
            gC.put("IgnoreFiltering", KN);
            gC.put("IgnoreSorting", KO);
            gC.put("Rowbuffer", KP);
            gC.put("DataSource", KQ);
            gC.put("DataSourceDesc", KR);
            gC.put("FormatWithMultipleColumns", KS);
            gC.put("SuppressIfNoRows", KT);
            gC.put("ConvertNullValuesToDefault", KU);
            gC.put("HidePageFooterInsideReportHeader", KV);
            gC.put("FormPrint", KW);
            gC.put("EnabledFormats", KX);
            gC.put("PrintingEnabled", KY);
            gC.put("ClipboardEnabled", KZ);
            gC.put("ExportEnabled", La);
            gC.put("GroupTreeVisible", Lb);
            gC.put("ShowSuppressedNodes", Lc);
            gC.put("ReportLocale", Ld);
            gC.put("SaveDatasource", Le);
        }
    }
}

