/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.CrossTab;
import com.inet.report.CrossTabBody;
import com.inet.report.CrossTabHeader;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.FormulaField;
import com.inet.report.PropertyConstants;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.m;
import com.inet.report.y;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class CrossTabHeaderList
implements Serializable {
    private final CrossTab je;
    @Nonnull
    private final List<CrossTabHeader> jR;
    private boolean jS;
    private FormulaField jT;
    private FormulaField jU;
    private boolean jV;
    private boolean jW;
    private int jX;

    CrossTabHeaderList(CrossTab crossTab) {
        this.je = crossTab;
        this.jR = new ArrayList<CrossTabHeader>();
    }

    public void remove(int index) throws ReportException {
        if (index == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDropGrandTotal, new Object[0]);
        }
        CrossTabHeader crossTabHeader = this.jR.get(index);
        this.je.getBody().a(crossTabHeader);
        this.jR.remove(index);
        crossTabHeader.resetReferences();
        this.je.aR().bd();
        this.je.aR().be();
    }

    @Nonnull
    public CrossTabHeader add(@Nonnull Field field) {
        Element element;
        int n2;
        int n3;
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.je, this, field);
        this.jR.add(crossTabHeader);
        CrossTabBody crossTabBody = this.je.getBody();
        boolean bl2 = this.je.getOptions().getSummaryHorizontal();
        int n4 = Math.max(1, crossTabBody.getSummaryFieldsCount());
        if (this.isRow()) {
            crossTabBody.b(crossTabHeader);
            n3 = 2036;
            n2 = 230;
            if (this.size() == 2) {
                element = this.jR.get(0).getText();
                n3 = Math.max(n3, element.getWidth());
            }
            if (!bl2) {
                n2 *= n4;
            }
        } else {
            crossTabBody.c(crossTabHeader);
            n3 = 810;
            n2 = 230;
            if (this.size() == 2) {
                element = this.jR.get(0).getText();
                n2 = Math.max(n2, element.getHeight());
            }
            if (bl2) {
                n3 *= n4;
            }
        }
        if ((element = crossTabHeader.getFieldElement()) == null) {
            element = crossTabHeader.getText();
        }
        element.setWidth(n3);
        element.setHeight(n2);
        return crossTabHeader;
    }

    public void move(int from, int to) throws ReportException {
        Element element;
        int n2;
        if (from == 0 || to == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDropGrandTotal, new Object[0]);
        }
        this.jR.get(to);
        boolean bl2 = this.isRow();
        int[] nArray = new int[this.jR.size()];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            element = this.jR.get(n2).bt();
            nArray[n2] = bl2 ? element.jm : element.width;
        }
        this.jR.add(to, this.jR.remove(from));
        for (n2 = 1; n2 < nArray.length; ++n2) {
            element = this.jR.get(n2).bt();
            if (bl2) {
                element.jm = nArray[n2];
                continue;
            }
            element.width = nArray[n2];
        }
        this.je.aR().bd();
        this.je.aR().be();
    }

    @Nonnull
    @Deprecated
    CrossTabHeader bx() {
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.je, this, null);
        this.jR.add(crossTabHeader);
        return crossTabHeader;
    }

    @Nonnull
    public CrossTabHeader get(int index) {
        return this.jR.get(index);
    }

    public boolean isRow() {
        return this == this.je.getRows();
    }

    public int size() {
        return this.jR.size();
    }

    @Nonnull
    public CrossTabHeader getGrandTotal() {
        return this.jR.get(0);
    }

    public boolean getTotalOnStart() {
        return this.jS;
    }

    public void setTotalOnStart(boolean value) {
        this.jS = value;
    }

    public void setTotalOnStartFormula(FormulaField newFormula) {
        String string;
        int n2;
        FormulaField.d(this.jT);
        if (this.isRow()) {
            n2 = 465;
            string = "rowTotalOnLeft";
        } else {
            n2 = 466;
            string = "columnTotalOnTop";
        }
        this.jT = this.je.a(newFormula, n2, string);
    }

    public FormulaField getTotalOnStartFormula() {
        return this.jT;
    }

    public boolean getSuppressEmptyLines() {
        return this.jV;
    }

    public void setSuppressEmptyLines(boolean suppressEmptyLines) {
        this.jV = suppressEmptyLines;
    }

    public void setSuppressEmptyLinesFormula(FormulaField newFormula) {
        String string;
        int n2;
        FormulaField.d(this.jU);
        if (this.isRow()) {
            n2 = 455;
            string = "suppressEmptyRows";
        } else {
            n2 = 454;
            string = "suppressEmptyColumns";
        }
        this.jU = this.je.a(newFormula, n2, string);
    }

    public FormulaField getSuppressEmptyLinesFormula() {
        return this.jU;
    }

    public boolean getIndentLabel() {
        return this.jW;
    }

    public void setIndentLabel(boolean indentLabel) {
        if (this.jW != indentLabel) {
            this.jW = indentLabel;
            this.je.aR().bd();
            this.je.aR().be();
        }
    }

    public int getIndentLabelSize() {
        return this.jX;
    }

    public void setIndentLabelSize(int indentLabelSize) {
        if (indentLabelSize < 0) {
            throw y.a("indentLabelSize", indentLabelSize, null);
        }
        if (this.jX != indentLabelSize) {
            this.jX = indentLabelSize;
            if (this.isRow()) {
                this.je.aR().bd();
            } else {
                this.je.aR().be();
            }
        }
    }

    void setReferences() {
        for (int i2 = 0; i2 < this.jR.size(); ++i2) {
            this.jR.get(i2).setReferences();
        }
    }

    void resetReferences() {
        for (int i2 = 0; i2 < this.jR.size(); ++i2) {
            this.jR.get(i2).resetReferences();
        }
    }

    void b(@Nonnull List<FormulaField> list) {
        for (int i2 = 0; i2 < this.jR.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jR.get(i2);
            crossTabHeader.b(list);
        }
        list.add(PropertyConstants.setPropertyDefault(this.jU, this.getSuppressEmptyLines()));
        list.add(PropertyConstants.setPropertyDefault(this.jT, this.getTotalOnStart()));
    }

    int g(CrossTabHeader crossTabHeader) {
        return this.jR.indexOf(crossTabHeader);
    }

    int b(Element element) {
        for (int i2 = 0; i2 < this.jR.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jR.get(i2);
            if (crossTabHeader.getText() != element && crossTabHeader.getFieldElement() != element) continue;
            return i2;
        }
        return -1;
    }

    void aZ() {
        m m2 = this.je.aR();
        for (int i2 = 0; i2 < this.jR.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jR.get(i2);
            crossTabHeader.getText().addPropertyChangeListener(m2);
            FieldElement fieldElement = crossTabHeader.getFieldElement();
            if (fieldElement == null) continue;
            fieldElement.addPropertyChangeListener(m2);
        }
    }
}

