/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.html;

import com.inet.annotations.JsonData;
import com.inet.editor.HtmlConverter;
import com.inet.lib.json.Json;
import com.inet.report.BaseUtils;
import com.inet.report.util.WebUtils;
import com.inet.viewer.RenderData;
import com.inet.viewer.archive.search.SearchHandler;
import com.inet.viewer.archive.search.SearchReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlSearchHandler
extends SearchHandler {
    private final HtmlSearchResults aLh = new HtmlSearchResults();

    public HtmlSearchHandler(RenderData data) {
        super(data);
    }

    @Override
    protected SearchReader createSearchReader(byte[] pageData, String[] phraseTokens, int page, int flags) {
        return new a(pageData, phraseTokens, page, flags, this.aLh.results);
    }

    @Override
    protected byte[] writeFinish(int lastPage, long timestamp) {
        StringBuilder stringBuilder = new StringBuilder();
        this.aLh.lastPage = lastPage;
        new Json().toJson((Object)this.aLh, stringBuilder);
        return stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    @JsonData
    static class HtmlSearchResults {
        private ArrayList<HtmlSearchResult> results = new ArrayList();
        private int lastPage;

        HtmlSearchResults() {
        }
    }

    static class a
    extends SearchReader {
        private final String mp;
        private final String[] aLi;
        private final int page;
        private final ArrayList<HtmlSearchResult> results;
        private final int aLj;
        private int aLk;

        public a(byte[] byArray, String[] stringArray, int n2, int n3, ArrayList<HtmlSearchResult> arrayList) {
            super(byArray, stringArray, n2, n3, null);
            this.aLk = n3;
            this.mp = HtmlConverter.html2text((String)a.a(byArray, n2 + ".html"));
            this.aLi = stringArray;
            this.page = n2;
            this.results = arrayList;
            this.aLj = arrayList.size();
        }

        private static String a(byte[] byArray, String string) {
            int n2;
            for (int i2 = 0; byArray.length > i2; i2 += n2) {
                n2 = WebUtils.readHtmlInt(byArray, i2);
                i2 += 4;
                if (n2 == -1) {
                    return "";
                }
                if (n2 < 0 || i2 + n2 > byArray.length) {
                    return "";
                }
                String string2 = BaseUtils.getStringUTF8(byArray, i2, n2);
                i2 += n2;
                n2 = WebUtils.readHtmlInt(byArray, i2);
                if (n2 < 0 || (i2 += 4) + n2 > byArray.length) {
                    return "";
                }
                if (!string2.equals(string)) continue;
                return new String(byArray, i2, n2, StandardCharsets.UTF_8);
            }
            return "";
        }

        @Override
        protected int getSearchCount() {
            return this.results.size() - this.aLj;
        }

        @Override
        protected void search() {
            boolean bl2;
            boolean bl3 = bl2 = (this.aLk & 4) == 4;
            if (bl2) {
                this.BX();
                return;
            }
            SearchReader.Tokenizer tokenizer = new SearchReader.Tokenizer(this.mp);
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = tokenizer.nextToken();
            while (string != null) {
                arrayList.add(string.trim());
                string = tokenizer.nextToken();
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = arrayList.size() - this.aLi.length + 1;
            block1: for (int i2 = 0; i2 < n2; ++i2) {
                String string2;
                stringBuilder.setLength(0);
                for (int i3 = 0; i3 < this.aLi.length; ++i3) {
                    String string3;
                    string2 = (String)arrayList.get(i2 + i3);
                    if (!this.match(string2, string3 = this.aLi[i3])) continue block1;
                    stringBuilder.append(' ').append(string2);
                }
                String string4 = i2 == 0 ? "" : (String)arrayList.get(i2 - 1);
                string2 = i2 + this.aLi.length >= arrayList.size() ? "" : (String)arrayList.get(i2 + this.aLi.length);
                this.results.add(new HtmlSearchResult(string4, stringBuilder.substring(1), string2, this.page));
            }
        }

        private void BX() {
            Pattern pattern = Pattern.compile(this.aLi[0]);
            Matcher matcher = pattern.matcher(this.mp);
            while (matcher.find()) {
                int n2;
                int n3 = matcher.start();
                int n4 = matcher.end();
                String string = matcher.group();
                int n5 = n3 - 10;
                if (n5 < 0) {
                    n5 = 0;
                }
                if ((n2 = n4 + 10) > this.mp.length()) {
                    n2 = this.mp.length();
                }
                this.results.add(new HtmlSearchResult(this.mp.substring(n5, n3), string, this.mp.substring(n4, n2), this.page));
            }
        }
    }

    @JsonData
    static class HtmlSearchResult {
        private String pre;
        private String result;
        private String post;
        private int page;

        HtmlSearchResult(String pre, String result, String post, int page) {
            this.pre = pre;
            this.result = result;
            this.post = post;
            this.page = page;
        }
    }
}

