/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.html;

import com.inet.graphics.encode.PNGEncoder;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.layout.richhtml.b;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.html.d;
import com.inet.report.renderer.html.h;
import com.inet.report.renderer.html.tree.a;
import com.inet.report.renderer.html.tree.e;
import com.inet.shared.utils.MemoryStream;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class HtmlDocumentWriter
extends AbstractDocumentWriter {
    private static final int aKP = ",\"url\":\"".length();
    private final h aKQ;
    private final boolean aKR;
    private boolean aKS;
    private boolean aKT;
    private boolean aKU;
    private final MemoryStream aKV;
    private final MemoryStream aKW = new MemoryStream();
    private int bi;
    private int Kb;
    private WriterCapabilities aJJ;
    private int aKX;
    private int aKY;
    private HashMap<String, String> aKZ;
    private e aLa;
    private String aLb;
    private int aHs;
    private int aHt;
    private int aHu;
    private int aHv;

    public HtmlDocumentWriter() {
        this(false);
    }

    public HtmlDocumentWriter(boolean isZip) {
        this.aKR = isZip;
        this.aKV = new MemoryStream();
        this.aKQ = new h(this);
        this.aJJ = new d(this.aKS);
        this.aKZ = new HashMap();
    }

    @Override
    public void startDocument() throws ReportException {
        b.uz();
        super.startDocument();
    }

    @Override
    @Nonnull
    public Layout getLayout() {
        return this.aKQ;
    }

    @Override
    public void startPage() throws ReportException {
        super.startPage();
        if (!this.aKU) {
            this.aKW.setLength(0);
            ++this.aKX;
            this.aKY = 0;
            this.aKQ.refresh();
            this.aKQ.startPage();
            if (this.aKT || this.aKS) {
                this.aKU = true;
            }
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
        HtmlDocumentWriter.L(null, ".........endPage..........");
        if (this.aKU) {
            this.aKQ.Cj();
            this.aKQ.BY();
            this.aKQ.Cc();
        } else {
            this.BN();
        }
        this.aKQ.bM(false);
    }

    void BN() {
        Object object;
        this.aKQ.BY();
        this.aKQ.Cc();
        this.aKV.writeASCII("<!DOCTYPE html>");
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("<html>");
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("<head>");
        HtmlDocumentWriter.K(this.aKV);
        this.BS();
        this.aKV.writeASCII("<style type=\"text/css\">");
        HtmlDocumentWriter.K(this.aKV);
        this.aKQ.P(this.aKV);
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("</style>");
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("<script type=\"text/javascript\">");
        if (this.aKX == 1) {
            object = this.getMetaData();
            HtmlDocumentWriter.K(this.aKV);
            this.aKV.writeASCII("var permissions={allowprint:");
            this.aKV.writeASCII(Boolean.toString(object.isPrintingEnabled()));
            this.aKV.writeASCII(",enabledFormats:");
            String[] stringArray = object.getEnabledFormats();
            try {
                new Json().toJson((Object)stringArray, (OutputStream)this.aKV);
            }
            catch (IOException iOException) {
                BaseUtils.error(iOException.getMessage());
            }
            this.aKV.writeASCII("};");
            HtmlDocumentWriter.K(this.aKV);
        }
        try {
            HtmlDocumentWriter.b("viewer/helper/events.js", this.aKV);
            HtmlDocumentWriter.b("viewer/page.js", this.aKV);
        }
        catch (IOException iOException) {
            BaseUtils.error(iOException.getMessage());
        }
        this.aKV.writeASCII("</script>");
        this.aKV.writeASCII("</head>");
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("<body");
        this.aKV.writeASCII(" class=\"page" + this.aKX + "\">");
        HtmlDocumentWriter.K(this.aKV);
        this.aKQ.am().writeTo(this.aKV);
        this.aKQ.a(this.aKV, false, true);
        this.aKQ.am().reset();
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("</body>");
        HtmlDocumentWriter.K(this.aKV);
        this.aKV.writeASCII("</html>");
        object = this.aKX + ".html";
        HtmlDocumentWriter.a((String)object, this.aKV.toByteArray(), this.aKW);
        this.h(this.aKW, -1);
        this.aKV.reset();
        this.aKQ.Cd();
        this.aKQ.Ck();
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        if (this.aKU) {
            this.BN();
        }
        super.endDocument();
        String string = this.aLa != null ? this.aLa.CY() : "[]";
        string = this.co(string);
        String string2 = this.p(string, this.aKX);
        this.aKW.setLength(0);
        HtmlDocumentWriter.a("0.json", BaseUtils.getBytesUTF8(string2), this.aKW);
        try {
            object = new MemoryStream();
            try {
                object.writeASCII("var groupTreeJson=");
                Json json = new Json();
                StringBuilder stringBuilder = new StringBuilder();
                json.toJson((Object)string2, stringBuilder);
                object.write(BaseUtils.getBytesUTF8(stringBuilder.toString()));
                object.writeASCII(";");
                HtmlDocumentWriter.a("0.js", object.toByteArray(), this.aKW);
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            throw new ReportException("Memory Stream unexpectedly aborted.", -1);
        }
        if (this.aKR && (object = (Object)this.getMetaData().getThumbnailData()) != null) {
            HtmlDocumentWriter.a("thumbnail.png", (byte[])object, this.aKW);
        }
        this.getPages().setGroupTree(this.aKW.toByteArray());
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.bi = width;
        this.Kb = height;
        this.aHs = topMargin;
        this.aHt = leftMargin;
        this.aHu = bottomMargin;
        this.aHv = rightMargin;
    }

    String BO() {
        return String.valueOf(this.aKX);
    }

    public static void K(MemoryStream memoryStream) {
        memoryStream.write(10);
    }

    public int BP() {
        return this.Kb;
    }

    public int BQ() {
        if (this.aKS || this.aKT) {
            return Math.max(this.aKQ.Ch() + this.aHs + this.aHu, this.Kb);
        }
        return this.Kb;
    }

    public int BR() {
        return this.bi;
    }

    @Override
    @Nonnull
    public WriterCapabilities getCapabilities() {
        return this.aJJ;
    }

    private void BS() {
        DocumentMetaData documentMetaData = this.getMetaData();
        this.aKV.writeASCII("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        if (documentMetaData != null) {
            this.K("title", documentMetaData.getTitle());
            this.K("keywords", documentMetaData.getKeyWords());
            this.K("subject", documentMetaData.getSubject());
            this.K("template", documentMetaData.getTemplate());
            this.K("comments", documentMetaData.getComments());
            this.b("createTime", documentMetaData.getPrintTime());
            this.K("generator", "i-net Clear Reports");
        }
    }

    private void K(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        this.aKV.writeASCII("<meta name=\"" + string + "\" content=\"" + string2 + "\" />");
        HtmlDocumentWriter.K(this.aKV);
    }

    private void b(String string, Date date) {
        if (date == null) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String string2 = simpleDateFormat.format(date);
        this.K(string, string2);
    }

    String a(String string, Image image, byte[] byArray) {
        Object object;
        Object object2 = object = string != null ? this.aKZ.get(string) : null;
        if (object == null) {
            if (image == null) {
                return "";
            }
            if (byArray == null) {
                byArray = PNGEncoder.getPNGImageData((Image)image);
            }
            if (byArray != null) {
                String string2 = MimeTypes.getMimeTypeFromData((byte[])byArray);
                String string3 = string2 == "image/svg+xml" || string2 == "text/xml; charset=utf-8" ? ".svg" : ".png";
                object = String.valueOf(this.aKX) + "-" + ++this.aKY + string3;
                HtmlDocumentWriter.a((String)object, byArray, this.aKW);
                if (this.aLb != null) {
                    object = (String)object + this.aLb + (String)object;
                }
                if (string != null) {
                    this.aKZ.put(string, (String)object);
                }
            } else {
                return "";
            }
        }
        return object;
    }

    String a(String string, String string2, byte[] byArray) {
        Object object;
        Object object2 = object = string != null ? this.aKZ.get(string) : null;
        if (object != null) {
            return object;
        }
        if (byArray == null) {
            return "";
        }
        object = String.valueOf(this.aKX) + "-" + ++this.aKY + "." + (string2 != null ? string2 : ".png");
        HtmlDocumentWriter.a((String)object, byArray, this.aKW);
        if (this.aLb != null) {
            object = (String)object + this.aLb + (String)object;
        }
        if (string != null) {
            this.aKZ.put(string, (String)object);
        }
        return object;
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data) {
        HtmlDocumentWriter.a(fileName, data, this.aKW);
    }

    private void h(MemoryStream memoryStream, int n2) {
        if (n2 == -1) {
            this.getPages().addPage(memoryStream.toByteArray());
        } else {
            this.getPages().setPageData(memoryStream.toByteArray(), n2);
        }
    }

    private static void a(String string, byte[] byArray, MemoryStream memoryStream) {
        byte[] byArray2 = BaseUtils.getBytesUTF8(string);
        memoryStream.writeInverseInt(byArray2.length);
        memoryStream.write(byArray2);
        memoryStream.writeInverseInt(byArray.length);
        memoryStream.write(byArray);
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        super.setUserProperties(props);
        if (props == null) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("html export: user properties not defined");
            }
        } else {
            String string = props.getProperty("layout");
            if (string != null) {
                if (string.equals("single")) {
                    this.aKS = true;
                    ((d)this.aJJ).bJ(this.aKS);
                    this.aKQ.Ci();
                } else if (string.equals("concat")) {
                    this.aKT = true;
                    this.aKQ.Ci();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Report name is provided by user and checked before rendering. Also we're just reading the file name")
    private String p(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"grouptreeData\":");
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(',');
        stringBuilder.append(" \"pageCount\":");
        stringBuilder.append('\"');
        stringBuilder.append(String.valueOf(n2));
        stringBuilder.append('\"');
        int n3 = Math.round((float)this.bi / 15.0f);
        int n4 = Math.round((float)this.Kb / 15.0f);
        int n5 = Math.round((float)this.bi / 566.92914f * 10.0f);
        int n6 = Math.round((float)this.Kb / 566.92914f * 10.0f);
        if (this.aKS || this.aKT) {
            n4 = Math.max(Math.round((float)(this.aKQ.Ch() + this.aHs + this.aHu) / 15.0f * 10.0f), n4);
            n6 = Math.max(Math.round((float)(this.aKQ.Ch() + this.aHs + this.aHu) / 566.92914f * 10.0f), n6);
        }
        stringBuilder.append(',');
        stringBuilder.append(" \"page\":{\"width\":\"");
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append('\"');
        stringBuilder.append(',');
        stringBuilder.append(" \"height\":\"");
        stringBuilder.append(String.valueOf(n4));
        stringBuilder.append('\"');
        stringBuilder.append(',');
        stringBuilder.append(" \"print\":{\"width\":\"");
        stringBuilder.append(String.valueOf(n5));
        stringBuilder.append("mm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"height\":\"");
        stringBuilder.append(String.valueOf(n6));
        stringBuilder.append("mm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"margin\":{\"left\":\"");
        stringBuilder.append(String.valueOf((float)this.aHt / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"right\":\"");
        stringBuilder.append(String.valueOf((float)this.aHv / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"bottom\":\"");
        stringBuilder.append(String.valueOf((float)this.aHu / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append(',');
        stringBuilder.append(" \"top\":\"");
        stringBuilder.append(String.valueOf((float)this.aHs / 566.92914f));
        stringBuilder.append("cm\"");
        stringBuilder.append('}');
        stringBuilder.append('}');
        stringBuilder.append('}');
        DocumentMetaData documentMetaData = this.getMetaData();
        this.c(stringBuilder, "title", documentMetaData.getTitle());
        this.c(stringBuilder, "author", documentMetaData.getAuthor());
        this.c(stringBuilder, "subject", documentMetaData.getSubject());
        this.c(stringBuilder, "keywords", documentMetaData.getKeyWords());
        this.c(stringBuilder, "comments", documentMetaData.getComments());
        String string2 = HtmlDocumentWriter.j(this.getProperties());
        if (string2 != null) {
            this.c(stringBuilder, "report", string2 + ".rpt");
        } else if (documentMetaData.getReportURL() != null) {
            this.c(stringBuilder, "report", new File(documentMetaData.getReportURL().getFile()).getName());
        }
        if (documentMetaData.getPrintTime() != null) {
            this.c(stringBuilder, "created", "" + documentMetaData.getPrintTime().getTime());
        }
        String string3 = this.getPages() != null && this.getPages().isPageLimitExceeded() ? "true" : "false";
        stringBuilder.append(',');
        stringBuilder.append("\"isPageLimitExceeded\":\"");
        stringBuilder.append(string3);
        stringBuilder.append('\"');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void c(StringBuilder stringBuilder, String string, String string2) {
        if (StringFunctions.isEmpty((String)string2)) {
            return;
        }
        stringBuilder.append(',');
        stringBuilder.append("\"" + string + "\":");
        new Json().toJson((Object)string2, stringBuilder);
    }

    e BT() {
        if (this.aLa == null) {
            this.aLa = new a();
        }
        return this.aLa;
    }

    int zU() {
        return this.aHt;
    }

    int zT() {
        return this.aHs;
    }

    int zW() {
        return this.aHv;
    }

    int zV() {
        return this.aHu;
    }

    static void b(@Nonnull String string, MemoryStream memoryStream) throws IOException {
        URL uRL = HtmlDocumentWriter.class.getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException("resource: " + string + " not found");
        }
        byte[] byArray = IOFunctions.getFileBuffer((URL)uRL);
        memoryStream.write(byArray);
    }

    private String co(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -6;
        int n3 = 0;
        while ((n2 = string.indexOf(",\"url\":\"", n2 + 6)) != -1) {
            int n4 = n2 + aKP;
            if (n4 >= string.length() || string.charAt(n4) != '\"') continue;
            stringBuilder.append(string.substring(n3, n2));
            n3 = n4 + 1;
        }
        if (n3 != 0) {
            stringBuilder.append(string.substring(n3, string.length()));
            string = stringBuilder.toString();
        }
        return string;
    }

    public static void L(String string, String string2) {
    }

    @Nullable
    public static String j(@Nullable Properties properties) {
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("report");
        if (string != null) {
            int n2 = Math.max(string.lastIndexOf("/"), string.lastIndexOf(92));
            if (n2 != -1 && n2 != string.length() - 1) {
                if ((string = string.substring(n2 + 1)).endsWith(".rpt")) {
                    string = string.substring(0, string.length() - ".rpt".length());
                }
            } else {
                string = null;
            }
        }
        return string;
    }
}

