/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.docx;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.DiskBufferedOutputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.output.DocumentOutput;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.docx.DocxStyledLayout;
import com.inet.report.renderer.docx.a;
import com.inet.report.renderer.docx.b;
import com.inet.report.renderer.docx.c;
import com.inet.report.renderer.docx.e;
import com.inet.report.renderer.docx.models.l;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;

@InternalApi
public class DocxDocumentWriter
extends AbstractDocumentWriter {
    private final c aGK = new c();
    private final FastByteArrayOutputStream aGL = new FastByteArrayOutputStream();
    private final com.inet.report.util.zip.a aGM = new com.inet.report.util.zip.a((OutputStream)this.aGL){

        @Override
        public DiskBufferedOutputStream ch(String string) {
            Runnable runnable = () -> {
                if (DocxDocumentWriter.this.aGL.size() > 100000) {
                    DocumentOutput documentOutput = DocxDocumentWriter.this.getPages();
                    documentOutput.addPage(DocxDocumentWriter.this.aGL.toByteArray());
                    DocxDocumentWriter.this.aGL.reset();
                }
            };
            return super.a(string, runnable);
        }
    };
    private b aGN;
    private e aGO;

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aGO = new e(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
    }

    @Override
    public void startDocument() throws ReportException {
        Date date;
        super.startDocument();
        DocumentMetaData documentMetaData = this.getMetaData();
        if (documentMetaData != null && (date = documentMetaData.getPrintTime()) != null) {
            this.aGM.h(date.getTime());
        }
        try {
            this.aGN.startReport(this.aGO);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void endDocument() throws ReportException {
        l l2;
        super.endDocument();
        String string = null;
        DocumentMetaData documentMetaData = this.getMetaData();
        long l3 = System.currentTimeMillis();
        if (documentMetaData != null) {
            if (documentMetaData.getPrintTime() != null) {
                l3 = documentMetaData.getPrintTime().getTime();
            }
            l2 = new l(documentMetaData.getAuthor(), documentMetaData.getKeyWords(), documentMetaData.getComments(), documentMetaData.getTitle(), documentMetaData.getSubject(), l3);
            string = documentMetaData.getCreator();
        } else {
            l2 = new l("", "", "", "", "", l3);
        }
        if (string == null) {
            string = "";
        }
        try {
            this.aGN.finishReport(l2, string);
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
        DocumentOutput documentOutput = this.getPages();
        documentOutput.addPage(this.aGL.toByteArray());
    }

    @Override
    public void startPage() throws ReportException {
        super.startPage();
        try {
            this.aGN.startPage();
        }
        catch (IOException iOException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(iOException);
        }
    }

    @Override
    public void setUserProperties(Properties props) {
        super.setUserProperties(props);
        this.aGK.setUserProperties(props);
        this.aGN = props != null && Boolean.parseBoolean(props.getProperty("editable")) ? new a(this.aGM) : new DocxStyledLayout(this.aGM);
    }

    @Override
    public Layout getLayout() {
        return this.aGN;
    }

    @Override
    public WriterCapabilities getCapabilities() {
        return this.aGK;
    }
}

