/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.report.Chart2;
import com.inet.report.chart.dataset.AbstractDataset;
import com.inet.report.chart.dataset.ForAllRecordsDataset;
import com.inet.report.chart.dataset.ForEachRecordDataset;
import com.inet.report.chart.dataset.OneGroupDataset;
import com.inet.report.chart.dataset.TwoGroupsDataset;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ContinuousBarPlot;
import com.inet.report.chart.plot.ContinuousStyle;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public class ContinuousBarStyle
extends ContinuousStyle {
    public static final ContinuousBarStyle BAR_NUMBER = new ContinuousBarStyle("ContinuousBarStyle.BAR_NUMBER");
    public static final ContinuousBarStyle BAR_DATE = new ContinuousBarStyle("ContinuousBarStyle.BAR_DATE");
    public static final ContinuousBarStyle BAR_STACKED_NUMBER = new ContinuousBarStyle("ContinuousBarStyle.BAR_STACKED_NUMBER");
    public static final ContinuousBarStyle BAR_STACKED_DATE = new ContinuousBarStyle("ContinuousBarStyle.BAR_STACKED_DATE");

    private ContinuousBarStyle(String name) {
        super(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ContinuousBarStyle)) {
            return false;
        }
        ContinuousBarStyle continuousBarStyle = (ContinuousBarStyle)obj;
        return this.toString().equals(continuousBarStyle.toString());
    }

    @Override
    public AbstractPlot getDefaultPlot() {
        return new ContinuousBarPlot(this);
    }

    @Override
    public List getAllowedDatasets(Chart2 chart) {
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(4);
        arrayList.add(new ForAllRecordsDataset(chart));
        arrayList.add(new ForEachRecordDataset(chart));
        arrayList.add(new OneGroupDataset(chart));
        arrayList.add(new TwoGroupsDataset(chart));
        return arrayList;
    }

    public boolean isSimpleBar() {
        return this.equals(BAR_NUMBER) || this.equals(BAR_DATE);
    }

    public boolean isStackedBar() {
        return this.equals(BAR_STACKED_NUMBER) || this.equals(BAR_STACKED_DATE);
    }

    private Object readResolve() throws ObjectStreamException {
        ContinuousBarStyle continuousBarStyle = null;
        if (this.equals(BAR_DATE)) {
            continuousBarStyle = BAR_DATE;
        } else if (this.equals(BAR_NUMBER)) {
            continuousBarStyle = BAR_NUMBER;
        } else if (this.equals(BAR_STACKED_NUMBER)) {
            continuousBarStyle = BAR_STACKED_NUMBER;
        } else if (this.equals(BAR_STACKED_DATE)) {
            continuousBarStyle = BAR_STACKED_DATE;
        }
        return continuousBarStyle;
    }
}

