/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ActionPool;
import com.inet.viewer.CustomPromptEditor;
import com.inet.viewer.ProgressPool;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ReportViewChangeListener;
import com.inet.viewer.ReportViewer;
import com.inet.viewer.SwingReportView;
import com.inet.viewer.SwingToolBar;
import com.inet.viewer.SwingViewerContext;
import com.inet.viewer.ToolBar;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.l;
import com.inet.viewer.n;
import com.inet.viewer.props.DefaultSetting;
import com.inet.viewer.y;
import java.applet.Applet;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PublicApi
public class SwingReportViewer
extends JPanel
implements ReportViewer {
    private ChangeListener bHU = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane jTabbedPane = (JTabbedPane)evt.getSource();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 == -1) {
                return;
            }
            SwingReportViewer.this.setCurrentReportView((SwingReportView)jTabbedPane.getComponentAt(n2));
            SwingReportViewer.this.repaint();
        }
    };
    private int bHV;
    public static final int VERSION_MAJOR = 23;
    public static final int VERSION_MINOR = 10;
    public static final boolean IS_TECHNICAL_BUILD = false;
    private com.inet.viewer.props.a bHW = new com.inet.viewer.props.b();
    static final Dimension bEj = new Dimension(640, 480);
    private ArrayList bHX = new ArrayList();
    private boolean bHY = true;
    private boolean bHZ = true;
    private boolean bIa;
    private SwingReportView bIb;
    private y bIc;
    private ActionPool bId;
    private ArrayList bIe = new ArrayList();
    private SwingToolBar bIf;
    private Map bIg = new HashMap();
    private ProgressPool bIh = new ProgressPool();
    private PropertyChangeSupport bBf = new PropertyChangeSupport(this);
    private String bIi;
    private ViewerContext bxy;
    public static final int PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR = 0;
    public static final int PRINTER_USE_REPORT_FORMAT = 1;
    private Throwable bIj;
    private final HashMap bFz = new HashMap();
    private Boolean bIk = null;

    public SwingReportViewer() {
        this((ViewerContext)null);
    }

    public SwingReportViewer(ViewerContext context) {
        this.bId = new ActionPool(this);
        this.bIf = new SwingToolBar(this);
        if (context == null) {
            context = new SwingViewerContext(this);
        }
        this.setViewerContext(context);
        SwingUtilities.invokeLater(new Runnable(){
            private final String[] bIm = new String[]{"notfound.gif", "rootnode.gif", "groupnode_magnifier.gif", "groupnodeexp.gif", "groupnode.gif"};
            private int MZ;

            @Override
            public void run() {
                ViewerUtils.getImageIcon(this.bIm[this.MZ++]);
                if (this.MZ < this.bIm.length) {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        ViewerUtils.logClientData(SwingReportViewer.getVersion());
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        if (this.getLayout() instanceof FlowLayout) {
            this.setLayout(new BorderLayout());
        }
        this.add((Component)this.bIf, "North");
        this.setPreferredSize(bEj);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.QH();
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.Rg()));
        this.a(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.QI();
            }
        };
        abstractAction2.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.Rg() | 0x40));
        this.a(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.bIa = !SwingReportViewer.this.bIa;
                for (int i2 = 0; i2 < SwingReportViewer.this.bHX.size(); ++i2) {
                    ((b)SwingReportViewer.this.bHX.get((int)i2)).bIn.QC().dr(SwingReportViewer.this.bIa);
                }
            }
        };
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, ViewerUtils.Rg() | 0x40));
        this.a(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingReportViewer.this.bIc != null && SwingReportViewer.this.bIc.indexOfComponent(SwingReportViewer.this.bIb) > 0) {
                    SwingReportViewer.this.closeReportView(SwingReportViewer.this.bIb);
                }
            }
        };
        abstractAction4.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, ViewerUtils.Rg()));
        this.a(abstractAction4);
        ActionPool actionPool = this.getActionPool();
        this.a(actionPool.getViewerAction(17));
        this.a(actionPool.getViewerAction(16));
        this.a(actionPool.getViewerAction(15));
        this.a(actionPool.getViewerAction(13));
        this.a(actionPool.getViewerAction(14));
        this.a(actionPool.getViewerAction(18));
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AWTPermission("accessClipboard"));
            }
        }
        catch (SecurityException securityException) {
            actionPool.getViewerAction(1).setEnabled(false);
            actionPool.getViewerAction(2).setEnabled(false);
        }
    }

    @Override
    public void setViewerContext(ViewerContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (context instanceof SwingViewerContext) {
            ((SwingViewerContext)context).setViewer(this);
        }
        this.bxy = context;
    }

    @Override
    public ViewerContext getViewerContext() {
        return this.bxy;
    }

    private void a(Action action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        this.getInputMap(2).put(keyStroke, action);
        this.getActionMap().put(action, action);
    }

    @Override
    public void closeAllReportViews() {
        ViewerUtils.debug("closing and disposing of all ReportViews...");
        for (b b2 : this.bHX) {
            b2.bIn.unregister();
        }
        this.bHX.clear();
        this.setCurrentReportView(null);
        this.removeAll();
        this.add((Component)this.bIf, "North");
        this.bIc = new y(this);
        this.add((Component)this.bIc, "Center");
        this.repaint();
    }

    @Override
    public void closeReportView(int index) {
        Component component = ((b)this.bHX.get((int)index)).bIn.getComponent();
        this.closeReportView((SwingReportView)component);
    }

    @Override
    public void closeReportView(ReportView view) {
        if (view == null) {
            throw new IllegalArgumentException();
        }
        if (this.bIc == null) {
            return;
        }
        int n2 = this.bIc.indexOfComponent((SwingReportView)view);
        this.bIc.removeTabAt(n2);
        this.bHX.remove(n2);
        this.setCurrentReportView((SwingReportView)this.bIc.getSelectedComponent());
        ((SwingReportView)view).unregister();
    }

    @Override
    public ToolBar getToolBar() {
        return this.bIf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView addNewReportView(RenderData data, boolean isClosable) {
        if (data == null) {
            throw new IllegalArgumentException("RenderData is null");
        }
        ReportView reportView = this.c(data);
        if (reportView != null) {
            return reportView;
        }
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            ReportView reportView2 = this.createReportView(data);
            this.addReportView(reportView2, isClosable);
            return reportView2;
        }
    }

    @Override
    public void addReportView(ReportView repView, boolean isClosable) {
        if (repView == null) {
            throw new IllegalArgumentException();
        }
        RenderData renderData = repView.getReportData();
        this.a(repView, renderData, isClosable);
    }

    @Override
    public ReportView addNewReportView(RenderData data) {
        boolean bl2 = this.bHX.size() > 0;
        return this.addNewReportView(data, bl2);
    }

    public ReportView createReportView(RenderData data) {
        SwingReportView swingReportView = new SwingReportView(this, this.bHW, this.getViewerContext());
        swingReportView.init(data);
        return swingReportView;
    }

    @Override
    public void addReportView(ReportView repView) {
        boolean bl2 = this.bHX.size() > 0;
        this.addReportView(repView, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ReportView reportView, RenderData renderData, boolean bl2) {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            boolean bl3;
            this.setPreferredSize(null);
            this.requestFocusInWindow();
            if (this.c(renderData) != null) {
                return;
            }
            this.bHX.add(new b((SwingReportView)reportView, renderData.getReportLocation(), renderData.getProperties()));
            this.setCurrentReportView(reportView);
            boolean bl4 = bl3 = this.bIc == null;
            if (bl3) {
                this.bIc = new y(this);
                this.add((Component)this.bIc, "Center");
                this.bIc.addChangeListener(this.bHU);
            }
            String string = SwingReportViewer.ef(renderData.getReportTitle());
            this.bIc.a(string, reportView.getComponent(), bl2);
            this.bIc.setSelectedComponent(reportView.getComponent());
            PropertyChangeListener[] propertyChangeListenerArray = this.bBf.getPropertyChangeListeners();
            for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
                reportView.getStatusBar().addStateChangeListener(propertyChangeListenerArray[i2]);
            }
        }
    }

    private ReportView c(RenderData renderData) {
        Iterator iterator = this.bHX.iterator();
        if (this.bIc != null) {
            while (iterator.hasNext()) {
                b b2 = (b)iterator.next();
                if (!b2.My.equals(renderData.getReportLocation()) || !"adhoc".equals(b2.My) && !b2.JO.equals(renderData.getProperties())) continue;
                this.bIc.setSelectedComponent(b2.bIn.getComponent());
                return b2.bIn;
            }
        }
        return null;
    }

    private static String ef(String string) {
        if (string != null && string.length() > 20) {
            String string2 = string.substring(0, 17) + "...";
            return string2;
        }
        return string;
    }

    @Override
    public void removeNotify() {
        if (this.bIc != null) {
            this.bIc.removeChangeListener(this.bHU);
        }
        for (b b2 : this.bHX) {
            b2.bIn.unregister();
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object2;
        if (this.bIc != null) {
            this.bIc.addChangeListener(this.bHU);
        }
        if (this.getRootPane() == null) {
            throw new ViewerException("The top window must be a Swing component - you cannot add the Viewer to a Frame or Dialog, use a JFrame or JDialog instead.");
        }
        for (Object object2 : this.bHX) {
            ((b)object2).bIn.NL();
        }
        object2 = SwingReportViewer.a(this);
        if (object2 instanceof Applet && ((Applet)object2).getAppletContext() != null) {
            this.setViewerContext(new com.inet.viewer.b(this.getViewerContext(), (Applet)object2));
        } else if (this.getViewerContext() == null) {
            this.setViewerContext(new SwingViewerContext(this));
        }
        super.addNotify();
    }

    private static Component a(Component component) {
        Container container = component.getParent();
        if (!(container == null || container instanceof Applet && ((Applet)container).getAppletContext() != null)) {
            return SwingReportViewer.a(container);
        }
        return container;
    }

    void b(n n2, RenderData renderData) {
        RenderData renderData2;
        if (n2 != null && (renderData2 = l.a(n2, renderData)) != null) {
            this.addNewReportView(renderData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView getCurrentReportView() {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            return this.bIb;
        }
    }

    @Override
    public void setCurrentReportView(ReportView rv) {
        int n2;
        if (rv != null && this.bIc != null && (n2 = this.bIc.indexOfComponent(rv.getComponent())) != -1 && n2 != this.bIc.getSelectedIndex()) {
            this.bIc.removeChangeListener(this.bHU);
            this.bIc.setSelectedComponent(rv.getComponent());
            this.bIc.addChangeListener(this.bHU);
            this.repaint();
        }
        this.bIb = (SwingReportView)rv;
        this.QG();
    }

    @Override
    public void setHasGroupTree(boolean hasGroupTree) {
        this.a(hasGroupTree ? Boolean.TRUE : Boolean.FALSE);
        this.dp(hasGroupTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dp(boolean bl2) {
        this.bHY = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bHX.size(); ++i2) {
                ((b)this.bHX.get((int)i2)).bIn.setHasGroupTree(bl2);
            }
        }
    }

    @Override
    public boolean hasGroupTree() {
        return this.bHY;
    }

    @Override
    public void setHasStatusBar(boolean hasStatusBar) {
        this.dq(hasStatusBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dq(boolean bl2) {
        this.bHZ = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bHX.size(); ++i2) {
                ((b)this.bHX.get((int)i2)).bIn.dm(bl2);
            }
        }
    }

    @Override
    public boolean hasStatusBar() {
        return this.bHZ;
    }

    boolean QF() {
        return this.bIa;
    }

    public static int getMajorVersion() {
        return 23;
    }

    public static int getMinorVersion() {
        return 10;
    }

    public static String getVersionSuffix() {
        String string = "";
        return string;
    }

    public static String getVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(23);
        stringBuffer.append(".");
        stringBuffer.append(10);
        stringBuffer.append(".");
        stringBuffer.append("930");
        stringBuffer.append(SwingReportViewer.getVersionSuffix());
        return stringBuffer.toString();
    }

    public ActionPool getActionPool() {
        return this.bId;
    }

    void d(Throwable throwable) {
        this.bIj = throwable;
    }

    public Throwable getLastError() {
        return this.bIj;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void QG() {
        for (int i2 = 0; i2 < this.bIe.size(); ++i2) {
            ((ReportViewChangeListener)this.bIe.get(i2)).reportViewChanged(this.bIb);
        }
    }

    @Override
    public void addReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bIe.add(rvcl);
    }

    @Override
    public void removeReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bIe.remove(rvcl);
    }

    public static PrintStream getLoggingStream() {
        return ViewerUtils.getLogStream();
    }

    public static void setLoggingStream(PrintStream stream) {
        ViewerUtils.setLogStream(stream);
    }

    void a(SwingReportView swingReportView, String string) {
        int n2;
        if (this.bIc != null && (n2 = this.bIc.indexOfComponent(swingReportView)) != -1) {
            String string2 = SwingReportViewer.ef(string);
            this.bIc.setTitleAt(n2, string2);
            if (!string.equals(string2)) {
                this.bIc.setToolTipTextAt(n2, string);
            }
            this.bIc.revalidate();
        }
    }

    @Override
    public ReportView getReportView(int i2) {
        return ((b)this.bHX.get((int)i2)).bIn;
    }

    @Override
    public int getReportViewCount() {
        return this.bHX.size();
    }

    @Override
    public void addStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bBf.addPropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().addStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public void removeStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bBf.removePropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().removeStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public ProgressPool getProgressPool() {
        return this.bIh;
    }

    public String getDefaultExportDirectory() {
        return this.QJ();
    }

    public void setDefaultExportDirectory(String directory) {
        this.eg(directory);
    }

    private void QH() {
        if (this.bIc != null) {
            int n2 = this.bIc.indexOfComponent(this.bIb);
            SwingReportView swingReportView = (SwingReportView)this.bIc.getComponentAt((n2 + 1) % this.bIc.getTabCount());
            this.bIc.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    private void QI() {
        if (this.bIc != null) {
            int n2 = this.bIc.indexOfComponent(this.bIb);
            if (n2 == 0) {
                n2 = this.bIc.getTabCount();
            }
            SwingReportView swingReportView = (SwingReportView)this.bIc.getComponentAt((n2 - 1) % this.bIc.getTabCount());
            this.bIc.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    void showError(Throwable th, Object source) {
        this.d(th);
        this.getViewerContext().showError(th, source);
    }

    @Override
    public void setCustomPromptEditor(String promptName, int valueType, CustomPromptEditor editor) {
        promptName = promptName.toLowerCase();
        if (editor == null) {
            this.bIg.remove(new a(promptName, valueType));
        } else {
            this.bIg.put(new a(promptName, valueType), editor);
        }
    }

    CustomPromptEditor z(String string, int n2) {
        CustomPromptEditor customPromptEditor = (CustomPromptEditor)this.bIg.get(new a(string.toLowerCase(), n2));
        if (customPromptEditor != null) {
            return customPromptEditor;
        }
        return (CustomPromptEditor)this.bIg.get(new a(string.toLowerCase(), -1));
    }

    void eg(String string) {
        this.bIi = string;
    }

    String QJ() {
        return this.bIi;
    }

    HashMap QK() {
        return this.bFz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void c(PromptData[] promptDataArray) {
        HashMap hashMap = this.bFz;
        synchronized (hashMap) {
            for (int i2 = 0; i2 < promptDataArray.length; ++i2) {
                String string = promptDataArray[i2].getName();
                if (string == null) continue;
                this.bFz.put(string.toLowerCase(), promptDataArray[i2].getPromptValueObject());
            }
        }
    }

    public void setPrinterDefaultFormatHandling(int printerDefaultFormatHandling) {
        if (printerDefaultFormatHandling != 0 && printerDefaultFormatHandling != 1) {
            throw new IllegalArgumentException("parameter must be either PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR or PRINTER_USE_REPORT_FORMAT!");
        }
        this.bHV = printerDefaultFormatHandling;
    }

    public int getPrinterDefaultFormatHandling() {
        return this.bHV;
    }

    void a(Boolean bl2) {
        this.bIk = bl2;
    }

    Boolean QL() {
        return this.bIk;
    }

    public DefaultSetting getDefaultSetting(DefaultSetting.a key) {
        return this.bHW.a(key);
    }

    public void setDefaultSetting(DefaultSetting.a key, DefaultSetting value) {
        this.bHW.a(key, value);
    }

    private static class b {
        private SwingReportView bIn;
        private String My;
        private Properties JO;

        private b(SwingReportView swingReportView, String string, Properties properties) {
            this.bIn = swingReportView;
            this.My = string;
            this.JO = properties;
        }

        public boolean equals(Object obj) {
            return this.bIn.equals(obj) || super.equals(obj);
        }
    }

    private static class a {
        private final String aVE;
        private final int brE;

        private a(String string, int n2) {
            this.aVE = string;
            this.brE = n2;
        }

        public boolean equals(Object obj) {
            return obj instanceof a && ((a)obj).brE == this.brE && (((a)obj).aVE == null && this.aVE == null || ((a)obj).aVE.equals(this.aVE));
        }

        public int hashCode() {
            return this.aVE.hashCode() + this.brE * 17;
        }
    }
}

