/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula;

import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.formula.IFormulaData;
import com.inet.report.formula.j;
import com.inet.report.formula.m;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;

public class FormulaException
extends ReportException {
    private m aiw;
    private String aix;
    private int aiy;

    protected FormulaException(String msg, int messageId) {
        super(msg, messageId);
    }

    public FormulaException(String msg, int messageId, m position) {
        super(msg, messageId);
        this.aiw = position;
    }

    public FormulaException(ReportException e2, m position) {
        super(e2.getMessage(), e2.getErrorCode());
        super.initCause(e2);
        this.aiw = position;
    }

    public static FormulaException create(ReportErrorCode idAsString, m position, Object ... msgParameter) {
        String string = idAsString.name();
        int n2 = idAsString.getErrorCodeNumber();
        string = Msg.getMsg(string, msgParameter);
        FormulaException formulaException = new FormulaException(string, n2);
        formulaException.aiw = position;
        return formulaException;
    }

    public int getRow() {
        if (this.aiw != null) {
            return this.aiw.getLine();
        }
        return -1;
    }

    public int getColumn() {
        if (this.aiw != null) {
            return this.aiw.getColumn();
        }
        return -1;
    }

    public int getEndRow() {
        if (this.aiw != null) {
            return this.aiw.qV();
        }
        return -1;
    }

    public int getEndColumn() {
        if (this.aiw != null) {
            return this.aiw.getEndColumn();
        }
        return -1;
    }

    public int getStartIndex() {
        if (this.aiw != null) {
            return this.aiw.getStartIndex();
        }
        return -1;
    }

    public int getLength() {
        if (this.aiw != null) {
            return this.aiw.getLength();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (this.aix != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Msg.getMsg(this.aiy == 0 ? "InFormula" : "InFunction", super.getMessage(), this.aix));
            if (this.aiw != null) {
                stringBuilder.append(", ");
                stringBuilder.append(Msg.getMsg("FormulaError.Position", this.aiw.getLine() + 1, this.aiw.getColumn() + 1));
            }
            return stringBuilder.toString();
        }
        return super.getMessage();
    }

    public void setFormulaField(j formula) {
        if (formula != null) {
            this.setFormulaField(formula.pW());
        }
    }

    public void setFormulaField(IFormulaData formulaField) {
        if (formulaField != null && formulaField.getName() != null) {
            this.aix = formulaField.getName();
            this.aiy = formulaField instanceof FormulaField ? 0 : 1;
        }
    }

    public void setFormulaName(String name) {
        if (this.aix == null) {
            this.aix = name;
        }
    }

    public void setPosition(m position) {
        this.qL();
        this.aiw = position;
    }

    public m getPosition() {
        return this.aiw;
    }

    protected void qL() {
    }

    public String getCausingFormulaName() {
        return this.aix;
    }
}

