/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.annotations.InternalApi;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.bi;
import com.inet.report.encode.BMPDecoder;
import com.inet.report.encode.ErrDecoder;
import com.inet.report.encode.OLEDecoder;
import com.inet.report.encode.RawDecoder;
import com.inet.report.encode.WMFDecoder;
import com.inet.report.encode.a;
import com.inet.report.encode.c;
import com.inet.report.encode.f;
import com.inet.report.encode.html.HTMLDecoder;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.util.e;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@InternalApi
public class DecoderFactory {
    private static List<DecoderFactory> aeG;
    public static final MagicCondition OR;
    private List<MagicCondition[]> aeH;
    private Class<? extends a> aeI;
    private String[] aeJ;
    private DataType aeK;

    public DecoderFactory(Class<? extends a> clazz, DataType type, String suffix, MagicCondition ... magicConditions) {
        int n2;
        this.aeI = clazz;
        this.aeK = type;
        this.aeH = new ArrayList<MagicCondition[]>();
        for (n2 = 0; n2 < magicConditions.length; ++n2) {
            int n3;
            for (n3 = n2 + 1; n3 < magicConditions.length && magicConditions[n3] != OR; ++n3) {
            }
            this.aeH.add(Arrays.copyOfRange(magicConditions, n2, n3));
            n2 = n3;
        }
        if (suffix.isEmpty()) {
            this.aeJ = new String[0];
        } else {
            this.aeJ = suffix.split("\\|");
            for (n2 = 0; n2 < this.aeJ.length; ++n2) {
                this.aeJ[n2] = "." + this.aeJ[n2];
            }
        }
    }

    public boolean match(byte[] buffer, int offset, int length) {
        for (MagicCondition[] magicConditionArray : this.aeH) {
            boolean bl2 = true;
            for (MagicCondition magicCondition : magicConditionArray) {
                if (magicCondition.match(buffer, offset, length)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public a create() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.aeI.newInstance();
    }

    public String[] getSuffixes() {
        return this.aeJ;
    }

    public DataType getType() {
        return this.aeK;
    }

    public static c getDecoder(Object obj) throws ReportException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return DecoderFactory.getDecoder((byte[])obj, 0, ((byte[])obj).length);
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return DecoderFactory.getDecoder(byArray, 0, byArray.length);
            }
            catch (SQLException sQLException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(sQLException.getMessage());
                }
                return new ErrDecoder(sQLException.getMessage());
            }
        }
        if (obj instanceof String) {
            return new ErrDecoder((String)obj);
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.UnknownBlobType, obj.getClass().getName());
    }

    public static c getDecoder(byte[] puf, int idx, int length) {
        if (length == 0) {
            return null;
        }
        byte[] byArray = new byte[length];
        System.arraycopy(puf, idx, byArray, 0, length);
        try {
            if (aeG == null) {
                aeG = ServerPluginManager.getInstance().get(DecoderFactory.class);
            }
            for (DecoderFactory decoderFactory : aeG) {
                if (!decoderFactory.match(byArray, 0, length)) continue;
                a a2 = decoderFactory.create();
                a2.setBuffer(byArray, 0, length);
                return a2;
            }
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
            return new ErrDecoder(byArray, 0, length, exception.toString());
        }
        return new ErrDecoder(byArray, 0, length, ReportErrorCode.UnknownImage);
    }

    public static BufferedImage getErrorImage(String errorMsg, int width, int height) {
        String string;
        errorMsg = String.valueOf(errorMsg);
        BufferedImage bufferedImage = e.bI(width, height);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        errorMsg = bi.a(errorMsg, fontMetrics, width);
        graphics2D.setColor(Color.lightGray);
        graphics2D.drawRect(0, 0, width - 1, height - 1);
        graphics2D.drawLine(0, 0, width, height);
        graphics2D.drawLine(width, 0, 0, height);
        graphics2D.setColor(Color.red);
        int n2 = fontMetrics.getAscent();
        int n3 = 0;
        int n4 = errorMsg.indexOf(10, n3);
        while (n4 >= 0) {
            string = errorMsg.substring(n3, n4);
            graphics2D.drawString(string, 1, n2);
            n2 += fontMetrics.getHeight();
            n3 = n4 + 1;
            n4 = errorMsg.indexOf(10, n3);
        }
        string = errorMsg.substring(n3);
        graphics2D.drawString(string, 1, n2);
        return bufferedImage;
    }

    public static List<String> getSupportedSuffixes(DataType type) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DecoderFactory decoderFactory : ServerPluginManager.getInstance().get(DecoderFactory.class)) {
            if (decoderFactory.getType() != type) continue;
            for (String string : decoderFactory.getSuffixes()) {
                arrayList.add(string);
            }
        }
        arrayList.sort(null);
        return arrayList;
    }

    private static byte[] be(String string) {
        int n2 = string.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '%' && i2 + 2 < n2) {
                byteArrayOutputStream.write(Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16));
                i2 += 2;
                continue;
            }
            byteArrayOutputStream.write(c2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void registerDefaultDecoders(ServerPluginManager spm) {
        spm.register(DecoderFactory.class, (Object)new DecoderFactory(BMPDecoder.class, DataType.IMAGE, "bmp", new MagicCondition("BM")));
        spm.register(DecoderFactory.class, (Object)new f());
        spm.register(DecoderFactory.class, (Object)new DecoderFactory(OLEDecoder.class, DataType.IMAGE, "", new MagicCondition("%15%1C")));
        spm.register(DecoderFactory.class, (Object)new DecoderFactory(WMFDecoder.class, DataType.IMAGE, "wmf", new MagicCondition("%D7%CD")));
        spm.register(DecoderFactory.class, (Object)new DecoderFactory(RawDecoder.class, DataType.IMAGE, "", new MagicCondition("ra")));
        spm.register(DecoderFactory.class, (Object)new DecoderFactory(HTMLDecoder.class, DataType.DOCUMENT, "htm|html", new MagicCondition("<"), new MagicCondition(0, 1024, "<html"), OR, new MagicCondition("%0d<"), new MagicCondition(0, 1024, "<html"), OR, new MagicCondition("%0d%0a<"), new MagicCondition(0, 1024, "<html"), OR, new MagicCondition("%ef%bb%bf"), new MagicCondition(0, 1024, "<html"), OR, new MagicCondition("%fe%ff"), new MagicCondition(0, 1024, new byte[]{0, 60, 0, 104, 0, 116, 0, 109, 0, 108}), OR, new MagicCondition("%ff%fe"), new MagicCondition(0, 1024, new byte[]{60, 0, 104, 0, 116, 0, 109, 0, 108, 0})));
    }

    static {
        OR = null;
    }

    @InternalApi
    public static enum DataType {
        IMAGE,
        DOCUMENT;

    }

    @InternalApi
    public static class MagicCondition {
        private int aeM;
        private int aeN;
        private byte[] aeO;

        public MagicCondition(int positionFirst, int positionLast, byte[] bytes) {
            this.aeM = positionFirst;
            this.aeN = positionLast;
            this.aeO = bytes;
        }

        public MagicCondition(String byteString) {
            this(0, 0, byteString);
        }

        public MagicCondition(int positionFirst, int positionLast, String string) {
            this(positionFirst, positionLast, DecoderFactory.be(string));
        }

        public boolean match(byte[] buffer, int offset, int length) {
            int n2 = Math.min(this.aeN + 1, length - offset - this.aeO.length);
            block0: for (int i2 = this.aeM; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < this.aeO.length; ++i3) {
                    byte by2 = buffer[this.aeM + i3 + i2 + offset];
                    byte by3 = this.aeO[i3];
                    if ((by2 = (byte)(by2 | 0x20)) != (by3 = (byte)(by3 | 0x20))) continue block0;
                }
                return true;
            }
            return false;
        }
    }
}

