/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DateRange
implements Serializable {
    private Date Xq;
    private Date Xr;
    private FormulaField Xs;
    private FormulaField Xt;
    private boolean vz;

    public DateRange() {
        this.vz = true;
    }

    public DateRange(Date lower, Date upper) {
        if (lower == null) {
            throw i.d("lower");
        }
        if (upper == null) {
            throw i.d("upper");
        }
        if (lower.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' before 'lower'.");
        }
        this.vz = false;
        this.Xq = (Date)lower.clone();
        this.Xr = (Date)upper.clone();
    }

    public boolean isAutoRange() {
        return this.vz;
    }

    public void setAutoRange(boolean autoRange) {
        this.vz = autoRange;
    }

    public Date getLowerBound() {
        if (this.Xq != null) {
            return (Date)this.Xq.clone();
        }
        return null;
    }

    public void setLowerBound(Date lower) {
        if (this.Xr != null && this.Xr.before(lower)) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.Xq = lower != null ? (Date)lower.clone() : null;
    }

    public FormulaField getLowerBoundFormula() {
        return this.Xs;
    }

    public void setLowerBoundFormula(FormulaField lowerBoundFormula) {
        this.Xs = lowerBoundFormula;
    }

    public Date getUpperBound() {
        if (this.Xr != null) {
            return (Date)this.Xr.clone();
        }
        return null;
    }

    public void setUpperBound(Date upper) {
        if (this.Xq != null && this.Xq.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.Xr = upper != null ? (Date)upper.clone() : null;
    }

    public FormulaField getUpperBoundFormula() {
        return this.Xt;
    }

    public void setUpperBoundFormula(FormulaField upperBoundFormula) {
        this.Xt = upperBoundFormula;
    }

    boolean mS() {
        return !(this.getUpperBound() == null && this.getUpperBoundFormula() == null || this.getLowerBound() == null && this.getLowerBoundFormula() == null);
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange() && this.mS()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeDate");
            buffer.append(' ');
            if (this.Xq != null) {
                f.b(buffer, "lowerBound", Long.toString(this.Xq.getTime()));
            }
            if (this.Xr != null) {
                f.b(buffer, "upperBound", Long.toString(this.Xr.getTime()));
            }
            buffer.append(">\n");
            if (this.Xs != null) {
                j.a(buffer, depth, this.Xs, "chartAxisMinDateFormula");
            }
            if (this.Xt != null) {
                j.a(buffer, depth, this.Xt, "chartAxisMaxDateFormula");
            }
            buffer.append("<");
            buffer.append("/");
            buffer.append("RangeDate");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element, Chart2 chart) {
        NodeList nodeList;
        FormulaField formulaField;
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            long l2 = Long.valueOf(string);
            this.setLowerBound(new Date(l2));
        }
        if ((formulaField = j.a(nodeList = element.getChildNodes(), chart, "chartAxisMinDateFormula")) != null) {
            this.setLowerBoundFormula(formulaField);
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            long l3 = Long.valueOf(string);
            this.setUpperBound(new Date(l3));
        }
        if ((formulaField = j.a(nodeList, chart, "chartAxisMaxDateFormula")) != null) {
            this.setUpperBoundFormula(formulaField);
        }
    }
}

