/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.IntervalMarker;
import com.inet.report.chart.axis.LineMarker;
import com.inet.report.chart.axis.c;
import com.inet.report.chart.f;
import com.inet.report.i;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public abstract class AbstractMarker
implements Serializable {
    public static final int DEFAULT_COLOR = 255;
    public static final int DEFAULT_LINE_STYLE = 1;
    public static final int DEFAULT_LINE_WIDTH = 20;
    public static final float DEFAULT_ALPHA = 1.0f;
    public static final double DEFAULT_VALUE = 0.0;
    private int color = 255;
    private int cm = 1;
    private int mJ = 20;

    protected AbstractMarker() {
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int markerColor) {
        if (markerColor == -1) {
            throw i.e("markerColor");
        }
        this.color = markerColor;
    }

    public int getLineStyle() {
        return this.cm;
    }

    public void setLineStyle(int lineStyle) {
        i.D(lineStyle);
        this.cm = lineStyle;
    }

    public int getLineWidth() {
        return this.mJ;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 1) {
            throw new IllegalArgumentException("The parameter 'lineWidth' should be greater zero.");
        }
        this.mJ = lineWidth;
    }

    void saveProperties(PrintWriter out, int depth) {
        String string = BaseUtils.getIndent(depth);
        StringBuilder stringBuilder = this.cB(++depth);
        String string2 = null;
        if (this instanceof LineMarker) {
            string2 = "LineMarker";
        } else if (this instanceof IntervalMarker) {
            string2 = "IntervalMarker";
        } else {
            return;
        }
        f.a(out, string, string2, null, false);
        if (stringBuilder.length() > 0) {
            out.print(stringBuilder.toString());
        }
        f.a(out, string, string2, null, true);
    }

    protected StringBuilder cB(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getColor() != 255 || this.getLineStyle() != 1 || this.getLineWidth() != 20) {
            f.a(stringBuilder, null, n2, this.getColor(), this.getLineStyle(), this.getLineWidth());
        }
        return stringBuilder;
    }

    public void readProperties(Element element, Chart2 chart) {
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            int n2;
            Element element2;
            if (!(nodeList.item(i2) instanceof Element) || !(element2 = (Element)nodeList.item(i2)).getNodeName().equals("Outline")) continue;
            String string = element2.getAttribute("color");
            if (string.length() > 0 && (n2 = Integer.parseInt(string)) != -1) {
                this.setColor(n2);
            }
            if ((string = element2.getAttribute("style")).length() > 0) {
                n2 = Integer.parseInt(string);
                if (n2 == 0 || n2 == 3 || n2 == 4 || n2 == 1) {
                    this.setLineStyle(n2);
                } else {
                    this.setLineStyle(1);
                }
            }
            if ((string = element2.getAttribute("width")).length() <= 0) continue;
            n2 = Integer.parseInt(string);
            if (n2 < 1) {
                this.setLineWidth(20);
                continue;
            }
            this.setLineWidth(n2);
        }
    }

    public static List<FormulaField> getMarkerReferencesIfExist(c ... axis) {
        ArrayList<FormulaField> arrayList = new ArrayList<FormulaField>();
        if (axis != null) {
            for (c c2 : axis) {
                if (c2 == null) continue;
                for (int i2 = 0; i2 < c2.getMarkersCount(); ++i2) {
                    AbstractMarker abstractMarker;
                    AbstractMarker abstractMarker2 = c2.getMarker(i2);
                    if (abstractMarker2 instanceof LineMarker) {
                        abstractMarker = (LineMarker)abstractMarker2;
                        if (((LineMarker)abstractMarker).getValueFormula() == null) continue;
                        arrayList.add(((LineMarker)abstractMarker).getValueFormula());
                        continue;
                    }
                    if (!(abstractMarker2 instanceof IntervalMarker)) continue;
                    abstractMarker = (IntervalMarker)abstractMarker2;
                    if (((IntervalMarker)abstractMarker).getFirstValueFormula() != null) {
                        arrayList.add(((IntervalMarker)abstractMarker).getFirstValueFormula());
                    }
                    if (((IntervalMarker)abstractMarker).getSecondValueFormula() == null) continue;
                    arrayList.add(((IntervalMarker)abstractMarker).getSecondValueFormula());
                }
            }
        }
        return arrayList;
    }
}

