/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.IntList;
import com.inet.lib.list.StringList;
import com.inet.logging.LogManager;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Join;
import com.inet.report.MissedColumnException;
import com.inet.report.ParameterList;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Section;
import com.inet.report.bo;
import com.inet.report.cb;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.JdbcData;
import com.inet.report.database.a;
import com.inet.report.database.sql.PromptPlaceholderReplacer;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public class TableSource
implements ReferenceHolder,
NodeParser,
Serializable {
    private String PE;
    private String PF;
    private com.inet.report.list.a PG = new com.inet.report.list.a();
    private String PH;
    private boolean PJ = true;
    private Datasource qV;
    private ParameterList PK;
    private String[] PL;
    public static final int TYPE_TABLE_OR_VIEW = 1;
    public static final int TYPE_PROCEDURE = 2;
    public static final int TYPE_COMMAND = 3;
    public static final String TYPE_NAME_TABLE = "TABLE";
    public static final String TYPE_NAME_VIEW = "VIEW";
    public static final String TYPE_NAME_SYSTEM_TABLE = "SYSTEM TABLE";
    private int type = 0;
    Engine lC;
    private static Set<String> PM = new HashSet<String>();
    private r qk = new r(this);

    TableSource(Engine engine, Datasource ds) {
        this.lC = engine;
        this.qV = ds;
    }

    TableSource(String databaseIdentifier, String aliasName, Engine engine, Datasource ds) throws ReportException {
        this(engine, ds);
        this.au(aliasName);
        this.setDatabaseIdentifierName(databaseIdentifier);
    }

    public int getType() throws ReportException {
        if (this.type == 0) {
            this.kt();
        }
        return this.type;
    }

    private void kt() throws ReportException {
        block10: {
            if (this.PH != null) {
                this.type = 3;
                return;
            }
            this.PK = new ParameterList();
            try {
                DataFactory dataFactory = this.qV.l(false);
                if (dataFactory instanceof Database) {
                    try (Connection connection = this.qV.getConnection();){
                        this.type = ((Database)dataFactory).scanSourceType(this, this.PK, true) ? 2 : 1;
                        break block10;
                    }
                }
                this.type = 1;
            }
            catch (SQLException sQLException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
            }
        }
    }

    ParameterList ku() {
        if (this.PK == null) {
            try {
                this.kt();
            }
            catch (Exception exception) {
                BaseUtils.error("Check type of TableSource is failed");
                BaseUtils.error(exception);
            }
        }
        return this.PK;
    }

    private void updateReferences() {
        if (this.type == 3) {
            this.resetReferences();
            if (this.PH != null && this.PH.length() > 0) {
                this.setReferences();
            }
        }
    }

    @Nonnull
    public ResultSet getResultSet() throws ReportException, SQLException {
        DataFactory dataFactory = this.qV.getDataFactory();
        if (!DatabaseUtils.useJdbcDriver(dataFactory)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.useJDBCIsFalse, dataFactory.getClass().getName());
        }
        try (Connection connection = this.qV.getConnection();){
            Statement statement;
            Database database = (Database)dataFactory;
            switch (this.getType()) {
                case 3: {
                    this.updateReferences();
                    PromptPlaceholderReplacer promptPlaceholderReplacer = new PromptPlaceholderReplacer(database.getSqlSyntax()).setQuoteStringPrompts(this.PJ);
                    String string = promptPlaceholderReplacer.replace(this.PH, this.lC.bB.getFields());
                    this.lC.bB.BE = connection.createStatement();
                    bo.a(this.lC.bB, this.lC.bB.BE);
                    ResultSet resultSet = DatabaseUtils.executeQuery(this.lC.bB.BE, string, null);
                    return resultSet;
                }
                case 2: {
                    PromptField[] promptFieldArray = this.lC.bB.iV();
                    ResultSet resultSet = new a(database, connection, this).a(this.ku()).b(promptFieldArray).nN();
                    return resultSet;
                }
            }
            String string = this.kv();
            if (BaseUtils.isInfo()) {
                BaseUtils.info(string);
            }
            this.lC.bB.BE = statement = connection.createStatement();
            ResultSet resultSet = DatabaseUtils.executeQuery(statement, string, null);
            return resultSet;
        }
    }

    private String kv() throws SQLException, ReportException {
        Object object;
        String string = this.kx();
        com.inet.report.list.a a2 = this.a(null, null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (a2.size() > 0) {
            object = (Database)this.qV.getDataFactory();
            for (int i2 = 0; i2 < a2.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(',').append(' ');
                }
                stringBuilder.append(((Database)object).convertIdentifier(this.qV, a2.eD(i2).getName()));
            }
        } else {
            stringBuilder.append('1');
        }
        stringBuilder.append(" FROM ").append(string).append(' ');
        object = ((Database)this.qV.getDataFactory()).getConfiguration().getAliasToken();
        if (!((String)object).isEmpty() && !((String)object).equals(" ")) {
            stringBuilder.append((String)object).append(' ');
        }
        stringBuilder.append(this.PE);
        return stringBuilder.toString();
    }

    private String ap(boolean bl2) throws ReportException, SQLException {
        ParameterList parameterList;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 0) {
            this.kt();
        }
        if ((parameterList = this.ku()).hasReturnCursor()) {
            stringBuilder.append("{?=call ");
        } else {
            stringBuilder.append("{call ");
        }
        stringBuilder.append(this.kx());
        int n2 = parameterList.paramCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(i2 == 0 ? (char)'(' : ',');
            stringBuilder.append((String)(bl2 ? "{?" + parameterList.elementAt(i2).eV() + "}" : "?"));
            if (i2 != n2 - 1) continue;
            stringBuilder.append(')');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void checkExistsOnCurrentDatasource() throws ReportException {
        block20: {
            try (Connection connection = this.qV.getConnection();){
                Object object;
                if (this.getType() == 3) {
                    this.refresh();
                    break block20;
                }
                if (this.getType() == 2) {
                    PromptField[] promptFieldArray = this.lC.bB.iV();
                    try (a a2 = new a((JdbcData)this.qV.getDataFactory(), connection, this);){
                        a2.a(this.ku()).b(promptFieldArray).nN();
                        break block20;
                    }
                }
                com.inet.report.list.a a3 = this.a(null, null);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SELECT ");
                Database database = (Database)this.qV.getDataFactory();
                if (a3.size() > 0) {
                    for (int i2 = 0; i2 < a3.size(); ++i2) {
                        if (i2 > 0) {
                            stringBuilder.append(',').append(' ');
                        }
                        object = database.convertIdentifier(this.qV, a3.eD(i2).getName());
                        stringBuilder.append((String)object);
                    }
                } else {
                    stringBuilder.append('1');
                }
                stringBuilder.append(" FROM ").append(this.kx()).append(' ').append(database.getConfiguration().getAliasToken()).append(' ').append(this.PE);
                String string = DatabaseTables.changeWhereToNoRows(stringBuilder.toString());
                this.lC.bB.BE = object = connection.createStatement();
                DatabaseUtils.executeQuery((Statement)object, string, null);
            }
            catch (SQLException sQLException) {
                if (this.getSql() != null) {
                    Object[] objectArray = new Object[]{this.getAlias(), sQLException.getLocalizedMessage()};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.commandDoesNotWorkAnymore, objectArray);
                }
                Object[] objectArray = new Object[]{this.getAlias(), sQLException.getLocalizedMessage()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.reportDoesNotWorkAnymore, objectArray);
            }
        }
    }

    public void addColumn(String columnName, int columnType) throws ReportException {
        if (!cb.bZ(columnType)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnType, new Integer(columnType));
        }
        if (columnName != null) {
            DatabaseField databaseField = this.g(columnName, columnType);
            this.PG.f(databaseField);
            this.lC.bB.iZ().f(databaseField);
            Fields.a(this.lC.bB, databaseField, 0);
        }
    }

    public void addColumn(String columnName, int columnType, String columnLabel) throws ReportException {
        if (!cb.bZ(columnType)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnType, new Integer(columnType));
        }
        if (columnName != null) {
            DatabaseField databaseField = this.g(columnName, columnType);
            this.PG.f(databaseField);
            this.lC.bB.iZ().f(databaseField);
            databaseField.setColumnLabel(columnLabel);
            Fields.a(this.lC.bB, databaseField, 0);
        }
    }

    void a(DatabaseField databaseField) {
        databaseField.kX = this;
        this.PG.f(databaseField);
        this.lC.bB.iZ().f(databaseField);
    }

    void b(DatabaseField databaseField) throws ReportException {
        this.c(databaseField);
        this.lC.bB.iZ().h(databaseField);
        this.PG.h(databaseField);
    }

    private DatabaseField g(String string, int n2) throws ReportException {
        if (!cb.bZ(n2)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnType, new Integer(n2));
        }
        if (string == null || string.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidColumnName, string);
        }
        DatabaseField databaseField = new DatabaseField(this.lC.bB);
        databaseField.name = this.PE + "." + string;
        databaseField.kX = this;
        databaseField.valueType = n2;
        databaseField.kZ = string;
        return databaseField;
    }

    public DatabaseField getDatabaseField(int idx) {
        return this.PG.eD(idx);
    }

    public DatabaseField getDatabaseField(String columnName) {
        int n2 = this.PG.bU(this.PE + "." + columnName);
        if (n2 >= 0) {
            return this.PG.eD(n2);
        }
        return null;
    }

    public DatabaseField[] getDatabaseFields() {
        return this.PG.vy();
    }

    public String getColumnName(int idx) {
        return this.PG.eD(idx).getShortName();
    }

    public String[] getColumnNames() {
        int n2 = this.getColumnCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.getColumnName(i2);
        }
        return stringArray;
    }

    public int[] getColumnTypes() {
        int n2 = this.getColumnCount();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.getColumnType(i2);
        }
        return nArray;
    }

    public int getColumnType(int idx) throws IndexOutOfBoundsException {
        return this.PG.eD(idx).getValueType();
    }

    int at(String string) throws ReportException {
        for (int i2 = 0; i2 < this.PG.size(); ++i2) {
            if (!string.equalsIgnoreCase(this.PG.eD(i2).getShortName())) continue;
            return this.PG.eD(i2).getValueType();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < this.PG.size(); ++i3) {
            if (i3 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.PG.eD(i3).getName());
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.NoColumn, string, stringBuilder);
    }

    public void removeColumn(String columnName) throws ReportException {
        if (this.PG.bU(this.PE + "." + columnName) == -1) {
            return;
        }
        this.canRemoveColumn(columnName);
        Fields fields = this.lC.bB.getFields();
        List<Join> list = this.lC.bB.iY().bV();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2;
            Join join = list.get(i2);
            if (join.getSourceAlias().equals(this.getAlias())) {
                for (n2 = 0; n2 < join.getConditionCount(); ++n2) {
                    if (!join.getConditionSourceColumn(n2).equals(columnName)) continue;
                    join.removeCondition(n2);
                    --n2;
                }
            }
            if (join.getTargetAlias().equals(this.getAlias())) {
                for (n2 = 0; n2 < join.getConditionCount(); ++n2) {
                    if (!join.getConditionTargetColumn(n2).equals(columnName)) continue;
                    join.removeCondition(n2);
                    --n2;
                }
            }
            if (join.getConditionCount() != 0) continue;
            list.remove(i2);
        }
        DatabaseField databaseField = fields.getDatabaseField(this.PE + "." + columnName);
        if (databaseField != null) {
            BaseUtils.info(Msg.getMsg("removing", databaseField.paramString()));
        }
        this.lC.bB.iZ().h(databaseField);
        this.PG.h(databaseField);
        if (databaseField != null) {
            this.lC.bB.getFields().a(databaseField, 1);
        }
    }

    public void canRemoveColumn(String columnName) throws ReportException {
        Fields fields = this.lC.bB.getFields();
        DatabaseField databaseField = fields.getDatabaseField(this.PE + "." + columnName);
        if (databaseField == null) {
            return;
        }
        this.c(databaseField);
    }

    private void c(DatabaseField databaseField) throws ReportException {
        if (databaseField.getReferenceHolderCount() > 0) {
            boolean bl2 = true;
            ReferenceHolder[] referenceHolderArray = databaseField.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (referenceHolderArray[i2] instanceof Join) continue;
                bl2 = false;
                break;
            }
            if (!bl2) {
                Object object = "";
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(databaseField.getName());
                arrayList.add(this.PE);
                int n2 = 2;
                for (int i3 = 0; i3 < databaseField.getReferenceHolderCount(); ++i3) {
                    Object object2 = databaseField.getReferenceHolders()[i3];
                    if (object2 instanceof Field) {
                        object2 = ((Field)object2).getRefName() + " (" + object2.getClass().getSimpleName() + ")";
                    } else if (object2 instanceof FieldElement) {
                        FieldElement fieldElement = (FieldElement)object2;
                        Section section = (Section)fieldElement.getParent();
                        Object object3 = "";
                        if (section != null) {
                            Area area = (Area)section.getParent();
                            object3 = (String)object3 + area.getTypeAsString();
                            if (area.getSectionCount() > 1) {
                                object3 = (String)object3 + "(" + section.getSectionNameByNumber(section.indexOf()) + ")";
                            }
                        }
                        object2 = Msg.getMsg(ReportErrorCode.DBFieldIsUsedFieldPosition.name(), fieldElement.getX() / 15, fieldElement.getY() / 15, object3);
                    } else {
                        object2 = object2.getClass().getSimpleName();
                    }
                    object = (String)object + String.valueOf(object2) + "\n";
                    ++n2;
                }
                arrayList.add((String)object);
                throw ReportExceptionFactory.createReportException(ReportErrorCode.DBFieldIsUsed, arrayList.toArray());
            }
        }
    }

    private boolean a(PromptField promptField) throws ReportException {
        if (promptField == null) {
            return true;
        }
        return !promptField.isUsed() || promptField.f(this);
    }

    void kw() {
        this.PG.clear();
    }

    void au(String string) throws ReportException {
        if (DatabaseUtils.useJdbcDriver(this.qV.l(false))) {
            TableSource.checkAliasValidity(string);
        } else {
            TableSource.aw(string);
        }
        this.PE = string;
    }

    void av(String string) {
        this.PE = string;
    }

    private static String aw(String string) throws ReportException {
        if (string == null || string.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noEmptyAliasAllowed, new Object[0]);
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (i2 == 0) {
                if (Character.isLetter(c2) || c2 == '[') continue;
                throw ReportExceptionFactory.createReportException(ReportErrorCode.firstCharIsNotALetter, new Object[0]);
            }
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == ';' || c2 == '-' || c2 == '$' || c2 == ']') continue;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.illegalCharInAliasname, new Character(c2));
        }
        return string;
    }

    public static void checkAliasValidity(String newAlias) throws ReportException {
        if (PM.contains((newAlias = TableSource.aw(newAlias)).toUpperCase())) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.keywordsAsAlias, newAlias);
        }
    }

    public void changeAliasReferences(String newAlias) throws ReportException {
        String string = this.getAlias();
        if (this.lC.bB.iY().r(newAlias)) {
            Object[] objectArray = new Object[]{newAlias};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.DuplicateAliases, objectArray);
        }
        this.au(newAlias);
        this.lC.bB.getFields().changeAllAliases(string, newAlias, this.getDatasource());
    }

    void ax(String object) {
        int n2 = ((String)object).toLowerCase().indexOf("proc(");
        if (n2 >= 0) {
            String string = ((String)object).substring(n2 + 5, ((String)object).length() - 1);
            int n3 = string.indexOf(46);
            if (n3 != -1) {
                if (n2 > 0) {
                    --n2;
                }
                object = string.substring(0, n3 + 1) + ((String)object).substring(0, n2) + string.substring(n3, string.length());
            } else {
                object = ((String)object).substring(0, n2) + string;
            }
        }
        this.PF = object;
    }

    public void setDatabaseIdentifierName(String newDatabaseIdentifier) throws ReportException {
        if (newDatabaseIdentifier == null || newDatabaseIdentifier.length() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noEmptyIdentifierNameAllowed, new Object[0]);
        }
        this.ax(newDatabaseIdentifier);
    }

    public int getColumnCount() {
        return this.PG.size();
    }

    public String getAlias() {
        return this.PE;
    }

    public String getDatabaseIdentifier() {
        return this.PF;
    }

    String kx() {
        DataFactory dataFactory = this.qV.l(false);
        return ((Database)dataFactory).getSourceNameWithChange(this, dataFactory.getConfiguration().isUseEscapeEverything());
    }

    String ky() {
        int n2;
        Object object = this.kx();
        if (object == null) {
            return null;
        }
        String string = ((Database)this.qV.getDataFactory()).getIdentifierQuoteString();
        if (string == null || string.length() == 0) {
            return object;
        }
        while ((n2 = ((String)object).indexOf(string)) != -1) {
            object = ((String)object).substring(0, n2) + ((String)object).substring(n2 + 1);
        }
        return object;
    }

    public void setLocation(String location, Datasource newDatasource) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[TableSource " + this.getAlias() + " DS#" + this.getDatasource().ch() + "]setLocation " + location + "  new DS#" + String.valueOf(newDatasource));
        }
        this.type = 0;
        if (newDatasource != null && this.qV != newDatasource) {
            this.qV.a(this, newDatasource);
        }
        if (location == null) {
            return;
        }
        int n2 = this.PF.lastIndexOf(46);
        if (n2 == -1) {
            if (location.length() > 0) {
                this.PF = location + "." + this.PF;
            }
            return;
        }
        this.PF = location.length() > 0 ? location + "." + this.PF.substring(n2 + 1, this.PF.length()) : this.PF.substring(n2 + 1, this.PF.length());
    }

    public String toString() {
        return this.PE;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TableSource)) {
            return false;
        }
        TableSource tableSource = (TableSource)o2;
        if (tableSource.PE == null) {
            return false;
        }
        return tableSource.PE.equals(this.PE);
    }

    public String getSql() {
        return this.PH;
    }

    public String getSqlWithPromptFieldValues() throws ReportException {
        this.updateReferences();
        PromptPlaceholderReplacer promptPlaceholderReplacer = new PromptPlaceholderReplacer(this.qV.getDataFactory().getSqlSyntax());
        promptPlaceholderReplacer.setQuoteStringPrompts(this.PJ);
        return promptPlaceholderReplacer.replace(this.PH, this.lC.bB.getFields());
    }

    String aq(boolean bl2) throws ReportException, SQLException {
        DataFactory dataFactory = this.qV.getDataFactory();
        if (!DatabaseUtils.useJdbcDriver(dataFactory)) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Call of getDefaultSql from non JDBC database class.");
            }
            return "";
        }
        switch (this.getType()) {
            case 3: {
                if (bl2) {
                    return this.PH;
                }
                SqlSyntax sqlSyntax = dataFactory.getSqlSyntax();
                return new PromptPlaceholderReplacer(sqlSyntax).setQuoteStringPrompts(this.PJ).replace(this.PH, this.lC.bB.getFields());
            }
            case 2: {
                return this.ap(bl2);
            }
        }
        return this.kv();
    }

    public void setSql(String newSql) {
        this.resetReferences();
        if (newSql != null && newSql.trim().length() == 0) {
            newSql = null;
        }
        this.PH = newSql;
        this.setReferences();
        this.type = 3;
    }

    public void setQuoteStringPrompts(boolean value) {
        this.PJ = value;
    }

    public boolean getQuoteStringPrompts() {
        return this.PJ;
    }

    public Datasource getDatasource() {
        return this.qV;
    }

    void setDatasource(Datasource newConnection) {
        this.qV = newConnection;
    }

    String[] kz() {
        return this.PL;
    }

    void b(String[] stringArray) {
        this.PL = stringArray;
    }

    public void setInputParameter(String[] paramNames, int[] paramTypes) throws ReportException {
        this.setInputParameter(paramNames, paramTypes, null);
    }

    public void setInputParameter(String[] paramNames, int[] paramTypes, Object[] values) throws ReportException {
        int n2;
        if (paramNames.length != paramTypes.length) {
            Object[] objectArray = new Object[]{new Integer(paramNames.length), new Integer(paramTypes.length)};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.inputParamsOfDifferentSize, objectArray);
        }
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        Fields fields = this.lC.bB.getFields();
        int n3 = 0;
        block3: for (n2 = 0; n2 < paramNames.length; ++n2) {
            String string = paramNames[n2];
            switch (paramTypes[n2]) {
                case -10: 
                case 1111: {
                    continue block3;
                }
                default: {
                    PromptField promptField = fields.getPromptField(string);
                    if (promptField == null || promptField.za != this) {
                        promptField = fields.addPromptField(TableSource.a(string, this.lC.bB.iV()), "", paramTypes[n2]);
                        promptField.yZ = string;
                        promptField.za = this;
                    }
                    if (values != null && values[n3] != null) {
                        promptField.setPromptValue(values[n3]);
                    }
                    arrayList.add(promptField);
                    ++n3;
                }
            }
        }
        if (this.type != 3) {
            this.type = 2;
        }
        this.b(paramNames);
        for (n2 = fields.getPromptFieldsCount() - 1; n2 >= 0; --n2) {
            PromptField promptField = fields.getPromptField(n2);
            if (promptField.za != this || arrayList.contains(promptField) || !this.a(promptField)) continue;
            promptField.za = null;
            promptField.yZ = null;
            fields.removePromptField(n2);
        }
    }

    public List<PromptField> getInputParameters() throws ReportException {
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        Fields fields = this.lC.bB.getFields();
        for (int i2 = 0; i2 < fields.getPromptFieldsCount(); ++i2) {
            PromptField promptField = fields.getPromptField(i2);
            if (promptField.za != this) continue;
            arrayList.add(promptField);
        }
        return arrayList;
    }

    @Deprecated
    public void setInputParameter_TypesOfSQLType(String[] paramNames, int[] paramTypes) throws ReportException {
        LogManager.deprecatedMessage();
        this.setInputParameter_TypesOfSQLType(paramNames, paramTypes, null);
    }

    @Deprecated
    public void setInputParameter_TypesOfSQLType(String[] paramNames, int[] paramTypes, Object[] values) throws ReportException {
        LogManager.deprecatedMessage();
        if (paramNames.length != paramTypes.length) {
            Object[] objectArray = new Object[]{new Integer(paramNames.length), new Integer(paramTypes.length)};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.inputParamsOfDifferentSize, objectArray);
        }
        block3: for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            int n2 = paramTypes[i2];
            switch (n2) {
                case -10: 
                case 1111: {
                    continue block3;
                }
                default: {
                    int n3 = DatabaseTables.mapSqlTypeToCCType(n2);
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("[TableSource " + this.PE + "] parameter " + paramNames[i2] + " map sql type " + n2 + " to " + n3);
                    }
                    paramTypes[i2] = n3;
                }
            }
        }
        this.setInputParameter(paramNames, paramTypes, values);
    }

    private static String a(String string, PromptField[] promptFieldArray) {
        int n2 = 0;
        boolean bl2 = true;
        String string2 = string;
        block0: while (bl2) {
            bl2 = false;
            string2 = n2 == 0 ? string : string + "_" + n2;
            for (int i2 = 0; promptFieldArray != null && i2 < promptFieldArray.length; ++i2) {
                if (!promptFieldArray[i2].name.equalsIgnoreCase(string2)) continue;
                ++n2;
                bl2 = true;
                continue block0;
            }
        }
        return string2;
    }

    com.inet.report.list.a a(List<Join> list, ResultSet resultSet) throws ReportException, SQLException {
        if (resultSet != null) {
            com.inet.report.list.a a2 = new com.inet.report.list.a(this.PG.size());
            a2.by(true);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                String string;
                Object object = resultSetMetaData.getColumnName(i2);
                DatabaseField databaseField = this.getDatabaseField(this.a((String)object, string = resultSetMetaData.getColumnLabel(i2), i2 - 1));
                if (databaseField != null) {
                    a2.f(databaseField);
                    continue;
                }
                databaseField = this.getDatabaseField((String)object);
                if (databaseField != null) {
                    a2.f(databaseField);
                    continue;
                }
                if (object == null || ((String)object).trim().length() == 0) {
                    object = "EmptyColumnName" + i2;
                }
                if (!((String)object).equalsIgnoreCase(string) && (databaseField = this.getDatabaseField(string)) != null) {
                    a2.f(databaseField);
                    continue;
                }
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Addtional Column: " + (String)object + ", alias: " + string);
                }
                this.addColumn((String)object, 6);
                a2.f(this.getDatabaseField((String)object));
            }
            return a2;
        }
        return this.a(list, true);
    }

    com.inet.report.list.a a(List<Join> list, boolean bl2) throws ReportException {
        Serializable serializable;
        com.inet.report.list.a a2 = new com.inet.report.list.a();
        if (this.lC.bB.iZ() != null) {
            for (int i2 = 0; i2 < this.lC.bB.iZ().size(); ++i2) {
                serializable = this.lC.bB.iZ().eD(i2);
                if (((DatabaseField)serializable).kX != this || !((Field)serializable).isUsed() && (bl2 || !Database.a((DatabaseField)serializable, this.lC.bB))) continue;
                a2.f((DatabaseField)serializable);
            }
        }
        List<Join> list2 = this.lC.bB.iY().bV();
        serializable = this.lC.bB.iY();
        for (int i3 = 0; i3 < list2.size(); ++i3) {
            Join join = list2.get(i3);
            if (list != null && list.contains(join)) continue;
            TableSource tableSource = ((DatabaseTables)serializable).getTablesource(join.getSourceAlias());
            if (tableSource == this) {
                a2.b(join.getConditionSourceFields());
                continue;
            }
            TableSource tableSource2 = join.getTargetTableSource();
            if (tableSource2 != this) continue;
            a2.b(join.getConditionTargetFields());
        }
        return a2;
    }

    boolean kA() throws ReportException {
        for (int i2 = 0; i2 < this.PG.size(); ++i2) {
            DatabaseField databaseField = this.lC.bB.getFields().getDatabaseField(this.PE.concat(".").concat(this.getColumnName(i2)));
            if (databaseField == null || databaseField.getRealReferenceCount() <= 0) continue;
            return true;
        }
        return false;
    }

    void d(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(BaseUtils.getIndent(n2));
        stringBuilder.append("<").append("Tablesource").append(k.l("alias", this.PE)).append(k.l("databaseIdentifier", this.PF));
        stringBuilder.append(">\n").append("\n");
        ++n2;
        for (int i2 = 0; i2 < this.PG.size(); ++i2) {
            DatabaseField databaseField = this.PG.eD(i2);
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<").append("Column").append(k.l("name", databaseField.getShortName())).append(k.l("type", "" + databaseField.getValueType()));
            if (databaseField.hasColumnLabel()) {
                stringBuilder.append(k.l("description", databaseField.getColumnLabel()));
            }
            stringBuilder.append(" />\n");
        }
        if (this.PH != null && this.PH.length() > 0) {
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<").append("Sql");
            if (!this.PJ) {
                stringBuilder.append(k.l("QuoteStringPrompts", "false"));
            }
            stringBuilder.append(">\n").append("\n");
            stringBuilder.append(BaseUtils.getIndent(++n2)).append(k.h(this.PH)).append("\n").append(BaseUtils.getIndent(--n2));
            stringBuilder.append("<").append("/").append("Sql").append(">\n").append("\n");
        }
        stringBuilder.append(BaseUtils.getIndent(--n2)).append("<").append("/").append("Tablesource").append(">\n").append("\n");
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qk.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qk.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qk.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qk.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qk.removeReferencedObject(reference);
    }

    @Override
    public final void setReferences() {
        if (this.PH == null || this.PH.length() == 0) {
            return;
        }
        PromptField[] promptFieldArray = this.lC.bB.iV();
        if (promptFieldArray != null) {
            for (PromptField object : promptFieldArray) {
                String string = object.getPlaceholderName();
                int n2 = -1;
                while ((n2 = this.PH.indexOf(string, n2 + 1)) != -1) {
                    object.addReferenceHolder(this);
                }
            }
        }
        try {
            Fields fields = this.lC.getFields();
            for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
                FormulaField formulaField = fields.getFormulaField(i2);
                String string = formulaField.getPlaceholderName();
                int n3 = -1;
                while ((n3 = this.PH.indexOf(string, n3 + 1)) != -1) {
                    formulaField.addReferenceHolder(this);
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
        }
    }

    @Override
    public final void resetReferences() {
        this.qk.resetReferences();
        PromptField[] promptFieldArray = this.lC.bB.iV();
        if (promptFieldArray != null) {
            for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
                promptFieldArray[i2].removeReferenceHolder(this);
            }
        }
        if (this.lC.bB.Iv != null) {
            for (FormulaField formulaField : this.lC.bB.Iv) {
                formulaField.removeReferenceHolder(this);
            }
        }
    }

    public void refresh() throws ReportException, SQLException {
        try {
            this.kB();
        }
        catch (ReportException reportException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(reportException);
            }
            throw reportException;
        }
    }

    private void kB() throws ReportException, SQLException {
        int n2;
        Field field;
        int n3;
        PromptField[] promptFieldArray;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[TableSource " + this.PE + "] start refresh");
        }
        this.kt();
        MissedColumnException missedColumnException = new MissedColumnException();
        DataFactory dataFactory = this.qV.getDataFactory();
        List<ColumnInfo> list = dataFactory.getColumns(this);
        StringList stringList = new StringList();
        IntList intList = new IntList();
        StringList stringList2 = new StringList();
        IntList intList2 = new IntList();
        block12: for (int i2 = 0; i2 < list.size(); ++i2) {
            promptFieldArray = list.get(i2);
            switch (promptFieldArray.getSqlType()) {
                case -10: 
                case 1111: 
                case 2012: {
                    continue block12;
                }
                default: {
                    switch (promptFieldArray.getColumnType()) {
                        case 1: 
                        case 2: 
                        case 4: {
                            stringList2.addElement(promptFieldArray.getName());
                            intList2.addElement(promptFieldArray.getDataType());
                        }
                        case 5: {
                            continue block12;
                        }
                        case 3: {
                            stringList.addElement(promptFieldArray.getName());
                            intList.addElement(promptFieldArray.getDataType());
                        }
                    }
                }
            }
        }
        ArrayList<Field> arrayList = new ArrayList<Field>();
        promptFieldArray = this.lC.bB.iV();
        for (int i3 = 0; i3 < stringList2.size(); ++i3) {
            boolean bl2 = false;
            String string = stringList2.elementAt(i3);
            int n4 = intList2.elementAt(i3);
            for (n3 = 0; promptFieldArray != null && n3 < promptFieldArray.length; ++n3) {
                field = promptFieldArray[n3];
                if (((PromptField)field).za != this || !string.equalsIgnoreCase(((PromptField)field).yZ)) {
                    if (((PromptField)field).za != this && ((PromptField)field).za != null || !string.equalsIgnoreCase(((PromptField)field).name)) continue;
                    ((PromptField)field).za = this;
                    ((PromptField)field).yZ = string;
                }
                bl2 = true;
                ((PromptField)field).setValueType(n4);
                arrayList.add(field);
                break;
            }
            if (bl2) continue;
            PromptField promptField = this.lC.bB.getFields().addPromptField(TableSource.a(string, this.lC.bB.iV()), "", n4);
            promptField.za = this;
            promptField.yZ = string;
            arrayList.add(promptField);
        }
        ArrayList<PromptField> arrayList2 = new ArrayList<PromptField>();
        StringList stringList3 = new StringList();
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            String string = this.getColumnName(n2);
            n3 = stringList.indexOfIgnoreCase(string);
            if (n3 == -1) {
                this.a(string, stringList3, missedColumnException);
                continue;
            }
            field = this.getDatabaseField(string);
            try {
                field.setValueType(intList.elementAt(n3));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.a(string, stringList3, missedColumnException);
            }
        }
        for (n2 = 0; promptFieldArray != null && n2 < promptFieldArray.length; ++n2) {
            PromptField promptField = promptFieldArray[n2];
            if (promptField.za != this || arrayList.contains(promptField)) continue;
            if (this.a(promptField)) {
                arrayList2.add(promptField);
                continue;
            }
            promptField.za = null;
            promptField.yZ = null;
        }
        for (n2 = 0; n2 < stringList3.size(); ++n2) {
            String string = stringList3.elementAt(n2);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[TableSource(SP) " + this.PE + "] remove Column " + string);
            }
            this.removeColumn(string);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            PromptField promptField = (PromptField)arrayList2.get(n2);
            promptField.za = null;
            promptField.yZ = null;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[TableSource(SP) " + this.PE + "]remove PromptField " + promptField.getName());
            }
            this.lC.bB.getFields().removePromptField(promptField.indexOf());
        }
        for (n2 = 0; n2 < stringList.size(); ++n2) {
            String string = stringList.elementAt(n2);
            if (list.contains(this.PE + "." + string)) continue;
            n3 = intList.elementAt(n2);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[TableSource(SP) " + this.PE + "]add Column " + string + " " + n3);
            }
            try {
                this.addColumn(string, n3);
                continue;
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) continue;
                BaseUtils.debug("[TableSource(Tbl) " + this.PE + "] ignore Column " + string + " because of invalid column type " + n3);
            }
        }
        if (missedColumnException.getColumns().size() > 0) {
            throw missedColumnException;
        }
        if (dataFactory instanceof Database && !this.lC.bB.je().getFile().endsWith(".dataview")) {
            ((Database)dataFactory).findColumnLabels(this);
        }
    }

    private void a(String string, StringList stringList, MissedColumnException missedColumnException) {
        try {
            this.canRemoveColumn(string);
            stringList.addElement(string);
        }
        catch (ReportException reportException) {
            missedColumnException.addColumn(string);
        }
    }

    void d(DatabaseField databaseField) {
        int n2 = this.PG.g(databaseField);
        if (n2 != -1) {
            this.PG.a(databaseField, n2);
        } else {
            this.PG.f(databaseField);
        }
        n2 = this.lC.bB.iZ().g(databaseField);
        if (n2 != -1) {
            this.lC.bB.iZ().a(databaseField, n2);
        }
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            parserMap.remove("TableSourceIsCurrentlySqlTag");
            XMLTag xMLTag = XMLTag.getValueOf(tag);
            switch (xMLTag) {
                case Sql: {
                    parserMap.put("TableSourceIsCurrentlySqlTag", Boolean.TRUE);
                    String string = atts.getValue("QuoteStringPrompts");
                    if (string == null) break;
                    this.PJ = Boolean.parseBoolean(string);
                    break;
                }
                case Column: {
                    String string = atts.getValue("name");
                    int n2 = Integer.valueOf(atts.getValue("type").toString());
                    String string2 = atts.getValue("description");
                    this.addColumn(string, n2, string2);
                    break;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        if (parserMap.get("TableSourceIsCurrentlySqlTag") != null) {
            this.setSql(text);
        }
    }

    int kC() {
        return this.type;
    }

    void e(DatabaseField databaseField) {
        this.PG.h(databaseField);
    }

    String a(String string, String string2, int n2) throws SQLException, ReportException {
        DataFactory dataFactory = this.qV.getDataFactory();
        if (dataFactory instanceof Database) {
            int n3 = -1;
            try (Connection connection = this.qV.getConnection();){
                if (connection != null) {
                    n3 = connection.getMetaData().getDriverMajorVersion();
                }
                String string3 = ((Database)dataFactory).getColumnName(string, string2, n3, this, n2);
                return string3;
            }
        }
        return string;
    }

    public boolean isUsed() throws ReportException {
        try {
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.canRemoveColumn(this.getColumnName(i2));
            }
        }
        catch (ReportException reportException) {
            return true;
        }
        DatabaseTables databaseTables = this.qV.getEngine().getDatabaseTables();
        Vector vector = databaseTables.getJoinsEntries();
        for (Join join : vector) {
            if (!this.equals(join.getSourceTableSource()) && !this.equals(join.getTargetTableSource())) continue;
            return true;
        }
        return false;
    }

    static {
        PM.add("SELECT");
        PM.add("FROM");
        PM.add("ORDER");
        PM.add("GROUP");
        PM.add("BY");
        PM.add("AS");
        PM.add("WHERE");
        PM.add("UNION");
        PM.add("JOIN");
        PM.add("INNER");
        PM.add("OUTER");
        PM.add("LEFT");
        PM.add("RIGHT");
        PM.add("FULL");
        PM.add("AND");
        PM.add("OR");
        PM.add("ON");
        PM.add("DISTINCT");
        PM.add("SOUNDEX");
        PM.add("ALL");
        PM.add("INTO");
        PM.add("AND");
        PM.add("IS");
        PM.add("ANY");
        PM.add("JOIN");
        PM.add("AS");
        PM.add("LEFT");
        PM.add("ASC");
        PM.add("LIKE");
        PM.add("AVG");
        PM.add("LOCAL");
        PM.add("BETWEEN");
        PM.add("MATCH");
        PM.add("BY");
        PM.add("MAX");
        PM.add("CAST");
        PM.add("MIN");
        PM.add("CORRESPONDING");
        PM.add("NATURAL");
        PM.add("COUNT");
        PM.add("NOT");
        PM.add("CREATE");
        PM.add("NULL");
        PM.add("CROSS");
        PM.add("ON");
        PM.add("DELETE");
        PM.add("OR");
        PM.add("DESC");
        PM.add("ORDER");
        PM.add("DISTINCT");
        PM.add("OUTER");
        PM.add("DROP");
        PM.add("RIGHT");
        PM.add("ESCAPE");
        PM.add("SELECT");
        PM.add("EXCEPT");
        PM.add("SET");
        PM.add("EXISTS");
        PM.add("SOME");
        PM.add("FALSE");
        PM.add("SUM");
        PM.add("FROM");
        PM.add(TYPE_NAME_TABLE);
        PM.add("FULL");
        PM.add("TEMPORARY");
        PM.add("GLOBAL");
        PM.add("TRUE");
        PM.add("GROUP");
        PM.add("UNION");
        PM.add("HAVING");
        PM.add("UNIQUE");
        PM.add("IN");
        PM.add("UNKNOWN");
        PM.add("INNER");
        PM.add("UPDATE");
        PM.add("INSERT");
        PM.add("USING");
        PM.add("INTERSECT");
        PM.add("VALUES");
    }
}

