/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.authentication.LoginProcessor;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.report.Field;
import com.inet.report.ReportException;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.bj;
import com.inet.report.bz;
import com.inet.report.k;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.Locale;
import java.util.TimeZone;

@PublicApi
public class SpecialField
extends Field {
    public static final int PRINT_DATE = 0;
    public static final int PRINT_TIME = 1;
    public static final int MODIFICATION_DATE = 2;
    public static final int MODIFICATION_TIME = 3;
    public static final int DATA_DATE = 4;
    public static final int DATA_TIME = 5;
    public static final int RECORD_NUMBER = 6;
    public static final int PAGE_NUMBER = 7;
    public static final int GROUP_NUMBER = 8;
    public static final int TOTAL_PAGE_COUNT = 9;
    public static final int REPORT_TITLE = 10;
    public static final int REPORT_COMMENTS = 11;
    public static final int RECORD_SELECTION_FORMULA = 12;
    public static final int GROUP_SELECTION_FORMULA = 13;
    public static final int REPORT_FILE = 14;
    public static final int REPORT_AUTHOR = 15;
    public static final int CREATION_DATE = 16;
    public static final int PAGE_N_OF_M = 17;
    public static final int RECORD_COUNT = 18;
    public static final int HORIZONTAL_PAGE_NUMBER = 19;
    public static final int CURRENT_USER_NAME = 20;
    public static final int CURRENT_USER_ID = 21;
    public static final int CURRENT_USER_TIME_ZONE = 22;
    public static final int PRINT_TIME_ZONE = 23;
    public static final int DATA_TIME_ZONE = 24;
    public static final int CONTENT_LOCALE = 25;
    public static final int SELECTION_LOCALE = 26;
    int Na;

    SpecialField(ba renderer) {
        this.type = 10;
        this.bB = renderer;
    }

    @Override
    public void setName(String newValue) {
        throw new IllegalStateException("A special field does not have a name.");
    }

    public String getOperationName() {
        switch (this.Na) {
            case 0: {
                return "PrintDate";
            }
            case 1: {
                return "PrintTime";
            }
            case 23: {
                return "PrintTimeZone";
            }
            case 2: {
                return "ModificationDate";
            }
            case 3: {
                return "ModificationTime";
            }
            case 4: {
                return "DataDate";
            }
            case 5: {
                return "DataTime";
            }
            case 24: {
                return "DataTimeZone";
            }
            case 6: {
                return "RecordNumber";
            }
            case 18: {
                return "RecordCount";
            }
            case 7: {
                return "PageNumber";
            }
            case 8: {
                return "GroupNumber";
            }
            case 9: {
                return "TotalPageCount";
            }
            case 10: {
                return "ReportTitle";
            }
            case 11: {
                return "ReportComments";
            }
            case 12: {
                return "RecordSelection";
            }
            case 13: {
                return "GroupSelection";
            }
            case 14: {
                return "Filename";
            }
            case 15: {
                return "FileAuthor";
            }
            case 16: {
                return "FileCreationDate";
            }
            case 17: {
                return "PageNOfM";
            }
            case 19: {
                return "HorizontalPageNumber";
            }
            case 20: {
                return "CurrentUserName";
            }
            case 22: {
                return "CurrentUserTimeZone";
            }
            case 25: {
                return "ContentLocale";
            }
            case 26: {
                return "SelectionLocale";
            }
        }
        return "";
    }

    public void setSpecialType(int type) {
        this.Na = type;
    }

    public int getSpecialType() {
        return this.Na;
    }

    @Override
    Field[] K(int n2) {
        return new SpecialField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, "Operation", k.G(this.Na));
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    final void a(int n2, String string, at at2) {
        switch (n2) {
            case 176: {
                this.Na = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, at2);
            }
        }
    }

    @Override
    public String getRefName() {
        return "Specialfield:" + this.Na;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SpecialField && super.equals(obj) && this.Na == ((SpecialField)obj).Na;
    }

    @Override
    public String getName() {
        return this.getOperationName();
    }

    @Override
    Object getValue() throws ReportException {
        bj bj2 = this.bB.gF();
        switch (this.Na) {
            case 2: {
                return new Date(this.bB.getSummaryInfo().getLastSaved().getTime());
            }
            case 3: {
                return new Time(this.bB.getSummaryInfo().getLastSaved().getTime());
            }
            case 0: 
            case 4: {
                return new Date(this.bB.iQ().getTime());
            }
            case 1: 
            case 5: {
                return new Time(this.bB.iQ().getTime());
            }
            case 23: 
            case 24: {
                TimeZone timeZone = TimeZone.getDefault();
                boolean bl2 = timeZone.inDaylightTime(this.bB.iQ());
                StringBuilder stringBuilder = new StringBuilder(timeZone.getDisplayName(bl2, 0, this.bB.Jf));
                stringBuilder.append(", ").append(timeZone.getDisplayName(bl2, 1, this.bB.Jf));
                stringBuilder.append(", ").append(timeZone.getID());
                return stringBuilder.toString();
            }
            case 6: {
                return new Integer(bj2.M());
            }
            case 18: {
                return new Integer(bj2.getRowCount());
            }
            case 7: {
                return new Integer(this.bB.IY - this.bB.IZ);
            }
            case 8: {
                return new Integer(bj2.Y());
            }
            case 9: {
                if (!this.bB.gA()) {
                    throw new bz(this.bB);
                }
                return new Integer(this.bB.gB());
            }
            case 10: {
                return this.bB.getSummaryInfo().getReportTitle();
            }
            case 11: {
                return this.bB.getSummaryInfo().getComments();
            }
            case 12: {
                return this.bB.ja() != null ? this.bB.ja().getFormula() : null;
            }
            case 13: {
                return this.bB.jb() != null ? this.bB.jb().getFormula() : null;
            }
            case 14: {
                switch (this.bB.IS.getProtocol()) {
                    case "file": {
                        return IOFunctions.getFileName((URL)this.bB.IS);
                    }
                    case "repo": 
                    case "drive": 
                    case "jndi": {
                        return EncodingFunctions.decodeUrlPath((String)this.bB.IS.getPath());
                    }
                }
                return this.bB.IS.getFile();
            }
            case 15: {
                return this.bB.getSummaryInfo().getAuthor();
            }
            case 16: {
                return new Date(this.bB.getSummaryInfo().getCreated().getTime());
            }
            case 17: {
                return this.bB.fE();
            }
            case 20: {
                LoginProcessor loginProcessor = LoginProcessor.getCurrent();
                if (loginProcessor != null) {
                    return loginProcessor.getLoginID();
                }
                return "";
            }
            case 22: {
                return "";
            }
            case 19: {
                return new Integer(1);
            }
            case 25: {
                return this.bB.Jf;
            }
            case 26: {
                if (this.bB.Je == null) {
                    return Locale.getDefault();
                }
                return this.bB.Je;
            }
        }
        return "Unknown SpecialField: " + this.Na;
    }

    public static enum a {
        Nk(0),
        Nl(1),
        Nm(2),
        Nn(3),
        No(4),
        Np(5),
        Nq(6),
        Nr(7),
        Ns(8),
        Nt(9),
        Nu(10),
        Nv(11),
        Nw(12),
        Nx(13),
        Ny(14),
        Nz(15),
        NA(16),
        NB(17),
        NC(17),
        ND(18),
        NE(19),
        NF(20),
        NG(22),
        NH(23),
        NI(24),
        NJ(25),
        NK(26);

        private int gH;

        private a(int n3) {
            this.gH = n3;
        }

        int kk() {
            return this.gH;
        }
    }
}

