/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.CrossTab;
import com.inet.report.CrossTabBody;
import com.inet.report.CrossTabHeader;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.FormulaField;
import com.inet.report.PropertyConstants;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.m;
import com.inet.report.y;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class CrossTabHeaderList
implements Serializable {
    private final CrossTab jg;
    @Nonnull
    private final List<CrossTabHeader> jT;
    private boolean jU;
    private FormulaField jV;
    private FormulaField jW;
    private boolean jX;
    private boolean jY;
    private int jZ;

    CrossTabHeaderList(CrossTab crossTab) {
        this.jg = crossTab;
        this.jT = new ArrayList<CrossTabHeader>();
    }

    public void remove(int index) throws ReportException {
        if (index == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDropGrandTotal, new Object[0]);
        }
        CrossTabHeader crossTabHeader = this.jT.get(index);
        this.jg.getBody().a(crossTabHeader);
        this.jT.remove(index);
        crossTabHeader.resetReferences();
        this.jg.bd().bm();
        this.jg.bd().bn();
    }

    @Nonnull
    public CrossTabHeader add(@Nonnull Field field) {
        Element element;
        int n2;
        int n3;
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.jg, this, field);
        this.jT.add(crossTabHeader);
        CrossTabBody crossTabBody = this.jg.getBody();
        boolean bl2 = this.jg.getOptions().getSummaryHorizontal();
        int n4 = Math.max(1, crossTabBody.getSummaryFieldsCount());
        if (this.isRow()) {
            crossTabBody.b(crossTabHeader);
            n3 = 2036;
            n2 = 230;
            if (this.size() == 2) {
                element = this.jT.get(0).getText();
                n3 = Math.max(n3, element.getWidth());
            }
            if (!bl2) {
                n2 *= n4;
            }
        } else {
            crossTabBody.c(crossTabHeader);
            n3 = 810;
            n2 = 230;
            if (this.size() == 2) {
                element = this.jT.get(0).getText();
                n2 = Math.max(n2, element.getHeight());
            }
            if (bl2) {
                n3 *= n4;
            }
        }
        if ((element = crossTabHeader.getFieldElement()) == null) {
            element = crossTabHeader.getText();
        }
        element.setWidth(n3);
        element.setHeight(n2);
        return crossTabHeader;
    }

    public void move(int from, int to) throws ReportException {
        Element element;
        int n2;
        if (from == 0 || to == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDropGrandTotal, new Object[0]);
        }
        this.jT.get(to);
        boolean bl2 = this.isRow();
        int[] nArray = new int[this.jT.size()];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            element = this.jT.get(n2).bC();
            nArray[n2] = bl2 ? element.jo : element.width;
        }
        this.jT.add(to, this.jT.remove(from));
        for (n2 = 1; n2 < nArray.length; ++n2) {
            element = this.jT.get(n2).bC();
            if (bl2) {
                element.jo = nArray[n2];
                continue;
            }
            element.width = nArray[n2];
        }
        this.jg.bd().bm();
        this.jg.bd().bn();
    }

    @Nonnull
    @Deprecated
    CrossTabHeader bG() {
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.jg, this, null);
        this.jT.add(crossTabHeader);
        return crossTabHeader;
    }

    @Nonnull
    public CrossTabHeader get(int index) {
        return this.jT.get(index);
    }

    public boolean isRow() {
        return this == this.jg.getRows();
    }

    public int size() {
        return this.jT.size();
    }

    @Nonnull
    public CrossTabHeader getGrandTotal() {
        return this.jT.get(0);
    }

    public boolean getTotalOnStart() {
        return this.jU;
    }

    public void setTotalOnStart(boolean value) {
        this.jU = value;
    }

    public void setTotalOnStartFormula(FormulaField newFormula) {
        String string;
        int n2;
        FormulaField.d(this.jV);
        if (this.isRow()) {
            n2 = 465;
            string = "rowTotalOnLeft";
        } else {
            n2 = 466;
            string = "columnTotalOnTop";
        }
        this.jV = this.jg.a(newFormula, n2, string);
    }

    public FormulaField getTotalOnStartFormula() {
        return this.jV;
    }

    public boolean getSuppressEmptyLines() {
        return this.jX;
    }

    public void setSuppressEmptyLines(boolean suppressEmptyLines) {
        this.jX = suppressEmptyLines;
    }

    public void setSuppressEmptyLinesFormula(FormulaField newFormula) {
        String string;
        int n2;
        FormulaField.d(this.jW);
        if (this.isRow()) {
            n2 = 455;
            string = "suppressEmptyRows";
        } else {
            n2 = 454;
            string = "suppressEmptyColumns";
        }
        this.jW = this.jg.a(newFormula, n2, string);
    }

    public FormulaField getSuppressEmptyLinesFormula() {
        return this.jW;
    }

    public boolean getIndentLabel() {
        return this.jY;
    }

    public void setIndentLabel(boolean indentLabel) {
        if (this.jY != indentLabel) {
            this.jY = indentLabel;
            this.jg.bd().bm();
            this.jg.bd().bn();
        }
    }

    public int getIndentLabelSize() {
        return this.jZ;
    }

    public void setIndentLabelSize(int indentLabelSize) {
        if (indentLabelSize < 0) {
            throw y.a("indentLabelSize", indentLabelSize, null);
        }
        if (this.jZ != indentLabelSize) {
            this.jZ = indentLabelSize;
            if (this.isRow()) {
                this.jg.bd().bm();
            } else {
                this.jg.bd().bn();
            }
        }
    }

    void setReferences() {
        for (int i2 = 0; i2 < this.jT.size(); ++i2) {
            this.jT.get(i2).setReferences();
        }
    }

    void resetReferences() {
        for (int i2 = 0; i2 < this.jT.size(); ++i2) {
            this.jT.get(i2).resetReferences();
        }
    }

    void b(@Nonnull List<FormulaField> list) {
        for (int i2 = 0; i2 < this.jT.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jT.get(i2);
            crossTabHeader.b(list);
        }
        list.add(PropertyConstants.setPropertyDefault(this.jW, this.getSuppressEmptyLines()));
        list.add(PropertyConstants.setPropertyDefault(this.jV, this.getTotalOnStart()));
    }

    int g(CrossTabHeader crossTabHeader) {
        return this.jT.indexOf(crossTabHeader);
    }

    int b(Element element) {
        for (int i2 = 0; i2 < this.jT.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jT.get(i2);
            if (crossTabHeader.getText() != element && crossTabHeader.getFieldElement() != element) continue;
            return i2;
        }
        return -1;
    }

    void bj() {
        m m2 = this.jg.bd();
        for (int i2 = 0; i2 < this.jT.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jT.get(i2);
            crossTabHeader.getText().addPropertyChangeListener(m2);
            FieldElement fieldElement = crossTabHeader.getFieldElement();
            if (fieldElement == null) continue;
            fieldElement.addPropertyChangeListener(m2);
        }
    }
}

