/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.axis.CategoryAxis;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.entity.CategoryItemEntity;
import com.inet.jfree.chart.entity.EntityCollection;
import com.inet.jfree.chart.event.RendererChangeEvent;
import com.inet.jfree.chart.labels.CategoryItemLabelGenerator;
import com.inet.jfree.chart.labels.CategoryToolTipGenerator;
import com.inet.jfree.chart.plot.CategoryPlot;
import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.renderer.category.CategoryItemRendererState;
import com.inet.jfree.chart.renderer.category.Face;
import com.inet.jfree.chart.renderer.category.IntervalBarRenderer;
import com.inet.jfree.data.category.CategoryDataset;
import com.inet.jfree.data.category.StockCategoryDataset;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.ui.RectangleEdge;

public class StockChartRenderer
extends IntervalBarRenderer
implements Serializable {
    private static final long serialVersionUID = -8135673815876552517L;
    private boolean drawOpenTicks = false;
    private boolean drawCloseTicks = false;
    private transient Paint openTickPaint;
    private transient Paint closeTickPaint;
    private boolean invertedColumns = false;

    public StockChartRenderer() {
        this(false);
    }

    public StockChartRenderer(boolean drawOpenClose) {
        this.drawOpenTicks = drawOpenClose;
        this.drawCloseTicks = drawOpenClose;
        this.invertedColumns = false;
    }

    @Override
    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (dataset instanceof StockCategoryDataset) {
            StockCategoryDataset d = (StockCategoryDataset)dataset;
            this.drawInterval(g2, state, dataArea, plot, domainAxis, rangeAxis, d, row, column);
        } else {
            super.drawItem(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column, pass);
        }
    }

    protected void drawInterval(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, StockCategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        CategoryItemLabelGenerator generator;
        double yClose;
        double yOpen;
        double seriesGap;
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        PlotOrientation orientation = plot.getOrientation();
        double rectX = 0.0;
        double rectY = 0.0;
        RectangleEdge domainAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
        Number value0 = dataset.getEndValue(row, column);
        if (value0 == null) {
            return;
        }
        double java2dValue0 = rangeAxis.valueToJava2D(value0.doubleValue(), dataArea, rangeAxisLocation);
        Number value1 = dataset.getStartValue(row, column);
        if (value1 == null) {
            return;
        }
        double java2dValue1 = rangeAxis.valueToJava2D(value1.doubleValue(), dataArea, rangeAxisLocation);
        if (java2dValue1 < java2dValue0) {
            double temp = java2dValue1;
            java2dValue1 = java2dValue0;
            java2dValue0 = temp;
            Number tempNum = value1;
            value1 = value0;
            value0 = tempNum;
        }
        double rectWidth = state.getBarWidth();
        if (this.getDrawOpenTicks() && dataset.getOpenValue(row, column) != null || this.getDrawCloseTicks() && dataset.getCloseValue(row, column) != null) {
            rectWidth = rectWidth * 2.0 / 3.0;
        }
        double rectHeight = Math.abs(java2dValue1 - java2dValue0);
        if (orientation == PlotOrientation.HORIZONTAL) {
            rectY = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, domainAxisLocation);
            if (seriesCount > 1) {
                seriesGap = dataArea.getHeight() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
                rectY += (double)row * (rectWidth + seriesGap);
            } else {
                rectY += (double)row * rectWidth;
            }
            rectX = java2dValue0;
            rectHeight = rectWidth;
            rectWidth = Math.abs(java2dValue1 - java2dValue0);
        } else if (orientation == PlotOrientation.VERTICAL) {
            rectX = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, domainAxisLocation);
            if (seriesCount > 1) {
                seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
                rectX += (double)row * (rectWidth + seriesGap);
            } else {
                rectX += (double)row * rectWidth;
            }
            rectY = java2dValue0;
        }
        Rectangle2D.Double bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
        Rectangle2D.Double barH = new Rectangle2D.Double(rectX + rectWidth, rectY + rectHeight, rectHeight, rectWidth);
        this.getBarPainter().paintBar(g2, this, row, column, bar, domainAxisLocation, state, Face.Front);
        double xx = rectX;
        if (orientation == PlotOrientation.HORIZONTAL) {
            xx = rectY;
        }
        double delta = 2.0;
        delta = state.getBarWidth() / 3.0;
        if (delta < 1.0) {
            delta = 1.0;
        }
        if (this.getInvertedColumns()) {
            delta = -delta;
        }
        if (this.getDrawOpenTicks() && dataset.getOpenValue(row, column) != null && !Double.isNaN(yOpen = dataset.getOpenValue(row, column).doubleValue())) {
            double yyOpen = rangeAxis.valueToJava2D(yOpen, dataArea, rangeAxisLocation);
            if (this.openTickPaint != null) {
                g2.setPaint(this.openTickPaint);
            } else if (this.isDrawBarOutline() && this.getItemOutlinePaint(row, column) != null) {
                g2.setPaint(this.getItemOutlinePaint(row, column));
            }
            g2.setStroke(new BasicStroke());
            if (orientation == PlotOrientation.HORIZONTAL) {
                g2.draw(new Line2D.Double(yyOpen, xx - delta, yyOpen, xx));
            } else if (orientation == PlotOrientation.VERTICAL) {
                g2.draw(new Line2D.Double(xx - delta, yyOpen, xx, yyOpen));
            }
        }
        if (this.getDrawCloseTicks() && dataset.getCloseValue(row, column) != null && !Double.isNaN(yClose = dataset.getCloseValue(row, column).doubleValue())) {
            double yyClose = rangeAxis.valueToJava2D(yClose, dataArea, rangeAxisLocation);
            if (this.closeTickPaint != null) {
                g2.setPaint(this.closeTickPaint);
            } else if (this.isDrawBarOutline() && this.getItemOutlinePaint(row, column) != null) {
                g2.setPaint(this.getItemOutlinePaint(row, column));
            }
            g2.setStroke(new BasicStroke());
            if (orientation == PlotOrientation.HORIZONTAL) {
                g2.draw(new Line2D.Double(yyClose, xx + rectHeight, yyClose, xx + rectHeight + delta));
            } else if (orientation == PlotOrientation.VERTICAL) {
                g2.draw(new Line2D.Double(xx + rectWidth, yyClose, xx + rectWidth + delta, yyClose));
            }
        }
        if ((generator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            if (orientation == PlotOrientation.VERTICAL) {
                this.drawItemLabel(g2, dataset, row, column, plot, generator, bar, false);
            }
            if (orientation == PlotOrientation.HORIZONTAL) {
                this.drawItemLabel(g2, dataset, row, column, plot, generator, barH, false);
            }
        }
        if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
            String tip = null;
            CategoryToolTipGenerator tipster = this.getToolTipGenerator(row, column);
            if (tipster != null) {
                tip = tipster.generateToolTip(dataset, row, column);
            }
            String url = null;
            if (this.getItemURLGenerator(row, column) != null) {
                url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity entity = new CategoryItemEntity(bar, tip, url, dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
            entities.add(entity);
        }
    }

    public boolean getDrawOpenTicks() {
        return this.drawOpenTicks;
    }

    public void setDrawOpenTicks(boolean draw) {
        this.drawOpenTicks = draw;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawCloseTicks() {
        return this.drawCloseTicks;
    }

    public void setDrawCloseTicks(boolean draw) {
        this.drawCloseTicks = draw;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getOpenTickPaint() {
        return this.openTickPaint;
    }

    public void setOpenTickPaint(Paint paint) {
        this.openTickPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getCloseTickPaint() {
        return this.closeTickPaint;
    }

    public void setCloseTickPaint(Paint paint) {
        this.closeTickPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setInvertedColumns(boolean invertedColumns) {
        this.invertedColumns = invertedColumns;
    }

    public boolean getInvertedColumns() {
        return this.invertedColumns;
    }
}

