/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axg;
    private static Hashtable<String, Object> bsl;
    private static long bsm;
    private static long bsn;
    private static int bso;
    private static int bsp;
    private static int bsq;
    private static volatile int bsr;
    private static volatile int bss;
    private static Set<Integer> bst;
    private static Set<String> bsu;
    private static Set<String> bsv;
    private static double bsw;
    private static int bsx;
    private static int bsy;
    private static double bsz;
    private static double bsA;
    private static int bsB;
    private static int bsC;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.MP();
        ++bso;
    }

    public static void incReportRequest() {
        ++bsp;
    }

    public static void incRenderedReports() {
        ++bsq;
        bss = Math.max(bss, ++bsr);
    }

    public static void decRenderedReports() {
        --bsr;
    }

    public static int getCurrentRenderingReports() {
        return bsr;
    }

    public static int getMaxRenderingReports() {
        return bss;
    }

    public static void countReportTemplates(URL reportUrl) {
        bst.add(new Integer(reportUrl.hashCode()));
    }

    public static void countClientLanguages(Locale locale) {
        bsu.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        bsv.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        bsw += (double)pages;
        ++bsx;
        bsy = Math.max(bsy, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        bsz += (double)fetchedRecord;
        bsA += (double)discardedRecords;
        bsB = Math.max(bsB, fetchedRecord);
        bsC = Math.max(bsC, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = bsl.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void MP() {
        long l2 = System.currentTimeMillis();
        if (l2 > bsm) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= bsm) return;
                Accumulator.a(bsl, "");
                Accumulator.save();
                bso = 0;
                bsp = 0;
                bsq = 0;
                bsw = 0.0;
                bsy = 0;
                bsx = 0;
                bsz = 0.0;
                bsB = 0;
                bsA = 0.0;
                bsC = 0;
                bst.clear();
                bsu.clear();
                bsv.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= bsn) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= bsn) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axg == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        bsl.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(bso, hashtable, "Total Requests" + string);
        Accumulator.a(bsp, hashtable, "Report Requests" + string);
        Accumulator.a(bsq, hashtable, "Rendered Reports" + string);
        Accumulator.a(bsw, hashtable, "Total Page Count" + string);
        Accumulator.a(bsy, hashtable, "Maximal Page Count" + string);
        Accumulator.a(bsz, hashtable, "Total fetched Records" + string);
        Accumulator.a(bsB, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(bsA, hashtable, "Total discarded Records" + string);
        Accumulator.a(bsC, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(bst.size(), hashtable, "Report Templates");
            Accumulator.a(bsu.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", bsu);
            Accumulator.a(bsv.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", bsv);
            Accumulator.a(bsw / (double)bsx, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, bst);
            hashtable.put("Client Languages" + string, bsu);
            hashtable.put("Report Formats" + string, bsv);
            hashtable.put("Average Page Count" + string, new Double(bsx));
        }
        hashtable.put("Next Day", new Long(bsm));
    }

    private static Hashtable<String, Object> MQ() {
        Hashtable<String, Object> hashtable = bsl = new Hashtable<String, Object>();
        try {
            axg = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axg));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    bsl = hashtable;
                } else {
                    hashtable = bsl;
                }
                bso = (int)Accumulator.dH("Total Requests");
                bsp = (int)Accumulator.dH("Report Requests");
                bsq = (int)Accumulator.dH("Rendered Reports");
                bsw = Accumulator.dH("Total Page Count");
                bsy = (int)Accumulator.dH("Maximal Page Count");
                bsx = (int)Accumulator.dH("Average Page Count");
                bsz = Accumulator.dH("Total fetched Records");
                bsB = (int)Accumulator.dH("Maximal fetched Records");
                bsA = Accumulator.dH("Total discarded Records");
                bsC = (int)Accumulator.dH("Maximal discarded Records");
                bst = Accumulator.dI("Report Templates");
                bsu = Accumulator.dI("Client Languages");
                bsv = Accumulator.dI("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.MR();
                    bsm = l2;
                    Accumulator.MP();
                }
            }
            catch (Throwable throwable) {
                bsl = hashtable;
                bst = Collections.synchronizedSet(new HashSet());
                bsu = Collections.synchronizedSet(new HashSet());
                bsv = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.MR();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            bst = Collections.synchronizedSet(new HashSet());
            bsu = Collections.synchronizedSet(new HashSet());
            bsv = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void MR() {
        Date date = new Date();
        bsn = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        bsm = date.getTime();
    }

    private static synchronized void save() {
        if (axg == null) {
            return;
        }
        Accumulator.MR();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axg));
            objectOutputStream.writeObject(bsl);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dH(String string) {
        Number number = (Number)bsl.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dI(String string) {
        Set set = (Set)bsl.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, new Double(d2));
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, new Double(d4));
        }
    }

    static {
        bsl = Accumulator.MQ();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

