/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.http.utils.MimeTypes;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.u;
import com.inet.report.renderer.pdf.PDFConfig;
import com.inet.report.renderer.pdf.e;
import com.inet.report.renderer.pdf.h;
import com.inet.report.renderer.pdf.i;
import com.inet.report.renderer.pdf.k;
import com.inet.report.renderer.pdf.model.ai;
import com.inet.report.renderer.pdf.model.al;
import com.inet.report.renderer.pdf.model.ar;
import com.inet.report.renderer.pdf.model.m;
import com.inet.report.renderer.pdf.model.o;
import com.inet.report.renderer.pdf.model.r;
import com.inet.report.renderer.pdf.model.structure.g;
import com.inet.report.renderer.pdf.sec.a;
import com.inet.report.renderer.pdf.sec.b;
import com.inet.report.renderer.pdf.sec.f;
import com.inet.shared.utils.MemoryStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

public class PDFDocumentWriter
extends com.inet.report.renderer.doc.a {
    public static final String NAVIGATION = "navview";
    public static final String NAVIGATION_OUTLINES = "bookmarks";
    public static final String NAVIGATION_THUMBNAILS = "pages";
    public static final String OWNER_PASS = "opass";
    public static final String USER_PASS = "upass";
    public static final String ALG_TYPE = "algtype";
    public static final String ENCRYPT_METADATA = "encryptmeta";
    public static final String USERPROP_PDFA = "pdfa";
    public static final String USERPROP_PDFFASTWEBVIEW = "fastwebview";
    public static final String PDF_STRUCTURE_TREE = "pdftags";
    private boolean aTW = false;
    private b aTX;
    private boolean aTY;
    private boolean aTZ;
    private Date IW;
    private boolean aUa;
    private MemoryStream CW = null;
    private e aUb;
    private m aSX;
    private i aUc;
    private k aUd;
    private int aUe;
    private h aUf;
    private Properties JO;
    private al aUg;

    public PDFDocumentWriter(PDFConfig config) {
        this.aUb = new e(config);
        this.aSX = this.aUb.Gi();
        this.aUc = new i(this.aUb, this.aSX);
        this.aUd = new k(this.aSX.Hl(), this.aUc, this.aSX.Ho().isReplaceMissingChars());
    }

    @Override
    public Layout getLayout() {
        return this.aUc;
    }

    @Override
    public u getCapabilities() {
        return this.aUd;
    }

    @Override
    public void setUserProperties(Properties props) {
        super.setUserProperties(props);
        this.JO = props;
        boolean bl2 = this.aSX.Ho().isCreateStructure();
        this.k(props);
        if (props != null) {
            String string;
            boolean bl3 = "true".equalsIgnoreCase(props.getProperty(USERPROP_PDFFASTWEBVIEW, "false"));
            this.aSX.Ho().setLinear(bl3);
            if (bl3) {
                this.aUf = new h(this.aSX);
            }
            if ("true".equals(string = props.getProperty(PDF_STRUCTURE_TREE))) {
                bl2 = true;
            } else if ("false".equals(string)) {
                bl2 = false;
            }
        }
        if (bl2) {
            g g2 = new g(this.aSX);
            this.aSX.a(g2);
            this.aUc.a(g2);
        }
    }

    @Override
    public void setMetaData(DocumentMetaData metaData) {
        super.setMetaData(metaData);
        this.aUb.setMetaData(metaData);
        this.aTY = metaData.isClipboardEnabled();
        this.aUa = metaData.isGroupTreeVisible();
        this.aTZ = metaData.isPrintingEnabled();
        this.IW = metaData.getPrintTime();
        this.Gm();
        if (this.JO == null) {
            return;
        }
        if (metaData.getProperty("facturx-level") != null) {
            this.aSX.Ho().setPdfa3(true);
        } else {
            String string = this.JO.getProperty(USERPROP_PDFA, "false");
            if ("true".equalsIgnoreCase(string)) {
                if (this.aTW) {
                    BaseUtils.error("Documents which are encrypted or constraint the access to their content can not be exported in PDF/A format");
                } else {
                    this.aSX.Ho().setPDFA(true);
                }
            }
        }
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aUb.D(width, height, topMargin, leftMargin);
    }

    @Override
    public void startDocument() throws ReportException {
        super.startDocument();
        this.aUb.start();
        this.aUe = 0;
        g g2 = this.aSX.Hp();
        if (g2 != null) {
            this.aUb.Gj().a(g2.IN());
            DocumentMetaData documentMetaData = this.getMetaData();
            if (documentMetaData != null) {
                Locale locale = documentMetaData.getResourceLocale();
                String string = locale.toString();
                this.aUb.Gj().da(string);
            }
        }
    }

    @Override
    public void startPage() throws ReportException {
        boolean bl2;
        super.startPage();
        boolean bl3 = bl2 = this.CW == null;
        if (!bl2) {
            this.cq(false);
        }
        this.aUg = this.aUc.Gw();
        this.CW = new MemoryStream();
        if (this.aUf != null) {
            this.aUf.a(this.aUg);
        } else if (bl2) {
            this.aUb.ab(this.CW);
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
    }

    private void cq(boolean bl2) throws ReportException {
        if (bl2) {
            this.aUc.Gz();
        }
        this.aUc.endPage();
        if (this.aUf == null) {
            this.aUb.c(this.CW, this.getPages().getPageCount() + 1, this.aUe);
            byte[] byArray = this.CW.toByteArray();
            this.getPages().addPage(byArray);
            this.aUe += byArray.length;
            this.aUg.dispose();
        }
        this.CW = null;
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        int n2;
        super.endDocument();
        if (this.CW != null) {
            this.cq(true);
        }
        if (this.aUf != null) {
            n2 = this.aUf.a(this.aUb, this.getPages());
        } else {
            object = new MemoryStream();
            this.aUb.ac((MemoryStream)object);
            byte[] byArray = object.toByteArray();
            this.getPages().addPage(byArray);
            n2 = this.aUe + byArray.length;
        }
        object = this.aUc.Gy();
        if (object != null) {
            ((ar)object).a(this.getPages(), n2);
        }
    }

    private void Gm() {
        String string;
        boolean bl2 = true;
        if (this.JO != null && (string = this.JO.getProperty(ENCRYPT_METADATA, "true")) != null && string.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        int n2 = a.k(this.aTY, this.aTZ);
        String[] stringArray = a.l(this.JO);
        if (stringArray[0] == null) {
            if (!this.aTY || !this.aTZ) {
                this.aTW = true;
                stringArray[0] = "DEFAULT_ALG";
            }
        } else {
            this.aTW = true;
        }
        byte[] byArray = null;
        if (this.aTW) {
            byArray = a.f(this.IW.getTime());
        }
        if (this.aTW) {
            this.aTX = f.a(stringArray[0], stringArray[1], stringArray[2], n2, bl2, this.IW, byArray);
        }
        this.aUb.a(this.aTX, byArray);
    }

    private void k(Properties properties) {
        if (properties != null) {
            String string = properties.getProperty(NAVIGATION, "");
            if (NAVIGATION_OUTLINES.equals(string) || NAVIGATION_THUMBNAILS.equals(string)) {
                BaseUtils.info("PDF Export navigation type: " + string);
                this.aUb.cQ(string);
            }
        } else if (BaseUtils.isDebug()) {
            BaseUtils.debug("pdf export: user properties not defined");
        }
    }

    @Override
    public void addAttchment(@Nonnull String fileName, @Nonnull byte[] data) {
        if (!this.aUb.Gi().Ho().isPDFA()) {
            com.inet.report.renderer.pdf.model.k k2 = this.aUb.Gj();
            ai ai2 = k2.Hj();
            if (ai2 == null) {
                ai2 = new ai(this.aSX);
            }
            String string = MimeTypes.getMimeType((String)fileName).split(";")[0];
            o o2 = new o(this.aSX, data, string, this.IW);
            r r2 = new r(this.aSX, o2, fileName, null);
            ai2.a(r2);
            k2.a(ai2);
        }
    }
}

