/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.java;

import com.inet.lib.util.ColorUtils;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import com.inet.report.output.MemoryOutput;
import com.inet.report.renderer.doc.u;
import com.inet.report.renderer.java.b;
import com.inet.report.renderer.java.f;
import com.inet.shared.utils.MemoryStream;
import com.inet.viewer.PrinterJobProgress;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.print.Transparency;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class a
extends b {
    private MemoryOutput aMM = new MemoryOutput();
    private PageFormat aMN;
    private boolean aMO;
    private String aMP;
    private Color aMQ;
    private int aMR = 0;
    private Properties JO;

    public a(String string) {
        super(new f(){

            @Override
            public u.a yQ() {
                return u.a.aCE;
            }
        });
        this.aMP = string;
    }

    @Override
    protected DocumentOutput Ek() {
        return this.aMM;
    }

    @Override
    public void startDocument() throws ReportException {
        String string;
        super.startDocument();
        if (this.JO != null && (string = this.JO.getProperty("background")) != null && !string.isEmpty()) {
            if (string.startsWith("#")) {
                this.aMQ = new Color(Integer.parseInt(string.substring(1), 16));
            } else {
                boolean bl2 = string.toLowerCase().startsWith("0x");
                int n2 = bl2 ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string);
                this.aMQ = ColorUtils.toJavaColor((int)n2);
            }
        }
        if (this.aMP.equals("jpg") || this.aMP.equals("jpeg") || this.aMP.equals("bmp") || this.aMP.equals("gif")) {
            if (this.aMQ == null) {
                this.aMQ = Color.WHITE;
            }
            this.aMO = false;
        } else {
            this.aMO = this.aMQ == null || this.aMQ.getAlpha() == 255;
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
        try {
            int n2 = (int)(this.aMN.getWidth() + 0.5);
            int n3 = (int)(this.aMN.getHeight() + 0.5);
            int n4 = this.aMO ? 2 : 1;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, n4);
            Graphics graphics = bufferedImage.getGraphics();
            if (this.aMQ != null) {
                graphics.setColor(this.aMQ);
                graphics.fillRect(0, 0, n2, n3);
            }
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintRequestAttributeSet.add(new Transparency());
            a a2 = new a(this.aMM);
            PrinterJobProgress printerJobProgress = new PrinterJobProgress(null, null, hashPrintRequestAttributeSet, a2){

                @Override
                public void showError(Throwable th) {
                    BaseUtils.printStackTrace(th);
                }
            };
            int n5 = printerJobProgress.print(graphics, this.aMN, this.aMR++);
            graphics.dispose();
            if (n5 != 0) {
                throw new IllegalStateException("Page was not printed to image.");
            }
            MemoryStream memoryStream = new MemoryStream();
            boolean bl2 = ImageIO.write((RenderedImage)bufferedImage, this.aMP, (OutputStream)memoryStream);
            if (!bl2) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.ImgWrtNotFound, this.aMP);
            }
            this.getPages().addPage(memoryStream.toByteArray());
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    @Override
    public void setUserProperties(Properties props) {
        super.setUserProperties(props);
        this.JO = props;
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aMN = new PageFormat();
        Paper paper = new Paper();
        width /= 15;
        height /= 15;
        int n2 = leftMargin / 15;
        int n3 = topMargin / 15;
        int n4 = rightMargin / 15;
        int n5 = bottomMargin / 15;
        if (this.JO != null) {
            double d2 = 1.0;
            try {
                String string = this.JO.getProperty("zoom");
                if (string != null) {
                    int n6;
                    if ((string = string.trim()).endsWith("%")) {
                        n6 = 100;
                        string = string.substring(0, string.length() - 1).trim();
                    } else {
                        n6 = 1;
                    }
                    d2 = Double.parseDouble(string) / (double)n6;
                } else {
                    String string2 = this.JO.getProperty("width");
                    if (string2 != null) {
                        double d3 = Integer.parseInt(string2);
                        d2 = d3 / (double)width;
                    } else {
                        String string3 = this.JO.getProperty("height");
                        if (string3 != null) {
                            double d4 = Integer.parseInt(string3);
                            d2 = d4 / (double)height;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
            }
            if (d2 != 1.0) {
                if (d2 <= 0.0) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.negativeParam, "zoom", String.valueOf(d2));
                }
                width = (int)((double)width * d2);
                height = (int)((double)height * d2);
                n2 = (int)((double)n2 * d2);
                n3 = (int)((double)n3 * d2);
                n4 = (int)((double)n4 * d2);
                n5 = (int)((double)n5 * d2);
            }
        }
        if (width <= 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.negativeParam, "width", String.valueOf(width));
        }
        if (height <= 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.negativeParam, "height", String.valueOf(height));
        }
        long l2 = (long)width * (long)height;
        if (l2 > 0x1000000L) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.ImgToLarge, String.valueOf(0x1000000), String.valueOf(l2));
        }
        if (landscape) {
            this.aMN.setOrientation(0);
            int n7 = width;
            width = height;
            height = n7;
            n7 = n2;
            n2 = n3;
            n3 = n4;
            n4 = n5;
            n5 = n7;
        }
        paper.setSize(width, height);
        paper.setImageableArea(n2, n3, width - n2 - n4, height - n3 - n5);
        this.aMN.setPaper(paper);
    }

    private static class a
    implements RenderData {
        private final DocumentOutput nR;

        a(DocumentOutput documentOutput) {
            this.nR = documentOutput;
        }

        @Override
        public byte[] getFontData(int idx) {
            return this.nR.getFontData(idx - 1);
        }

        @Override
        public int getPageCount() throws ViewerException {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isPageLimitExceeded() {
            return this.nR.isPageLimitExceeded();
        }

        @Override
        public byte[] getPageData(int idx) throws ViewerException {
            return this.nR.getPageData(idx);
        }

        @Override
        public RenderData getCopy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getExportChunkCount(Properties arg0) throws ViewerException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getGroupTree() throws ViewerException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getNextExportChunk() throws ViewerException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Properties getProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReportLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReportProperty(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReportTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPromptOnRefresh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] refreshPageData(int arg0) throws ViewerException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resetServerCacheTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] search(String arg0, int arg1, int arg2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPromptOnRefresh(boolean arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReportLocation(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReportProperty(String arg0, String arg1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReportTitle(String arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void stop() {
            throw new UnsupportedOperationException();
        }
    }
}

