/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.debug;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.IFormulaData;
import com.inet.report.formula.a;
import com.inet.report.formula.ast.w;
import com.inet.report.formula.debug.BreakPointProvider;
import com.inet.report.formula.debug.PropertyKeyGenerator;
import com.inet.report.formula.userfunctions.UserFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;

public class GenericBreakPointProvider
implements BreakPointProvider {
    public static final String METADATA_KEY = "BreakPointData";
    private transient Map<Serializable, Set<Integer>> anL = new WeakHashMap<Serializable, Set<Integer>>();
    private Map<Serializable, Set<Integer>> anM = new HashMap<Serializable, Set<Integer>>();
    private Engine bm;
    private boolean breakOnException = false;
    private transient Map<BreakPointProvider.ChangeListener, Object> anj = new HashMap<BreakPointProvider.ChangeListener, Object>();

    public GenericBreakPointProvider(Engine engine) {
        this.bm = engine;
    }

    @Override
    public void toggleBreakPoint(IFormulaData formulaContainer, int line, boolean add) {
        if (formulaContainer == null) {
            return;
        }
        boolean bl2 = false;
        Set<Integer> set = this.anL.get(formulaContainer);
        if (add) {
            if (set == null) {
                set = new HashSet<Integer>();
                this.anL.put(formulaContainer, set);
            }
            bl2 = set.add(line);
        } else {
            if (set == null) {
                return;
            }
            bl2 = set.remove(line);
            if (set.size() == 0) {
                this.anL.remove(formulaContainer);
            }
        }
        if (bl2) {
            for (BreakPointProvider.ChangeListener changeListener : this.anj.keySet()) {
                changeListener.breakPointChanged(formulaContainer, line, add);
            }
        }
    }

    @Override
    public boolean isBreakPoint(IFormulaData formulaContainer, int line) {
        Set<Integer> set = this.anL.get(formulaContainer);
        return set != null ? set.contains(line) : false;
    }

    @Override
    public boolean isActive() {
        if (this.breakOnException) {
            return true;
        }
        for (Set<Integer> set : this.anL.values()) {
            if (set == null || set.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getBreakPoints(IFormulaData formulaContainer) {
        Set<Integer> set = this.anL.get(formulaContainer);
        if (set == null || set.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(set);
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public List<FormulaField> getFormulasWithBreakPoints() {
        ArrayList<FormulaField> arrayList = new ArrayList<FormulaField>();
        System.gc();
        for (Map.Entry<Serializable, Set<Integer>> entry : this.anL.entrySet()) {
            if (!(entry.getKey() instanceof FormulaField) || entry.getValue().size() <= 0) continue;
            arrayList.add((FormulaField)entry.getKey());
        }
        return arrayList;
    }

    @Override
    public List<UserFunction> getFunctionsWithBreakPoints() {
        ArrayList<UserFunction> arrayList = new ArrayList<UserFunction>();
        for (Map.Entry<Serializable, Set<Integer>> entry : this.anL.entrySet()) {
            if (!(entry.getKey() instanceof UserFunction) || entry.getValue().size() <= 0) continue;
            arrayList.add((UserFunction)entry.getKey());
        }
        return arrayList;
    }

    @Override
    public boolean hasBreakPoint(IFormulaData formulaContainer) {
        Set<Integer> set = this.anL.get(formulaContainer);
        if (set != null && set.size() > 0) {
            return true;
        }
        if (formulaContainer instanceof FormulaField) {
            Evaluable evaluable = ((FormulaField)formulaContainer).getFormulaTree();
            a<w> a2 = new a<w>(evaluable, w.class);
            while (a2.hasNext()) {
                w w2 = a2.pR();
                set = this.anL.get(w2.sh());
                if (set == null || set.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void checkJson(Engine e2) throws ReportException {
        for (int i2 = 0; i2 < e2.getSubReportCount(); ++i2) {
            GenericBreakPointProvider.checkJson(e2.getSubReport(i2));
        }
        PropertyKeyGenerator propertyKeyGenerator = new PropertyKeyGenerator(e2);
        Properties properties = e2.getMetaProperties();
        if (properties == null || !properties.containsKey(METADATA_KEY)) {
            return;
        }
        String string = properties.getProperty(METADATA_KEY);
        if (string == null || string.isEmpty()) {
            return;
        }
        Export export = (Export)new Json().fromJson(string, Export.class);
        if ((export.breakPoints == null || export.breakPoints.isEmpty()) && !export.breakOnException) {
            return;
        }
        GenericBreakPointProvider genericBreakPointProvider = new GenericBreakPointProvider(e2);
        genericBreakPointProvider.breakOnException = export.breakOnException;
        Fields fields = e2.getFields();
        if (export.breakPoints != null) {
            for (Map.Entry<FieldDesc, Set<Integer>> entry : export.breakPoints.entrySet()) {
                IFormulaData iFormulaData = null;
                FieldDesc fieldDesc = entry.getKey();
                if (fieldDesc == null || (iFormulaData = fieldDesc.isFunction ? fields.getFunction(fieldDesc.name) : (fieldDesc.propsKey != null ? propertyKeyGenerator.getFieldForKey(fieldDesc.propsKey) : fields.getFormulaField(fieldDesc.name))) == null) continue;
                genericBreakPointProvider.anL.put(iFormulaData, entry.getValue());
            }
        }
        properties.put("BreakPointProvider", genericBreakPointProvider);
        properties.remove(METADATA_KEY);
    }

    public String toJson() {
        PropertyKeyGenerator propertyKeyGenerator = new PropertyKeyGenerator(this.bm);
        Export export = new Export();
        export.breakPoints = new HashMap();
        for (Serializable serializable : this.anL.keySet()) {
            FieldDesc fieldDesc = new FieldDesc(serializable, propertyKeyGenerator);
            Set<Integer> set = this.anL.get(serializable);
            if (set == null || set.isEmpty()) continue;
            export.breakPoints.put(fieldDesc, set);
        }
        export.breakOnException = this.breakOnException;
        return new Json().toJson((Object)export);
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        for (Map.Entry<Serializable, Set<Integer>> entry : this.anL.entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
            this.anM.put(entry.getKey(), entry.getValue());
        }
        aOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
        this.anj = new HashMap<BreakPointProvider.ChangeListener, Object>();
        this.anL = new WeakHashMap<Serializable, Set<Integer>>();
        this.anL.putAll(this.anM);
        this.anM.clear();
    }

    @Override
    public boolean isBreakOnException() {
        return this.breakOnException;
    }

    @Override
    public void setBreakOnException(boolean doBreak) {
        boolean bl2 = doBreak != this.breakOnException;
        this.breakOnException = doBreak;
        if (bl2) {
            for (BreakPointProvider.ChangeListener changeListener : this.anj.keySet()) {
                changeListener.exceptionBreakChanged(doBreak);
            }
        }
    }

    @Override
    public void addChangeListener(BreakPointProvider.ChangeListener listener) {
        this.anj.put(listener, new Object());
    }

    @Override
    public void removeChangeListener(BreakPointProvider.ChangeListener listener) {
        this.anj.remove(listener);
    }

    @JsonData
    public static class FieldDesc
    implements Serializable {
        private boolean isFunction;
        private String name;
        private String propsKey;

        private FieldDesc() {
        }

        private FieldDesc(Object reference, PropertyKeyGenerator gen) {
            if (reference instanceof FormulaField) {
                this.isFunction = false;
                FormulaField formulaField = (FormulaField)reference;
                this.name = formulaField.getName();
                this.propsKey = gen.getKeyForField(formulaField);
                if (this.name == null) {
                    this.name = this.propsKey;
                }
            } else if (reference instanceof UserFunction) {
                this.isFunction = true;
                this.name = ((UserFunction)reference).getName();
            } else {
                throw new IllegalArgumentException(String.valueOf(reference) + " is neither a formula nor a function");
            }
            if (this.name == null) {
                throw new IllegalArgumentException(String.valueOf(reference) + " has no name!");
            }
        }

        public String toString() {
            return Boolean.toString(this.isFunction) + "|" + this.name + (String)(this.propsKey != null ? "|" + this.propsKey : "");
        }

        public static FieldDesc valueOf(String json) {
            if (json == null || !json.contains("|")) {
                return null;
            }
            int n2 = json.indexOf("|");
            if (n2 > 0) {
                FieldDesc fieldDesc = new FieldDesc();
                fieldDesc.isFunction = Boolean.valueOf(json.substring(0, n2));
                int n3 = json.lastIndexOf(124);
                if (n3 > n2) {
                    fieldDesc.name = json.substring(n2 + 1, n3);
                    fieldDesc.propsKey = json.substring(n3 + 1);
                } else {
                    fieldDesc.name = json.substring(n2 + 1);
                }
                return fieldDesc;
            }
            return null;
        }

        public int hashCode() {
            return this.name.hashCode() + Boolean.valueOf(this.isFunction).hashCode() + (this.propsKey != null ? this.propsKey.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FieldDesc) {
                FieldDesc fieldDesc = (FieldDesc)obj;
                return this.isFunction == fieldDesc.isFunction && this.name.equals(fieldDesc.name) && this.propsKey != null ? this.propsKey.equals(fieldDesc.propsKey) : fieldDesc.propsKey == null;
            }
            return false;
        }
    }

    @JsonData
    private static class Export
    implements Serializable {
        private HashMap<FieldDesc, Set<Integer>> breakPoints;
        private boolean breakOnException;

        private Export() {
        }
    }
}

