/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.encode.DecoderFactory;
import com.inet.report.encode.a;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.imageio.ImageIO;

public class ErrDecoder
extends a {
    private String afY;
    private ErrorCode afZ;

    public ErrDecoder() {
    }

    public ErrDecoder(String errMsg) {
        this.afY = errMsg;
    }

    public ErrDecoder(byte[] buffer, int offset, int length, String errMsg) {
        super(buffer, offset, length);
        this.afY = errMsg;
    }

    public ErrDecoder(byte[] buffer, int offset, int length, ErrorCode errorCode) {
        super(buffer, offset, length);
        this.afZ = errorCode;
        Object[] objectArray = new Object[]{};
        this.afY = errorCode.getMsg(objectArray);
    }

    public String getErrorMessage() {
        return this.afY;
    }

    public ReportException getReportException() {
        if (this.afZ != null) {
            return ReportExceptionFactory.createReportException(this.afZ, new Object[0]);
        }
        return ReportExceptionFactory.createReportException(ReportErrorCode.PictureError, this.afY);
    }

    @Override
    public BufferedImage decodeImage(int width, int height) {
        return DecoderFactory.getErrorImage(this.pA(), width, height);
    }

    @Override
    public byte[] getBuffer() {
        if (this.buffer == null) {
            BufferedImage bufferedImage = this.getImage(100, 100);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                this.buffer = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.buffer;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.afY);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.afY = (String)in.readObject();
    }

    private String pA() {
        return Msg.getMsg(this.afY, new Object[0]);
    }

    @Override
    public boolean isAutoScaledAndAligned() {
        return true;
    }
}

