/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.util.Encryption;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.a;
import com.inet.report.config.datasource.b;
import com.inet.report.config.datasource.c;
import com.inet.report.i18n.ReportErrorCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSourceConfigurationXMLFileStore {
    public static void saveToReportXMLFile(DataSourceConfiguration dsc, Appendable fsb, int depth) {
        try {
            fsb.append(BaseUtils.getIndent(depth));
            fsb.append("<DataSourceConfiguration name=\"").append(DataSourceConfigurationXMLFileStore.xmlEncode(dsc.getConfigurationName())).append("\">\n");
            Properties properties = dsc.getProperties();
            boolean bl2 = dsc.isSavePassword();
            Object[] objectArray = properties.keySet().toArray();
            ++depth;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                String string = objectArray[i2].toString();
                String string2 = properties.getProperty(string);
                if (string2 == null) {
                    string2 = "";
                }
                if (string.equalsIgnoreCase("password")) {
                    if (!bl2) continue;
                    string2 = Encryption.encrypt((String)string2);
                }
                string = DataSourceConfigurationXMLFileStore.xmlEncode(string);
                string2 = DataSourceConfigurationXMLFileStore.xmlEncode(string2);
                fsb.append(BaseUtils.getIndent(depth));
                fsb.append("<property name=\"").append(string).append("\" value=\"").append(string2).append("\"/>");
                fsb.append("\n");
            }
            fsb.append(BaseUtils.getIndent(--depth));
            fsb.append("</DataSourceConfiguration>\n");
        }
        catch (IOException iOException) {
            ErrorCode.throwAny((Throwable)iOException);
        }
    }

    public void saveDataSourceConfigurationToXML(DataSourceConfiguration[] configs, OutputStream fos) throws ReportException {
        try (UTF8StreamWriter uTF8StreamWriter = new UTF8StreamWriter(fos);){
            uTF8StreamWriter.append((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DataSourceConfigurations>\n");
            for (int i2 = 0; i2 < configs.length; ++i2) {
                DataSourceConfiguration dataSourceConfiguration = configs[i2];
                if (dataSourceConfiguration == null) continue;
                DataSourceConfigurationXMLFileStore.saveToReportXMLFile(dataSourceConfiguration, (Appendable)uTF8StreamWriter, 1);
            }
            uTF8StreamWriter.append((CharSequence)"</DataSourceConfigurations>");
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    public DataSourceConfiguration[] readDataSourceConfigurationFromXML(InputStream input, int scope) throws ReportException {
        try {
            c c2 = new c();
            a a2 = c2.a(input);
            if (a2 == null || !"DataSourceConfigurations".equals(a2.getName())) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.invalidDataSourceFile, "");
            }
            b b2 = a2.no();
            DataSourceConfiguration[] dataSourceConfigurationArray = new DataSourceConfiguration[b2.np()];
            for (int i2 = 0; i2 < dataSourceConfigurationArray.length; ++i2) {
                a a3 = b2.cN(i2);
                dataSourceConfigurationArray[i2] = this.a(a3, scope, null);
            }
            return dataSourceConfigurationArray;
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.invalidDataSourceFile, "");
        }
    }

    DataSourceConfiguration a(InputStream inputStream, int n2, @Nullable GUID gUID) throws ReportException {
        try {
            return this.a(new c().a(inputStream), n2, gUID);
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.invalidDataSourceFile, "");
        }
    }

    @Nonnull
    private DataSourceConfiguration a(a a2, int n2, @Nullable GUID gUID) throws ReportException {
        if (a2 == null || !"DataSourceConfiguration".equals(a2.getName())) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.invalidDataSourceFile, "");
        }
        String string = a2.aO("name");
        string = DataSourceConfigurationXMLFileStore.xmlDecode(string);
        DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(string, n2, gUID);
        b b2 = a2.no();
        for (int i2 = 0; i2 < b2.np(); ++i2) {
            a a3 = b2.cN(i2);
            String string2 = a3.aO("name");
            String string3 = a3.aO("value");
            string2 = DataSourceConfigurationXMLFileStore.xmlDecode(string2);
            string3 = DataSourceConfigurationXMLFileStore.xmlDecode(string3);
            if (string2.equalsIgnoreCase("password")) {
                string3 = Encryption.decrypt((String)string3);
            }
            dataSourceConfiguration.addProperty(string2, string3);
        }
        return dataSourceConfiguration;
    }

    public static String xmlEncode(String s2) {
        StringBuffer stringBuffer = new StringBuffer(s2.length());
        char[] cArray = s2.toCharArray();
        block6: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            switch (c2) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String xmlDecode(String s2) {
        s2 = s2.replace("&quot;", "\"");
        s2 = s2.replace("&gt;", ">");
        s2 = s2.replace("&lt;", "<");
        s2 = s2.replace("&amp;", "&");
        return s2;
    }
}

