/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.jfree.chart.labels.PieSectionLabelGenerator;
import com.inet.jfree.chart.labels.StandardPieSectionLabelGenerator;
import com.inet.lib.list.IntList;
import com.inet.lib.util.ColorUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.dataset.BaseDataset;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.PieDataset;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.PieLegendLayout;
import com.inet.report.chart.plot.PieStyle;
import com.inet.report.i;
import java.awt.Color;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class PiePlot
extends AbstractPlot {
    public static final PieStyle DEFAULT_STYLE = PieStyle.PIE2D;
    public static final double DEFAULT_ROTATION_ANGLE = 90.0;
    public static final double DEFAULT_ITEM_LABEL_GAP = 0.05;
    public static final int DEFAULT_ITEM_LABEL_BACKGROUND_COLOR = ColorUtils.toCcColor((Color)new Color(255, 255, 192));
    public static final int DEFAULT_ITEM_LABEL_OUTLINE_COLOR = 0;
    public static final int DEFAULT_ITEM_LABEL_OUTLINE_STYLE = 1;
    public static final int DEFAULT_ITEM_LABEL_OUTLINE_WIDTH = 20;
    public static final double DEFAULT_EXPAND_PERCENT = 0.1;
    private PieStyle ZC;
    private PieDataset ZD;
    private boolean ZE;
    private double ZF;
    private double ZG;
    private int ZH;
    private int ZI;
    private int ZJ;
    private int ZK;
    private boolean ZL;
    private PieLegendLayout ZM;
    private int[] ZN;
    private double ZO;

    public PiePlot() {
        this(DEFAULT_STYLE);
    }

    public PiePlot(PieStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZC = style;
        this.setOutlineColor(AbstractPlot.DEFAULT_OUTLINE_COLOR);
        this.ZF = 90.0;
        this.ZG = 0.05;
        this.ZH = DEFAULT_ITEM_LABEL_BACKGROUND_COLOR;
        this.ZI = 0;
        this.ZJ = 1;
        this.ZK = 20;
        this.ZL = true;
        this.ZE = false;
        this.ZM = PieLegendLayout.SHOW_LABEL;
        this.ZN = new int[0];
        this.ZO = 0.1;
    }

    @Override
    public BaseDataset getDataset() {
        return this.ZD;
    }

    public void setDataset(PieDataset dataset) {
        if (dataset == null) {
            throw i.d("dataset");
        }
        this.ZD = dataset;
        this.ZD.updateReferences();
    }

    @Override
    public ChartStyle getStyle() {
        return this.ZC;
    }

    public void setStyle(PieStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZC = style;
    }

    public boolean isIgnoreZeroValues() {
        return this.ZE;
    }

    public void setIgnoreZeroValues(boolean ignoreZeroValues) {
        this.ZE = ignoreZeroValues;
    }

    public double getRotationAngle() {
        return this.ZF;
    }

    public void setRotationAngle(double rotationAngle) {
        this.ZF = rotationAngle;
    }

    public double getItemLabelGap() {
        return this.ZG;
    }

    public void setItemLabelGap(double itemLabelGap) {
        if (itemLabelGap < 0.0) {
            throw new IllegalArgumentException("The gap is less than zero.");
        }
        if (itemLabelGap > 0.49) {
            itemLabelGap = 0.49;
        }
        this.ZG = itemLabelGap;
    }

    public boolean isDrawItemLabelOutline() {
        return this.ZL;
    }

    public void setDrawItemLabelOutline(boolean drawOutline) {
        this.ZL = drawOutline;
    }

    public int getItemLabelBackColor() {
        return this.ZH;
    }

    public void setItemLabelBackColor(int backgroundColor) {
        this.ZH = backgroundColor;
    }

    public int getItemLabelOutlineColor() {
        return this.ZI;
    }

    public void setItemLabelOutlineColor(int outlineColor) {
        if (outlineColor == -1) {
            throw i.e("outlineColor");
        }
        this.ZI = outlineColor;
    }

    public int getItemLabelOutlineStyle() {
        return this.ZJ;
    }

    public void setItemLabelOutlineStyle(int itemLabelOutlineStyle) {
        this.ZJ = itemLabelOutlineStyle;
    }

    public int getItemLabelOutlineWidth() {
        return this.ZK;
    }

    public void setItemLabelOutlineWidth(int itemLabelOutlineWidth) {
        if (itemLabelOutlineWidth < 1) {
            throw new IllegalArgumentException("The parameter 'itemLabelOutlineWidth' should be greater zero.");
        }
        this.ZK = itemLabelOutlineWidth;
    }

    public PieLegendLayout getLegendLayout() {
        return this.ZM;
    }

    public void setLegendLayout(PieLegendLayout legendLayout) {
        if (legendLayout == null) {
            throw i.d("legendLayout");
        }
        this.ZM = legendLayout;
    }

    public int[] getSectionIndexes() {
        return (int[])this.ZN.clone();
    }

    public void setSectionIndexes(int[] sectionIndexes) {
        if (sectionIndexes == null) {
            throw i.d("sectionIndexes");
        }
        this.ZN = (int[])sectionIndexes.clone();
    }

    public double getExpandPercent() {
        return this.ZO;
    }

    public void setExpandPercent(double expandPercent) {
        if (expandPercent < 0.0) {
            throw new IllegalArgumentException("Parameter 'expandPercent' less than zero.");
        }
        if (expandPercent < 0.1) {
            expandPercent = 0.1;
        }
        this.ZO = expandPercent;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart) {
        if (this.getDataset() != null) {
            LabelProvider labelProvider = this.getDataset().getLabelProvider();
            a.setAutoTitle(chart.getHeaderTitle(), labelProvider.getLabel(0));
        }
    }

    PieSectionLabelGenerator c(Locale locale) {
        ChartFormat chartFormat;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (this.getItemLabelFormat() instanceof NumberFormat) {
            chartFormat = this.getItemLabelFormat();
            chartFormat.setFormatingProperties(new FormatingProperties(TimeZone.getDefault(), locale, -1));
            numberFormat = (NumberFormat)((Object)chartFormat);
        }
        chartFormat = null;
        boolean bl2 = i.a(this.getItemLabelFormat());
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("{2}");
        } else {
            stringBuilder.append("{1}");
        }
        if (this.isShowValue()) {
            if (this.isShowLabel()) {
                stringBuilder = new StringBuilder("{0}   ").append((CharSequence)stringBuilder);
            }
            chartFormat = new StandardPieSectionLabelGenerator(stringBuilder.toString(), numberFormat, numberFormat);
        } else if (this.isShowLabel()) {
            chartFormat = new StandardPieSectionLabelGenerator("{0}", numberFormat, numberFormat);
        }
        return chartFormat;
    }

    @Override
    protected StringBuilder cB(int n2) {
        StringBuilder stringBuilder = super.cB(n2);
        if (this.getItemLabelBackColor() != DEFAULT_ITEM_LABEL_BACKGROUND_COLOR) {
            f.b(stringBuilder, n2, "ItemLabelBackground", "value", String.valueOf(this.getItemLabelBackColor()));
        }
        if (this.getItemLabelGap() != 0.05) {
            f.b(stringBuilder, n2, "ItemLabelGap", String.valueOf(this.getItemLabelGap()));
        }
        if (!this.isDrawItemLabelOutline()) {
            f.b(stringBuilder, n2, "DrawItemLabelOutline", String.valueOf(this.isDrawItemLabelOutline()));
        }
        if (this.getItemLabelOutlineColor() != 0 || this.getItemLabelOutlineStyle() != 1 || this.getItemLabelOutlineWidth() != 20) {
            f.a(stringBuilder, "ItemLabelOutline", n2, this.getItemLabelOutlineColor(), this.getItemLabelOutlineStyle(), this.getItemLabelOutlineWidth());
        }
        if (this.isIgnoreZeroValues()) {
            f.b(stringBuilder, n2, "IgnoreZeroValues", String.valueOf(this.isIgnoreZeroValues()));
        }
        if (!this.getLegendLayout().equals(PieLegendLayout.SHOW_LABEL)) {
            stringBuilder.append((CharSequence)this.getLegendLayout().cG(n2));
        }
        if (this.getRotationAngle() != 90.0) {
            f.b(stringBuilder, n2, "RotationAngle", String.valueOf(this.getRotationAngle()));
        }
        if (this.getSectionIndexes().length > 0) {
            int[] nArray = this.getSectionIndexes();
            f.a(stringBuilder, n2, "SectionIndexes", null, false);
            for (int n3 : nArray) {
                f.b(stringBuilder, n2 + 1, "SectionIndex", String.valueOf(n3));
            }
            f.a(stringBuilder, n2, "SectionIndexes", null, true);
            f.b(stringBuilder, n2, "ExpandPercent", String.valueOf(this.getExpandPercent()));
        }
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        ++n2;
        if (this.getDataset() != null) {
            com.inet.report.chart.dataset.a.a(this.getDataset(), printWriter, n2);
        }
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("ItemLabelBackground")) {
                object = element2.getAttribute("color");
                if (((String)object).length() == 0) {
                    object = element2.getAttribute("value");
                }
                if (((String)object).length() <= 0) continue;
                int n2 = Integer.parseInt((String)object);
                this.setItemLabelBackColor(n2);
                continue;
            }
            if (element2.getNodeName().equals("ItemLabelGap")) {
                double d2;
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0 || !((d2 = Double.valueOf((String)object).doubleValue()) >= 0.0)) continue;
                this.setItemLabelGap(d2);
                continue;
            }
            if (element2.getNodeName().equals("DrawItemLabelOutline")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                this.setDrawItemLabelOutline(Boolean.valueOf((String)object));
                continue;
            }
            if (element2.getNodeName().equals("ItemLabeOutline") || element2.getNodeName().equals("ItemLabelOutline")) {
                object = element2.getAttribute("color");
                if (((String)object).length() > 0) {
                    int n3 = Integer.parseInt((String)object);
                    this.setItemLabelOutlineColor(n3);
                }
                if (((String)(object = element2.getAttribute("style"))).length() > 0) {
                    int n4 = Integer.parseInt((String)object);
                    if (n4 == 0 || n4 == 3 || n4 == 4 || n4 == 1) {
                        this.setItemLabelOutlineStyle(n4);
                    } else {
                        this.setItemLabelOutlineStyle(1);
                    }
                }
                if (((String)(object = element2.getAttribute("width"))).length() <= 0) continue;
                int n5 = Integer.parseInt((String)object);
                if (n5 < 1) {
                    this.setItemLabelOutlineWidth(20);
                    continue;
                }
                this.setItemLabelOutlineWidth(n5);
                continue;
            }
            if (element2.getNodeName().equals("IgnoreZeroValues")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                this.setIgnoreZeroValues(Boolean.valueOf((String)object));
                continue;
            }
            if (element2.getNodeName().equals("LegendLayout")) {
                this.setLegendLayout(PieLegendLayout.f(element2));
                continue;
            }
            if (element2.getNodeName().equals("RotationAngle")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                double d3 = Double.valueOf((String)object);
                this.setRotationAngle(d3);
                continue;
            }
            if (element2.getNodeName().equals("SectionIndexes")) {
                object = element2.getChildNodes();
                if (object.getLength() > 0) {
                    int[] nArray = new int[object.getLength()];
                    for (int i3 = 0; i3 < object.getLength(); ++i3) {
                        nArray[i3] = Integer.valueOf(object.item(i3).getAttributes().getNamedItem("value").getNodeValue());
                    }
                    this.setSectionIndexes(nArray);
                    continue;
                }
                String string = element2.getAttribute("value");
                IntList intList = new IntList();
                if (string.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    int n6 = Integer.valueOf(stringTokenizer.nextToken());
                    intList.addElement(n6);
                }
                this.setSectionIndexes(intList.toArray());
                continue;
            }
            if (element2.getNodeName().equals("ExpandPercent")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                double d4 = Double.valueOf((String)object);
                this.setExpandPercent(d4);
                continue;
            }
            if (!element2.getNodeName().equals("Dataset")) continue;
            this.c(element2, chart);
        }
    }

    protected void c(Element element, Chart2 chart2) {
        this.setDataset((PieDataset)com.inet.report.chart.dataset.a.b(element, chart2));
    }
}

