/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache.store;

import com.inet.annotations.PublicApi;
import com.inet.cache.StoreMap;
import com.inet.classloader.ObjectStreams;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cache.store.a;
import com.inet.report.cache.store.b;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;

@PublicApi
public class CachedOutput
implements DocumentOutput,
Comparable<CachedOutput> {
    private final long VP = System.currentTimeMillis();
    private final ReportCacheKey hw;
    private ReportGenerator VQ;
    private int VK;
    private int VR;
    private int VS;
    private byte VT;
    private boolean VU;
    private boolean VV;
    private long VW;
    private String VX;

    public CachedOutput(ReportCacheKey key, ReportGenerator engine) {
        this.hw = key;
        this.VQ = engine;
    }

    @Override
    public int getPageCount() {
        return this.VK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aH(String string) {
        StoreMap<a, byte[]> storeMap = b.Wb;
        synchronized (storeMap) {
            this.stop(string);
            this.me();
        }
    }

    private void me() {
        for (int i2 = -this.VR; i2 <= this.VK; ++i2) {
            b.Wb.remove((Object)new a(this.hw, i2));
        }
        this.VS = 0;
        this.VK = 0;
        this.VR = 0;
        this.VQ = null;
    }

    @Override
    public void clear() {
        this.me();
        this.VT = 0;
        this.VX = null;
    }

    @Override
    public byte[] getPageData(int idx) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = (byte[])b.Wb.get((Object)new a(this.hw, idx));
        if (byArray == null) {
            this.G(idx, this.VK);
        }
        return byArray;
    }

    private void G(int n2, int n3) {
        byte[] byArray;
        if (this.VT == 3 && (byArray = (byte[])b.Wb.get((Object)new a(this.hw, 1))) != null) {
            Throwable throwable = null;
            try {
                ObjectStreams.CacheObjectInputStream cacheObjectInputStream = new ObjectStreams.CacheObjectInputStream((InputStream)new ByteArrayInputStream(byArray));
                throwable = (Throwable)cacheObjectInputStream.readObject();
                cacheObjectInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (throwable != null) {
                ErrorCode.throwAny(throwable);
            }
        }
        ErrorCode.throwAny((Throwable)new PageOutOfRangeException(n2, n3, this.VX));
    }

    @Override
    public byte[] getGroupTree() {
        return (byte[])b.Wb.get((Object)new a(this.hw, 0));
    }

    @Override
    public void addPage(byte[] page) throws IllegalStateException {
        if (this.a("addPage()", this.VK + 1, page, 0)) {
            ++this.VK;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("addPage:" + this.VK);
            }
        }
    }

    @Override
    public void setPageData(byte[] page, int idx) throws IllegalStateException {
        this.a("setPageData()", idx, page, 0);
    }

    @Override
    public void setGroupTree(byte[] data) throws IllegalStateException {
        this.a("setGroupTree()", 0, data, 2);
    }

    @Override
    public void setErrorData(byte[] error) throws IllegalStateException {
        this.a("setErrorData()", 1, error, 3);
        if (this.VK == 0) {
            this.VK = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String cause) {
        StoreMap<a, byte[]> storeMap = b.Wb;
        synchronized (storeMap) {
            this.VX = cause;
            this.VT = 1;
            this.VQ = null;
            b.Wb.notifyAll();
        }
    }

    @Override
    public void addFontData(byte[] fontData) throws IllegalStateException {
        if (this.a("addFontData()", -1 - this.VR, fontData, 0)) {
            ++this.VR;
        }
    }

    @Override
    public void setFontData(byte[] fontData, int idx) throws IllegalStateException {
        this.a("setFontData()", -1 - idx, fontData, 0);
    }

    @Override
    public byte[] getFontData(int idx) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = (byte[])b.Wb.get((Object)new a(this.hw, -1 - idx));
        if (byArray == null) {
            this.G(idx, this.VR);
        }
        return byArray;
    }

    @Override
    public int getFontCount() {
        return this.VR;
    }

    @Override
    public void setPageLimitExceeded() {
        this.VU = true;
    }

    @Override
    public boolean isPageLimitExceeded() {
        return this.VU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsingTotalPage() {
        StoreMap<a, byte[]> storeMap = b.Wb;
        synchronized (storeMap) {
            this.VV = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string, int n2, @Nonnull byte[] byArray, int n3) {
        Object object;
        a a2 = new a(this.hw, n2);
        StoreMap<a, byte[]> storeMap = b.Wb;
        synchronized (storeMap) {
            switch (this.VT) {
                case 1: {
                    object = ": Rendering stopped: " + this.VX;
                    break;
                }
                case 2: {
                    object = ": Rendering finished";
                    break;
                }
                case 3: {
                    object = ": Rendering error";
                    break;
                }
                default: {
                    if (n2 != 0) {
                        byte[] byArray2 = (byte[])b.Wb.get((Object)a2);
                        this.VS += byArray.length;
                        if (byArray2 != null) {
                            this.VS -= byArray2.length;
                        }
                    }
                    b.Wb.put((Object)a2, (Object)byArray);
                    this.VT = (byte)n3;
                    if (n3 != 0) {
                        this.VQ = null;
                    }
                    b.Wb.notifyAll();
                    return true;
                }
            }
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Report Cache] Cache already closed: " + string + (String)object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] H(int n2, int n3) throws ReportException, PageOutOfRangeException, IllegalArgumentException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Illegal timeout value: " + n3);
        }
        a a2 = new a(this.hw, n2);
        long l2 = n3 == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)n3;
        int n4 = 5;
        long l3 = 0L;
        while (true) {
            StoreMap<a, byte[]> storeMap;
            StoreMap<a, byte[]> storeMap2 = storeMap = b.Wb;
            synchronized (storeMap2) {
                long l4;
                if (!this.VV || this.VT != 0) {
                    byte[] byArray = (byte[])storeMap.get((Object)a2);
                    if (byArray != null) {
                        return byArray;
                    }
                    if (this.VT != 0) {
                        if (this.VT == 3 && n2 != 1 && (byArray = (byte[])storeMap.get((Object)new a(this.hw, 1))) != null) {
                            return byArray;
                        }
                        throw new PageOutOfRangeException(n2, this.VK, this.VX);
                    }
                }
                if (l2 < (l4 = System.currentTimeMillis())) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.Timeout, this.hw);
                }
                long l5 = (l4 - this.VP) / 1000L;
                if (BaseUtils.isDebug() && l5 - l3 > (long)n4) {
                    BaseUtils.debug("[Report Cache] Rendering worker is running or queued since " + l5 + " seconds. Waiting for available of chunk " + n2 + " of report: " + String.valueOf(this.hw));
                    l3 = l5;
                    ++n4;
                }
                try {
                    storeMap.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    ReportExceptionFactory.createReportExceptionWithCause(interruptedException);
                }
            }
        }
    }

    int mf() {
        return this.VS;
    }

    int mg() {
        return this.VT;
    }

    public ReportCacheKey getKey() {
        return this.hw;
    }

    public ReportGenerator getEngine() {
        return this.VQ;
    }

    void a(long l2) {
        this.VW = l2;
    }

    @Override
    public int compareTo(CachedOutput o2) {
        return Long.compare(this.VW, o2.VW);
    }
}

