/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.ba;
import com.inet.report.bj;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.y;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

@PublicApi
public class SQLField
extends Field
implements ReferenceHolder,
Validatable {
    String LM = "";
    private Datasource qV;
    private Validity rV;
    private r qk = new r(this);

    SQLField(ba ren) {
        this(ren, ren.iY().getDatasource(0));
    }

    SQLField(ba ren, Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("Parameter 'datasource' is null");
        }
        this.type = 17;
        this.bB = ren;
        this.qV = datasource;
    }

    @Override
    public void setName(String name) throws ReportException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a SQL field can not be empty.");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.IB, name)) {
            throw y.b("SQLField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    public String getSQLExpression() {
        return this.LM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSQLExpression(String formula) throws ReportException {
        try {
            this.LM = formula;
            this.jH();
        }
        finally {
            this.updateReferences();
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (!(referenceHolderArray[i2] instanceof FormulaField)) continue;
                FormulaField formulaField = (FormulaField)referenceHolderArray[i2];
                formulaField.setFormula(formulaField.getFormula());
            }
            Fields.a(this.bB, this, 3);
        }
    }

    private void jH() {
        if (this.LM == null || this.LM.trim().isEmpty()) {
            this.valueType = -1;
            this.rV = new Validity(Validity.States.ERROR, ReportExceptionFactory.createReportException(ReportErrorCode.EmptySQLField, new Object[0]));
            return;
        }
        try (Connection connection = this.qV.getConnection();){
            if (connection == null) {
                this.valueType = 11;
                this.rV = new Validity(Validity.States.UNKNOWN, null);
            } else {
                Database database = (Database)this.qV.getDataFactory();
                this.valueType = database.a(this.bB.iY(), this.qV, this.LM, connection);
                this.rV = new Validity(Validity.States.VALID, null);
            }
        }
        catch (Throwable throwable) {
            if (BaseUtils.isWarning()) {
                BaseUtils.warning(throwable.toString());
            }
            this.valueType = -1;
            this.rV = new Validity(Validity.States.ERROR, throwable);
        }
    }

    void am(String string) {
        this.LM = string;
    }

    @Override
    Field[] K(int n2) {
        return new SQLField[n2];
    }

    public void changeAliasName(String oldAlias, String newAlias) {
        try {
            int n2 = 0;
            int n3 = 0;
            Object object = this.LM;
            StringTokenizer stringTokenizer = null;
            String string = "";
            stringTokenizer = new StringTokenizer((String)object, "\"'{() \n;./}", true);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().toUpperCase();
                n2 = string.length();
                if (string.equals(oldAlias.toUpperCase()) && ((String)object).charAt(n3 + n2) == '.') {
                    object = ((String)object).substring(0, n3) + newAlias + ((String)object).substring(n3 + n2, ((String)object).length());
                    n2 = newAlias.length();
                }
                n3 += n2;
            }
            this.LM = object;
        }
        catch (Exception exception) {
            BaseUtils.warning(exception);
        }
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + k.h(this.LM) + "\n");
        k.a(stringBuilder, n2, a.LQ.name(), this.qV.getDataSourceConfigurationName());
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qk.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qk.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qk.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qk.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qk.removeReferencedObject(reference);
    }

    @Override
    public final void setReferences() {
        PromptField[] promptFieldArray = this.bB.iV();
        if (promptFieldArray != null) {
            for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
                String string = promptFieldArray[i2].getPlaceholderName();
                int n2 = -1;
                while ((n2 = this.LM.indexOf(string, n2 + 1)) != -1) {
                    promptFieldArray[i2].addReferenceHolder(this);
                }
            }
        }
    }

    @Override
    public final void resetReferences() {
        this.qk.resetReferences();
        PromptField[] promptFieldArray = this.bB.iV();
        if (promptFieldArray != null) {
            for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
                String string = "{?" + promptFieldArray[i2].name + "}";
                int n2 = -1;
                while ((n2 = this.LM.indexOf(string, n2 + 1)) != -1) {
                    promptFieldArray[i2].removeReferenceHolder(this);
                }
            }
        }
    }

    private final void updateReferences() {
        this.resetReferences();
        this.setReferences();
    }

    @Override
    public boolean isUsed() {
        return super.isUsed();
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            String string = atts.getValue("value");
            switch (a.valueOf(tag)) {
                case LO: {
                    try {
                        this.setName(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        BaseUtils.printStackTrace(illegalArgumentException);
                        for (int i2 = 1; i2 < 10000; ++i2) {
                            try {
                                this.setName(string + " (" + i2 + ")");
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                continue;
                            }
                        }
                        if (this.getName() != null) break;
                        this.setName(string + " " + System.nanoTime());
                    }
                    break;
                }
                case LP: {
                    break;
                }
                case LQ: {
                    String string2 = string;
                    Datasource datasource = this.bB.iY().getDatasource(string2);
                    if (datasource == null) break;
                    this.qV = datasource;
                }
            }
            return null;
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
            return super.parseElement(group, tag, atts, parserMap);
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        try {
            if (this.valueType == -1) {
                this.setSQLExpression(text);
            } else {
                this.am(text);
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    @Override
    public Field duplicate(String copyName) {
        try {
            return this.bB.getFields().addSQLField(copyName, this.valueType, this.getSQLExpression(), this.qV);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("could not duplicate SQL field " + copyName, reportException);
        }
    }

    public Datasource getDatasource() {
        return this.qV;
    }

    @Override
    public Validity validate() {
        if (this.rV == null) {
            this.jH();
        }
        return this.rV;
    }

    @Override
    Object getValue() throws ReportException {
        bj bj2 = this.bB.gF();
        if (bj2.N() == null) {
            return "(" + this.LM + ")";
        }
        int n2 = this.da();
        if (n2 < 0) {
            this.ac(bj2.k(this));
            n2 = this.da();
        }
        return bj2.getObject(n2);
    }

    private static enum a {
        LO,
        LP,
        LQ;

    }
}

