/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.Fields;
import com.inet.report.FormulaDefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.FormulaRange;
import com.inet.report.PromptRequestWarning;
import com.inet.report.QueryValueProvider;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLValueProvider;
import com.inet.report.TableSource;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.bf;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.e;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.util.PromptUtils;
import com.inet.report.y;
import com.inet.viewer.PromptValue;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class PromptField
extends Field
implements ReferenceHolder {
    transient boolean valueSet;
    private ArrayList<DefaultValue> yX;
    private DynamicValueProvider yY;
    String yZ;
    TableSource za;
    String promptText;
    boolean zb;
    int zc;
    boolean range;
    Object zd;
    Object ze;
    String editMask = "";
    boolean zf;
    int zg;
    boolean zh;
    boolean zi;
    private boolean zj = true;
    private boolean descOnly;
    Integer zk;
    int zl;
    Object value;
    private Evaluable zm;
    public static final int DISCRETE_VALUE = 0;
    public static final int RANGE_VALUE = 1;
    public static final int DISCRETE_AND_RANGE_VALUE = 2;
    private r qk = new r(this);

    PromptField(ba ren) {
        this.type = 16;
        this.bB = ren;
        this.zj = true;
        this.zh = true;
    }

    @Override
    public final void setName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a prompt field cannot be empty");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (name.equalsIgnoreCase(this.name)) {
            try {
                this.rename(name);
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("Name not allowed", reportException);
            }
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.iV(), name)) {
            throw y.b("PromptField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    public final String getPromptText() {
        return this.promptText;
    }

    public final void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public final Object getPromptValue() {
        return this.getValue();
    }

    void e(Object object) throws ReportException {
        String string;
        Object object2;
        if (!this.range) {
            return;
        }
        if (this.zd == null && this.ze == null) {
            return;
        }
        if (object instanceof FormulaRange) {
            FormulaRange formulaRange = (FormulaRange)object;
            this.e(formulaRange.getFrom());
            this.e(formulaRange.getTo());
            return;
        }
        if (object instanceof Object[]) {
            for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                this.e(((Object[])object)[i2]);
            }
            return;
        }
        switch (this.getPromptType()) {
            case 11: {
                if (!(object instanceof String) || this.zd != null && !((double)((String)object).length() >= ((Number)this.zd).doubleValue()) || this.ze != null && !((double)((String)object).length() <= ((Number)this.ze).doubleValue())) break;
                return;
            }
            case 6: 
            case 7: {
                if (!(object instanceof Number)) break;
                object2 = (Number)object;
                if (this.zd != null && !(((Number)object2).doubleValue() >= ((Number)this.zd).doubleValue()) || this.ze != null && !(((Number)object2).doubleValue() <= ((Number)this.ze).doubleValue())) break;
                return;
            }
            case 8: {
                return;
            }
            case 9: 
            case 10: 
            case 15: {
                if (!(object instanceof java.util.Date)) break;
                object2 = (java.util.Date)object;
                if (this.zd != null && !((java.util.Date)this.zd).before((java.util.Date)object2) && !this.zd.equals(object2) || this.ze != null && !((java.util.Date)this.ze).after((java.util.Date)object2) && !this.ze.equals(object2)) break;
                return;
            }
        }
        switch (this.getPromptType()) {
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                e e2 = this.bB.dw().qF();
                object2 = ReportErrorCode.valueNoBetweenMinMax;
                string = object2.getMsg(new Object[]{e2.b(this.zd, true), e2.b(this.ze, true)});
                break;
            }
            case 11: {
                object2 = ReportErrorCode.valueNoBetweenMinMaxLength;
                string = object2.getMsg(new Object[]{this.zd, this.ze});
                break;
            }
            case 8: {
                object2 = ReportErrorCode.rangeOnBoolean;
                string = object2.getMsg(new Object[0]);
                break;
            }
            default: {
                object2 = ReportErrorCode.wrongPromptType;
                string = object2.getMsg(new Object[]{this.getPromptType()});
            }
        }
        int n2 = ((ReportErrorCode)((Object)object2)).getErrorCodeNumber();
        throw new PromptRequestWarning(string, n2, Engine.t(this.bB));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPromptValue(Object prompt) throws ReportException {
        if (prompt == null) {
            this.e(prompt);
            this.value = prompt;
            this.valueSet = true;
            return;
        }
        if (prompt instanceof PromptValue) {
            this.setPromptValueAsFormula("formula:" + ((PromptValue)prompt).getStringRepresentation());
            return;
        }
        if (this.zb) {
            if (!(prompt instanceof Object[])) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongMultipleDiscreteValue, String.valueOf(this.zb));
            }
            Object[] objectArray = (Object[])prompt;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                PromptField.a(object, this.valueType, this.name, this.getValueTypeString());
                if (object instanceof FormulaRange) {
                    if (this.zc == 0) {
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongRangeValue, String.valueOf(this.zc));
                    }
                    this.e(object);
                    continue;
                }
                if (this.zc == 1) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongRangeValue, String.valueOf(this.zc));
                }
                this.e(object);
            }
            if (objectArray.length == 0) {
                this.e(null);
            }
            this.valueSet = true;
            this.value = prompt;
            return;
        } else if (this.zc == 0) {
            if (prompt instanceof Object[] || prompt instanceof FormulaRange) throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongDiscreteValue, "Object");
            PromptField.a(prompt, this.valueType, this.name, this.getValueTypeString());
            this.e(prompt);
            this.valueSet = true;
            this.value = prompt;
            return;
        } else if (this.zc == 1) {
            if (!(prompt instanceof FormulaRange)) throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongDiscreteValue, "FormulaRange");
            PromptField.a(prompt, this.valueType, this.name, this.getValueTypeString());
            this.e(prompt);
            this.valueSet = true;
            this.value = prompt;
            return;
        } else {
            if (this.zc != 2) return;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongMultipleDiscreteValue, String.valueOf(this.zb));
        }
    }

    public void setPromptValueAsFormula(String formula) throws ReportException {
        this.bB.getEngine().a(this, formula);
    }

    public final int getPromptType() {
        if (this.valueType == -1) {
            return this.valueType;
        }
        return this.valueType % 128;
    }

    public final void setPromptType(int valueType) {
        if (this.valueType == valueType) {
            return;
        }
        this.valueType = valueType;
        this.zd = null;
        this.ze = null;
        if (valueType % 128 != 6 && valueType % 128 != -1 && valueType % 128 != 7 && valueType % 128 != 8 && valueType % 128 != 9 && valueType % 128 != 10 && valueType % 128 != 15 && valueType % 128 != 11 && valueType % 128 != 14) {
            throw new IllegalArgumentException("illegal prompt value type " + valueType + "! Must be one of the Field value type constants!");
        }
        this.bB.getFields().a(this, 2);
    }

    public final void setUseRange(boolean newValue) {
        this.range = newValue;
    }

    public final boolean getUseRange() {
        return this.range;
    }

    public final void setDescriptionOnly(boolean descOnly) {
        this.descOnly = descOnly;
    }

    public final boolean isDescriptionOnly() {
        return this.descOnly;
    }

    public final void setEditable(boolean isEditable) {
        if (!isEditable && this.isPasswordField()) {
            throw new UnsupportedOperationException("password fields must be editable!");
        }
        this.zj = isEditable;
    }

    public final boolean isEditable() {
        return this.zj;
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public final boolean isPasswordField() {
        return "password".equals(this.editMask);
    }

    public final void setPasswordField(boolean isPasswordField) {
        if (isPasswordField) {
            this.editMask = "password";
            this.setDefaultValues(null);
            this.setEditable(true);
            this.setAllowMultipleValues(false);
            this.setDiscreteOrRangeType(0);
        } else {
            this.editMask = "";
        }
    }

    public void setDiscreteOrRangeType(int newValue) throws IllegalArgumentException {
        if (newValue != 0 && this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field must have the discrete type DISCRETE_VALUE");
        }
        if (newValue < 0 || newValue > 2) {
            throw y.a(newValue, "DiscreteOrRangeType", (ErrorCode)ReportErrorCode.outOfRange2);
        }
        this.zc = newValue;
    }

    public int getDiscreteOrRangeType() {
        return this.zc;
    }

    public void setAllowMultipleValues(boolean newValue) {
        if (this.isPasswordField() && newValue) {
            throw new UnsupportedOperationException("Password Fields can not be set to allow multiple values.");
        }
        this.zb = newValue;
    }

    public boolean getAllowMultipleValues() {
        return this.zb;
    }

    public int getValuesCount() {
        if (this.getValue() == null) {
            return 0;
        }
        if (this.getValue() instanceof Object[]) {
            return ((Object[])this.getValue()).length;
        }
        return 1;
    }

    public void setMinRangeValue(Object min) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (min == null) {
            this.zd = null;
        } else {
            this.setMinMaxRangeValues(min, this.ze);
        }
    }

    public void setMaxRangeValue(Object max) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (max == null) {
            this.ze = null;
        } else {
            this.setMinMaxRangeValues(this.zd, max);
        }
    }

    public void setMinMaxRangeValues(Object min, Object max) throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 11: {
                    double d2;
                    if (min instanceof Number) {
                        d2 = ((Number)min).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MinNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                    if (max instanceof Number) {
                        d2 = ((Number)max).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                }
                case 6: 
                case 7: {
                    if (min instanceof Number && max instanceof Number) {
                        if (((Number)min).doubleValue() > ((Number)max).doubleValue()) {
                            Object[] objectArray = new Object[]{max, min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Number || min instanceof Number && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.MinMaxNotNumber, objectArray);
                    }
                    this.zd = min;
                    this.ze = max;
                    break;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    if (min instanceof Date && max instanceof Date) {
                        if (((Date)min).getTime() > ((Date)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Date || min instanceof Date && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noDateInstance, objectArray);
                    }
                    this.zd = min;
                    this.ze = max;
                    break;
                }
                case 15: {
                    if (min instanceof Timestamp && max instanceof Timestamp) {
                        if (((Timestamp)min).getTime() > ((Timestamp)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Timestamp || min instanceof Timestamp && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noTimeStampInstance, objectArray);
                    }
                    this.zd = min;
                    this.ze = max;
                    break;
                }
                case 10: {
                    if (min instanceof Time && max instanceof Time) {
                        if (((Time)min).getTime() > ((Time)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Time || min instanceof Time && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noTimeInstance, objectArray);
                    }
                    this.zd = min;
                    this.ze = max;
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{this.name};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
                }
            }
        } else {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
        }
    }

    public Object getMinRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.zd;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.zd;
                }
                case 15: {
                    return this.zd;
                }
                case 10: {
                    return this.zd;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
    }

    public Object getMaxRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.ze;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.ze;
                }
                case 15: {
                    return this.ze;
                }
                case 10: {
                    return this.ze;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
    }

    public void setPromptValueDescriptions(String[] descr) {
        if (descr == null) {
            throw new NullPointerException("description array is null");
        }
        int n2 = this.getDefaultValueCount();
        if (n2 != descr.length) {
            throw new IllegalArgumentException("description array's length(" + descr.length + ") does not match default value count (" + n2 + ")");
        }
        for (int i2 = 0; i2 < descr.length; ++i2) {
            String string = descr[i2];
            this.getDefaultValue(i2).setDescription(string);
        }
    }

    public String[] getPromptValueDescriptions() {
        if (this.yY != null) {
            DefaultValue[] defaultValueArray = this.yY.getDefaultValues();
            String[] stringArray = new String[defaultValueArray.length];
            for (int i2 = 0; i2 < defaultValueArray.length; ++i2) {
                DefaultValue defaultValue = defaultValueArray[i2];
                stringArray[i2] = defaultValue.getDescription();
            }
            return stringArray;
        }
        if (this.yX == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.getDefaultValueCount()];
        for (int i3 = 0; i3 < this.getDefaultValueCount(); ++i3) {
            stringArray[i3] = this.getDefaultValue(i3).getDescription();
        }
        return stringArray;
    }

    @Override
    Field[] K(int n2) {
        return new PromptField[n2];
    }

    void ft() throws ReportException {
        this.value = null;
        this.valueSet = false;
        int n2 = this.getDefaultValueCount();
        if (this.yX == null || n2 == 0) {
            return;
        }
        if (this.zb) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = this.getDefaultValue(i2).getValue();
                if (!(object instanceof FormulaRange) && this.getDiscreteOrRangeType() == 1) continue;
                arrayList.add(object);
            }
            this.setPromptValue(arrayList.toArray());
        } else if (this.getDiscreteOrRangeType() != 0) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = this.getDefaultValue(i3).getValue();
                if (!(object instanceof FormulaRange)) continue;
                this.setPromptValue(object);
            }
        } else {
            this.setPromptValue(this.getDefaultValue(0).getValue());
        }
    }

    @Override
    public void setValueType(int newValue) {
        if (PromptUtils.isArray(newValue)) {
            newValue ^= 0x100;
            this.setAllowMultipleValues(true);
        }
        if (PromptUtils.isRange(newValue)) {
            newValue ^= 0x80;
            this.setDiscreteOrRangeType(1);
        }
        super.setValueType(newValue);
    }

    @Override
    public int getValueType() {
        int n2 = this.valueType;
        if (n2 == -1) {
            return n2;
        }
        if (this.zb && !PromptUtils.isArray(n2)) {
            n2 += 256;
        }
        if (this.zc != 0 && !PromptUtils.isRange(n2)) {
            n2 += 128;
        }
        return n2;
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("\n\tText: ").append(this.promptText);
        stringBuilder.append("\n\tType: ").append(this.valueType);
        stringBuilder.append("\n\tValue:").append(this.getValue());
        stringBuilder.append("\n\tLink: ").append(this.zk);
        return stringBuilder.toString();
    }

    public String getPromptValueAsFormula() {
        return PromptUtils.defaultPrompt(this.value, this.valueType);
    }

    public void setDefaultValueProvider(DynamicValueProvider provider) {
        if (provider instanceof CascadingValueProvider && this.a((CascadingValueProvider)provider)) {
            throw new IllegalArgumentException("Circular dependency: this prompt is already an ancestor of the prompt being set as parent!");
        }
        this.yY = provider;
        this.resetReferences();
        this.setReferences();
        if (provider != null) {
            this.yX = null;
        }
    }

    private boolean a(CascadingValueProvider cascadingValueProvider) {
        PromptField promptField = cascadingValueProvider.getParent();
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        while (true) {
            if (arrayList.contains(promptField)) {
                return true;
            }
            arrayList.add(promptField);
            if (promptField == this) {
                return true;
            }
            DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
            if (!(dynamicValueProvider instanceof CascadingValueProvider)) break;
            promptField = ((CascadingValueProvider)dynamicValueProvider).getParent();
        }
        return false;
    }

    public DynamicValueProvider getDefaultValueProvider() {
        return this.yY;
    }

    public DefaultValue[] getDefaultValues() {
        if (this.yY != null) {
            DefaultValue[] defaultValueArray;
            for (DefaultValue defaultValue : defaultValueArray = this.yY.getDefaultValues()) {
                if (PromptUtils.checkValueType(defaultValue.getValue(), this.valueType)) continue;
                BaseUtils.error("Dynamic default values were not the correct type: " + defaultValue.getValue().getClass().getCanonicalName() + " for value type " + this.getValueTypeString());
                return new DefaultValue[0];
            }
            if (this.yY instanceof SQLValueProvider && defaultValueArray.length == 1000) {
                this.setEditable(true);
            }
            return defaultValueArray;
        }
        if (this.yX == null) {
            return null;
        }
        return this.yX.toArray(new DefaultValue[0]);
    }

    public void setDefaultValues(DefaultValue[] values) {
        DefaultValue defaultValue;
        int n2;
        if (this.yX != null) {
            for (n2 = 0; n2 < this.yX.size(); ++n2) {
                defaultValue = this.yX.get(n2);
                if (!(defaultValue instanceof FormulaDefaultValue)) continue;
                FormulaField.d(((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField());
            }
        }
        if (values == null || values.length == 0 || values[0] == null) {
            this.yX = null;
            this.yY = null;
            return;
        }
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field can not have default values");
        }
        this.yX = new ArrayList();
        this.yY = null;
        for (n2 = 0; n2 < values.length; ++n2) {
            if (values[n2] instanceof FormulaDefaultValue) continue;
            try {
                this.e(values[n2].getValue());
                continue;
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("The default value '" + String.valueOf(values[n2].getValue()) + "' is not in the allowed value range.");
            }
        }
        this.yX.clear();
        for (n2 = 0; n2 < values.length; ++n2) {
            defaultValue = values[n2];
            this.yX.add(defaultValue);
        }
        this.fu();
        this.resetReferences();
        this.setReferences();
    }

    public String getDefaultPromptValuesAsString() {
        DefaultValue[] defaultValueArray = this.getDefaultValues();
        if (defaultValueArray == null) {
            return "";
        }
        return PromptUtils.parsePrompt(defaultValueArray, this.valueType);
    }

    public void addDefaultValue(DefaultValue value) {
        this.a(value);
        this.fu();
    }

    private void fu() {
        if (this.bB != null && this.bB.gH > 0 || ((Boolean)bf.Do.get()).booleanValue()) {
            try {
                this.ft();
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
                throw new IllegalArgumentException("could not set default value as prompt's value:" + reportException.getMessage());
            }
        }
    }

    private void a(DefaultValue defaultValue) {
        FormulaField formulaField;
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("Password prompts can not have default values.");
        }
        try {
            this.e(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            try {
                throw new IllegalArgumentException("default value (" + String.valueOf(defaultValue.getValue()) + ") was not in the allowed range (" + String.valueOf(this.getMinRangeValue()) + " to " + String.valueOf(this.getMaxRangeValue()) + ").");
            }
            catch (ReportException reportException2) {
                BaseUtils.printStackTrace(reportException2);
            }
        }
        if (this.yX == null) {
            this.yX = new ArrayList();
        }
        if (this.yY != null) {
            this.yY = null;
        }
        this.yX.add(defaultValue);
        if (defaultValue instanceof FormulaDefaultValue && (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) != null) {
            this.addReferencedObject(formulaField);
        }
    }

    public void removeDefaultValue(int index) {
        if (this.yX == null) {
            throw new IndexOutOfBoundsException("trying to remove a default value when there are none!");
        }
        this.yX.remove(index);
        if (this.yX.size() == 0) {
            this.yX = null;
        }
    }

    public int getDefaultValueCount() {
        if (this.yX == null) {
            return 0;
        }
        return this.yX.size();
    }

    public void setDefaultValue(int index, DefaultValue defaultValue) {
        try {
            this.e(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("trying to set illegal default value: " + reportException.getMessage());
        }
        if (this.yX == null) {
            throw new IndexOutOfBoundsException(index + " >= 0");
        }
        this.yX.set(index, defaultValue);
        this.fu();
    }

    @Override
    void a(int n2, String string, at at2) {
        try {
            switch (n2) {
                case 210: {
                    this.range = Boolean.valueOf(string);
                    break;
                }
                case 7701: {
                    this.editMask = string;
                    break;
                }
                case 216: {
                    this.ze = this.V(string);
                    break;
                }
                case 215: {
                    this.zd = this.V(string);
                    break;
                }
                case 208: {
                    this.zc = Integer.parseInt(string);
                    break;
                }
                case 209: {
                    this.promptText = string;
                    break;
                }
                case 223: {
                    if (at2.xN < this.getDefaultValueCount()) {
                        this.getDefaultValue(at2.xN).setDescription(string);
                        ++at2.xN;
                        break;
                    }
                    BaseUtils.warning("truncated prompt descriptions for prompt field " + this.getName() + " - the number of prompt values did not match the number of prompt descriptions!");
                    break;
                }
                case 221: {
                    Datasource datasource;
                    this.yZ = string;
                    if (this.yZ.trim().length() == 0) {
                        this.yZ = this.name;
                    }
                    if (this.yZ != null && (datasource = at2.wU.bU().iY().getDatasource(0)).getTableSourceCount() > 0 && this.za == null) {
                        this.za = datasource.getTableSource(0);
                    }
                    break;
                }
                case 207: {
                    this.zj = Boolean.valueOf(string);
                    break;
                }
                case 229: {
                    this.descOnly = Boolean.valueOf(string);
                    break;
                }
                case 206: {
                    this.zb = Boolean.valueOf(string);
                    break;
                }
                case 214: {
                    this.zk = new Integer(Integer.parseInt(string));
                    break;
                }
                case 228: {
                    try {
                        this.za = at2.wU.bU().iY().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                default: {
                    super.a(n2, string, at2);
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    private Object V(String string) {
        Comparable<java.util.Date> comparable = null;
        switch (this.getPromptType()) {
            case 6: 
            case 7: 
            case 11: {
                comparable = new Double(string);
                break;
            }
            case 9: {
                comparable = Date.valueOf(string);
                break;
            }
            case 10: {
                comparable = Time.valueOf(string);
                break;
            }
            case 15: {
                comparable = Timestamp.valueOf(string);
            }
        }
        return comparable;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public boolean isParameterOfStoredProcedure() {
        return this.yZ != null && this.za != null;
    }

    public TableSource[] getTableSources() {
        if (this.za == null) {
            return null;
        }
        return new TableSource[]{this.za};
    }

    public String[] getStoredProceduresParameterNames() {
        if (this.yZ == null) {
            return null;
        }
        return new String[]{this.yZ};
    }

    public boolean isSubreportLink() {
        return this.zl > 0;
    }

    @Override
    public boolean isUsed() {
        if (this.za != null || this.yZ != null && this.yZ.trim().length() > 0) {
            return true;
        }
        if (!super.isUsed()) {
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (!(referenceHolderArray[i2] instanceof PromptField) || !((PromptField)referenceHolderArray[i2]).isUsed()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    boolean f(TableSource tableSource) {
        if (super.isUsed()) {
            return false;
        }
        return this.za == tableSource;
    }

    public DefaultValue getDefaultValue(int i2) {
        if (this.yX == null) {
            throw new IndexOutOfBoundsException("trying to retrieve a default value when there are none!");
        }
        return this.yX.get(i2);
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        Object object;
        Object object2;
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, a.zq.name(), k.h(this.zb));
        k.a(stringBuilder, n2, a.zr.name(), k.G(this.zc));
        k.a(stringBuilder, n2, a.zy.name(), k.h(this.zj));
        k.a(stringBuilder, n2, a.zs.name(), k.h(this.descOnly));
        k.a(stringBuilder, n2, a.zt.name(), this.editMask);
        if (this.range) {
            object2 = "";
            int n3 = this.getPromptType();
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.zd != null) {
                object2 = k.e(((Number)this.zd).doubleValue());
            } else if (n3 == 9 && this.zd != null) {
                object2 = this.zd.toString();
            } else if (n3 == 10 && this.zd != null) {
                object2 = this.zd.toString();
            } else if (n3 == 15 && this.zd != null) {
                object2 = this.zd.toString();
            }
            if (((String)object2).length() != 0) {
                k.a(stringBuilder, n2, a.zw.name(), (String)object2);
            }
            object = "";
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.ze != null) {
                object = k.e(((Number)this.ze).doubleValue());
            } else if (n3 == 9 && this.ze != null) {
                object = this.ze.toString();
            } else if (n3 == 10 && this.ze != null) {
                object = this.ze.toString();
            } else if (n3 == 15 && this.ze != null) {
                object = this.ze.toString();
            }
            if (((String)object).length() != 0) {
                k.a(stringBuilder, n2, a.zx.name(), (String)object);
            }
        }
        k.a(stringBuilder, n2, a.zu.name(), this.promptText);
        k.a(stringBuilder, n2, a.zv.name(), k.h(this.range));
        if (this.zk != null) {
            k.a(stringBuilder, n2, a.zA.name(), k.G(this.zk));
        }
        k.a(stringBuilder, n2, a.zC.name(), this.yZ);
        if (this.za != null) {
            k.a(stringBuilder, n2, a.zB.name(), this.za.getAlias());
        }
        if (this.yY != null) {
            stringBuilder.append(string).append("<").append("DefaultValueProvider");
            if (this.yY instanceof QueryValueProvider) {
                PromptField promptField;
                String string2;
                object2 = (QueryValueProvider)this.yY;
                k.a(stringBuilder, "type", "sql");
                stringBuilder.append(">\n");
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zF.name(), ((QueryValueProvider)object2).getQuery().replaceAll("\r\n", "\n"));
                String string3 = ((QueryValueProvider)object2).getFieldRefName();
                if (string3 != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, a.zG.name(), string3);
                }
                if ((string2 = ((Datasource)(object = ((QueryValueProvider)object2).getDatasource())).getDataSourceConfigurationName()) != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, a.zH.name(), string2);
                }
                if ((promptField = ((QueryValueProvider)object2).getParent()) != null) {
                    k.a(stringBuilder, n2, promptField, "cascading parent");
                }
            } else if (this.yY instanceof CascadingValueProvider) {
                k.a(stringBuilder, "type", "cascading");
                stringBuilder.append(">\n");
                object2 = (CascadingValueProvider)this.yY;
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zz.name(), k.G(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((CascadingValueProvider)object2).getParent(), "cascading parent");
            } else if (this.yY instanceof FieldValueProvider) {
                k.a(stringBuilder, "type", "field");
                stringBuilder.append(">\n");
                object2 = (FieldValueProvider)this.yY;
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zz.name(), k.G(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
            } else {
                stringBuilder.append(">\n");
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("could not save dynamic value provider");
                }
            }
            stringBuilder.append(string + "</DefaultValueProvider>\n");
        } else if (this.yX != null) {
            int n4 = this.getDefaultValueCount();
            stringBuilder.append(string + "<DefaultPromptValues>\n");
            String[] stringArray = this.getPromptValueDescriptions();
            for (int i2 = 0; i2 < n4; ++i2) {
                DefaultValue defaultValue;
                stringBuilder.append(string + string + "<DefaultValue");
                if (stringArray != null && stringArray.length > i2 && stringArray[i2] != null && !stringArray[i2].equals("")) {
                    stringBuilder.append(k.l("description", stringArray[i2]));
                }
                if ((defaultValue = this.getDefaultValue(i2)) instanceof FormulaDefaultValue) {
                    stringBuilder.append(">\n");
                    stringBuilder.append(string + string + string + k.h(((FormulaDefaultValue)defaultValue).getFormulaText()) + "\n");
                    stringBuilder.append(string + string + string);
                    k.a(stringBuilder, 0, FormulaField.a.sf.name(), k.G(((FormulaDefaultValue)defaultValue).isBasicSyntax() ? 1002 : 1001));
                    stringBuilder.append(string + string + "</DefaultValue>\n");
                    continue;
                }
                stringBuilder.append(k.l("value", PromptUtils.parsePrompt(defaultValue.getValue(), this.getPromptType())));
                stringBuilder.append("/>\n");
            }
            stringBuilder.append(string + "</DefaultPromptValues>\n");
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        if ("formula".equals(parserMap.get("defaultvaluetype"))) {
            parserMap.put("defaultvalueformulatext", text);
        } else {
            super.parseText(text, parserMap);
        }
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            a a2 = a.valueOf(tag);
            String string = atts.getValue("value");
            switch (a2) {
                case zo: {
                    if (group != XMLTag.DefaultPromptValues) break;
                    String string2 = atts.getValue("value");
                    String string3 = atts.getValue("description");
                    if (string2 != null) {
                        DefaultValue defaultValue = DefaultValue.createDefaultValueFromFormula(string2, string3, this.bB.getEngine());
                        this.a(defaultValue);
                        break;
                    }
                    parserMap.put("defaultvaluetype", "formula");
                    parserMap.put("defaultvaluedescription", string3);
                    break;
                }
                case zJ: {
                    parserMap.put("defaultvalueformulasyntax", Integer.valueOf(string));
                    break;
                }
                case zp: {
                    this.setName(string);
                    break;
                }
                case zu: {
                    this.setPromptText(string);
                    break;
                }
                case zq: {
                    this.setAllowMultipleValues(Boolean.valueOf(string));
                    break;
                }
                case zr: {
                    this.setDiscreteOrRangeType(Integer.valueOf(string));
                    break;
                }
                case zs: {
                    this.setDescriptionOnly(Boolean.valueOf(string));
                    break;
                }
                case zv: {
                    this.setUseRange(Boolean.valueOf(string));
                    break;
                }
                case zt: {
                    this.editMask = string;
                    break;
                }
                case zy: {
                    this.setEditable(Boolean.valueOf(string));
                    break;
                }
                case zA: {
                    this.zk = Integer.valueOf(string);
                    break;
                }
                case zB: {
                    try {
                        this.za = this.bB.iY().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                case zC: {
                    this.yZ = string;
                    if (this.yZ.trim().length() != 0) break;
                    this.yZ = this.name;
                    break;
                }
                case zw: {
                    this.zd = this.V(string);
                    break;
                }
                case zx: {
                    this.ze = this.V(string);
                    break;
                }
                case zE: {
                    String string4 = atts.getValue("type");
                    parserMap.put(b.zM.name(), this.bB.getEngine());
                    SQLValueProvider sQLValueProvider = null;
                    if ("sql".equals(string4)) {
                        sQLValueProvider = new QueryValueProvider();
                    } else if ("cascading".equals(string4)) {
                        sQLValueProvider = new CascadingValueProvider();
                    } else if ("field".equals(string4)) {
                        sQLValueProvider = new FieldValueProvider();
                    }
                    parserMap.put(b.zN.name(), sQLValueProvider);
                    return sQLValueProvider;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.printStackTrace(illegalArgumentException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        if (XMLTag.DefaultValue.name().equals(tag)) {
            String string = (String)parserMap.get("defaultvalueformulatext");
            Integer n2 = (Integer)parserMap.get("defaultvalueformulasyntax");
            String string2 = (String)parserMap.get("defaultvaluedescription");
            if (string != null && n2 != null && "formula".equals(parserMap.get("defaultvaluetype"))) {
                try {
                    FormulaField formulaField = this.bB.getEngine().getFields().addFormulaField("defaultvalueformula", string, 3);
                    formulaField.setSyntax(n2);
                    FormulaDefaultValue formulaDefaultValue = DefaultValue.createFormulaFieldDefaultValueFromFormula(formulaField, string2, this.getValueType(), this.bB.getEngine());
                    this.a(formulaDefaultValue);
                }
                catch (ReportException reportException) {
                    BaseUtils.printStackTrace(reportException);
                }
            }
            parserMap.remove("defaultvalueformulatext");
            parserMap.remove("defaultvaluedescription");
            parserMap.remove("defaultvalueformulasyntax");
            parserMap.remove("defaultvaluetype");
            super.parseEndElement(group, tag, parserMap);
            return;
        }
        DynamicValueProvider dynamicValueProvider = (DynamicValueProvider)parserMap.get(b.zN.name());
        if (dynamicValueProvider != null) {
            try {
                QueryValueProvider queryValueProvider;
                if (dynamicValueProvider instanceof CascadingValueProvider) {
                    CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)dynamicValueProvider;
                    if (cascadingValueProvider.getParent() == null || cascadingValueProvider.getParent().getDefaultValueProvider() == null || cascadingValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read cascading prompt: parent - " + String.valueOf(cascadingValueProvider.getParent()) + "; values - " + String.valueOf(cascadingValueProvider.getValues()));
                        return;
                    }
                } else if (dynamicValueProvider instanceof FieldValueProvider) {
                    FieldValueProvider fieldValueProvider = (FieldValueProvider)dynamicValueProvider;
                    if (fieldValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read dynamic prompt: values - " + String.valueOf(fieldValueProvider.getValues()));
                        return;
                    }
                } else if (dynamicValueProvider instanceof QueryValueProvider && ((queryValueProvider = (QueryValueProvider)dynamicValueProvider).getQuery() == null || queryValueProvider.getDatasource() == null)) {
                    BaseUtils.warning("could not read dynamic query-based prompt: sql - " + queryValueProvider.getQuery() + "; datasource - " + String.valueOf(queryValueProvider.getDatasource()));
                    return;
                }
                this.setDefaultValueProvider(dynamicValueProvider);
            }
            finally {
                parserMap.remove(b.zN.name());
            }
        }
        this.fu();
        super.parseEndElement(group, tag, parserMap);
    }

    @Override
    public void addReferencedObject(ReferencedObject reference) {
        this.qk.addReferencedObject(reference);
    }

    @Override
    public void removeReferencedObject(ReferencedObject reference) {
        this.qk.removeReferencedObject(reference);
    }

    @Override
    public int getReferencedObjectCount() {
        return this.qk.getReferencedObjectCount();
    }

    @Override
    public ReferencedObject[] getReferencedObjects() {
        return this.qk.getReferencedObjects();
    }

    @Override
    public void resetReferences() {
        this.qk.resetReferences();
        if (this.yX != null) {
            for (int i2 = 0; i2 < this.yX.size(); ++i2) {
                FormulaField formulaField;
                DefaultValue defaultValue = this.yX.get(i2);
                if (!(defaultValue instanceof FormulaDefaultValue) || (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) == null) continue;
                formulaField.resetReferences();
            }
        }
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qk.getRealReferencedObjectCount();
    }

    @Override
    public void setReferences() {
        Field field;
        Serializable serializable;
        NodeParser nodeParser;
        DynamicValueProvider dynamicValueProvider = this.getDefaultValueProvider();
        if (dynamicValueProvider != null && dynamicValueProvider instanceof CascadingValueProvider) {
            nodeParser = ((CascadingValueProvider)dynamicValueProvider).getParent();
            ((Field)nodeParser).addReferenceHolder(this);
        }
        if (dynamicValueProvider != null && dynamicValueProvider instanceof FieldValueProvider) {
            nodeParser = (FieldValueProvider)dynamicValueProvider;
            serializable = ((FieldValueProvider)nodeParser).getValues();
            serializable.addReferenceHolder(this);
            field = ((FieldValueProvider)nodeParser).getDescriptions();
            if (field != null) {
                field.addReferenceHolder(this);
            }
        }
        if (this.yX != null) {
            for (int i2 = 0; i2 < this.yX.size(); ++i2) {
                serializable = this.yX.get(i2);
                if (!(serializable instanceof FormulaDefaultValue) || (field = ((FormulaDefaultValue)serializable).getUnderlyingFormulaField()) == null) continue;
                ((FormulaField)field).resetReferences();
                ((FormulaField)field).setReferences();
                field.addReferenceHolder(this);
            }
        }
    }

    @Override
    public Field duplicate(String name) {
        PromptField promptField;
        try {
            promptField = this.bB.getFields().addPromptField(name, this.getPromptText(), this.getPromptType());
            promptField.setAllowMultipleValues(this.getAllowMultipleValues());
            promptField.setDescriptionOnly(this.isDescriptionOnly());
            promptField.setDiscreteOrRangeType(this.getDiscreteOrRangeType());
            promptField.setEditable(this.isEditable());
            promptField.setUseRange(this.getUseRange());
            if (this.getUseRange()) {
                promptField.setMaxRangeValue(this.getMaxRangeValue());
                promptField.setMinRangeValue(this.getMinRangeValue());
            }
            if (this.getDefaultValueProvider() == null) {
                DefaultValue[] defaultValueArray = this.getDefaultValues();
                if (defaultValueArray != null) {
                    for (DefaultValue defaultValue : defaultValueArray) {
                        try {
                            promptField.addDefaultValue((DefaultValue)defaultValue.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            BaseUtils.printStackTrace(cloneNotSupportedException);
                        }
                    }
                }
            } else if (this.yY instanceof QueryValueProvider) {
                QueryValueProvider queryValueProvider = (QueryValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new QueryValueProvider(queryValueProvider.getQuery(), queryValueProvider.getDatasource()));
            } else if (this.yY instanceof CascadingValueProvider) {
                CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new CascadingValueProvider(cascadingValueProvider.getParent(), cascadingValueProvider.getParentSource(), cascadingValueProvider.getValues(), cascadingValueProvider.getDescriptions(), cascadingValueProvider.getSortType()));
            } else if (this.yY instanceof FieldValueProvider) {
                FieldValueProvider fieldValueProvider = (FieldValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new FieldValueProvider(fieldValueProvider.getValues(), fieldValueProvider.getDescriptions(), fieldValueProvider.getSortType()));
            } else {
                BaseUtils.warning("cannot duplicate default value provider while duplicating " + this.getName() + " - using no default value provider instead...");
            }
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("cannot duplicate prompt field with name " + name, reportException);
        }
        return promptField;
    }

    void a(Evaluable evaluable) {
        this.zm = evaluable;
    }

    public Evaluable getFormulaAst() {
        return this.zm;
    }

    static void a(Object object, int n2, String string, String string2) throws ReportException {
        if (object == null) {
            return;
        }
        switch (n2 %= 128) {
            case 6: 
            case 7: {
                if (object instanceof Number) {
                    return;
                }
                if (object instanceof FormulaRange && (((FormulaRange)object).getFrom() instanceof Number && ((FormulaRange)object).getTo() instanceof Number || ((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getFrom() == null || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                    PromptField.a(((Object[])object)[i2], n2, string, string2);
                }
                return;
            }
            case 8: {
                if (object instanceof Boolean) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof Boolean || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof Boolean || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i3 = 0; i3 < ((Object[])object).length; ++i3) {
                    PromptField.a(((Object[])object)[i3], n2, string, string2);
                }
                return;
            }
            case 9: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i4 = 0; i4 < ((Object[])object).length; ++i4) {
                    PromptField.a(((Object[])object)[i4], n2, string, string2);
                }
                return;
            }
            case 10: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i5 = 0; i5 < ((Object[])object).length; ++i5) {
                    PromptField.a(((Object[])object)[i5], n2, string, string2);
                }
                return;
            }
            case 11: {
                if (object instanceof String) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i6 = 0; i6 < ((Object[])object).length; ++i6) {
                    PromptField.a(((Object[])object)[i6], n2, string, string2);
                }
                return;
            }
            case 15: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange) {
                    if ((!(((FormulaRange)object).getFrom() instanceof java.util.Date) && ((FormulaRange)object).getFrom() != null || !(((FormulaRange)object).getTo() instanceof java.util.Date)) && ((FormulaRange)object).getTo() != null) break;
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i7 = 0; i7 < ((Object[])object).length; ++i7) {
                    PromptField.a(((Object[])object)[i7], n2, string, string2);
                }
                return;
            }
            case 14: {
                if (!(object instanceof byte[])) break;
                return;
            }
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongPromptData, string, object, object.getClass().getName(), string2);
    }

    public void copySPParametersTo(PromptField toField) {
        if (this.yZ != null) {
            toField.yZ = this.yZ;
        }
        if (this.za != null) {
            try {
                TableSource tableSource = toField.bB.iY().getTablesource(this.za.getAlias());
                if (tableSource != null) {
                    toField.za = tableSource;
                }
            }
            catch (ReportException reportException) {
                BaseUtils.warning(reportException);
            }
        }
    }

    static enum b {
        zM,
        zN;

    }

    private static enum a {
        zo,
        zp,
        zq,
        zr,
        zs,
        zt,
        zu,
        zv,
        zw,
        zx,
        zy,
        zz,
        zA,
        zB,
        zC,
        zD,
        zE,
        zF,
        zG,
        zH,
        zI,
        zJ,
        zK;

    }
}

