/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.Engine;
import com.inet.report.FormulaDefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.util.PromptUtils;
import java.io.Serializable;
import java.util.Base64;

@PublicApi
public class DefaultValue
implements Serializable,
Cloneable {
    private Object value;
    private String description;
    private final int type;

    protected DefaultValue(String description, int type) {
        this.type = this.R(type);
        this.description = description;
    }

    public DefaultValue(Object value, String description, int type) {
        this.value = value;
        this.description = description;
        this.type = this.R(type);
        if (!PromptUtils.checkValueType(value, type)) {
            throw new IllegalArgumentException("illegal value for given value type, value=" + String.valueOf(value) + ", type =" + type);
        }
    }

    public DefaultValue(Object value, String description) {
        this(value, description, -1);
    }

    private int R(int n2) {
        if (n2 != -1) {
            n2 %= 128;
        }
        if (n2 != 11 && n2 != 6 && n2 != 7 && n2 != 15 && n2 != 9 && n2 != 10 && n2 != 8 && n2 != 14 && n2 != -1) {
            throw new IllegalArgumentException("field type must be one of the valid Field types, but it is:" + n2);
        }
        return n2;
    }

    public static DefaultValue createDefaultValueFromFormula(String value, String description, Engine engine) throws ReportException {
        Object object = engine.bB.dw().a(value, false, null, null);
        return new DefaultValue(object, description);
    }

    public static DefaultValue createDefaultValueFromFormula(String value, String description, int valueType, Engine engine) throws ReportException {
        Object object = engine.bB.dw().a(value, false, null, null);
        return new DefaultValue(object, description, valueType);
    }

    public static FormulaDefaultValue createFormulaFieldDefaultValueFromFormula(FormulaField formulaField, String description, int valueType, Engine engine) {
        return new FormulaDefaultValue(formulaField, description, valueType);
    }

    public static DefaultValue createBinaryDefaultValue(String value, String description) {
        byte[] byArray = Base64.getDecoder().decode(value);
        return new DefaultValue(byArray, description, 14);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultValue) {
            DefaultValue defaultValue = (DefaultValue)obj;
            if ((defaultValue.description == this.description || defaultValue.description.equals(this.description)) && defaultValue.type == this.type && (defaultValue.value == this.value || defaultValue.value.equals(this.value))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.type;
        n2 = this.value != null ? (n2 |= this.value.hashCode()) : (n2 |= 1);
        n2 = this.description != null ? (n2 |= this.description.hashCode()) : (n2 |= 2);
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultValue(this.value, this.description, this.type);
    }
}

