/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingSource;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.HasCascadingParent;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.formula.ast.q;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.sql.SQLException;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class CascadingValueProvider
extends FieldValueProvider
implements HasCascadingParent {
    private PromptField hz;
    private CascadingSource hA;

    public CascadingValueProvider(PromptField parent, CascadingSource parentSource, DatabaseField values, DatabaseField descriptions, int sortType) {
        super(values, descriptions, sortType);
        this.setParent(parent);
        this.setParentSource(parentSource);
    }

    CascadingValueProvider() {
    }

    @Override
    public PromptField getParent() {
        return this.hz;
    }

    @Override
    public void setParent(PromptField parent) {
        if (parent == null) {
            throw new IllegalArgumentException("A cascading prompt must have a parent.");
        }
        this.hz = parent;
    }

    @Override
    public String getSQL() {
        try {
            TableSource tableSource = this.getValues().kX;
            Datasource datasource = tableSource.getDatasource();
            Database database = (Database)datasource.getDataFactory();
            StringBuilder stringBuilder = new StringBuilder("");
            String string = this.hA.getFieldRefName();
            this.a(database, stringBuilder, string, this.hz);
            boolean bl2 = this.hA instanceof FieldValueProvider && ((FieldValueProvider)this.hA).getValues().kX != tableSource;
            return this.a(stringBuilder.toString(), bl2, true);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (SQLException sQLException) {
            BaseUtils.printStackTrace(sQLException);
        }
        return "";
    }

    private void a(Database database, StringBuilder stringBuilder, String string, PromptField promptField) throws ReportException {
        String string2;
        Object object;
        if (string != null) {
            object = promptField.getValue();
            if (object instanceof Object[] && ((Object[])object).length == 0) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("1=0 ");
                } else {
                    stringBuilder.append("AND 1=0 ");
                }
            } else {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append("AND " + string);
                }
                if (object == null) {
                    stringBuilder.append(" IS NULL ");
                } else {
                    stringBuilder.append(" IN ");
                    string2 = q.a(object, null, database);
                    if (object instanceof Object[]) {
                        stringBuilder.append(string2);
                    } else {
                        stringBuilder.append('(');
                        stringBuilder.append(string2);
                        stringBuilder.append(") ");
                    }
                }
            }
        }
        if ((object = promptField.getDefaultValueProvider()) instanceof CascadingValueProvider) {
            string2 = ((CascadingValueProvider)object).getParentSource().getFieldRefName();
            this.a(database, stringBuilder, string2, ((CascadingValueProvider)object).getParent());
        }
    }

    public void setParentSource(CascadingSource parentSource) {
        if (parentSource == null) {
            throw new IllegalArgumentException("A cascading prompt must have a parent source, e.g. a FieldValueProvider.");
        }
        this.hA = parentSource;
    }

    public CascadingSource getParentSource() {
        return this.hA;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            String string;
            if (tag.equals("Reference") && "cascading parent".equals(string = atts.getValue("name"))) {
                String string2 = atts.getValue("value");
                Engine engine = (Engine)parserMap.get(PromptField.b.zM.name());
                Field field = engine.bU().a(false, string2);
                PromptField promptField = (PromptField)field;
                this.setParent(promptField);
                DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
                if (dynamicValueProvider instanceof CascadingSource) {
                    this.setParentSource((CascadingSource)((Object)dynamicValueProvider));
                }
                return null;
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return super.parseElement(group, tag, atts, parserMap);
    }
}

