/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.PromptData;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.am;
import com.inet.viewer.az;
import com.inet.viewer.ba;
import com.inet.viewer.bb;
import com.inet.viewer.bd;
import com.inet.viewer.bf;
import com.inet.viewer.bh;
import com.inet.viewer.i18n.a;
import com.inet.viewer.widgets.c;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import javax.annotation.SuppressFBWarnings;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class SwingViewerUtils
extends ViewerUtils {
    public static final int KEY_LENGTH = 16;
    private static final String[] d = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    public static final String ENCRYPT_XOR = "00";

    public static JButton createToolBarButton(Action action) {
        JButton jButton = new JButton(action);
        SwingViewerUtils.a(jButton, action);
        return jButton;
    }

    public static JToggleButton createToggleButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        SwingViewerUtils.a(jToggleButton, action);
        return jToggleButton;
    }

    private static void a(AbstractButton abstractButton, Action action) {
        abstractButton.setName((String)action.getValue("ActionCommandKey"));
        abstractButton.setText("");
        abstractButton.setRolloverEnabled(true);
        abstractButton.setPreferredSize(new Dimension(26, 26));
        abstractButton.setMinimumSize(new Dimension(26, 26));
        abstractButton.setMaximumSize(new Dimension(26, 26));
    }

    static c a(ArrayList arrayList, Action action) {
        return new c(arrayList, action);
    }

    static JToolBar a() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setOpaque(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setBorder(null);
        return jToolBar;
    }

    public static am createPromptPanel(JDialog owner, PromptData currentPrompt) {
        if (currentPrompt.isMultipleAllowed()) {
            return new bd(owner, currentPrompt);
        }
        if (currentPrompt.isRange()) {
            int n2 = currentPrompt.getType() % 128;
            if ((n2 == 9 || n2 == 15) && currentPrompt.isChangeable()) {
                return new ba(owner, currentPrompt);
            }
            return new bf(owner, currentPrompt);
        }
        return SwingViewerUtils.createSinglePromptPanel(owner, currentPrompt, false);
    }

    public static bh createSinglePromptPanel(JDialog owner, PromptData currentPrompt, boolean multiSelectionBox) {
        switch (currentPrompt.getType()) {
            case 8: {
                return new az(owner, currentPrompt);
            }
            case 6: 
            case 7: {
                return new bh(owner, currentPrompt, multiSelectionBox);
            }
            case 9: {
                return new bb(owner, currentPrompt, multiSelectionBox);
            }
            case 10: 
            case 15: {
                return new bb(owner, currentPrompt, multiSelectionBox);
            }
        }
        return new bh(owner, currentPrompt, multiSelectionBox);
    }

    public static final Window getParentWindow(Component parentComponent) {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return SwingViewerUtils.getParentWindow(parentComponent.getParent());
    }

    public static JDialog createJDialog(Component parent, String title) {
        Window window = SwingViewerUtils.getWindow(parent);
        JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, title, window != ViewerUtils.c) : new JDialog((Dialog)window, title, true);
        jDialog.setModal(true);
        return jDialog;
    }

    public static Window getWindow(Component c2) {
        for (Component component = c2; component != null; component = component.getParent()) {
            if (!(component instanceof Frame) && !(component instanceof Dialog)) continue;
            if (!component.isDisplayable()) {
                component.addNotify();
            }
            return (Window)component;
        }
        return ViewerUtils.b();
    }

    public static void sortButtons(JButton[] buttons) {
        Arrays.sort(buttons, new Comparator(){
            private boolean a = System.getProperty("os.name", "").toLowerCase().startsWith("mac");
            private final boolean b = this.a || UIManager.getBoolean("OptionPane.isYesLast");
            private final String c = com.inet.viewer.i18n.a.a("ok");
            private final String d = com.inet.viewer.i18n.a.a("cancel");
            private final String e = "NextPrompt";
            private final String f = "PrevPrompt";

            private int a(JButton jButton) {
                String string = jButton.getText();
                if (this.c.equals(string)) {
                    return this.b ? 4 : 3;
                }
                if (this.d.equals(string)) {
                    return this.b ? 3 : 4;
                }
                if ("NextPrompt".equals(jButton.getName())) {
                    return 2;
                }
                if ("PrevPrompt".equals(jButton.getName())) {
                    return 1;
                }
                return -1;
            }

            public int compare(Object o1, Object o2) {
                int n2 = this.a((JButton)o1);
                int n3 = this.a((JButton)o2);
                if (n2 == -1 || n3 == -1) {
                    return 0;
                }
                return n2 - n3;
            }
        });
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="used for obfuscation")
    public static String encrypt(String value) {
        int n2;
        if (value == null) {
            return "";
        }
        byte[] byArray = new byte[16];
        Random random = new Random();
        random.nextBytes(byArray);
        byte[] byArray2 = SwingViewerUtils.getBytesUTF8(value);
        byte[] byArray3 = new byte[byArray2.length + 2 + 15 & 0x7FFFFFF0];
        random.nextBytes(byArray3);
        for (n2 = 0; n2 < 2; ++n2) {
            byArray3[n2] = (byte)(byArray2.length >> n2 * 8);
        }
        System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
        n2 = 0;
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            int n3 = byArray3[i2];
            byArray3[i2] = (byte)(byArray3[i2] ^ n2 ^ byArray[i2 % 15]);
            n2 = n3;
        }
        return ENCRYPT_XOR + SwingViewerUtils.a(byArray) + SwingViewerUtils.a(byArray3);
    }

    private static String a(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(d[byArray[i2] >> 4 & 0xF]);
            stringBuffer.append(d[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte[] getBytesUTF8(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }
}

